/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors;

import com.ibm.team.enterprise.systemdefinition.common.helper.ValidationHelper;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.DataDefinitionEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.IConcatenation;
import com.ibm.team.enterprise.systemdefinition.common.model.IDDAllocation;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionCache;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractSystemDefinitionEditor;
import com.ibm.team.enterprise.systemdefinition.ui.helper.ConditionValidator;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.ConcatenationDSDControl;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.api.MappingValidation;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ConcatenationDialog
extends TitleAreaDialog {
    protected Text fDDNameText;
    protected Text fConditionalText;
    protected Shell fParentShell;
    private ConcatenationDSDControl ddec;
    private final IConcatenation fConcat;
    private final ITeamRepository repository;
    private final ISystemDefinitionCache definitionCache;
    private final MappingValidation validator;
    private final boolean isNew;
    private final String fOriginalName;
    private final String fTitle;
    private final List<IDDAllocation> fExistingDDAllocations;
    private final List<IConcatenation> fExistingConcatenations;

    public ConcatenationDialog(Shell parentShell, String title, IConcatenation concat, List<IConcatenation> existingConcats, List<IDDAllocation> existingDDallocations, ITeamRepository repository, boolean isNew, ISystemDefinitionCache definitionCache, MappingValidation validator) {
        super(parentShell);
        ValidationHelper.validateNotNull((String)"title", (Object)title);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fTitle = title;
        this.fParentShell = parentShell;
        this.fExistingConcatenations = existingConcats;
        this.fExistingDDAllocations = existingDDallocations;
        this.fConcat = ModelFactory.eINSTANCE.createConcatenation();
        this.fConcat.setName(concat.getName());
        this.fConcat.setCondition(concat.getCondition());
        for (IDataDefinitionEntry entry : concat.getDataDefinitionEntries()) {
            DataDefinitionEntry cloned = ModelFactory.eINSTANCE.createDataDefinitionEntry();
            cloned.setKind(entry.getKind());
            cloned.setMember(entry.isMember());
            cloned.setValue(entry.getValue());
            this.fConcat.getDataDefinitionEntries().add(cloned);
        }
        this.repository = repository;
        this.isNew = isNew;
        this.definitionCache = definitionCache;
        this.validator = validator;
        this.fOriginalName = concat.getName();
    }

    protected boolean validate(boolean suppressErrorMessage) {
        String con;
        if (suppressErrorMessage) {
            this.setMessage(Messages.ConcatenationDialog_CONCATENATION_HEADER);
            this.setErrorMessage(null);
        }
        String errorMessage = null;
        String warningMessage = null;
        String proposedName = this.fDDNameText.getText().trim();
        errorMessage = proposedName == null || proposedName.equals("") ? Messages.ConcatenationDialog_DD_NAME_REQUIRED : (this.validator.isValidDDName(proposedName) != 0 ? NLS.bind((String)Messages.ConcatenationDialog_DD_NAME_INVALID, (Object)proposedName) : this.nameConflict(proposedName));
        if (errorMessage == null && (con = this.fConditionalText.getText()) != null && !con.isEmpty()) {
            IStatus error = ConditionValidator.validate((String)con);
            if (error != null && error.matches(4)) {
                errorMessage = error.getMessage();
            } else if (error != null && error.matches(2)) {
                warningMessage = error.getMessage();
            }
        }
        if (errorMessage == null) {
            this.setErrorMessage(null);
            if (warningMessage != null) {
                this.setMessage(warningMessage, 2);
            } else {
                this.setMessage(Messages.ConcatenationDialog_CONCATENATION_HEADER);
            }
        } else {
            this.setErrorMessage(errorMessage);
        }
        Button okButton = this.getButton(0);
        okButton.setEnabled(errorMessage == null);
        return errorMessage == null;
    }

    protected String getDDNameTextValue() {
        return this.fDDNameText.getText().trim();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        gridData.widthHint = 300;
        composite.setLayoutData((Object)gridData);
        this.setTitle(this.fTitle);
        this.setMessage(Messages.ConcatenationDialog_CONCATENATION_HEADER);
        Label label = new Label(composite, 0);
        label.setText(Messages.ConcatenationDialog_DD_NAME_LABEL);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.fDDNameText = new Text(composite, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        if (this.fConcat.getName() != null) {
            this.fDDNameText.setText(this.fConcat.getName());
        }
        this.fDDNameText.setLayoutData((Object)gridData);
        this.fDDNameText.addModifyListener(this.getNameModifiedListener());
        this.createSpacer(composite, 5, 3);
        this.ddec = new ConcatenationDSDControl(composite, null, this.fConcat.getDataDefinitionEntries(), this.repository, true, this.definitionCache);
        Label conditionalLabel = new Label(composite, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        conditionalLabel.setText(Messages.ConcatenationDialog_CONDITION);
        conditionalLabel.setLayoutData((Object)gridData);
        this.fConditionalText = new Text(composite, 2818);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.heightHint = gridData.minimumHeight = this.fConditionalText.getLineHeight() * 5;
        gridData.grabExcessVerticalSpace = true;
        this.fConditionalText.setLayoutData((Object)gridData);
        this.updateCondition();
        this.fConditionalText.addModifyListener(this.getConditionModifiedListener());
        Label conditionalInfoLabel = new Label(composite, 64);
        conditionalInfoLabel.setText(com.ibm.team.enterprise.systemdefinition.ui.nls.Messages.Common_CONDITION_INFORMATIONAL);
        conditionalInfoLabel.setForeground(Display.getCurrent().getSystemColor(16));
        GridDataFactory.fillDefaults().grab(true, false).span(2, -1).applyTo((Control)conditionalInfoLabel);
        ConcatenationDialog.applyDialogFont((Control)composite);
        if (this.isNew) {
            this.fDDNameText.setFocus();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.build.ui.dialog_ddconcatenation");
        return composite;
    }

    protected void updateCondition() {
        String text = "";
        if (this.fConcat.getCondition() != null) {
            text = this.fConcat.getCondition();
        }
        this.fConditionalText.setText(text);
    }

    private ModifyListener getConditionModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConcatenationDialog.this.validate(false);
                ConcatenationDialog.this.fConcat.setCondition(ConcatenationDialog.this.fConditionalText.getText().trim());
            }
        };
    }

    private ModifyListener getNameModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConcatenationDialog.this.validate(false);
                ConcatenationDialog.this.fConcat.setName(ConcatenationDialog.this.fDDNameText.getText().trim());
            }
        };
    }

    private void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = new Label(parent, 64);
        label.setText("");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.fTitle);
    }

    public void create() {
        super.create();
        this.validate(true);
    }

    public IConcatenation getWorkingCopy() {
        return this.fConcat;
    }

    protected String nameConflict(String name) {
        boolean otherHasCondition;
        if (!this.isNew && name.equals(this.fOriginalName)) {
            return null;
        }
        boolean thisHasCondition = !this.fConditionalText.getText().trim().isEmpty();
        for (IConcatenation iConcatenation : this.fExistingConcatenations) {
            IConcatenation concat = iConcatenation;
            boolean bl = otherHasCondition = concat.getCondition() != null && !concat.getCondition().isEmpty();
            if (!concat.getName().equals(name)) continue;
            if (!otherHasCondition) {
                return NLS.bind((String)Messages.ConcatenationDialog_DD_NAME_EXISTS, (Object)AbstractSystemDefinitionEditor.escapeAmpersands((String)name));
            }
            if (thisHasCondition) continue;
            return NLS.bind((String)Messages.ConcatenationDialog_DD_NAME_CONDITION_REQUIRED, (Object)AbstractSystemDefinitionEditor.escapeAmpersands((String)name));
        }
        for (IConcatenation iConcatenation : this.fExistingDDAllocations) {
            IDDAllocation DDalloc = (IDDAllocation)iConcatenation;
            boolean bl = otherHasCondition = DDalloc.getCondition() != null && !DDalloc.getCondition().isEmpty();
            if (!DDalloc.getName().equals(name)) continue;
            if (!otherHasCondition) {
                return NLS.bind((String)Messages.ConcatenationDialog_DD_NAME_EXISTS, (Object)AbstractSystemDefinitionEditor.escapeAmpersands((String)name));
            }
            if (thisHasCondition) continue;
            return NLS.bind((String)Messages.ConcatenationDialog_DD_NAME_CONDITION_REQUIRED, (Object)AbstractSystemDefinitionEditor.escapeAmpersands((String)name));
        }
        return null;
    }

    public boolean close() {
        this.ddec.dispose();
        return super.close();
    }
}

