/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors;

import com.ibm.team.enterprise.systemdefinition.common.helper.ValidationHelper;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.DataDefinitionEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractSystemDefinitionEditor;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.DataDefinitionEntryLabelHelper;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.DataSetDefinitionSelectionDialog;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.IModeledDataDefinitionEntryContext;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.zos.systemdefinition.common.IDataDefinitionEntry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ConcatenationDSDDialog
extends TitleAreaDialog {
    protected String fTitle;
    protected Text fDataDefinitionText;
    protected Text fSubParamText;
    private Button fBrowseButton;
    protected Button fDataDefEntryKindButtonDataDef;
    protected Button fDataDefEntryKindButtonSubParam;
    protected Button fMemberButton;
    protected com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry fConcatenationDSD;
    protected List<com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry> fConcatenationDSDList;
    protected ITeamRepository fTeamRepository;
    protected boolean fIsNew;
    protected Shell fParentShell;
    protected Composite fComposite;

    public ConcatenationDSDDialog(Shell parentShell, String title, com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry concatDSD, boolean isNew, ITeamRepository repo) {
        super(parentShell);
        ValidationHelper.validateNotNull((String)"title", (Object)title);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fTitle = title;
        this.fParentShell = parentShell;
        this.fConcatenationDSD = ModelFactory.eINSTANCE.createDataDefinitionEntry();
        this.fConcatenationDSD.setKind(concatDSD.getKind());
        this.fConcatenationDSD.setValue(concatDSD.getValue());
        this.fConcatenationDSD.setMember(concatDSD.isMember());
        this.fConcatenationDSDList = new ArrayList<com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry>();
        this.fIsNew = isNew;
        this.fTeamRepository = repo;
    }

    protected void validate(boolean suppressErrorMessage) {
        String errorMessage = this.getErrorMessage();
        if (errorMessage == null || suppressErrorMessage) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(errorMessage);
        }
        Button okButton = this.getButton(0);
        okButton.setEnabled((this.fDataDefEntryKindButtonDataDef.getSelection() || this.fDataDefEntryKindButtonSubParam.getSelection()) && errorMessage == null);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogAreaComposite = (Composite)super.createDialogArea(parent);
        this.fComposite = new Composite(dialogAreaComposite, 0);
        this.fComposite.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fComposite);
        this.setTitle(this.fTitle);
        this.setMessage(Messages.DataDefinitionEntryDialog_HEADER);
        this.fDataDefEntryKindButtonDataDef = this.createKindRadioButton(this.fComposite, Messages.DataDefinitionEntryDialog_KIND_DATA_DEF, 16400);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fDataDefEntryKindButtonDataDef.setLayoutData((Object)gridData);
        this.fDataDefinitionText = new Text(this.fComposite, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.fDataDefinitionText.setLayoutData((Object)gridData);
        this.fDataDefinitionText.setEditable(false);
        this.fDataDefinitionText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.DataDefinitionEntryDialog_KIND_DATA_DEF;
            }
        });
        this.fBrowseButton = new Button(this.fComposite, 0);
        this.fBrowseButton.setText(Messages.DataDefinitionEntryDialog_BROWSE_BUTTON_WITH_ELLIPSIS);
        this.fBrowseButton.addSelectionListener(this.getEditButtonSelectionListener());
        this.fBrowseButton.setEnabled(false);
        this.fDataDefEntryKindButtonSubParam = this.createKindRadioButton(this.fComposite, Messages.DataDefinitionEntryDialog_KIND_SUB_PARAM, 16400);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fDataDefEntryKindButtonSubParam.setLayoutData((Object)gridData);
        this.fSubParamText = new Text(this.fComposite, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fSubParamText.setLayoutData((Object)gridData);
        this.fSubParamText.setEnabled(false);
        this.fSubParamText.setEditable(false);
        this.fSubParamText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.DataDefinitionEntryDialog_KIND_SUB_PARAM;
            }
        });
        this.updateEntryKindRadioButtonValues();
        this.fSubParamText.addModifyListener(this.getSubParamModifiedListener());
        this.createSpacer(this.fComposite, 2, 2);
        this.fMemberButton = this.createCheckbox(this.fComposite, Messages.DDAllocationDialog_MEMBER_LABEL, 32);
        this.fMemberButton.setSelection(this.fConcatenationDSD.isMember());
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fMemberButton.setLayoutData((Object)gridData);
        this.fMemberButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConcatenationDSDDialog.this.fConcatenationDSD.setMember(ConcatenationDSDDialog.this.fMemberButton.getSelection());
                if (ConcatenationDSDDialog.this.fConcatenationDSDList.size() > 0) {
                    ConcatenationDSDDialog.this.fConcatenationDSDList.get(0).setMember(ConcatenationDSDDialog.this.fMemberButton.getSelection());
                }
            }
        });
        ConcatenationDSDDialog.applyDialogFont((Control)this.fComposite);
        if (this.fDataDefEntryKindButtonDataDef.getSelection()) {
            this.fBrowseButton.setFocus();
        } else if (this.fDataDefEntryKindButtonSubParam.getSelection()) {
            this.fSubParamText.setFocus();
            this.fSubParamText.selectAll();
        } else {
            this.fDataDefEntryKindButtonDataDef.setFocus();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.build.ui.dialog_datadefinition");
        return this.fComposite;
    }

    private Button createKindRadioButton(Composite parent, String text, int style) {
        Button radioButton = new Button(parent, style);
        radioButton.setText(text);
        radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConcatenationDSDDialog.this.handleKindUpdate();
            }
        });
        return radioButton;
    }

    protected void handleKindUpdate() {
        if (this.fDataDefEntryKindButtonDataDef.getSelection()) {
            this.fConcatenationDSD.setKind("com.ibm.teamz.langdef.entry.data_definition");
            this.fConcatenationDSD.setValue("");
        } else if (this.fDataDefEntryKindButtonSubParam.getSelection()) {
            this.fConcatenationDSD.setKind("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable");
            this.fConcatenationDSD.setValue("");
        }
        this.updateEntryKindEnablement();
        this.validate(false);
    }

    protected void updateEntryKindRadioButtonValues() {
        this.updateEntryKindEnablement();
        if (this.fConcatenationDSD.getKind() == null || this.fConcatenationDSD.getKind().equals("")) {
            return;
        }
        if (this.fConcatenationDSD.getKind().equals("com.ibm.teamz.langdef.entry.data_definition")) {
            this.fDataDefEntryKindButtonDataDef.setSelection(true);
            String value = this.fConcatenationDSD.getValue();
            if (value != null && !value.equals("")) {
                value = Messages.DDAllocationDialog_PENDING;
                DataDefinitionEntryLabelHelper labelHelper = this.getLabelHelper();
                IModeledDataDefinitionEntryContext context = this.getDataDefinitionEntryContext(this.fConcatenationDSD);
                labelHelper.getDataDefinitionEntryValueLabelInBackground(context);
            }
        } else if (this.fConcatenationDSD.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable")) {
            this.fDataDefEntryKindButtonSubParam.setSelection(true);
            this.fSubParamText.setText(this.fConcatenationDSD.getValue() == null ? "" : this.fConcatenationDSD.getValue());
        }
    }

    protected void updateEntryKindEnablement() {
        if (this.fConcatenationDSD.getKind() == null || this.fConcatenationDSD.getKind().equals("")) {
            this.fBrowseButton.setEnabled(false);
            this.fSubParamText.setEnabled(false);
            this.fSubParamText.setEditable(false);
            this.fSubParamText.setText("");
            this.fDataDefinitionText.setText("");
        } else if (this.fConcatenationDSD.getKind().equals("com.ibm.teamz.langdef.entry.data_definition")) {
            this.fBrowseButton.setEnabled(true);
            this.fSubParamText.setEnabled(false);
            this.fSubParamText.setEditable(false);
            this.fSubParamText.setText("");
        } else if (this.fConcatenationDSD.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable")) {
            this.fSubParamText.setEnabled(true);
            this.fSubParamText.setEditable(true);
            this.fBrowseButton.setEnabled(false);
            this.fDataDefinitionText.setText("");
        }
    }

    private ModifyListener getSubParamModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConcatenationDSDDialog.this.validate(false);
                if (ConcatenationDSDDialog.this.fConcatenationDSD.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable")) {
                    ConcatenationDSDDialog.this.fConcatenationDSD.setValue(ConcatenationDSDDialog.this.fSubParamText.getText().trim());
                }
            }
        };
    }

    protected void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = new Label(parent, 64);
        label.setText("");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = horizontalSpan;
        label.setLayoutData((Object)gridData);
    }

    private Button createCheckbox(Composite composite, String text, int check) {
        Button checkBox = new Button(composite, check);
        checkBox.setText(text);
        return checkBox;
    }

    protected Label createLabel(Composite composite, String text, Color color) {
        Label label = new Label(composite, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        label.setText(text);
        label.setForeground(color);
        return label;
    }

    protected Text createText(Composite parent, String labelText, String defaultText, int textHorizontalSpan) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData());
        Text text = new Text(parent, 2052);
        if (defaultText != null) {
            text.setText(defaultText);
        }
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = textHorizontalSpan;
        text.setLayoutData((Object)gridData);
        return text;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.fTitle);
    }

    public void create() {
        super.create();
        this.validate(true);
    }

    public String getErrorMessage() {
        if (this.fDataDefEntryKindButtonDataDef.getSelection()) {
            String value = this.fDataDefinitionText.getText().trim();
            if (value == null || value.equals("")) {
                return Messages.DataDefinitionEntryDialog_DATA_DEF_REQUIRED;
            }
            return null;
        }
        if (this.fDataDefEntryKindButtonSubParam.getSelection()) {
            String value = this.fSubParamText.getText().trim();
            if (value == null || value.equals("")) {
                return Messages.DataDefinitionEntryDialog_SUB_PARAM_REQUIRED;
            }
            if (value.indexOf(32) > -1) {
                return Messages.Common_NO_SPACES_IN_BUILD_PROPERTY;
            }
            if (!AbstractSystemDefinitionEditor.isValidBuildProperty((String)value)) {
                return Messages.Common_INVALID_BUILD_PROPERTY_NAME;
            }
            return null;
        }
        return null;
    }

    private SelectionListener getEditButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConcatenationDSDDialog.this.editDataDefinition();
                ConcatenationDSDDialog.this.validate(false);
            }
        };
    }

    private void editDataDefinition() {
        try {
            Object[] dsDefs;
            DataSetDefinitionSelectionDialog dialog = new DataSetDefinitionSelectionDialog(this.fComposite.getShell(), this.fTeamRepository, null);
            dialog.setAllowMultiple(this.fIsNew);
            if (dialog.open() == 0 && (dsDefs = dialog.getSelectedSystemDefinitions()) != null && dsDefs.length > 0) {
                String datasetText = null;
                Object[] objectArray = dsDefs;
                int n = dsDefs.length;
                int n2 = 0;
                while (n2 < n) {
                    Object dsdef = objectArray[n2];
                    ISystemDefinition datasetDef = (ISystemDefinition)dsdef;
                    if ((datasetText = datasetText == null ? datasetDef.getName() : datasetText.concat(", " + datasetDef.getName())) != null) {
                        DataDefinitionEntry entryItem = ModelFactory.eINSTANCE.createDataDefinitionEntry();
                        entryItem.setKind(this.fConcatenationDSD.getKind());
                        entryItem.setValue(datasetDef.getItemId().getUuidValue());
                        entryItem.setMember(this.fConcatenationDSD.isMember());
                        this.fConcatenationDSDList.add((com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry)entryItem);
                    }
                    ++n2;
                }
                if (datasetText != null) {
                    this.fDataDefinitionText.setText(datasetText);
                }
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
    }

    protected DataDefinitionEntryLabelHelper getLabelHelper() {
        return new DataDefinitionEntryLabelHelper(){

            @Override
            public void labelAvailable(String label, com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry dataDefEntry) {
                if (!ConcatenationDSDDialog.this.fDataDefinitionText.isDisposed()) {
                    ConcatenationDSDDialog.this.fDataDefinitionText.setText(label);
                    ConcatenationDSDDialog.this.validate(false);
                }
            }
        };
    }

    protected IModeledDataDefinitionEntryContext getDataDefinitionEntryContext(final com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry entry) {
        return new IModeledDataDefinitionEntryContext(){

            @Override
            public com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry getModeledEntry() {
                return entry;
            }

            @Override
            public ITeamRepository getTeamRepository() {
                return ConcatenationDSDDialog.this.fTeamRepository;
            }

            @Override
            public IDataDefinitionEntry getEntry() {
                return null;
            }
        };
    }

    public List<com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry> getConcatenationDSDs() {
        if (this.fConcatenationDSD.getKind().equalsIgnoreCase("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable") || this.fConcatenationDSDList.isEmpty()) {
            this.fConcatenationDSDList.clear();
            this.fConcatenationDSDList.add(this.fConcatenationDSD);
        }
        return this.fConcatenationDSDList;
    }
}

