/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors;

import com.ibm.team.enterprise.systemdefinition.common.internal.model.DataDefinitionEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionCache;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.AbstractCompositeSystemDefinitionControl;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.ConcatenationDSDDialog;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.ConcatenationDSDTableContentProvider;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.ConcatenationDSDTableLabelProvider;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ConcatenationDSDControl
extends AbstractCompositeSystemDefinitionControl {
    protected ITeamRepository fTeamRepository;
    protected Shell fParentShell;
    protected List<IDataDefinitionEntry> fDataDefinitionEntries;
    protected Button fAddConcatenationDSDButton;
    protected Button fEditConcatenationDSDButton;
    protected Button fRemoveConcatenationDSDButton;
    protected Button fUpButton;
    protected Button fDownButton;
    protected TableViewer fTableViewer;
    private static final String COLUMN_NAME = "name";
    private static final String COLUMN_MEMBER = "member";
    private final FormToolkit fToolkit;
    private final Composite fComposite;

    public ConcatenationDSDControl(Composite parent, FormToolkit toolkit, List<IDataDefinitionEntry> concatenationDSDs, ITeamRepository teamRepository, boolean isEditable) {
        this(parent, toolkit, concatenationDSDs, teamRepository, isEditable, null);
    }

    public ConcatenationDSDControl(Composite parent, FormToolkit toolkit, List<IDataDefinitionEntry> concatenationDSDs, ITeamRepository teamRepository, boolean isEditable, ISystemDefinitionCache definitionCache) {
        super(teamRepository, definitionCache);
        this.fDataDefinitionEntries = concatenationDSDs;
        this.fParentShell = parent.getShell();
        this.fToolkit = toolkit;
        this.fTeamRepository = teamRepository;
        this.fComposite = this.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.fComposite);
        Composite tableComposite = this.createComposite(this.fComposite);
        GridDataFactory.fillDefaults().grab(true, true).span(isEditable ? 1 : 2, 1).applyTo((Control)tableComposite);
        Table table = this.createTable(tableComposite, 68354);
        TableColumnLayout tcl = new TableColumnLayout();
        String[] columnProperties = new String[]{COLUMN_NAME, COLUMN_MEMBER};
        String[] columnHeaders = new String[]{Messages.ConcatenationsControl_NAME, Messages.ConcatenationsControl_MEMBER};
        int[] columnWeights = new int[]{70, 30};
        int i = 0;
        while (i < columnHeaders.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columnHeaders[i]);
            tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(columnWeights[i]));
            ++i;
        }
        tableComposite.setLayout((Layout)tcl);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fTableViewer = this.getTableViewer(table);
        this.fTableViewer.setColumnProperties(columnProperties);
        ConcatenationDSDTableLabelProvider labelProvider = new ConcatenationDSDTableLabelProvider(this.fTableViewer, teamRepository, this);
        this.fTableViewer.setContentProvider((IContentProvider)new ConcatenationDSDTableContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fTableViewer.setInput(this.fDataDefinitionEntries);
        this.fTableViewer.addSelectionChangedListener(this.getSelectionChangedListener());
        if (isEditable) {
            this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    ConcatenationDSDControl.this.handleDoubleClick(event);
                }
            });
            Composite buttonBar = this.createComposite(this.fComposite);
            buttonBar.setLayoutData((Object)new GridData(131072, 4, false, true));
            buttonBar.setLayout((Layout)new GridLayout(1, false));
            this.fAddConcatenationDSDButton = this.createButton(buttonBar, Messages.DataDefinitionEntryControl_ADD_BUTTON_LABEL_WITH_ELLIPSIS, 8);
            this.fAddConcatenationDSDButton.addSelectionListener(this.getAddEntryListener());
            this.fRemoveConcatenationDSDButton = this.createButton(buttonBar, Messages.DataDefinitionEntryControl_REMOVE_BUTTON_LABEL, 8);
            this.fRemoveConcatenationDSDButton.addSelectionListener(this.getRemoveEntryListener());
            this.fEditConcatenationDSDButton = this.createButton(buttonBar, Messages.DataDefinitionEntryControl_EDIT_BUTTON_LABEL_WITH_ELLIPSIS, 8);
            this.fEditConcatenationDSDButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IDataDefinitionEntry entry = ConcatenationDSDControl.this.getSelectedEntry();
                    if (entry != null) {
                        ConcatenationDSDControl.this.editEntry(entry);
                    }
                }
            });
            this.fUpButton = this.createButton(buttonBar, Messages.DataDefinitionEntryControl_UP_BUTTON, 8);
            this.fUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConcatenationDSDControl.this.moveEntries(true);
                }
            });
            this.fDownButton = this.createButton(buttonBar, Messages.DataDefinitionEntryControl_DOWN_BUTTON, 8);
            this.fDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConcatenationDSDControl.this.moveEntries(false);
                }
            });
            this.updateButtonEnablement();
            this.setButtonLayoutData();
        }
    }

    private void moveEntries(boolean up) {
        ISelection selection = this.fTableViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (up) {
                for (IDataDefinitionEntry entry : structuredSelection) {
                    int orig = this.fDataDefinitionEntries.indexOf(entry);
                    this.fDataDefinitionEntries.remove(entry);
                    this.fDataDefinitionEntries.add(orig - 1, entry);
                }
            } else {
                Vector<IDataDefinitionEntry> move = new Vector<IDataDefinitionEntry>();
                for (IDataDefinitionEntry entry : structuredSelection) {
                    move.add(0, entry);
                }
                int i = 0;
                while (i < move.size()) {
                    int orig = this.fDataDefinitionEntries.indexOf(move.get(i));
                    this.fDataDefinitionEntries.remove(move.get(i));
                    this.fDataDefinitionEntries.add(orig + 1, (IDataDefinitionEntry)move.get(i));
                    ++i;
                }
            }
            this.fTableViewer.refresh();
            this.updateButtonEnablement();
        }
    }

    protected SelectionListener getRemoveEntryListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConcatenationDSDControl.this.removeSelectedEntries();
            }
        };
    }

    protected ISelectionChangedListener getSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConcatenationDSDControl.this.updateButtonEnablement();
            }
        };
    }

    protected SelectionListener getAddEntryListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConcatenationDSDControl.this.addConcatenationDSD();
            }
        };
    }

    public List<IDataDefinitionEntry> getConcatenationDSDs() {
        return this.fDataDefinitionEntries;
    }

    public void setDataDefinitionEntries(List<IDataDefinitionEntry> concatenationDSDs) {
        this.fDataDefinitionEntries = concatenationDSDs;
        this.fTableViewer.setInput(this.fDataDefinitionEntries);
        this.updateButtonEnablement();
    }

    public Composite getComposite() {
        return this.fComposite;
    }

    private void addConcatenationDSD() {
        String title;
        DataDefinitionEntry concatDSD = ModelFactory.eINSTANCE.createDataDefinitionEntry();
        ConcatenationDSDDialog dialog = this.getConcatenationDSDDialog((IDataDefinitionEntry)concatDSD, title = Messages.DataDefinitionEntryControl_ADD_DATA_DEF_TITLE, true);
        if (dialog.open() == 0) {
            List<IDataDefinitionEntry> selectedDSDs = dialog.getConcatenationDSDs();
            for (IDataDefinitionEntry selectedDSD : selectedDSDs) {
                if (this.isDuplicate(selectedDSD)) continue;
                this.fDataDefinitionEntries.add(selectedDSD);
            }
            this.fTableViewer.refresh();
            this.updateButtonEnablement();
        }
    }

    protected boolean isDuplicate(IDataDefinitionEntry entry) {
        boolean duplicate = false;
        for (IDataDefinitionEntry o : this.fDataDefinitionEntries) {
            if (!entry.getValue().equals(o.getValue()) || !entry.getKind().equals(o.getKind()) || entry.isMember() != o.isMember()) continue;
            duplicate = true;
            break;
        }
        return duplicate;
    }

    protected ConcatenationDSDDialog getConcatenationDSDDialog(IDataDefinitionEntry dataDefEntry, String title, boolean isNew) {
        return new ConcatenationDSDDialog(this.fComposite.getShell(), title, dataDefEntry, isNew, this.fTeamRepository);
    }

    private void editEntry(IDataDefinitionEntry concatDSD) {
        String title = Messages.DataDefinitionEntryControl_EDIT_DATA_DEF_TITLE;
        ConcatenationDSDDialog dialog = this.getConcatenationDSDDialog(concatDSD, title, false);
        if (dialog.open() == 0) {
            DataDefinitionEntry concatDSDTemp = ModelFactory.eINSTANCE.createDataDefinitionEntry();
            List<IDataDefinitionEntry> resultList = dialog.getConcatenationDSDs();
            if (resultList != null && !resultList.isEmpty()) {
                IDataDefinitionEntry firstEntry = resultList.get(0);
                concatDSDTemp.setKind(firstEntry.getKind());
                concatDSDTemp.setValue(firstEntry.getValue());
                concatDSDTemp.setMember(firstEntry.isMember());
                if (!this.isDuplicate((IDataDefinitionEntry)concatDSDTemp)) {
                    concatDSD.setKind(firstEntry.getKind());
                    concatDSD.setValue(firstEntry.getValue());
                    concatDSD.setMember(firstEntry.isMember());
                }
            }
            this.fTableViewer.refresh();
        }
    }

    private void removeSelectedEntries() {
        ISelection selection;
        boolean deleteConfirmed = MessageDialog.openQuestion((Shell)this.fParentShell, (String)Messages.DataDefinitionEntryControl_CONFIRM_TITLE, (String)Messages.DataDefinitionEntryControl_CONFIRM);
        if (deleteConfirmed && (selection = this.fTableViewer.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ArrayList<IDataDefinitionEntry> entriesRemoved = new ArrayList<IDataDefinitionEntry>();
            for (IDataDefinitionEntry entry : structuredSelection) {
                this.fTableViewer.remove((Object)entry);
                this.fDataDefinitionEntries.remove(entry);
                entriesRemoved.add(entry);
            }
            if (!entriesRemoved.isEmpty()) {
                this.fTableViewer.refresh();
                this.updateButtonEnablement();
            }
        }
    }

    protected IStructuredSelection getCurrentEntrySelection() {
        return (IStructuredSelection)this.fTableViewer.getSelection();
    }

    private IDataDefinitionEntry getSelectedEntry() {
        IStructuredSelection selection = this.getCurrentEntrySelection();
        Object element = selection.getFirstElement();
        if (element instanceof IDataDefinitionEntry) {
            return (IDataDefinitionEntry)element;
        }
        return null;
    }

    private void updateButtonEnablement() {
        if (this.fEditConcatenationDSDButton == null) {
            return;
        }
        IStructuredSelection selection = this.getCurrentEntrySelection();
        this.fEditConcatenationDSDButton.setEnabled(selection.size() == 1);
        this.fRemoveConcatenationDSDButton.setEnabled(!selection.isEmpty());
        if (!selection.isEmpty()) {
            int size = selection.size();
            IDataDefinitionEntry first = (IDataDefinitionEntry)selection.getFirstElement();
            if (this.fDataDefinitionEntries.indexOf(first) == 0) {
                this.fUpButton.setEnabled(false);
            } else {
                this.fUpButton.setEnabled(true);
            }
            if (this.fDataDefinitionEntries.indexOf(first) + size == this.fDataDefinitionEntries.size()) {
                this.fDownButton.setEnabled(false);
            } else {
                this.fDownButton.setEnabled(true);
            }
        } else {
            this.fDownButton.setEnabled(false);
            this.fUpButton.setEnabled(false);
        }
    }

    private Composite createComposite(Composite parent) {
        if (this.fToolkit != null) {
            return this.fToolkit.createComposite(parent);
        }
        return new Composite(parent, 0);
    }

    private Button createButton(Composite parent, String label, int style) {
        if (this.fToolkit != null) {
            return this.fToolkit.createButton(parent, label, style);
        }
        Button button = new Button(parent, style);
        button.setText(label);
        return button;
    }

    private Table createTable(Composite parent, int style) {
        if (this.fToolkit != null) {
            return this.fToolkit.createTable(parent, style);
        }
        return new Table(parent, style);
    }

    private void handleDoubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (element instanceof IDataDefinitionEntry) {
            IDataDefinitionEntry entry = (IDataDefinitionEntry)element;
            this.editEntry(entry);
        }
    }

    private void setButtonLayoutData() {
        GC gc = new GC((Drawable)this.fAddConcatenationDSDButton);
        gc.setFont(this.fAddConcatenationDSDButton.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int maxWidth = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        Point minSize = this.fAddConcatenationDSDButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fEditConcatenationDSDButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fRemoveConcatenationDSDButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fUpButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        minSize = this.fDownButton.computeSize(-1, -1, true);
        maxWidth = Math.max(maxWidth, minSize.x);
        GridData gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fAddConcatenationDSDButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fEditConcatenationDSDButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fRemoveConcatenationDSDButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fUpButton.setLayoutData((Object)gridData);
        gridData = new GridData(128);
        gridData.widthHint = maxWidth;
        this.fDownButton.setLayoutData((Object)gridData);
    }

    public void setEnabled(boolean enabled) {
        this.fAddConcatenationDSDButton.setEnabled(enabled);
        this.fEditConcatenationDSDButton.setEnabled(enabled);
        this.fRemoveConcatenationDSDButton.setEnabled(enabled);
        this.fTableViewer.getTable().setEnabled(enabled);
        if (enabled) {
            this.updateButtonEnablement();
        }
    }

    public Viewer getViewer() {
        return this.fTableViewer;
    }

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    protected TableViewer getTableViewer(Table table) {
        return new TableViewer(table);
    }

    public void refresh() {
        this.fTableViewer.refresh();
    }
}

