/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors;

import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractSystemDefinitionEditor;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.ZDefUIPlugin;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.AbstractSystemDefinitionEditorPage;
import com.ibm.team.repository.client.ITeamRepository;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public abstract class AbstractLanguageDefinitionItemEditorPage
extends AbstractSystemDefinitionEditorPage {
    private Composite fContentContainer;
    private IManagedForm fManagedForm;
    private ITeamRepository fTeamRepository;
    private boolean fDirty;
    private AbstractSystemDefinitionEditor fEditor;

    public AbstractLanguageDefinitionItemEditorPage(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    public abstract void setWorkingCopy(ISystemDefinition var1);

    public abstract void createContent(Composite var1, FormToolkit var2);

    public abstract boolean validate();

    public Control getFocusControl() {
        return null;
    }

    public void initialize(AbstractSystemDefinitionEditor editor) {
        super.initialize((FormEditor)editor);
        this.fEditor = editor;
        this.fTeamRepository = editor.getTeamRepository();
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.fManagedForm = managedForm;
        managedForm.getToolkit().setBorderStyle(2048);
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        TableWrapLayout layout = new TableWrapLayout();
        body.setLayout((Layout)layout);
        body.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fContentContainer = this.createContentContainer(this.fManagedForm);
        this.createContent(this.fContentContainer, this.fManagedForm.getToolkit());
        this.handleReadOnlyMode(this.fContentContainer);
    }

    protected ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    public void setDirty(boolean isDirty) {
        this.fDirty = isDirty;
        this.fEditor.setDirty(isDirty);
        this.fEditor.fireDirtyPropertyChangeEvent();
    }

    public void refresh() {
        if (this.fContentContainer != null && !this.fContentContainer.isDisposed()) {
            this.fContentContainer.dispose();
            this.fContentContainer = this.createContentContainer(this.fManagedForm);
            this.createContent(this.fContentContainer, this.fManagedForm.getToolkit());
            this.validate();
        }
        this.setDirty(false);
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    private Composite createContentContainer(IManagedForm managedForm) {
        Composite container = managedForm.getToolkit().createComposite(managedForm.getForm().getBody());
        TableWrapData layoutData = new TableWrapData(256, 256);
        container.setLayoutData((Object)layoutData);
        return container;
    }

    protected void setPageErrorIndicator(boolean isError) {
        Image image = null;
        if (isError && this.fEditor.isSaveAttempted()) {
            image = ZDefUIPlugin.getImage("icons/ovr16/failed_ovr.gif");
        }
        this.fEditor.setPageImage(this.getIndex(), image);
    }

    public void addErrorMessage(Object id, String message, Control control) {
        this.fEditor.addErrorMessage(id, message, control, this.getIndex());
    }

    public void addWarningMessage(Object id, String message, Control control) {
        this.fEditor.addWarningMessage(id, message, control, this.getIndex());
    }

    public void addErrorMessageForRequiredField(Object id, String message, Control control) {
        if (this.fEditor.isSaveAttempted()) {
            this.fEditor.addErrorMessage(id, message, control, this.getIndex());
        }
    }

    public void addErrorMessage(Object id, String message, IStatus status) {
        this.fEditor.addErrorMessage(id, message, status);
    }

    public void removeErrorMessage(Object id, Control control) {
        this.fEditor.removeErrorMessage(id, control);
    }

    public void removeErrorMessage(Object id) {
        this.fEditor.removeErrorMessage(id);
    }

    public void setFocus() {
        if (this.getFocusControl() != null) {
            this.getFocusControl().setFocus();
        } else {
            ((AbstractSystemDefinitionEditor)this.getEditor()).setFocusInHeader();
        }
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fManagedForm.getForm(), this.getContextHelpId());
        }
    }

    protected abstract String getContextHelpId();

    protected void createSpacer(FormToolkit fToolkit, Composite parent, int height, int horizontalSpan) {
        Label label = fToolkit.createLabel(parent, "");
        TableWrapData tableWrapData = new TableWrapData(128, 32, 1, horizontalSpan);
        tableWrapData.heightHint = height;
        label.setLayoutData((Object)tableWrapData);
    }

    protected Text createLabeledText(FormToolkit fToolkit, Composite parent, String label, String tooltip, String textValue) {
        return this.createLabeledText(fToolkit, parent, label, tooltip, textValue, 1);
    }

    protected Text createLabeledText(FormToolkit fToolkit, Composite parent, String label, String tooltip, String textValue, int horizontalSpan) {
        Label l = fToolkit.createLabel(parent, label);
        l.setToolTipText(tooltip);
        Text text = fToolkit.createText(parent, textValue);
        text.setLayoutData((Object)new TableWrapData(256, 128, 1, horizontalSpan));
        return text;
    }
}

