/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors;

import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.ZDefUIPlugin;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.AbstractSystemDefinitionEditorPage;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.DataSetDefinitionEditor;
import com.ibm.team.repository.client.ITeamRepository;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public abstract class AbstractDataSetDefinitionEditorPage
extends AbstractSystemDefinitionEditorPage {
    private Composite fContentContainer;
    private IManagedForm fManagedForm;
    private ITeamRepository fTeamRepository;
    private boolean fDirty;
    protected DataSetDefinitionEditor fDataSetDefinitionEditor;

    public AbstractDataSetDefinitionEditorPage(String elementId, String title) {
        super(elementId, title);
    }

    public abstract void createContent(Composite var1, FormToolkit var2);

    public abstract boolean validate();

    public Control getFocusControl() {
        return null;
    }

    public void initialize(DataSetDefinitionEditor editor) {
        super.initialize((FormEditor)editor);
        this.fDataSetDefinitionEditor = editor;
        this.fTeamRepository = editor.getTeamRepository();
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.fManagedForm = managedForm;
        managedForm.getToolkit().setBorderStyle(2048);
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        TableWrapLayout layout = new TableWrapLayout();
        body.setLayout((Layout)layout);
        this.fContentContainer = this.createContentContainer(this.fManagedForm);
        this.createContent(this.fContentContainer, this.fManagedForm.getToolkit());
        this.handleReadOnlyMode(this.fContentContainer);
    }

    protected ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    public void setDirty(boolean isDirty) {
        this.fDirty = isDirty;
        this.fDataSetDefinitionEditor.setDirty(isDirty);
        this.fDataSetDefinitionEditor.fireDirtyPropertyChangeEvent();
    }

    public void refresh() {
        if (this.fContentContainer != null && !this.fContentContainer.isDisposed()) {
            this.fContentContainer.dispose();
            this.fContentContainer = this.createContentContainer(this.fManagedForm);
            this.createContent(this.fContentContainer, this.fManagedForm.getToolkit());
            this.validate();
        }
        this.setDirty(false);
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    private Composite createContentContainer(IManagedForm managedForm) {
        Composite container = managedForm.getToolkit().createComposite(managedForm.getForm().getBody());
        TableWrapData layoutData = new TableWrapData(256, 256);
        container.setLayoutData((Object)layoutData);
        return container;
    }

    protected void setPageErrorIndicator(boolean isError) {
        Image image = null;
        if (isError && this.fDataSetDefinitionEditor.isSaveAttempted()) {
            image = ZDefUIPlugin.getImage("icons/ovr16/failed_ovr.gif");
        }
        this.fDataSetDefinitionEditor.setPageImage(this.getIndex(), image);
    }

    public void addErrorMessage(Object id, String message, Control control) {
        this.fDataSetDefinitionEditor.addErrorMessage(id, message, control, this.getIndex());
    }

    public void addErrorMessageForRequiredField(Object id, String message, Control control) {
        if (this.fDataSetDefinitionEditor.isSaveAttempted()) {
            this.fDataSetDefinitionEditor.addErrorMessage(id, message, control, this.getIndex());
        }
    }

    public void addErrorMessage(Object id, String message, IStatus status) {
        this.fDataSetDefinitionEditor.addErrorMessage(id, message, status);
    }

    public void removeErrorMessage(Object id, Control control) {
        this.fDataSetDefinitionEditor.removeErrorMessage(id, control);
    }

    public void removeErrorMessage(Object id) {
        this.fDataSetDefinitionEditor.removeErrorMessage(id);
    }

    public void setFocus() {
        if (this.getFocusControl() != null) {
            this.getFocusControl().setFocus();
        } else {
            ((DataSetDefinitionEditor)this.getEditor()).setFocusInHeader();
        }
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fManagedForm.getForm(), this.getContextHelpId());
        }
    }

    protected String getContextHelpId() {
        return null;
    }

    protected void createSpacer(FormToolkit fToolkit, Composite parent, int height, int horizontalSpan) {
        Label spacingLabel = fToolkit.createLabel(parent, "");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = horizontalSpan;
        gridData.heightHint = height;
        spacingLabel.setLayoutData((Object)gridData);
    }

    protected Text createLabeledText(FormToolkit fToolkit, Composite parent, String label, String tooltip, String textValue) {
        return this.createLabeledText(fToolkit, parent, label, tooltip, textValue, 1);
    }

    protected Text createLabeledText(FormToolkit fToolkit, Composite parent, String label, String tooltip, String textValue, int horizontalSpan) {
        Label l = fToolkit.createLabel(parent, label);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        l.setLayoutData((Object)gridData);
        l.setToolTipText(tooltip);
        Text text = fToolkit.createText(parent, textValue);
        gridData = new GridData(768);
        gridData.horizontalSpan = horizontalSpan;
        text.setLayoutData((Object)gridData);
        return text;
    }

    protected Label createLabel(FormToolkit fToolkit, Composite parent, String label, String tooltip) {
        Label l = fToolkit.createLabel(parent, label);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        l.setLayoutData((Object)gridData);
        l.setToolTipText(tooltip);
        return l;
    }

    protected Text createText(FormToolkit fToolkit, Composite parent, String textValue, int horizontalSpan) {
        Text text = fToolkit.createText(parent, textValue);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = horizontalSpan;
        text.setLayoutData((Object)gridData);
        return text;
    }
}

