/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.internal.systemdefinition.ui.domain.dsdef;

import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainRegistry;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.SystemDefinitionJob;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.ZDefUIPlugin;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.domain.actions.SystemDefDomainActionHelper;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.domain.dsdef.DataSetDefinitionNodeEE;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IElementCollector;

public class DataSetDefinitionsNodeEE
extends AbstractEnterpriseExtensionsNode {
    private boolean fFetchInProgress;
    private List<DataSetDefinitionNodeEE> elements = Collections.emptyList();

    public Image getIcon() {
        return ZDefUIPlugin.getImage("icons/obj16/dsdefs_obj.gif");
    }

    public String getLabel() {
        return Messages.DataSetDefinitionsNodeEE_DSDLabel;
    }

    public boolean hasChildren() {
        return true;
    }

    public void contributeContextMenuActions(IMenuManager manager, IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        SystemDefDomainActionHelper actionHelper = new SystemDefDomainActionHelper(manager, selection, this.getDomainSubtreeRoot().getDomain().getWorkbenchPart().getSite());
        actionHelper.contributeActions();
        super.contributeContextMenuActions(manager, selection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDeferredChildren(IElementCollector collector, IProgressMonitor monitor) {
        DataSetDefinitionsNodeEE dataSetDefinitionsNodeEE = this;
        synchronized (dataSetDefinitionsNodeEE) {
            if (this.fFetchInProgress) {
                return;
            }
            this.fFetchInProgress = true;
        }
        try {
            monitor.beginTask("", -1);
            this.getChildrenOfDataSetDefinitionNode(this.getDomainSubtreeRoot(), collector, monitor);
        }
        finally {
            this.fFetchInProgress = false;
            collector.done();
            monitor.done();
        }
    }

    private void getChildrenOfDataSetDefinitionNode(DomainSubtreeRoot parent, IElementCollector collector, IProgressMonitor monitor) {
        Object category = parent.getCategoryElement();
        if (category instanceof ITeamArea) {
            category = ((ITeamArea)category).getProjectArea();
        }
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)category;
        ArrayList<DataSetDefinitionNodeEE> nodes = new ArrayList<DataSetDefinitionNodeEE>();
        ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
        ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)teamRepository);
        try {
            boolean showArchived = EnterpriseExtensionsDomainRegistry.getInstance().getArchivefilterListener().isShowArchived();
            DomainSubtreeRoot treeRoot = this.getDomainSubtreeRoot();
            List dsDefHandles = client.findSystemDefinitions(IDataSetDefinition.ITEM_TYPE, projectAreaHandle, -1, showArchived, Arrays.asList(ISystemDefinition.SMALL_PROFILE), monitor);
            for (ISystemDefinition handle : dsDefHandles) {
                nodes.add(new DataSetDefinitionNodeEE(projectAreaHandle, (IResourceDefinition)handle, treeRoot, this));
            }
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
        this.setElements(nodes);
        collector.add(nodes.toArray(), monitor);
    }

    public List<DataSetDefinitionNodeEE> getElements() {
        return this.elements;
    }

    public void setElements(List<DataSetDefinitionNodeEE> elements) {
        this.elements = elements;
    }

    public boolean fetchAndUpdate(DataSetDefinitionNodeEE element) {
        SystemDefinitionJob job = this.getFetchDataSetDefinitionJob(element);
        job.schedule();
        return true;
    }

    protected SystemDefinitionJob getFetchDataSetDefinitionJob(final DataSetDefinitionNodeEE element) {
        return new SystemDefinitionJob(NLS.bind((String)Messages.DsDefDomainContentProvider_REFRESH_NODE_JOB_NAME, (Object)element.getLabel()), true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)DataSetDefinitionsNodeEE.this.getTeamRepository());
                IResourceDefinition def = element.getSystemDefinition();
                if ((def = (IResourceDefinition)client.fetchSystemDefinition((ISystemDefinitionHandle)def, Arrays.asList(ISystemDefinition.SMALL_PROFILE), monitor)) != null) {
                    element.setDataSetDefinition(def);
                    DataSetDefinitionsNodeEE.this.refreshNode(element);
                }
                return Status.OK_STATUS;
            }
        };
    }

    private void refreshNode(final DataSetDefinitionNodeEE element) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DataSetDefinitionsNodeEE.this.getViewer() != null && !DataSetDefinitionsNodeEE.this.getViewer().getControl().isDisposed()) {
                    ((TreeViewer)DataSetDefinitionsNodeEE.this.getViewer()).refresh((Object)element);
                }
            }
        });
    }

    public void refreshNode(ISystemDefinition systemDefinition) {
        for (DataSetDefinitionNodeEE element : this.getElements()) {
            if (!element.getSystemDefinition().sameItemId((IItemHandle)systemDefinition)) continue;
            element.setDataSetDefinition((IResourceDefinition)systemDefinition);
            this.refreshNode(element);
            break;
        }
    }
}

