/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.internal.systemdefinition.ui.domain.actions;

import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.ui.editors.actions.AbstractDeleteSystemDefinitionActionDelegate;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class DeleteSystemDefinitionActionDelegate
extends AbstractDeleteSystemDefinitionActionDelegate
implements IObjectActionDelegate {
    private ISelection fSelection;
    private final ITeamRepository fTeamRepository;

    public DeleteSystemDefinitionActionDelegate(ITeamRepository repository) {
        this.fTeamRepository = repository;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    protected String getConfirmationMessage() {
        return Messages.DeleteLanguageDefinitionActionDelegate_0;
    }

    protected String getJobLabel() {
        return Messages.DeleteLanguageDefinitionActionDelegate_1;
    }

    protected void performAction(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        ArrayList<ISystemDefinition> selectedSystemDefinitions = new ArrayList<ISystemDefinition>();
        IStructuredSelection selection = (IStructuredSelection)this.fSelection;
        for (Object element : selection) {
            if (!(element instanceof ISystemDefinition)) continue;
            selectedSystemDefinitions.add((ISystemDefinition)element);
        }
        this.removeSystemDefinitions(selectedSystemDefinitions, progressMonitor);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }

    private void removeSystemDefinitions(List<ISystemDefinition> systemDefs, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        progressMonitor.beginTask(Messages.DeleteLanguageDefinitionActionDelegate_1, systemDefs.size());
        try {
            for (ISystemDefinition systemDef : systemDefs) {
                ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.fTeamRepository);
                try {
                    client.deleteSystemDefinition((ISystemDefinitionHandle)systemDef, progressMonitor);
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    // empty catch block
                }
            }
        }
        finally {
            progressMonitor.done();
        }
    }
}

