/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.ref.integrity.resolvers.internal;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.ref.integrity.internal.search.IReferenceResolver2;
import com.ibm.team.enterprise.ref.integrity.internal.search.ITreeNodeLoader;
import com.ibm.team.enterprise.ref.integrity.internal.search.ReferenceTreeNode;
import com.ibm.team.enterprise.ref.integrity.internal.search.TreeNodeLoaderRegistry;
import com.ibm.team.enterprise.ref.integrity.nodes.FileTreeNode;
import com.ibm.team.enterprise.ref.integrity.nodes.FolderTreeNode;
import com.ibm.team.enterprise.ref.integrity.nodes.ProjectTreeNode;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.internal.impl.Packaging;
import com.ibm.team.enterprise.systemdefinition.common.model.IConcatenation;
import com.ibm.team.enterprise.systemdefinition.common.model.IDDAllocation;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IFmidItemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingDetailDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingItemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosTranslator;
import com.ibm.team.enterprise.systemdefinition.ui.util.MessagingTools;
import com.ibm.team.enterprise.zos.ref.integrity.internal.Activator;
import com.ibm.team.enterprise.zos.ref.integrity.internal.Utils;
import com.ibm.team.enterprise.zos.ref.integrity.internal.nls.Messages;
import com.ibm.team.enterprise.zos.ref.integrity.query.dsd.internal.DataSetDefinitionTreeNode;
import com.ibm.team.enterprise.zos.ref.integrity.query.langdefs.internal.LanguageDefinitionTreeNode;
import com.ibm.team.enterprise.zos.ref.integrity.query.translators.internal.TranslatorTreeNode;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ReferenceResolverDataSetDefinition
implements IReferenceResolver2 {
    public String getLoglabel() {
        return Messages.SystemZLangDefReferenceResolver_0;
    }

    private List<ISystemDefinition> getLanguageDefinitions(ITeamRepository repository, ISystemDefinitionModelClient client) {
        ArrayList<ISystemDefinition> languageDefinitions = new ArrayList<ISystemDefinition>();
        List projectAreas = new ArrayList();
        try {
            projectAreas = Utils.getProjectAreas((ITeamRepository)repository);
        }
        catch (TeamRepositoryException e) {
            MessagingTools.openErrorDialog((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ReferenceResolverDataSetDefinition, (String)Messages.ReferenceResolverDataSetDefinition_0, (IStatus)new Status(4, "com.ibm.team.enterprise.zos.ref.integrity", e.getLocalizedMessage()));
            Activator.log(Messages.ReferenceResolverDataSetDefinition_0, e);
        }
        try {
            for (IProjectArea projectArea : projectAreas) {
                List definitions;
                if (projectArea == null || (definitions = client.findSystemDefinitionsComplete(IZosLanguageDefinition.ITEM_TYPE, (IProjectAreaHandle)projectArea, -1, false, (IProgressMonitor)new NullProgressMonitor())) == null) continue;
                languageDefinitions.addAll(definitions);
            }
        }
        catch (TeamRepositoryException e) {
            MessagingTools.openErrorDialog((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ReferenceResolverDataSetDefinition, (String)Messages.ReferenceResolverDataSetDefinition_1, (IStatus)new Status(4, "com.ibm.team.enterprise.zos.ref.integrity", e.getLocalizedMessage()));
            Activator.log(Messages.ReferenceResolverDataSetDefinition_1, e);
        }
        return languageDefinitions;
    }

    private List<ISystemDefinition> getTranslatorDefinitions(ITeamRepository repository, ISystemDefinitionModelClient client) {
        ArrayList<ISystemDefinition> translatorDefinitions = new ArrayList<ISystemDefinition>();
        List projectAreas = new ArrayList();
        try {
            projectAreas = Utils.getProjectAreas((ITeamRepository)repository);
        }
        catch (TeamRepositoryException e) {
            MessagingTools.openErrorDialog((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ReferenceResolverDataSetDefinition, (String)Messages.ReferenceResolverDataSetDefinition_0, (IStatus)new Status(4, "com.ibm.team.enterprise.zos.ref.integrity", e.getLocalizedMessage()));
            Activator.log(Messages.ReferenceResolverDataSetDefinition_0, e);
        }
        try {
            for (IProjectArea projectArea : projectAreas) {
                List definitions;
                if (projectArea == null || (definitions = client.findSystemDefinitionsComplete(IZosTranslator.ITEM_TYPE, (IProjectAreaHandle)projectArea, -1, false, (IProgressMonitor)new NullProgressMonitor())) == null) continue;
                translatorDefinitions.addAll(definitions);
            }
        }
        catch (TeamRepositoryException e) {
            MessagingTools.openErrorDialog((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ReferenceResolverDataSetDefinition, (String)Messages.ReferenceResolverDataSetDefinition_3, (IStatus)new Status(4, "com.ibm.team.enterprise.zos.ref.integrity", e.getLocalizedMessage()));
            Activator.log(Messages.ReferenceResolverDataSetDefinition_3, e);
        }
        return translatorDefinitions;
    }

    private List<ISystemDefinition> getVersionDefinitions(ITeamRepository repository, ISystemDefinitionModelClient client) {
        ArrayList<ISystemDefinition> versionDefinitions = new ArrayList<ISystemDefinition>();
        List projectAreas = new ArrayList();
        try {
            projectAreas = Utils.getProjectAreas((ITeamRepository)repository);
        }
        catch (TeamRepositoryException e) {
            MessagingTools.openErrorDialog((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ReferenceResolverDataSetDefinition, (String)Messages.ReferenceResolverDataSetDefinition_0, (IStatus)new Status(4, "com.ibm.team.enterprise.zos.ref.integrity", e.getLocalizedMessage()));
            Activator.log(Messages.ReferenceResolverDataSetDefinition_0, e);
        }
        try {
            for (IProjectArea projectArea : projectAreas) {
                List definitions;
                if (projectArea == null || (definitions = client.findSystemDefinitionsComplete(IVersionDefinition.ITEM_TYPE, (IProjectAreaHandle)projectArea, -1, false, (IProgressMonitor)new NullProgressMonitor())) == null) continue;
                versionDefinitions.addAll(definitions);
            }
        }
        catch (TeamRepositoryException e) {
            MessagingTools.openErrorDialog((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ReferenceResolverDataSetDefinition, (String)Messages.ReferenceResolverDataSetDefinition_2, (IStatus)new Status(4, "com.ibm.team.enterprise.zos.ref.integrity", e.getLocalizedMessage()));
            Activator.log(Messages.ReferenceResolverDataSetDefinition_2, e);
        }
        return versionDefinitions;
    }

    public List<ReferenceTreeNode> referencesTo(List<ISystemDefinition> jazzObjects, ITeamRepository targetRepo) throws Exception {
        return this.extendedReferencesTo(jazzObjects, targetRepo, null);
    }

    public List<String> reReference(ArrayList<ReferenceTreeNode> currentReferences, ISystemDefinition newTarget, ISystemDefinition oldTarget, ITeamRepository repository) {
        Status status;
        ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)repository);
        ArrayList<String> log = new ArrayList<String>();
        TreeNode versionTreeNodeInstance = null;
        try {
            TreeNodeLoaderRegistry instance = TreeNodeLoaderRegistry.getInstance();
            ITreeNodeLoader treeNodeLoader = instance.getLoader("VersionDefinitionTreeNode");
            versionTreeNodeInstance = (TreeNode)treeNodeLoader.getTreeNode(null);
        }
        catch (Exception e) {
            Status status2 = new Status(4, "com.ibm.team.enterprise.zos.ref.integrity", Messages.SystemZDSDReferenceResolver_01);
            Activator.log((IStatus)status2);
            Activator.log(e);
            log.add(Messages.SystemZDSDReferenceResolver_00);
            return log;
        }
        if (!(oldTarget instanceof IDataSetDefinition)) {
            status = new Status(4, "com.ibm.team.enterprise.zos.ref.integrity", Messages.SystemZDSDReferenceResolver_02);
            Activator.log((IStatus)status);
            log.add(Messages.SystemZDSDReferenceResolver_00);
            return log;
        }
        IDataSetDefinition oldDataSetDefinition = (IDataSetDefinition)oldTarget;
        if (!(newTarget instanceof IDataSetDefinition)) {
            status = new Status(4, "com.ibm.team.enterprise.zos.ref.integrity", Messages.SystemZDSDReferenceResolver_03);
            Activator.log((IStatus)status);
            log.add(Messages.SystemZDSDReferenceResolver_00);
            return log;
        }
        IDataSetDefinition newDataSetDefinition = (IDataSetDefinition)newTarget;
        String oldDataSetDefinitionUuid = oldDataSetDefinition.getItemId().getUuidValue();
        String newDataSetDefinitionUuid = newDataSetDefinition.getItemId().getUuidValue();
        for (ReferenceTreeNode referenceTreeNode : currentReferences) {
            IResource resource;
            if (referenceTreeNode instanceof FolderTreeNode) {
                Object status3;
                resource = (IResource)referenceTreeNode.getValue();
                String dsdef = Utils.getArtifactVersionableProperty((IResource)resource, (String)"team.enterprise.resource.definition");
                String folderDistlib = Utils.getArtifactVersionableProperty((IResource)resource, (String)"team.enterprise.smpe.packagingdetail.folder.distlib");
                String folderLocation = Utils.getArtifactVersionableProperty((IResource)resource, (String)"team.enterprise.smpe.packagingdetail.folder.location");
                String folderSyslib = Utils.getArtifactVersionableProperty((IResource)resource, (String)"team.enterprise.smpe.packagingdetail.folder.syslib");
                JSONObject folderDistlibJsonObject = Packaging.getJsonObject((String)folderDistlib);
                JSONObject folderLocationJsonObject = Packaging.getJsonObject((String)folderLocation);
                JSONObject folderSyslibJsonObject = Packaging.getJsonObject((String)folderSyslib);
                if (oldDataSetDefinitionUuid.equals(dsdef)) {
                    status3 = Utils.setArtifactVersionableProperty((IResource)resource, (String)newDataSetDefinitionUuid, (String)"team.enterprise.resource.definition");
                    if (status3.getSeverity() == 0) {
                        log.add(NLS.bind((String)Messages.SystemZDSDReferenceResolver_04, (Object)resource.getName(), (Object[])new Object[]{oldDataSetDefinition.getName(), newDataSetDefinition.getName()}));
                    } else {
                        log.add(NLS.bind((String)Messages.SystemZDSDReferenceResolver_05, (Object)resource.getName(), (Object[])new Object[]{oldDataSetDefinition.getName()}));
                        Activator.log((IStatus)status3);
                    }
                }
                if (folderDistlibJsonObject.containsValue((Object)oldDataSetDefinitionUuid)) {
                    for (Object key : folderDistlibJsonObject.keySet()) {
                        if (!folderDistlibJsonObject.get(key).equals(oldDataSetDefinitionUuid)) continue;
                        folderDistlibJsonObject.put(key, (Object)newDataSetDefinitionUuid);
                    }
                    status3 = Utils.setArtifactVersionableProperty((IResource)resource, (String)folderDistlibJsonObject.toString().replaceAll("\\s", ""), (String)"team.enterprise.smpe.packagingdetail.folder.distlib");
                    if (status3.getSeverity() == 0) {
                        log.add(NLS.bind((String)Messages.SystemZDSDReferenceResolver_06, (Object)resource.getName(), (Object[])new Object[]{oldDataSetDefinition.getName(), newDataSetDefinition.getName()}));
                    } else {
                        log.add(NLS.bind((String)Messages.SystemZDSDReferenceResolver_07, (Object)resource.getName(), (Object[])new Object[]{oldDataSetDefinition.getName()}));
                        Activator.log((IStatus)status3);
                    }
                }
                if (folderLocationJsonObject.containsValue((Object)oldDataSetDefinitionUuid)) {
                    for (Object key : folderLocationJsonObject.keySet()) {
                        if (!folderLocationJsonObject.get(key).equals(oldDataSetDefinitionUuid)) continue;
                        folderLocationJsonObject.put(key, (Object)newDataSetDefinitionUuid);
                    }
                    status3 = Utils.setArtifactVersionableProperty((IResource)resource, (String)folderLocationJsonObject.toString().replaceAll("\\s", ""), (String)"team.enterprise.smpe.packagingdetail.folder.location");
                    if (status3.getSeverity() == 0) {
                        log.add(NLS.bind((String)Messages.SystemZDSDReferenceResolver_08, (Object)resource.getName(), (Object[])new Object[]{oldDataSetDefinition.getName(), newDataSetDefinition.getName()}));
                    } else {
                        log.add(NLS.bind((String)Messages.SystemZDSDReferenceResolver_09, (Object)resource.getName(), (Object[])new Object[]{oldDataSetDefinition.getName()}));
                        Activator.log((IStatus)status3);
                    }
                }
                if (!folderSyslibJsonObject.containsValue((Object)oldDataSetDefinitionUuid)) continue;
                for (Object key : folderSyslibJsonObject.keySet()) {
                    if (!folderSyslibJsonObject.get(key).equals(oldDataSetDefinitionUuid)) continue;
                    folderSyslibJsonObject.put(key, (Object)newDataSetDefinitionUuid);
                }
                status3 = Utils.setArtifactVersionableProperty((IResource)resource, (String)folderSyslibJsonObject.toString().replaceAll("\\s", ""), (String)"team.enterprise.smpe.packagingdetail.folder.syslib");
                if (status3.getSeverity() == 0) {
                    log.add(NLS.bind((String)Messages.SystemZDSDReferenceResolver_10, (Object)resource.getName(), (Object[])new Object[]{oldDataSetDefinition.getName(), newDataSetDefinition.getName()}));
                    continue;
                }
                log.add(NLS.bind((String)Messages.SystemZDSDReferenceResolver_11, (Object)resource.getName(), (Object[])new Object[]{oldDataSetDefinition.getName()}));
                Activator.log((IStatus)status3);
                continue;
            }
            if (referenceTreeNode instanceof FileTreeNode) {
                IStatus status4;
                resource = (IResource)referenceTreeNode.getValue();
                String fileDistlib = Utils.getArtifactVersionableProperty((IResource)resource, (String)"team.enterprise.smpe.packagingdetail.file.distlib");
                String fileLocation = Utils.getArtifactVersionableProperty((IResource)resource, (String)"team.enterprise.smpe.packagingdetail.file.location");
                String fileSyslib = Utils.getArtifactVersionableProperty((IResource)resource, (String)"team.enterprise.smpe.packagingdetail.file.syslib");
                JSONObject fileDistlibJsonObject = Packaging.getJsonObject((String)fileDistlib);
                JSONObject fileLocationJsonObject = Packaging.getJsonObject((String)fileLocation);
                JSONObject fileSyslibJsonObject = Packaging.getJsonObject((String)fileSyslib);
                if (fileDistlibJsonObject.containsValue((Object)oldDataSetDefinitionUuid)) {
                    for (Object key : fileDistlibJsonObject.keySet()) {
                        if (!fileDistlibJsonObject.get(key).equals(oldDataSetDefinitionUuid)) continue;
                        fileDistlibJsonObject.put(key, (Object)newDataSetDefinitionUuid);
                    }
                    status4 = Utils.setArtifactVersionableProperty((IResource)resource, (String)fileDistlibJsonObject.toString().replaceAll("\\s", ""), (String)"team.enterprise.smpe.packagingdetail.file.distlib");
                    if (status4.getSeverity() == 0) {
                        log.add(NLS.bind((String)Messages.SystemZDSDReferenceResolver_12, (Object)resource.getName(), (Object[])new Object[]{oldDataSetDefinition.getName(), newDataSetDefinition.getName()}));
                    } else {
                        log.add(NLS.bind((String)Messages.SystemZDSDReferenceResolver_13, (Object)resource.getName(), (Object[])new Object[]{oldDataSetDefinition.getName()}));
                        Activator.log(status4);
                    }
                }
                if (fileLocationJsonObject.containsValue((Object)oldDataSetDefinitionUuid)) {
                    for (Object key : fileLocationJsonObject.keySet()) {
                        if (!fileLocationJsonObject.get(key).equals(oldDataSetDefinitionUuid)) continue;
                        fileLocationJsonObject.put(key, (Object)newDataSetDefinitionUuid);
                    }
                    status4 = Utils.setArtifactVersionableProperty((IResource)resource, (String)fileLocationJsonObject.toString().replaceAll("\\s", ""), (String)"team.enterprise.smpe.packagingdetail.file.location");
                    if (status4.getSeverity() == 0) {
                        log.add(NLS.bind((String)Messages.SystemZDSDReferenceResolver_14, (Object)resource.getName(), (Object[])new Object[]{oldDataSetDefinition.getName(), newDataSetDefinition.getName()}));
                    } else {
                        log.add(NLS.bind((String)Messages.SystemZDSDReferenceResolver_15, (Object)resource.getName(), (Object[])new Object[]{oldDataSetDefinition.getName()}));
                        Activator.log(status4);
                    }
                }
                if (!fileSyslibJsonObject.containsValue((Object)oldDataSetDefinitionUuid)) continue;
                for (Object key : fileSyslibJsonObject.keySet()) {
                    if (!fileSyslibJsonObject.get(key).equals(oldDataSetDefinitionUuid)) continue;
                    fileSyslibJsonObject.put(key, (Object)newDataSetDefinitionUuid);
                }
                status4 = Utils.setArtifactVersionableProperty((IResource)resource, (String)fileSyslibJsonObject.toString().replaceAll("\\s", ""), (String)"team.enterprise.smpe.packagingdetail.file.syslib");
                if (status4.getSeverity() == 0) {
                    log.add(NLS.bind((String)Messages.SystemZDSDReferenceResolver_16, (Object)resource.getName(), (Object[])new Object[]{oldDataSetDefinition.getName(), newDataSetDefinition.getName()}));
                    continue;
                }
                log.add(NLS.bind((String)Messages.SystemZDSDReferenceResolver_17, (Object)resource.getName(), (Object[])new Object[]{oldDataSetDefinition.getName()}));
                Activator.log(status4);
                continue;
            }
            if (referenceTreeNode instanceof LanguageDefinitionTreeNode) {
                IZosLanguageDefinition languageDefinition = (IZosLanguageDefinition)referenceTreeNode.getValue();
                IZosLanguageDefinition languageWorkingCopy = (IZosLanguageDefinition)languageDefinition.getWorkingCopy();
                IPackagingItemDefinition packagingItemDefinition = (IPackagingItemDefinition)languageWorkingCopy.getSmpePackaging();
                IPackagingItemDefinition packagingItemWorkingCopy = (IPackagingItemDefinition)packagingItemDefinition.getWorkingCopy();
                if (Verification.isNonEmpty((List)packagingItemWorkingCopy.getDetails())) {
                    ArrayList<IPackagingDetailDefinition> details = new ArrayList<IPackagingDetailDefinition>(packagingItemWorkingCopy.getDetails().size());
                    for (IPackagingDetailDefinition packagingDetailDefinition : packagingItemWorkingCopy.getDetails()) {
                        IPackagingDetailDefinition packagingDetailWorkingCopy = (IPackagingDetailDefinition)packagingDetailDefinition.getWorkingCopy();
                        if (oldDataSetDefinition.sameItemId((IItemHandle)packagingDetailWorkingCopy.getDistlib())) {
                            packagingDetailWorkingCopy.setDistlib((IDataSetDefinitionHandle)newDataSetDefinition);
                        }
                        if (oldDataSetDefinition.sameItemId((IItemHandle)packagingDetailWorkingCopy.getLocation())) {
                            packagingDetailWorkingCopy.setLocation((IDataSetDefinitionHandle)newDataSetDefinition);
                        }
                        if (oldDataSetDefinition.sameItemId((IItemHandle)packagingDetailWorkingCopy.getSyslib())) {
                            packagingDetailWorkingCopy.setSyslib((IDataSetDefinitionHandle)newDataSetDefinition);
                        }
                        details.add(packagingDetailWorkingCopy);
                    }
                    packagingItemWorkingCopy.getPackagingDetails().clear();
                    packagingItemWorkingCopy.getPackagingDetails().addAll(details);
                }
                try {
                    ISystemDefinitionHandle saveHandle = client.saveSystemDefinition((ISystemDefinition)languageWorkingCopy, (IProgressMonitor)new NullProgressMonitor());
                    IZosLanguageDefinition language = (IZosLanguageDefinition)client.fetchSystemDefinitionComplete(saveHandle, false, (IProgressMonitor)new NullProgressMonitor());
                    referenceTreeNode.setValue((Object)language);
                    log.add(NLS.bind((String)Messages.SystemZDSDReferenceResolver_18, (Object)languageDefinition.getName(), (Object[])new Object[]{oldDataSetDefinition.getName(), newDataSetDefinition.getName()}));
                }
                catch (TeamRepositoryException e) {
                    log.add(NLS.bind((String)Messages.SystemZDSDReferenceResolver_19, (Object)languageDefinition.getName(), (Object[])new Object[]{oldDataSetDefinition.getName()}));
                    Activator.log(e);
                }
                continue;
            }
            if (!(referenceTreeNode instanceof TranslatorTreeNode)) continue;
            IZosTranslator translator = (IZosTranslator)referenceTreeNode.getValue();
            IZosTranslator workingCopy = (IZosTranslator)translator.getWorkingCopy();
            boolean changed = false;
            if (oldDataSetDefinition.sameItemId((IItemHandle)workingCopy.getDataSetDefinition())) {
                workingCopy.setDataSetDefinition((IDataSetDefinitionHandle)newDataSetDefinition);
                changed = true;
                log.add(NLS.bind((String)Messages.SystemZDSDReferenceResolver_20, (Object)workingCopy.getName(), (Object[])new Object[]{newDataSetDefinition.getName()}));
            }
            if (Verification.isNonEmpty((List)workingCopy.getDDAllocations())) {
                for (IDDAllocation allocation : workingCopy.getDDAllocations()) {
                    IDataDefinitionEntry dataDefinitionEntry = allocation.getDataDefinitionEntry();
                    if (!dataDefinitionEntry.getKind().equals("com.ibm.teamz.langdef.entry.data_definition") || !oldDataSetDefinitionUuid.equals(dataDefinitionEntry.getValue())) continue;
                    dataDefinitionEntry.setValue(newDataSetDefinitionUuid);
                    changed = true;
                    log.add(NLS.bind((String)Messages.SystemZDSDReferenceResolver_21, (Object)workingCopy.getName(), (Object[])new Object[]{allocation.getName(), newDataSetDefinition.getName()}));
                }
            }
            if (Verification.isNonEmpty((List)workingCopy.getConcatenations())) {
                for (IConcatenation concatenation : workingCopy.getConcatenations()) {
                    if (!Verification.isNonEmpty((List)concatenation.getDataDefinitionEntries())) continue;
                    for (IDataDefinitionEntry dataDefinitionEntry : concatenation.getDataDefinitionEntries()) {
                        if (!dataDefinitionEntry.getKind().equals("com.ibm.teamz.langdef.entry.data_definition") || !oldDataSetDefinitionUuid.equals(dataDefinitionEntry.getValue())) continue;
                        dataDefinitionEntry.setValue(newDataSetDefinitionUuid);
                        changed = true;
                        log.add(NLS.bind((String)Messages.SystemZDSDReferenceResolver_22, (Object)workingCopy.getName(), (Object[])new Object[]{concatenation.getName(), newDataSetDefinition.getName()}));
                    }
                }
            }
            if (changed) {
                try {
                    ISystemDefinitionHandle savedHandle = client.saveSystemDefinition((ISystemDefinition)workingCopy, (IProgressMonitor)new NullProgressMonitor());
                    translator = (IZosTranslator)client.fetchSystemDefinitionComplete(savedHandle, false, (IProgressMonitor)new NullProgressMonitor());
                    referenceTreeNode.setValue((Object)translator);
                }
                catch (TeamRepositoryException e) {
                    log.add(NLS.bind((String)Messages.SystemZDSDReferenceResolver_23, (Object)workingCopy.getName(), (Object[])new Object[]{oldDataSetDefinition.getName()}));
                    Activator.log(NLS.bind((String)Messages.SystemZDSDReferenceResolver_24, (Object)workingCopy.getName(), (Object[])new Object[0]), e);
                }
                continue;
            }
            if (!referenceTreeNode.getClass().isInstance(versionTreeNodeInstance)) continue;
            IVersionDefinition versionDefinition = (IVersionDefinition)referenceTreeNode.getValue();
            IVersionDefinition versionWorkingCopy = (IVersionDefinition)versionDefinition.getWorkingCopy();
            if (Verification.isNonEmpty((List)versionWorkingCopy.getFmidItems())) {
                ArrayList<IFmidItemDefinition> fmidItems = new ArrayList<IFmidItemDefinition>(versionWorkingCopy.getFmidItems().size());
                for (IFmidItemDefinition fmidItemDefinition : versionWorkingCopy.getFmidItems()) {
                    IFmidItemDefinition fmidItemWorkingCopy = (IFmidItemDefinition)fmidItemDefinition.getWorkingCopy();
                    if (oldDataSetDefinition.sameItemId((IItemHandle)fmidItemWorkingCopy.getJclinDistlib())) {
                        fmidItemWorkingCopy.setJclinDistlib((IDataSetDefinitionHandle)newDataSetDefinition);
                    }
                    if (oldDataSetDefinition.sameItemId((IItemHandle)fmidItemWorkingCopy.getJclinLocation())) {
                        fmidItemWorkingCopy.setJclinLocation((IDataSetDefinitionHandle)newDataSetDefinition);
                    }
                    if (oldDataSetDefinition.sameItemId((IItemHandle)fmidItemWorkingCopy.getMcscpyrtLocation())) {
                        fmidItemWorkingCopy.setMcscpyrtLocation((IDataSetDefinitionHandle)newDataSetDefinition);
                    }
                    if (Verification.isNonEmpty((List)fmidItemWorkingCopy.getRelfiles())) {
                        ArrayList<Object> relfiles = new ArrayList<Object>(fmidItemWorkingCopy.getRelfiles().size());
                        for (IDataSetDefinitionHandle relfile : fmidItemWorkingCopy.getRelfiles()) {
                            if (oldDataSetDefinition.sameItemId((IItemHandle)relfile)) {
                                relfiles.add(newDataSetDefinition);
                                continue;
                            }
                            relfiles.add(relfile);
                        }
                        fmidItemWorkingCopy.getRelfiles().clear();
                        fmidItemWorkingCopy.getRelfiles().addAll(relfiles);
                    }
                    fmidItems.add(fmidItemWorkingCopy);
                }
                versionWorkingCopy.getFmidItemDefinitions().clear();
                versionWorkingCopy.getFmidItemDefinitions().addAll(fmidItems);
            }
            try {
                ISystemDefinitionHandle savedHandle = client.saveSystemDefinition((ISystemDefinition)versionWorkingCopy, (IProgressMonitor)new NullProgressMonitor());
                IVersionDefinition version = (IVersionDefinition)client.fetchSystemDefinitionComplete(savedHandle, false, (IProgressMonitor)new NullProgressMonitor());
                referenceTreeNode.setValue((Object)version);
                log.add(NLS.bind((String)Messages.SystemZDSDReferenceResolver_25, (Object)versionDefinition.getName(), (Object[])new Object[]{oldDataSetDefinition.getName(), newDataSetDefinition.getName()}));
            }
            catch (TeamRepositoryException e) {
                log.add(NLS.bind((String)Messages.SystemZDSDReferenceResolver_26, (Object)versionDefinition.getName(), (Object[])new Object[]{oldDataSetDefinition.getName()}));
                Activator.log(e);
            }
        }
        return log;
    }

    public List<ReferenceTreeNode> extendedReferencesTo(List<ISystemDefinition> jazzObjects, ITeamRepository targetRepo, IBuildDefinition buildDefinition) throws Exception {
        ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)targetRepo);
        ArrayList<ReferenceTreeNode> results = new ArrayList<ReferenceTreeNode>();
        List<IProject> projects = Utils.buildProjectList(targetRepo);
        List<ISystemDefinition> languageDefinitions = this.getLanguageDefinitions(targetRepo, client);
        List<ISystemDefinition> translatorDefinitions = this.getTranslatorDefinitions(targetRepo, client);
        List<ISystemDefinition> versionDefinitions = this.getVersionDefinitions(targetRepo, client);
        for (ISystemDefinition jazzObject : jazzObjects) {
            if (!(jazzObject instanceof IDataSetDefinition)) continue;
            IDataSetDefinition datasetDefinition = (IDataSetDefinition)jazzObject;
            String datasetDefinitionUuid = datasetDefinition.getItemId().getUuidValue();
            String datasetDefinitionName = datasetDefinition.getName();
            DataSetDefinitionTreeNode dataSetDefinitionTreeNode = new DataSetDefinitionTreeNode(datasetDefinition);
            for (IProject project : projects) {
                ProjectTreeNode projectTreeNode = null;
                List folders = Utils.getZFolderList((String)project.getName());
                for (IFolder folder : folders) {
                    FolderTreeNode folderTreeNode = null;
                    IResource[] folderChildren = folder.members();
                    if (!(folder instanceof IFolder)) continue;
                    String dsdef = Utils.getArtifactVersionableProperty((IResource)folder, (String)"team.enterprise.resource.definition");
                    String folderDistlib = Utils.getArtifactVersionableProperty((IResource)folder, (String)"team.enterprise.smpe.packagingdetail.folder.distlib");
                    String folderLocation = Utils.getArtifactVersionableProperty((IResource)folder, (String)"team.enterprise.smpe.packagingdetail.folder.location");
                    String folderSyslib = Utils.getArtifactVersionableProperty((IResource)folder, (String)"team.enterprise.smpe.packagingdetail.folder.syslib");
                    JSONObject folderDistlibJsonObject = Packaging.getJsonObject((String)folderDistlib);
                    JSONObject folderLocationJsonObject = Packaging.getJsonObject((String)folderLocation);
                    JSONObject folderSyslibJsonObject = Packaging.getJsonObject((String)folderSyslib);
                    boolean foundFolderReference = false;
                    if (datasetDefinitionUuid.equals(dsdef)) {
                        foundFolderReference = true;
                    } else if (folderDistlibJsonObject.containsValue((Object)datasetDefinitionUuid)) {
                        foundFolderReference = true;
                    } else if (folderLocationJsonObject.containsValue((Object)datasetDefinitionUuid)) {
                        foundFolderReference = true;
                    } else if (folderSyslibJsonObject.containsValue((Object)datasetDefinitionUuid)) {
                        foundFolderReference = true;
                    }
                    if (foundFolderReference) {
                        if (projectTreeNode == null) {
                            projectTreeNode = new ProjectTreeNode((Object)project);
                            Utils.addChildTreeNode((TreeNode)projectTreeNode, (TreeNode)dataSetDefinitionTreeNode);
                        }
                        folderTreeNode = new FolderTreeNode((Object)folder);
                        Utils.addChildTreeNode((TreeNode)folderTreeNode, (TreeNode)projectTreeNode);
                    }
                    for (IResource resource : Arrays.asList(folderChildren)) {
                        if (!(resource instanceof IFile)) continue;
                        String fileDistlib = Utils.getArtifactVersionableProperty((IResource)folder, (String)"team.enterprise.smpe.packagingdetail.file.distlib");
                        String fileLocation = Utils.getArtifactVersionableProperty((IResource)folder, (String)"team.enterprise.smpe.packagingdetail.file.location");
                        String fileSyslib = Utils.getArtifactVersionableProperty((IResource)folder, (String)"team.enterprise.smpe.packagingdetail.file.syslib");
                        JSONObject fileDistlibJsonObject = Packaging.getJsonObject((String)fileDistlib);
                        JSONObject fileLocationJsonObject = Packaging.getJsonObject((String)fileLocation);
                        JSONObject fileSyslibJsonObject = Packaging.getJsonObject((String)fileSyslib);
                        boolean foundFileReference = false;
                        if (fileDistlibJsonObject.containsValue((Object)datasetDefinitionUuid)) {
                            foundFileReference = true;
                        } else if (fileLocationJsonObject.containsValue((Object)datasetDefinitionUuid)) {
                            foundFileReference = true;
                        } else if (fileSyslibJsonObject.containsValue((Object)datasetDefinitionUuid)) {
                            foundFileReference = true;
                        }
                        if (!foundFileReference) continue;
                        if (projectTreeNode == null) {
                            projectTreeNode = new ProjectTreeNode((Object)project);
                            Utils.addChildTreeNode((TreeNode)projectTreeNode, (TreeNode)dataSetDefinitionTreeNode);
                        }
                        if (folderTreeNode == null) {
                            folderTreeNode = new FolderTreeNode((Object)folder);
                            Utils.addChildTreeNode((TreeNode)folderTreeNode, (TreeNode)projectTreeNode);
                        }
                        FileTreeNode fileTreeNode = new FileTreeNode((Object)resource);
                        Utils.addChildTreeNode((TreeNode)fileTreeNode, (TreeNode)folderTreeNode);
                    }
                }
            }
            for (ISystemDefinition systemDefinition : languageDefinitions) {
                IZosLanguageDefinition zosLanguageDefinition;
                ILanguageDefinition languageDefinition = (ILanguageDefinition)systemDefinition;
                if (!(languageDefinition instanceof IZosLanguageDefinition) || !(zosLanguageDefinition = (IZosLanguageDefinition)systemDefinition).hasSmpePackaging()) continue;
                IPackagingItemDefinition packagingItemDefinition = (IPackagingItemDefinition)zosLanguageDefinition.getSmpePackaging();
                boolean foundReference = false;
                if (Verification.isNonEmpty((List)packagingItemDefinition.getDetails())) {
                    for (IPackagingDetailDefinition packagingDetailDefinition : packagingItemDefinition.getDetails()) {
                        if (datasetDefinition.sameItemId((IItemHandle)packagingDetailDefinition.getDistlib())) {
                            foundReference = true;
                            break;
                        }
                        if (datasetDefinition.sameItemId((IItemHandle)packagingDetailDefinition.getLocation())) {
                            foundReference = true;
                            break;
                        }
                        if (!datasetDefinition.sameItemId((IItemHandle)packagingDetailDefinition.getSyslib())) continue;
                        foundReference = true;
                        break;
                    }
                }
                if (!foundReference) continue;
                LanguageDefinitionTreeNode languageDefinitionTreeNode = new LanguageDefinitionTreeNode(languageDefinition);
                Utils.addChildTreeNode((TreeNode)languageDefinitionTreeNode, (TreeNode)dataSetDefinitionTreeNode);
            }
            for (ISystemDefinition systemDefinition : translatorDefinitions) {
                IZosTranslator translator = (IZosTranslator)systemDefinition;
                boolean foundReference = false;
                if (datasetDefinition.sameItemId((IItemHandle)translator.getDataSetDefinition())) {
                    foundReference = true;
                } else if (Verification.isNonEmpty((List)translator.getDDAllocations())) {
                    for (IDDAllocation allocation : translator.getDDAllocations()) {
                        IDataDefinitionEntry dataDefinitionEntry = allocation.getDataDefinitionEntry();
                        String value = dataDefinitionEntry.getValue();
                        if (dataDefinitionEntry.getKind().equals("com.ibm.teamz.langdef.entry.data_definition")) {
                            if (!datasetDefinitionUuid.equals(value)) continue;
                            foundReference = true;
                        } else {
                            IBuildProperty properyValue;
                            if (!dataDefinitionEntry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable") || buildDefinition == null || !value.startsWith("${") || !value.endsWith("}") || (properyValue = buildDefinition.getProperty(value.substring(2, value.length() - 1))) == null || !properyValue.getValue().equals(datasetDefinitionName)) continue;
                            foundReference = true;
                        }
                        break;
                    }
                } else if (Verification.isNonEmpty((List)translator.getConcatenations())) {
                    block8: for (IConcatenation concatenation : translator.getConcatenations()) {
                        if (!Verification.isNonEmpty((List)concatenation.getDataDefinitionEntries())) continue;
                        for (IDataDefinitionEntry dataDefinitionEntry : concatenation.getDataDefinitionEntries()) {
                            IBuildProperty properyValue;
                            String value = dataDefinitionEntry.getValue();
                            if (dataDefinitionEntry.getKind().equals("com.ibm.teamz.langdef.entry.data_definition")) {
                                if (!datasetDefinitionUuid.equals(value)) continue;
                                foundReference = true;
                                break block8;
                            }
                            if (!dataDefinitionEntry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable") || buildDefinition == null || !value.startsWith("${") || !value.endsWith("}") || (properyValue = buildDefinition.getProperty(value.substring(2, value.length() - 1))) == null || !properyValue.getValue().equals(datasetDefinitionName)) continue;
                            foundReference = true;
                            break block8;
                        }
                    }
                }
                if (!foundReference) continue;
                TranslatorTreeNode translatorTreeNode = new TranslatorTreeNode(translator);
                Utils.addChildTreeNode((TreeNode)translatorTreeNode, (TreeNode)dataSetDefinitionTreeNode);
            }
            for (ISystemDefinition systemDefinition : versionDefinitions) {
                IVersionDefinition versionDefinition = (IVersionDefinition)systemDefinition;
                boolean foundReference = false;
                if (Verification.isNonEmpty((List)versionDefinition.getFmidItems())) {
                    block11: for (IFmidItemDefinition fmidItemDefinition : versionDefinition.getFmidItems()) {
                        if (datasetDefinition.sameItemId((IItemHandle)fmidItemDefinition.getJclinDistlib())) {
                            foundReference = true;
                            break;
                        }
                        if (datasetDefinition.sameItemId((IItemHandle)fmidItemDefinition.getJclinLocation())) {
                            foundReference = true;
                            break;
                        }
                        if (datasetDefinition.sameItemId((IItemHandle)fmidItemDefinition.getMcscpyrtLocation())) {
                            foundReference = true;
                            break;
                        }
                        for (IDataSetDefinitionHandle relfile : fmidItemDefinition.getRelfiles()) {
                            if (!datasetDefinition.sameItemId((IItemHandle)relfile)) continue;
                            foundReference = true;
                            break block11;
                        }
                    }
                }
                if (!foundReference) continue;
                TreeNodeLoaderRegistry instance = TreeNodeLoaderRegistry.getInstance();
                ITreeNodeLoader treeNodeLoader = instance.getLoader("VersionDefinitionTreeNode");
                TreeNode versionDefinitionTreeNode = (TreeNode)treeNodeLoader.getTreeNode((Object)versionDefinition);
                Utils.addChildTreeNode((TreeNode)versionDefinitionTreeNode, (TreeNode)dataSetDefinitionTreeNode);
            }
            if (!dataSetDefinitionTreeNode.hasChildren()) continue;
            results.add((ReferenceTreeNode)dataSetDefinitionTreeNode);
        }
        return results;
    }
}

