/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.build.ant.tasks;

import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZUtil;
import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.IStaticReset;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.extensions.common.debug.DebugGroup;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.build.extensions.common.debug.Statistics;
import com.ibm.team.build.extensions.common.debug.StatisticsBlock;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.build.extensions.toolkit.ant.AntInstance;
import com.ibm.team.build.extensions.toolkit.ant.DebugTask;
import com.ibm.team.build.extensions.toolkit.ant.DebuggerAnt;
import com.ibm.team.build.internal.publishing.LogPublisher;
import com.ibm.team.enterprise.build.ant.IBuildableResource;
import com.ibm.team.enterprise.build.ant.IFileSystemUtil;
import com.ibm.team.enterprise.build.ant.internal.utils.AbstractMacroExec;
import com.ibm.team.enterprise.build.ant.internal.utils.BuildFileUtil;
import com.ibm.team.enterprise.build.ant.internal.utils.FileSystemUtilFactory;
import com.ibm.team.enterprise.build.ant.internal.utils.SimulationUtil;
import com.ibm.team.enterprise.build.ant.internal.utils.VariableUtil;
import com.ibm.team.enterprise.build.ant.tasks.AbstractEETask;
import com.ibm.team.enterprise.build.ant.tasks.InitTask;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap;
import com.ibm.team.enterprise.build.buildmap.common.model.IOutputBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.IOutputBuildFileHandle;
import com.ibm.team.enterprise.build.buildmap.common.util.BuildMapSerializer;
import com.ibm.team.enterprise.build.common.buildreport.BuildFileXMLModel;
import com.ibm.team.enterprise.zos.build.ant.internal.messages.Messages;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.EBCDICFilterInputStream;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.GatewayResult;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.InteractiveISPFGateway;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.InteractiveISPFGatewayDebug;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.SubProcess;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.SubProcessMacroExec;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.SubProcessManager;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.TaskLog;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.ZOS;
import com.ibm.team.enterprise.zos.build.ant.types.AbstractDD;
import com.ibm.team.enterprise.zos.build.ant.types.Alloc;
import com.ibm.team.enterprise.zos.build.ant.types.Concat;
import com.ibm.team.enterprise.zos.build.ant.types.Variable;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.teamz.build.ant.zos.exceptions.ZosException;
import com.ibm.teamz.build.ant.zos.utils.AllocInfo;
import com.ibm.teamz.build.ant.zos.utils.ILoggingInterface;
import com.ibm.teamz.build.ant.zos.utils.ISPFGatewayUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.eclipse.emf.common.util.URI;
import org.xml.sax.SAXException;

public class Executable
extends AbstractEETask
implements IStaticReset {
    public static final String LOG_EXTENSION = ".log";
    private static final String BIN_SH = "/bin/sh";
    private static final String COLON = ":";
    private static final String COMMA = ",";
    private static final String COMPRESS_LOG_DD = "BLZERROR";
    private static final String COMPRESS_MODULE = Executable.formatInEightChars("BLZCMD");
    private static final String CRLF = "\r\n";
    private static final String C_OPTION = "-c";
    private static final String DD_PREFIX = "//DD:";
    private static final String DEBUG_LBL_CMD = "cmdLine";
    private static final String DEBUG_LBL_ISPF = "ISPF";
    private static final String DEBUG_LBL_SPME = "SPME";
    private static final String DEBUG_LBL_SUBP = "SUBP";
    private static final String DEBUG_LBL_TASK = "TASK";
    private static final String EIGHT_SPACES = "        ";
    private static final String EMPTY_STRING = "";
    private static final String ENCODE_PARAM = "ENCODE";
    private static final String END_CDATA = "]]>";
    private static final String[] FREE_HDN_DD_DEF = new String[]{"CCNDRVR", "REXXCOMP"};
    private static final String FREE_HDN_DD_FLG = "freeHiddenDD";
    private static final String FREE_HDN_DD_PRP = "freeHiddenDDPrograms";
    private static final String FREE_HDN_DD_VAR = "_FREE_HDN_DD_PROGRAMS";
    private static final String IBM_1047 = "IBM-1047";
    private static final String ISPF_GATEWAY = "ISPFGateway";
    private static final String ISPF_PREFIX = "ispf";
    private static final String KEY_DSNAME = "DSNAME=";
    private static final String KEY_MEMBER = "MEMBER=";
    private static final String KEY_TYPE = "TYPE=";
    private static final String LINK = "LINK";
    private static final String PLAIN_TEXT = "plain/text";
    private static final String PROPERTY_RC = "returnCode";
    private static final String PROPERTY_TMP_PFX = "team.enterprise.scm.temporaryPrefix";
    private static final String READ = "r";
    private static final String READ_ONLY = "r";
    private static final String SSI_INFO = "@{ssi_info}";
    private static final String START_CDATA = "<![CDATA[";
    private static final String SYSLIB = "SYSLIB";
    private static final String TASKLIB = "TASKLIB";
    private static final String TASKNAME_EXEC = "(internal) exectask";
    private static final String UTF_8 = "UTF-8";
    private static final String ZIP_EXTENSION = ".zip";
    private static final int BUFFER_SIZE = 256;
    private static final int BUF_SIZE = 8192;
    private static final int CALL_METHOD_ISPF = 1;
    private static final int CALL_METHOD_TSO = 2;
    private static final int EBCDIC_NL = 21;
    private static final int INITIAL_SIZE = 4;
    private static final int ONE_HUNDRED = 100;
    private static final int ONE_MILLION = 1000000;
    private static final int PUBLISH_ALWAYS = 2;
    private static final int PUBLISH_INHERIT = 1;
    private static final int PUBLISH_NEVER = 0;
    private static final int PUBLISH_ON_ERROR = 3;
    private static final int RC_MBR_NOTFOUND = 12;
    private static final int SIXTEEN = 16;
    private static final int THOUSAND = 1000;
    private static final Object logContributionMutex = new Object();
    private static final SecureRandom rand = new SecureRandom();
    private static final Hashtable<String, ReentrantLock> zipLocks = new Hashtable();
    private static final Hashtable<String, ConcurrentLinkedQueue<File>> zipsToAdd = new Hashtable();
    private static final List<Future<IBuildResultContribution>> logContributions = new ArrayList<Future<IBuildResultContribution>>();
    private static final List<Future<Object>> futureLogsConribsPublish = new Vector<Future<Object>>();
    private static DebugTask staticTsk;
    private static IDebugger staticDbg;
    private static String staticCls;
    @DebugGroup(value={"gateway"})
    private static IDebugger executeTsoDbg;
    private static IDebugger execViaSPMEDbg;
    private static IDebugger execViaTaskDbg;
    private static IDebugger execViaSubpDbg;
    private static StatisticsBlock executeTsoBlk;
    private static StatisticsBlock execViaSPMEBlk;
    private static StatisticsBlock execViaTaskBlk;
    private static StatisticsBlock execViaSubpBlk;
    private static String executeTsoMnm;
    private static String execViaSPMEMnm;
    private static String execViaTaskMnm;
    private static String execViaSubpMnm;
    private static AtomicInteger filePublishingCounter;
    private static AtomicLong rexxScriptCounter;
    private static String TEMPORARY_UNIT;
    private static Integer LOG_CONTRIBUTION_BATCH_SIZE;
    private final ArrayList<AbstractDD> allocs = new ArrayList(4);
    private final ArrayList<Variable> variables = new ArrayList(4);
    private final HashMap<String, String> variableMap = new HashMap(4);
    private AbstractMacroExec macroExec;
    private File buildmap;
    private File certificateFile;
    private File passwordFile;
    private String buildResultUUID;
    private String command;
    private String ddnamelist;
    private String loadDir;
    private String name;
    private String parm;
    private String password;
    private String pgm;
    private String publishoutputsdds;
    private String repositoryAddress;
    private String ssi_info;
    private String userId;
    private boolean ispfLogCompact;
    private boolean kerberos;
    private boolean linkedit;
    private boolean preview;
    private boolean publishoutputs;
    private boolean publishoutputsforerrorsonly;
    private boolean publishsuccessfullogsaszips;
    private boolean smartCard;
    private boolean tasklib;
    private boolean traceDDAlloc;
    private boolean traceDDNames;
    private int callMethod;
    private int ispfLogConsolidate = 0;
    private int ispfLogPublishType = 1;
    private int maxrc;
    private int rc;
    private Set<String> freeHiddenDD = null;

    static {
        executeTsoMnm = "executeTso";
        execViaSPMEMnm = "execViaSPME";
        execViaTaskMnm = "execViaTask";
        execViaSubpMnm = "execViaSubprocess";
        filePublishingCounter = new AtomicInteger(0);
        rexxScriptCounter = new AtomicLong(0L);
    }

    private SubProcessMacroExec getSubProcessMacroExec() {
        if (this.macroExec instanceof SubProcessMacroExec) {
            return (SubProcessMacroExec)this.macroExec;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        InteractiveISPFGatewayDebug.init(this.getProject());
        super.init();
        if (staticTsk == null) {
            Executable executable = this;
            synchronized (executable) {
                if (staticTsk == null) {
                    staticTsk = new DebugTask();
                    staticTsk.setProject(this.getProject());
                    staticTsk.setTaskName(this.getTaskName());
                    staticTsk.init();
                    staticDbg = new DebuggerAnt((Task)staticTsk, Executable.class);
                    staticCls = Executable.class.getSimpleName();
                    Field executeTsoFld = null;
                    Field execViaSPMEFld = null;
                    Field execViaTaskFld = null;
                    Field execViaSubpFld = null;
                    try {
                        executeTsoFld = Executable.class.getDeclaredField("executeTsoDbg");
                        execViaSPMEFld = Executable.class.getDeclaredField("execViaSPMEDbg");
                        execViaTaskFld = Executable.class.getDeclaredField("execViaTaskDbg");
                        execViaSubpFld = Executable.class.getDeclaredField("execViaSubpDbg");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    executeTsoDbg = executeTsoFld != null ? staticDbg.getDbg(staticDbg, executeTsoFld) : staticDbg.getDbg(staticDbg, Executable.class);
                    if (executeTsoDbg.isTimerOn()) {
                        executeTsoBlk = Statistics.getBlock((IDebugger)executeTsoDbg, (String)staticCls, (String)executeTsoMnm, (String)DEBUG_LBL_ISPF);
                        AntInstance.getInstance().getStatisticsBlocks().add(executeTsoBlk);
                    }
                    if ((execViaSPMEDbg = execViaSPMEFld != null ? staticDbg.getDbg(staticDbg, execViaSPMEFld) : staticDbg.getDbg(staticDbg, Executable.class)).isTimerOn()) {
                        execViaSPMEBlk = Statistics.getBlock((IDebugger)execViaSPMEDbg, (String)staticCls, (String)execViaSPMEMnm, (String)DEBUG_LBL_SPME);
                        AntInstance.getInstance().getStatisticsBlocks().add(execViaSPMEBlk);
                    }
                    if ((execViaTaskDbg = execViaTaskFld != null ? staticDbg.getDbg(staticDbg, execViaTaskFld) : staticDbg.getDbg(staticDbg, Executable.class)).isTimerOn()) {
                        execViaTaskBlk = Statistics.getBlock((IDebugger)execViaTaskDbg, (String)staticCls, (String)execViaTaskMnm, (String)DEBUG_LBL_TASK);
                        AntInstance.getInstance().getStatisticsBlocks().add(execViaTaskBlk);
                    }
                    if ((execViaSubpDbg = execViaSubpFld != null ? staticDbg.getDbg(staticDbg, execViaSubpFld) : staticDbg.getDbg(staticDbg, Executable.class)).isTimerOn()) {
                        execViaSubpBlk = Statistics.getBlock((IDebugger)execViaSubpDbg, (String)staticCls, (String)execViaSubpMnm, (String)DEBUG_LBL_SUBP);
                        AntInstance.getInstance().getStatisticsBlocks().add(execViaSubpBlk);
                    }
                }
            }
        }
    }

    public boolean isSmartCard() {
        return this.smartCard;
    }

    public void setSmartCard(boolean smartCard) {
        this.smartCard = smartCard;
    }

    public boolean isKerberos() {
        return this.kerberos;
    }

    public void setKerberos(boolean kerberos) {
        this.kerberos = kerberos;
    }

    public File getCertificateFile() {
        return this.certificateFile;
    }

    public void setCertificateFile(File certificateFile) {
        this.certificateFile = certificateFile;
    }

    public void addAlloc(Alloc alloc) {
        this.allocs.add(alloc);
    }

    public void addConcat(Concat concat) {
        this.allocs.add(concat);
    }

    public final void addVariable(Variable variable) {
        this.variables.add(variable);
    }

    private void allocateDDs() throws IOException {
        for (AbstractDD alloc : this.allocs) {
            String dd;
            alloc.allocate((Task)this);
            if (this.tasklib) continue;
            String string = dd = alloc.getDd() == null ? null : alloc.getDd().toUpperCase(Locale.US);
            if (!TASKLIB.equals(dd)) continue;
            this.tasklib = true;
            alloc.allocateSteplib((Task)this, dd);
        }
    }

    private List<AllocInfo> getAllocInfoList() {
        ArrayList<AllocInfo> result = new ArrayList<AllocInfo>(4);
        for (AbstractDD alloc : this.allocs) {
            List<AllocInfo> l = alloc.getAllocInfoList((Task)this, false);
            result.addAll(l);
        }
        return result;
    }

    private String buildDdnames() {
        String ddnames = this.getDdnamelist();
        if (ddnames == null) {
            return null;
        }
        String[] dds = ddnames.split(COMMA);
        String s = EMPTY_STRING;
        String[] stringArray = dds;
        int n = dds.length;
        int n2 = 0;
        while (n2 < n) {
            String dd = stringArray[n2];
            s = String.valueOf(s) + Executable.formatInEightChars(dd);
            ++n2;
        }
        return s;
    }

    public int compile(String pgm, String options, String ddnames, boolean attachx) {
        int rc = 12345;
        if (InitTask.getInstance() != null && InitTask.getInstance().isPerformanceAnalysisEnabled()) {
            CallMVSModuleTask callMVSModuleTask = new CallMVSModuleTask(pgm, options, ddnames, attachx);
            callMVSModuleTask.bindToOwner((Task)this);
            callMVSModuleTask.setTaskName("(internal) callmvsmoduletask");
            callMVSModuleTask.perform();
            return callMVSModuleTask.getRc();
        }
        if (this.isMultiProcess()) {
            block10: {
                String ret = null;
                try {
                    ret = this.getSubProcessMacroExec().sendReceive("compile:" + pgm + "<>" + options + "<>" + ddnames + "<>" + attachx);
                }
                catch (IOException e) {
                    throw new BuildException(NLS.bind((String)Messages.SUBPROCESS_COMMUNICATION_FAILURE, (Object)this.name, (Object[])new Object[0]), (Throwable)e);
                }
                if (ret == null) {
                    if (this.dbg.isDebug()) {
                        this.dbg.logMsg("ERROR :Problem on compile", 4);
                    }
                } else {
                    try {
                        rc = Integer.parseInt(ret);
                        if (this.dbg.isDebug()) {
                            this.dbg.logMsg("compile returns: " + ret, 4);
                        }
                    }
                    catch (NumberFormatException e) {
                        if (!this.dbg.isDebug()) break block10;
                        this.dbg.logMsg("ERROR :Problem on compile :" + ret, 4);
                    }
                }
            }
            return rc;
        }
        return new com.ibm.teamz.build.ant.jni.Executable().compile(pgm, options, ddnames, attachx);
    }

    public int exec(String parm) throws BuildException {
        int returnCode = 0;
        if (!SimulationUtil.isSimulationMode()) {
            String pgmName = this.getPgm();
            String translatorName = this.getName();
            if (pgmName == null) {
                throw new BuildException(NLS.bind((String)Messages.PGM_IS_NULL, (Object)translatorName, (Object[])new Object[0]));
            }
            if (pgmName.length() > 8) {
                throw new BuildException(NLS.bind((String)Messages.PGM_TOO_LONG, (Object)translatorName, (Object[])new Object[]{pgmName}));
            }
            pgmName = Executable.formatInEightChars(pgmName);
            String parameter = this.substituteVars(parm);
            if (parameter != null && parameter.contains(SSI_INFO)) {
                parameter = parameter.replace(SSI_INFO, this.ssi_info);
            }
            this.logMsg(NLS.bind((String)Messages.MVSEXEC_INFO, (Object[])new String[]{translatorName, pgmName, parameter, this.buildDdnames()}, (Object[])new Object[0]), 3);
            returnCode = this.compile(pgmName, parameter, this.buildDdnames(), this.tasklib);
        }
        if (this.isLinkedit() && returnCode <= this.getMaxrc()) {
            try {
                int postCompileReturnCode = this.postCompile();
                if (postCompileReturnCode > returnCode) {
                    returnCode = postCompileReturnCode;
                }
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
        return returnCode;
    }

    private int postCompile() throws IOException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException, ZosException {
        Mnm mnm = this.dbg.isOn() ? new Mnm(){}.enter(this.dbg, this.cls, new String[0]) : new Mnm();
        int returnCode = 0;
        String memberName = this.getMemberName();
        if (memberName.length() == 0) {
            this.logMsg(Messages.MEMBER_NAME_IS_NOT_FOUND, 0);
            returnCode = 12;
            mnm.leave(new String[]{LogString.value((Object)returnCode)});
            return returnCode;
        }
        if (!"BLZLKEPS".equals(this.getPgm()) || SimulationUtil.isSimulationMode()) {
            Object[] objectArray = new String[4];
            objectArray[0] = Messages.LINK_EDIT_PARSER;
            objectArray[1] = "BLZLKEPS";
            objectArray[2] = memberName;
            this.logMsg(NLS.bind((String)Messages.MVSEXEC_INFO, (Object[])objectArray, (Object[])new Object[0]), 3);
            if (SimulationUtil.isSimulationMode() && !ZOS.datasetExists((ProjectComponent)this, this.getMemberNameInDataSet())) {
                boolean skipLKEPSrcMemberNotFound = this.parseBoolean("team.enterprise.build.toolkit.simBuild.linkEditParser.skipLKEPSrcMemberNotFound");
                this.logMsg(NLS.bind((String)Messages.MEMBER_OBJECT_IS_NOT_FOUND, (Object)memberName, (Object[])new Object[0]), skipLKEPSrcMemberNotFound ? 0 : 2);
                returnCode = skipLKEPSrcMemberNotFound ? 12 : 0;
                mnm.leave(new String[]{LogString.value((Object)returnCode)});
                return returnCode;
            }
            returnCode = this.compile("BLZLKEPS", memberName, null, this.tasklib);
            this.logMsg(NLS.bind((String)Messages.COMPILE_RESULT, (Object[])new Object[]{Messages.LINK_EDIT_PARSER, returnCode, Integer.toString(returnCode, 16)}, (Object[])new Object[0]), 3);
            if (returnCode > this.getMaxrc()) {
                mnm.leave(new String[]{LogString.value((Object)returnCode)});
                return returnCode;
            }
        }
        ZFile f = null;
        BufferedReader br = null;
        boolean cuiFound = false;
        HashSet<IOutputBuildFile> parserOutputs = new HashSet<IOutputBuildFile>();
        try {
            String s;
            SubProcessMacroExec spme = SubProcessManager.getSubProcessMacroExec((Task)this);
            if (spme != null) {
                spme.send("getDDContents:RTCPRINT");
            } else {
                f = new ZFile("//DD:RTCPRINT", "r");
                br = new BufferedReader(new InputStreamReader(f.getInputStream()));
            }
            String dsname = null;
            String member = null;
            String type = null;
            while ((s = spme != null ? spme.readLine() : br.readLine()) != null) {
                s = s.trim();
                this.logMsg(s, 4);
                if (s.startsWith(KEY_TYPE)) {
                    cuiFound = true;
                    type = s.substring(KEY_TYPE.length()).trim();
                    continue;
                }
                if (s.startsWith(KEY_DSNAME)) {
                    dsname = s.substring(KEY_DSNAME.length()).trim();
                    continue;
                }
                if (!s.startsWith(KEY_MEMBER)) continue;
                member = s.substring(KEY_MEMBER.length()).trim();
                this.addParserOutput(parserOutputs, dsname, member, type);
                member = null;
                dsname = null;
                type = null;
            }
            if (cuiFound && parserOutputs.size() > 0) {
                BuildMapSerializer ser = new BuildMapSerializer();
                URI bmURI = URI.createURI((String)this.getBuildmap().toURI().toString());
                IBuildMap buildMap = ser.deserialize(bmURI);
                List oHandles = buildMap.getParserOutputs();
                if (oHandles != null) {
                    this.mergeParserOutputs(buildMap, parserOutputs);
                }
                ser.serialize(bmURI, buildMap);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (f != null) {
                f.close();
            }
        }
        mnm.leave(new Object[]{returnCode, cuiFound, parserOutputs});
        return returnCode;
    }

    private void mergeParserOutputs(IBuildMap buildMap, Set<IOutputBuildFile> files) {
        if (files == null || buildMap.getParserOutputs() == null) {
            return;
        }
        List parserOutputs = buildMap.getParserOutputs();
        for (IOutputBuildFile fileToAdd : files) {
            if (this.found(fileToAdd, parserOutputs)) continue;
            parserOutputs.add(fileToAdd);
        }
    }

    private boolean found(IOutputBuildFile file, List<IOutputBuildFileHandle> files) {
        String buildFile = file.getBuildFile();
        String buildPath = file.getBuildPath();
        for (IOutputBuildFileHandle fh : files) {
            IOutputBuildFile f = (IOutputBuildFile)fh;
            if (!buildFile.equals(f.getBuildFile()) || !buildPath.equals(f.getBuildPath())) continue;
            return true;
        }
        return false;
    }

    private String getMemberName() {
        String memberName = EMPTY_STRING;
        for (AbstractDD alloc : this.allocs) {
            if (!(alloc instanceof Alloc) || !"SYSLMOD".equals(alloc.getDd())) continue;
            String dsn = ((Alloc)alloc).getDsn();
            int i = dsn.lastIndexOf("(");
            int j = dsn.lastIndexOf(")");
            if (i <= 0 || j <= i) continue;
            memberName = dsn.substring(i + 1, j);
            break;
        }
        return memberName;
    }

    private String getMemberNameInDataSet() {
        for (AbstractDD alloc : this.allocs) {
            if (!(alloc instanceof Alloc) || !"SYSLMOD".equals(alloc.getDd())) continue;
            return ((Alloc)alloc).getDsn();
        }
        return EMPTY_STRING;
    }

    private void addParserOutput(Set<IOutputBuildFile> parserOutputs, String dsname, String member, String type) {
        Mnm mnm = this.dbg.isOn() ? new Mnm(){}.enter(this.dbg, this.cls, new String[0]) : new Mnm();
        boolean added = false;
        if (dsname == null || dsname.length() == 0 || member == null || member.length() == 0 || type == null || type.length() == 0) {
            mnm.leave(new String[0]);
            return;
        }
        for (IOutputBuildFile f : parserOutputs) {
            if (!dsname.equals(f.getBuildPath()) || !member.equals(f.getBuildFile())) continue;
            mnm.leave(new String[0]);
            return;
        }
        if (!BuildFileUtil.isDsNameExcludedFromParserOutput((String)dsname, (String)member, (Task)this)) {
            String foundNewDsName;
            String newDsName = dsname;
            if (SimulationUtil.isSimulationMode() && !this.parseBoolean("team.enterprise.build.toolkit.simBuild.linkEditParser.ignoreSyslib") && (foundNewDsName = this.findMatchInSyslib(dsname, member)) != null) {
                newDsName = foundNewDsName;
            }
            if (!this.isExistingDataSetType(newDsName, member)) {
                IOutputBuildFile file = (IOutputBuildFile)IOutputBuildFile.ITEM_TYPE.createItem();
                file.setType(LINK);
                file.setBuildFile(member);
                file.setBuildPath(newDsName);
                IFileSystemUtil util = FileSystemUtilFactory.createFileSystemUtil();
                long timestamp = util.lastModified((Task)this, (IBuildFile)file, false);
                if (timestamp > 0L) {
                    file.setTimestamp(new Timestamp(timestamp));
                    parserOutputs.add(file);
                    added = true;
                    mnm.inter(new String[]{NLS.bind((String)Messages.PARSER_OUTPUT_ADD, (Object)this.formatDatasetMember(newDsName, member), (Object[])new Object[0])});
                } else {
                    mnm.debug(new String[]{NLS.bind((String)Messages.PARSER_OUTPUT_ADD, (Object)this.formatDatasetMember(newDsName, member), (Object[])new Object[0])});
                }
            }
        }
        mnm.leave(new String[]{LogString.valueOf((boolean)added)});
    }

    private boolean isExistingDataSetType(String dsname, String member) {
        for (AbstractDD alloc : this.allocs) {
            if (!(alloc instanceof Concat) || !SYSLIB.equals(alloc.getDd())) continue;
            Concat syslib = (Concat)alloc;
            List<Alloc> syslibdds = syslib.getAllocs();
            for (Alloc dd : syslibdds) {
                boolean excluded;
                if (!dsname.equals(dd.getDsn())) continue;
                boolean bl = excluded = dd.getUsageType() == 3;
                if (excluded) {
                    this.logMsg(String.valueOf(dsname) + "(" + member + ") was excluded from the parser output list because it is from an existing data set.", 4);
                    return true;
                }
                this.logMsg(String.valueOf(dsname) + "(" + member + ") is still considered for adding to the parser output list because it is NOT from an existing data set.", 4);
                return false;
            }
        }
        this.logMsg(String.valueOf(dsname) + "(" + member + ") was excluded from the parser output list list because it is NOT found in the SYSLIB.", 4);
        return false;
    }

    public void doExecute() throws BuildException {
        if (this.isPreview()) {
            return;
        }
        if (SimulationUtil.isSimulationMode()) {
            if (!this.linkedit) {
                return;
            }
            if (!ZOS.isZOS()) {
                throw new BuildException(Messages.LINK_EDIT_PARSER_UNSUPPORTED_PLATFORM);
            }
        }
        this.traceDDNames = Boolean.valueOf(this.getProject().getProperty("team.enterprise.build.toolkit.trace.ddnames"));
        this.traceDDAlloc = Boolean.valueOf(this.getProject().getProperty("team.enterprise.build.toolkit.trace.ddalloc"));
        this.validateDDs();
        this.initializeVariableMap();
        Object macroExecObject = this.getProject().getReference(this.getDescription().toUpperCase());
        if (macroExecObject instanceof AbstractMacroExec) {
            this.macroExec = (AbstractMacroExec)macroExecObject;
        }
        if (this.macroExec != null) {
            this.resolveDDs();
        }
        if (this.callMethod == 1 || this.callMethod == 2) {
            try {
                if (!SimulationUtil.isSimulationMode()) {
                    Throwable e = null;
                    if (this.traceDDNames) {
                        this.logCurrentDDs();
                    }
                    try {
                        if (this.traceDDAlloc) {
                            this.logCurrentDDs();
                        }
                        this.executeTso();
                        if (this.traceDDAlloc) {
                            this.logCurrentDDs();
                        }
                    }
                    catch (BuildException be) {
                        e = be;
                    }
                    this.setReturnCodeVariable(Integer.toString(this.rc));
                    if (this.macroExec != null) {
                        this.log("(return code) rc=" + this.rc + " component=" + this.macroExec.getBuildableResource().getComponentName() + " project=" + this.macroExec.getBuildableResource().getProjectName() + " dataset=" + this.macroExec.getBuildableResource().getName(), 4);
                    }
                    this.publishDDs(this.rc);
                    try {
                        this.compactDDs();
                    }
                    catch (RuntimeException e2) {
                        if (e != null) {
                            e2.printStackTrace();
                        }
                        e = e2;
                    }
                    if (e != null) {
                        throw e;
                    }
                }
                return;
            }
            catch (Exception e) {
                this.log(e.getMessage(), e, 2);
                throw new BuildException((Throwable)e);
            }
        }
        try {
            if (this.traceDDAlloc) {
                this.logCurrentDDs();
            }
            this.allocateDDs();
        }
        catch (RcException rce) {
            this.freeDDs();
            throw new BuildException((Throwable)rce);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        boolean caughtException = false;
        try {
            try {
                SubProcessMacroExec spme;
                boolean freeHiddenDD = this.getProject().getProperty(FREE_HDN_DD_FLG) == null ? true : Boolean.valueOf(this.getProject().getProperty(FREE_HDN_DD_FLG));
                List<String> ddNamesBefore = null;
                String pgmName = this.getPgm();
                if (freeHiddenDD && this.isFreeHiddenDD(pgmName)) {
                    this.logMsg("hidden ddNamesBefore pgmName: " + pgmName, 4);
                    try {
                        spme = SubProcessManager.getSubProcessMacroExec((Task)this);
                        ddNamesBefore = ZOS.getDDNames((ProjectComponent)this, spme);
                        this.logMsg("hidden ddNamesBefore DD list: " + ddNamesBefore, 4);
                    }
                    catch (UnsatisfiedLinkError e) {
                        this.logMsg("Build toolkit is using an old version of libRTCzMVSExec", 1);
                    }
                }
                if (this.traceDDNames) {
                    this.logCurrentDDs();
                }
                this.rc = this.exec(this.getParm());
                this.logMsg(NLS.bind((String)Messages.COMPILE_RESULT, (Object[])new Object[]{this.name, this.rc, Integer.toString(this.rc, 16)}, (Object[])new Object[0]), 3);
                this.rc = this.convertRc(this.rc);
                this.setReturnCodeVariable(Integer.toString(this.rc));
                for (AbstractDD alloc : this.allocs) {
                    if (!(alloc instanceof Alloc) || !((Alloc)alloc).isInput()) continue;
                    Alloc alloc2 = (Alloc)alloc;
                    this.log("(return code) rc=" + this.rc + " component=" + alloc2.getComponentName() + " project=" + alloc2.getProjectName() + " dataset=" + alloc2.getDsn(), 4);
                }
                this.publishDDs(this.rc);
                this.checkRc(this.rc);
                if (ddNamesBefore != null && freeHiddenDD && this.isFreeHiddenDD(pgmName)) {
                    spme = SubProcessManager.getSubProcessMacroExec((Task)this);
                    List<String> ddNamesAfter = ZOS.getDDNames((ProjectComponent)this, spme);
                    this.logMsg("hidden ddNamesAfter DD list: " + ddNamesAfter, 4);
                    if (ddNamesAfter.size() > ddNamesBefore.size()) {
                        for (String s : ddNamesAfter) {
                            if (ddNamesBefore.contains(s)) continue;
                            try {
                                ZOS.free((Task)this, s, SubProcessManager.getSubProcessMacroExec((Task)this));
                            }
                            catch (ZFileException e) {
                                this.getProject().log(e.getMessage(), (Throwable)e, 4);
                            }
                        }
                    }
                }
            }
            catch (RuntimeException e) {
                caughtException = true;
                throw e;
            }
        }
        finally {
            block53: {
                try {
                    try {
                        this.compactDDs();
                    }
                    catch (RcException e) {
                        if (!caughtException) {
                            throw e;
                        }
                        e.printStackTrace();
                        this.freeDDs();
                        if (this.traceDDAlloc) {
                            this.logCurrentDDs();
                        }
                        break block53;
                    }
                }
                catch (Throwable throwable) {
                    this.freeDDs();
                    if (this.traceDDAlloc) {
                        this.logCurrentDDs();
                    }
                    throw throwable;
                }
                this.freeDDs();
                if (this.traceDDAlloc) {
                    this.logCurrentDDs();
                }
            }
        }
    }

    private void resolveDDs() {
        Task compileTask = this.macroExec.getTask();
        boolean needToupdateBuildmap = false;
        Hashtable buildProperties = this.getProject().getProperties();
        IFileSystemUtil util = FileSystemUtilFactory.createFileSystemUtil();
        String prefix = (String)buildProperties.get("team.enterprise.scm.resourcePrefix");
        util.setPrefix(prefix);
        util.setWorkspaceUuid((String)buildProperties.get("team.enterprise.scm.workspaceUUID"));
        IBuildableResource buildableResource = this.macroExec.getBuildableResource();
        Set inputFiles = buildableResource.getInputFiles();
        for (BuildFileXMLModel inputFile : inputFiles) {
            try {
                if (inputFile.getResolvedTo() != null || buildableResource.getResolvedInputFiles() != null && buildableResource.getResolvedInputFiles().contains(inputFile) || inputFile.getBuildPathDD() == null) continue;
                BuildFileXMLModel.BuildPathDD buildPathDD = inputFile.getBuildPathDD();
                this.logMsg("Buildpath DD is present and named " + buildPathDD.getName() + " on inputFile " + inputFile + " for " + buildableResource, 4);
                boolean foundThisTranslator = false;
                for (BuildFileXMLModel.BuildPathTranslator translator : buildPathDD.getTranslators()) {
                    this.logMsg("\ttranslator:  " + translator.getTranslator(), 4);
                    if (!translator.getTranslator().equals(this.getName())) continue;
                    foundThisTranslator = true;
                    this.logMsg("\ttranslator matches the DD", 4);
                    break;
                }
                if (!foundThisTranslator) continue;
                AbstractDD alloc = null;
                for (AbstractDD a : this.allocs) {
                    if (!a.getDd().equals(buildPathDD.getName())) continue;
                    alloc = a;
                    this.logMsg("\tfound alloc that matches the DD", 4);
                    break;
                }
                if (alloc == null) continue;
                StringBuffer buildPathBuffer = new StringBuffer();
                if (alloc instanceof Alloc) {
                    buildPathBuffer.append(((Alloc)alloc).getDsn());
                } else if (alloc instanceof Concat) {
                    Concat concat = (Concat)alloc;
                    String delimiter = EMPTY_STRING;
                    for (Alloc a : concat.getAllocs()) {
                        String dsn = a.getDsn();
                        buildPathBuffer.append(delimiter);
                        buildPathBuffer.append(dsn);
                        delimiter = COLON;
                    }
                }
                String buildPath = buildPathBuffer.toString();
                this.logMsg("\tderived build path=" + buildPath, 4);
                if (buildPath == null || buildPath.length() <= 0) continue;
                inputFile.setBuildPath(buildPath.toString());
                needToupdateBuildmap |= util.resolveFile(compileTask, buildableResource, inputFile);
            }
            catch (Exception e) {
                this.logMsg("Error processing inputfile for conditional DD", e, 0);
            }
        }
        if (needToupdateBuildmap) {
            buildableResource.getBuildMap(compileTask);
        }
    }

    private void validateDDs() {
        String passedConditions = this.getProject().getProperty("team.enterprise.conditional.dds");
        if (!Boolean.valueOf(passedConditions).booleanValue()) {
            return;
        }
        Iterator<AbstractDD> it = this.allocs.iterator();
        block0: while (it.hasNext()) {
            String[] unlessProps;
            AbstractDD dd = it.next();
            String ifProp = dd.getIf();
            String unless = dd.getUnless();
            if (ifProp != null && !ifProp.isEmpty()) {
                if (Boolean.valueOf(ifProp).booleanValue()) continue;
                this.getProject().log(NLS.bind((String)Messages.CONDITIONAL_DD_SKIPPED_FALSE_CONDITION, (Object)dd.getDd(), (Object[])new Object[]{dd.getIf()}), 4);
                it.remove();
                continue;
            }
            if (unless == null || unless.isEmpty()) continue;
            String[] stringArray = unlessProps = unless.split(";");
            int n = unlessProps.length;
            int n2 = 0;
            while (n2 < n) {
                String nextUnless = stringArray[n2];
                if (Boolean.valueOf(nextUnless).booleanValue()) {
                    this.getProject().log(NLS.bind((String)Messages.CONDITIONAL_DD_SKIPPED_SUPERCEDED, (Object)dd.getDd(), (Object[])new Object[0]), 3);
                    it.remove();
                    continue block0;
                }
                ++n2;
            }
        }
        HashSet<String> seen = new HashSet<String>(this.allocs.size());
        for (AbstractDD next : this.allocs) {
            String ddName = next.getDd().toUpperCase(Locale.US);
            if (seen.contains(ddName)) {
                throw new BuildException(NLS.bind((String)Messages.MULTIPLE_CONDITIONAL_DDS_TRUE, (Object)ddName, (Object[])new Object[0]));
            }
            seen.add(ddName);
        }
    }

    private void logCurrentDDs() {
        List<String> ddNames = null;
        try {
            SubProcessMacroExec spme = SubProcessManager.getSubProcessMacroExec((Task)this);
            ddNames = ZOS.getDDNames((ProjectComponent)this, spme);
        }
        catch (UnsatisfiedLinkError e) {
            this.dbg.logMsg("Build toolkit is using an old version of libRTCzMVSExec", 0);
            return;
        }
        if (ddNames != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Currently allocated DD:");
            sb.append(System.lineSeparator());
            for (String ddName : ddNames) {
                sb.append("    ");
                sb.append(ddName);
                sb.append(System.lineSeparator());
            }
            if (this.dbg.isDebug()) {
                this.dbg.logMsg(sb.toString(), 4);
            }
        } else if (this.dbg.isDebug()) {
            this.dbg.logMsg("No currently allocated DD", 4);
        }
    }

    private void setReturnCodeVariable(String sRc) {
        String rcVar = this.getReturnCodeVariableName();
        if (rcVar != null && !rcVar.isEmpty()) {
            this.getProject().setProperty(rcVar, sRc);
        }
    }

    private void freeDDs() {
        for (AbstractDD alloc : this.allocs) {
            String dd;
            alloc.free((Task)this);
            if (!this.tasklib) continue;
            String string = dd = alloc.getDd() == null ? null : alloc.getDd().toUpperCase(Locale.US);
            if (!TASKLIB.equals(dd)) continue;
            this.tasklib = false;
            alloc.freeSteplib((Task)this);
        }
    }

    private void compactDDs() throws RcException {
        String user = null;
        RcException firstException = null;
        boolean useGateway = this.callMethod == 1 || this.callMethod == 2;
        for (AbstractDD dd : this.allocs) {
            boolean blzerrorAllocated;
            Alloc alloc;
            block22: {
                if (!(dd instanceof Alloc) || !(alloc = (Alloc)dd).isCompact()) continue;
                if (useGateway) {
                    alloc.allocate((Task)this);
                }
                if (TEMPORARY_UNIT == null && ((TEMPORARY_UNIT = System.getenv("_TEMPORARY_UNIT")) == null || TEMPORARY_UNIT.trim().isEmpty())) {
                    TEMPORARY_UNIT = "SYSALLDA";
                }
                if (user == null) {
                    user = ZUtil.getCurrentUser();
                }
                blzerrorAllocated = false;
                if (this.shouldPublish(alloc, 10, 0)) {
                    try {
                        ZOS.bpxwdyn((ProjectComponent)this, "ALLOC DD(BLZERROR) cyl space(1,1) dsorg(ps) unit(sysallda) lrecl(131) recfm(f,b)  new msg(1)", this.getSubProcessMacroExec());
                        blzerrorAllocated = true;
                    }
                    catch (Exception e) {
                        if (!this.dbg.isDebug()) break block22;
                        this.dbg.logMsg((Throwable)e, 4);
                    }
                }
            }
            try {
                String parms = "ENCODE," + alloc.getDd() + COMMA + alloc.getDd() + COMMA + TEMPORARY_UNIT + COMMA + user + COMMA + "Y";
                this.getProject().log("Compacting DD " + alloc.getDd() + " with: " + COMPRESS_MODULE + " " + parms, 4);
                int rc = this.compile(COMPRESS_MODULE, parms, null, this.tasklib);
                if (rc != 0 && rc != 4) {
                    RcException rcEx = new RcException(NLS.bind((String)Messages.DD_COMPACT_FAILED, (Object)alloc.getDd(), (Object[])new Object[0]), rc);
                    if (firstException == null) {
                        firstException = rcEx;
                    } else {
                        rcEx.printStackTrace();
                    }
                    if (blzerrorAllocated) {
                        try {
                            this.publishFile(COMPRESS_LOG_DD, rc, alloc);
                        }
                        catch (Exception e) {
                            this.getProject().log(e.getMessage(), (Throwable)e, 4);
                        }
                    }
                }
                if (!useGateway) continue;
                alloc.free((Task)this);
            }
            finally {
                if (blzerrorAllocated) {
                    try {
                        ZOS.free((Task)this, COMPRESS_LOG_DD, this.getSubProcessMacroExec());
                    }
                    catch (Exception e) {
                        this.getProject().log(e.getMessage(), (Throwable)e, 4);
                    }
                }
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    private void publishDDs(int rc) {
        boolean useGateway = this.callMethod == 1 || this.callMethod == 2;
        Set<String> outputdds = this.getCandidateDDsToBePublished(rc);
        for (AbstractDD alloc : this.allocs) {
            String ddname = alloc.getDd().toUpperCase(Locale.US);
            if (!outputdds.contains(ddname) || !(alloc instanceof Alloc)) continue;
            Alloc alc = (Alloc)alloc;
            if (useGateway && alc.getDsn() == null) continue;
            try {
                if (!this.shouldPublish(alc, rc, this.getMaxrc())) continue;
                if (useGateway) {
                    try {
                        try {
                            alc.allocate((Task)this);
                            this.publishFile(ddname, rc, alc);
                        }
                        catch (ZFileException ze) {
                            this.logMsg(ze.toString(), 2);
                            try {
                                alc.free((Task)this);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            alc.free((Task)this);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        alc.free((Task)this);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                this.publishFile(ddname, rc, alc);
            }
            catch (ZFileException ze) {
                this.logMsg(ze.toString(), 2);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    private boolean shouldPublish(Alloc alloc, int rc, int maxrc) {
        boolean shouldPublish = true;
        if (alloc.isPublish() && alloc.getPublishType() == 0) {
            shouldPublish = this.isPublishoutputs() && (!this.isPublishoutputsforerrorsonly() || rc > maxrc);
        } else {
            switch (alloc.getPublishType()) {
                case 3: {
                    shouldPublish = rc > maxrc;
                    break;
                }
                case 2: {
                    break;
                }
                case 0: {
                    shouldPublish = false;
                    break;
                }
                case 1: {
                    shouldPublish = this.isPublishoutputs() && (!this.isPublishoutputsforerrorsonly() || rc > maxrc);
                }
            }
        }
        return shouldPublish;
    }

    private Set<String> getCandidateDDsToBePublished(int rc) {
        HashSet<String> outputdds = new HashSet<String>(4);
        if (this.getPublishoutputsdds() != null && this.getPublishoutputsdds().trim().length() > 0 && this.getPublishoutputsdds().charAt(0) != '$') {
            String[] dds;
            String s = this.getPublishoutputsdds().trim().toUpperCase(Locale.US);
            String[] stringArray = dds = s.split(COMMA);
            int n = dds.length;
            int n2 = 0;
            while (n2 < n) {
                String dd = stringArray[n2];
                outputdds.add(dd);
                ++n2;
            }
        } else {
            for (AbstractDD alloc : this.allocs) {
                if (!(alloc instanceof Alloc) || !((Alloc)alloc).isPublish()) continue;
                String ddname = alloc.getDd().toUpperCase(Locale.US);
                outputdds.add(ddname);
            }
        }
        return outputdds;
    }

    private static String formatInEightChars(String s) {
        if (s == null || s.length() == 8) {
            return s;
        }
        return (String.valueOf(s) + EIGHT_SPACES).substring(0, 8);
    }

    public String getBuildResultUUID() {
        return this.buildResultUUID;
    }

    public String getDdnamelist() {
        return this.ddnamelist;
    }

    public int getMaxrc() {
        return this.maxrc;
    }

    public String getName() {
        return this.name;
    }

    public String getParm() {
        return this.parm;
    }

    public String getPassword() {
        return this.password;
    }

    public File getPasswordFile() {
        return this.passwordFile;
    }

    public String getPgm() {
        return this.pgm;
    }

    public String getPublishoutputsdds() {
        return this.publishoutputsdds;
    }

    protected int getRc() {
        return this.rc;
    }

    public String getRepositoryAddress() {
        return this.repositoryAddress;
    }

    public String getUserId() {
        return this.userId;
    }

    public boolean isOK(int maxRc) {
        return this.getRc() <= maxRc;
    }

    public boolean isPublishoutputs() {
        return this.publishoutputs;
    }

    public boolean isPublishoutputsforerrorsonly() {
        return this.publishoutputsforerrorsonly;
    }

    public boolean isPublishsuccessfullogsaszips() {
        return this.publishsuccessfullogsaszips;
    }

    public void setPublishsuccessfullogsaszips(boolean publishsuccessfullogsaszips) {
        this.publishsuccessfullogsaszips = publishsuccessfullogsaszips;
    }

    private void publishOrZip(File filePath, int rc, boolean isConsolidated) {
        BuildStatus status = rc > this.maxrc ? BuildStatus.ERROR : (rc > 0 ? BuildStatus.WARNING : BuildStatus.OK);
        this.logMsg("publishOrZip: rc=" + rc + " error=" + (status == BuildStatus.ERROR) + " isPublishsuccessfullogsaszips():" + this.isPublishsuccessfullogsaszips(), 4);
        if (isConsolidated && this.macroExec != null) {
            this.macroExec.recordLogSeverity(status);
        } else {
            String logLabel = NLS.bind((String)Messages.SYSPRINT_DESCRIPTION, (Object)this.getName(), (Object[])new Object[]{"&&ANTZTEMP".equals(this.getDescription()) ? Messages.INSTREAM_SOURCE : this.getDescription()});
            String zipInfoMessageInsert = NLS.bind((String)Messages.SYSPRINT_STORED_AS_SINGLE_INSERT, (Object[])new String[]{filePath.getName(), this.getName(), "&&ANTZTEMP".equals(this.getDescription()) ? Messages.INSTREAM_SOURCE : this.getDescription()}, (Object[])new Object[0]);
            Executable.publishOrZip(filePath, status, this.getProject(), (Task)this, logLabel, zipInfoMessageInsert);
        }
    }

    public static void publishOrZip(File filePath, BuildStatus status, Project project, Task task, String logLabel, String zipInfoMessageInsert) {
        String absolutePath;
        if (status != BuildStatus.ERROR && filePath.length() == 0L) {
            project.log(NLS.bind((String)Messages.SKIPPING_EMPTY_LOG, (Object)logLabel, (Object[])new Object[0]), 3);
            filePath.delete();
            return;
        }
        if (status == BuildStatus.ERROR || !Boolean.parseBoolean(project.getProperty("team.enterprise.build.publishoutputs.successfulLogsAsZips"))) {
            Executable.publishTextFile(filePath, project, logLabel, status);
            return;
        }
        String tmpdir = AbstractMacroExec.getLoadDir((Project)project);
        int publishCount = filePublishingCounter.getAndIncrement();
        File zipFile = new File(String.valueOf(tmpdir) + File.separator + String.format("logs_%03d", publishCount / 100) + ZIP_EXTENSION);
        String newName = absolutePath = filePath.getAbsolutePath();
        if (absolutePath != null && absolutePath.endsWith(LOG_EXTENSION)) {
            newName = String.valueOf(absolutePath.substring(0, absolutePath.length() - LOG_EXTENSION.length())) + String.format("_%05d", publishCount) + LOG_EXTENSION;
            filePath.renameTo(new File(newName));
            filePath = new File(newName);
        }
        try {
            Executable.addFileToZip(zipFile, filePath, project);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        project.log(NLS.bind((String)Messages.SYSPRINT_STORED_AS, (Object[])new Object[]{zipInfoMessageInsert, filePath.getName(), zipFile.getName()}, (Object[])new Object[0]), 3);
        if (publishCount % 100 == 99) {
            Executable.publishZipFile(zipFile, project);
        }
    }

    private void publishFile(String dd, int rc, Alloc alloc) throws IOException {
        File tempFile;
        boolean isConsolidated;
        switch (alloc.getConsolidate()) {
            case 1: {
                isConsolidated = false;
                break;
            }
            case 2: {
                isConsolidated = true;
                break;
            }
            case 3: {
                isConsolidated = rc <= this.maxrc;
                break;
            }
            default: {
                boolean bl = isConsolidated = this.macroExec == null ? false : this.macroExec.isConsolidatedLogs();
            }
        }
        if (isConsolidated && this.macroExec != null) {
            tempFile = this.macroExec.getConsolidatedLog();
        } else {
            String tmpdir = AbstractMacroExec.getLoadDir((Project)this.getProject());
            String newName = this.convertSYSPRINT2MemberName(dd);
            String tempFileName = String.valueOf(tmpdir) + File.separator + newName + LOG_EXTENSION;
            tempFile = new File(tempFileName);
        }
        boolean needSeparator = isConsolidated && tempFile.exists();
        boolean compact = alloc.isCompact();
        if (this.isMultiProcess()) {
            this.saveDDContent(dd, tempFile.getAbsolutePath(), isConsolidated, needSeparator, compact);
        } else {
            EBCDICFilterInputStream ins = new EBCDICFilterInputStream(new ZFile(DD_PREFIX + dd, "r").getInputStream());
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile, isConsolidated), UTF_8));
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)ins, com.ibm.teamz.build.ant.jni.Executable.retrieveEncoding()));
            if (needSeparator) {
                w.write(CRLF);
                w.write(CRLF);
            }
            String x = null;
            while ((x = r.readLine()) != null) {
                w.write(x, 0, compact ? this.getCompactedLength(x) : x.length());
                w.write(CRLF);
            }
            w.flush();
            w.close();
            r.close();
        }
        this.publishOrZip(tempFile, rc, isConsolidated);
    }

    private int getCompactedLength(String s) {
        int i = s.length() - 1;
        while (i >= 0 && Character.isWhitespace(s.charAt(i))) {
            --i;
        }
        return i + 1;
    }

    private void saveDDContent(String dd, String tempFileName, boolean isConsolidated, boolean needSeparator, boolean compact) {
        String command = "saveContent:" + dd + "<>" + tempFileName + "<>" + (isConsolidated ? "1" : "0") + "<>" + (needSeparator ? "1" : "0") + "<>" + (compact ? "1" : "0");
        try {
            this.getSubProcessMacroExec().sendReceive(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void publishFile(File f, String name, boolean failed) throws IOException {
        String encoding;
        File tempFile;
        boolean isConsolidated;
        switch (this.getIspfLogConsolidate()) {
            case 2: {
                isConsolidated = true;
                break;
            }
            case 1: {
                isConsolidated = false;
                break;
            }
            case 3: {
                isConsolidated = !failed;
                break;
            }
            default: {
                boolean bl = isConsolidated = this.macroExec == null ? false : this.macroExec.isConsolidatedLogs();
            }
        }
        if (isConsolidated && this.macroExec != null) {
            tempFile = this.macroExec.getConsolidatedLog();
        } else {
            String tmpdir = AbstractMacroExec.getLoadDir((Project)this.getProject());
            tempFile = new File(String.valueOf(tmpdir) + File.separator + name + LOG_EXTENSION);
        }
        boolean needSeparator = isConsolidated && tempFile.exists();
        EBCDICFilterInputStream ins = new EBCDICFilterInputStream(new FileInputStream(f));
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile, isConsolidated), UTF_8));
        if (needSeparator) {
            w.write(CRLF);
            w.write(CRLF);
        }
        if (IBM_1047.equals(encoding = com.ibm.teamz.build.ant.jni.Executable.retrieveEncoding())) {
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)ins, encoding));
            String x = null;
            while ((x = r.readLine()) != null) {
                w.write(x, 0, this.ispfLogCompact ? this.getCompactedLength(x) : x.length());
                w.write(CRLF);
            }
            r.close();
        } else {
            int c;
            BufferedInputStream bis = new BufferedInputStream(ins, 256);
            byte[] b = new byte[256];
            boolean cdata = false;
            int i = 0;
            while ((c = bis.read()) != -1) {
                boolean newline;
                boolean bl = newline = c == 21;
                if (!newline) {
                    b[i++] = (byte)c;
                    if (i < 256) continue;
                }
                if (newline && i > 0 && b[i - 1] == 13) {
                    --i;
                }
                String s = new String(b, 0, i, IBM_1047);
                String s2 = s.trim();
                if (cdata && END_CDATA.equals(s2)) {
                    cdata = false;
                }
                if (cdata) {
                    s = new String(b, 0, i, encoding);
                } else if (START_CDATA.equals(s2)) {
                    cdata = true;
                }
                if (newline) {
                    w.write(s, 0, this.ispfLogCompact ? this.getCompactedLength(s) : s.length());
                    w.write(CRLF);
                } else {
                    w.write(s);
                }
                i = 0;
            }
            if (i > 0) {
                String s = new String(b, 0, i, IBM_1047);
                w.write(s, 0, this.ispfLogCompact ? this.getCompactedLength(s) : s.length());
                w.write(CRLF);
            }
            bis.close();
        }
        w.flush();
        w.close();
        this.publishOrZip(tempFile, this.rc, isConsolidated);
    }

    public void setBuildResultUUID(String buildResultUUID) {
        this.buildResultUUID = buildResultUUID;
    }

    public void setDdnamelist(String ddnamelist) {
        this.ddnamelist = ddnamelist;
    }

    public void setMaxrc(int maxrc) {
        this.maxrc = maxrc;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParm(String parm) {
        this.parm = parm;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPasswordFile(File passwordFile) {
        this.passwordFile = passwordFile;
    }

    public void setPgm(String pgm) {
        this.pgm = pgm;
    }

    public void setPublishoutputs(boolean publishoutputs) {
        this.publishoutputs = publishoutputs;
    }

    public void setPublishoutputsforerrorsonly(boolean publishoutputsforerrorsonly) {
        this.publishoutputsforerrorsonly = publishoutputsforerrorsonly;
    }

    @Deprecated
    public void setPublishoutputsdds(String publishoutputsdds) {
        this.publishoutputsdds = publishoutputsdds;
    }

    protected void setRc(int rc) {
        this.rc = rc;
    }

    public void setRepositoryAddress(String repositoryAddress) {
        this.repositoryAddress = repositoryAddress;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getLoadDir() {
        return this.loadDir;
    }

    public void setLoadDir(String loadDir) {
        this.loadDir = loadDir;
    }

    public int getCallMethod() {
        return this.callMethod;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCallMethod(int callMethod) {
        this.callMethod = callMethod;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public boolean isLinkedit() {
        return this.linkedit;
    }

    public void setLinkedit(boolean linkedit) {
        this.linkedit = linkedit;
    }

    public boolean isFreeHiddenDD(String pgmName) {
        if (this.freeHiddenDD == null) {
            String s;
            int n;
            int n2;
            String[] stringArray;
            this.logMsg("Initialize freeHiddenDD", 4);
            String newFreeHiddenDDvar = System.getenv(FREE_HDN_DD_VAR);
            this.logMsg("_FREE_HIDDEN_DD=" + newFreeHiddenDDvar, 4);
            String[] newFreeHiddenDDvars = null;
            if (newFreeHiddenDDvar != null && newFreeHiddenDDvar.length() > 0) {
                newFreeHiddenDDvars = newFreeHiddenDDvar.split(COMMA);
            }
            String newFreeHiddenDDprop = this.getProject().getProperty(FREE_HDN_DD_PRP);
            this.logMsg("freeHiddenDD=" + newFreeHiddenDDprop, 4);
            String[] newFreeHiddenDDprops = null;
            if (newFreeHiddenDDprop != null && newFreeHiddenDDprop.length() > 0) {
                newFreeHiddenDDprops = newFreeHiddenDDprop.split(COMMA);
            }
            this.freeHiddenDD = new HashSet<String>(Arrays.asList(FREE_HDN_DD_DEF));
            if (newFreeHiddenDDvars != null && newFreeHiddenDDvars.length > 0) {
                stringArray = newFreeHiddenDDvars;
                n2 = newFreeHiddenDDvars.length;
                n = 0;
                while (n < n2) {
                    s = stringArray[n];
                    this.freeHiddenDD.add(s);
                    ++n;
                }
            }
            if (newFreeHiddenDDprops != null && newFreeHiddenDDprops.length > 0) {
                stringArray = newFreeHiddenDDprops;
                n2 = newFreeHiddenDDprops.length;
                n = 0;
                while (n < n2) {
                    s = stringArray[n];
                    this.freeHiddenDD.add(s);
                    ++n;
                }
            }
            this.logMsg("Initialize freeHiddenDD done", 4);
        }
        return this.freeHiddenDD.contains(pgmName);
    }

    public File getBuildmap() {
        return this.buildmap;
    }

    public void setBuildmap(File buildmap) {
        this.buildmap = buildmap;
    }

    private int convertRc(int rc) {
        int convertedRc = rc;
        if (rc < 0 && !this.parseBoolean("team.enterprise.build.ant.allowNegativeReturnCode")) {
            int positiveRc = Math.abs(rc);
            this.logMsg(NLS.bind((String)Messages.CONVERT_NEGATIVE_RC, (Object)rc, (Object[])new Object[]{positiveRc}), 3);
            convertedRc = positiveRc;
        }
        return convertedRc;
    }

    private void checkRc(int rc) {
        this.checkRc(rc > this.getMaxrc());
    }

    private void checkRc(boolean failed) {
        if (failed) {
            throw new BuildException(NLS.bind((String)Messages.RC_EXCEEDS_MAXRC, (Object[])new Object[]{this.name, this.rc, Integer.toString(this.rc, 16), this.maxrc, Integer.toString(this.maxrc, 16)}, (Object[])new Object[0]));
        }
    }

    private int getAllocRetry() {
        String retryValue = this.getProject().getProperty("team.enterprise.build.tempRexxDatasetAllocRetry");
        if (retryValue != null) {
            try {
                int retry = Integer.parseInt(retryValue.trim());
                if (retry < 0) {
                    retry = Integer.MAX_VALUE;
                }
                return retry;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 100;
    }

    private String allocateRexxScript() throws BuildException, ZosException {
        String prefix = null;
        String temporaryPrefix = this.getProject().getProperty(PROPERTY_TMP_PFX);
        prefix = temporaryPrefix == null || temporaryPrefix.isEmpty() ? this.getProject().getProperty("team.enterprise.scm.resourcePrefix") : temporaryPrefix;
        rexxScriptCounter.compareAndSet(0L, System.currentTimeMillis() / 10L);
        String rexxScript = null;
        int allocRetry = this.getAllocRetry();
        int i = 0;
        while (i < allocRetry) {
            try {
                String tempName = String.format("ID%06d", rexxScriptCounter.getAndIncrement() % 1000000L, Locale.US);
                rexxScript = String.format("%s.%s.EXEC", prefix, tempName);
                this.logMsg("Allocate " + rexxScript + " as the REXX script for ISPF Gateway.", 4);
                String allocationString = "alloc da(" + rexxScript + ") fi(" + tempName + ") RECFM(V,B) LRECL(255) BLKSIZE(0) TRACKS SPACE(1,1) DSORG(PS) NEW CATALOG";
                ZOS.bpxwdyn((ProjectComponent)this, allocationString, this.getSubProcessMacroExec());
                ZOS.bpxwdyn((ProjectComponent)this, "FREE FI(" + tempName + ")", this.getSubProcessMacroExec());
                this.logMsg(String.valueOf(rexxScript) + " is allocated.", 4);
                return rexxScript;
            }
            catch (RcException rcException) {
                ++i;
            }
        }
        throw new ZosException(NLS.bind((String)Messages.ZOS_COULD_NOT_ALLOC_TEMP_REXX_SCRIPT, (Object[])new Object[]{rexxScript, String.valueOf(allocRetry)}, (Object[])new Object[0]));
    }

    @DebugGroup(value={"gateway"})
    private void executeTso() throws TransformerFactoryConfigurationError, Exception {
        boolean isInteractive;
        Mnm mnm = new Mnm(){}.put(this.dbg, this.cls);
        mnm.enter(new String[0]);
        File parmFile = null;
        File xml = null;
        String cmdLine = null;
        String rexxScript = null;
        Project project = this.getProject();
        boolean reuseISPFSession = Boolean.valueOf(project.getProperty("team.enterprise.build.ant.reuseISPFSession"));
        boolean debugISPFGateway = Boolean.valueOf(project.getProperty("team.enterprise.build.ant.debugISPFGateway"));
        boolean retries = true;
        int attempts = 0;
        List<AllocInfo> allocationStringList = this.getAllocInfoList();
        SubProcessMacroExec spme = SubProcessManager.getSubProcessMacroExec((Task)this);
        String cmd = this.substituteVars(this.getCommand());
        if (cmd != null && cmd.contains(SSI_INFO)) {
            cmd = cmd.replace(SSI_INFO, this.ssi_info);
        }
        if (mnm.getDbg().isFlow()) {
            String msg = NLS.bind((String)Messages.RUNNING_TSO_COMMAND, (Object[])new Object[]{this.getName(), cmd}, (Object[])new Object[0]);
            mnm.inter(new String[]{msg});
        }
        InteractiveISPFGateway interactiveGW = (isInteractive = InteractiveISPFGateway.isInteractiveGatewayEnabled(project)) ? new InteractiveISPFGateway(project, this.callMethod, cmd, spme, allocationStringList, debugISPFGateway, this.convertISPFGateway2MemberName(), this.dbg) : null;
        while (attempts <= 1) {
            if (attempts > 0 && this.dbg.isDebug()) {
                String msg = NLS.bind((String)Messages.RETRYING_TSO_COMMAND, (Object[])new Object[]{this.getName(), cmd, attempts + 1}, (Object[])new Object[0]);
                mnm.debug(new String[]{msg});
            }
            ++attempts;
            String dirName = AbstractMacroExec.getLoadDir((Project)this.getProject());
            File dir = new File(dirName);
            File out = File.createTempFile(ISPF_PREFIX, LOG_EXTENSION, dir);
            List<Environment.Variable> envVars = null;
            SubProcess subProcess = null;
            if (isInteractive) {
                InteractiveISPFGateway.CommandLine gatewayCmdLine = interactiveGW.getGatewayCmdLine();
                cmdLine = gatewayCmdLine.cmdLine;
                parmFile = gatewayCmdLine.parmFile;
                envVars = gatewayCmdLine.envVars;
                subProcess = gatewayCmdLine.subProcess;
            } else {
                rexxScript = this.allocateRexxScript();
                xml = ISPFGatewayUtil.generateXmlFile((ILoggingInterface)new TaskLog((Task)this), (File)dir, (String)rexxScript, (String)cmd, (String)(this.getCallMethod() == 2 ? "TSO" : DEBUG_LBL_ISPF), (String)(reuseISPFSession ? "REUSE" : "NONE"), allocationStringList, (boolean)this.isMultiProcess(), (boolean)false, (boolean)debugISPFGateway);
                cmdLine = "cat " + xml.getCanonicalPath() + " |ISPZXML";
            }
            mnm.debug(new String[]{DEBUG_LBL_CMD, cmdLine});
            try {
                boolean failed;
                StatisticsBlock block = mnm.getTime(DEBUG_LBL_ISPF, true);
                if (this.isMultiProcess()) {
                    this.execViaSPME(project, out, cmdLine);
                } else if (isInteractive) {
                    Executable.execViaSubprocess(subProcess, project, out, cmdLine);
                } else {
                    this.execViaTask(project, (Task)this, dir, out, cmdLine, true, envVars);
                }
                mnm.setTime(block, true);
                GatewayResult gwResult = null;
                if (isInteractive) {
                    gwResult = interactiveGW.getResult(out);
                    this.rc = gwResult.rc;
                } else {
                    this.rc = ISPFGatewayUtil.getTranslatorReturnCode((File)out, (boolean)debugISPFGateway);
                }
                if (mnm.getDbg().isFlow()) {
                    String msg = NLS.bind((String)Messages.COMPILE_RESULT, (Object[])new Object[]{this.name, this.rc, Integer.toString(this.rc, 16)}, (Object[])new Object[0]);
                    mnm.inter(new String[]{msg});
                }
                if (!isInteractive) {
                    this.rc = this.convertRc(this.rc);
                }
                boolean bl = failed = this.rc > this.maxrc || gwResult != null && gwResult.isFailure;
                if (this.shouldPublishISPFGatewayLog(failed)) {
                    this.publishFile(out, this.convertISPFGateway2MemberName(), failed);
                }
                if (isInteractive) {
                    interactiveGW.checkRc(gwResult);
                }
                this.checkRc(failed);
                break;
            }
            catch (InteractiveISPFGateway.RetryException e) {
                mnm.log((Throwable)e, 2);
            }
            catch (IOException e) {
                mnm.log((Throwable)e, 0);
                ++attempts;
                break;
            }
            finally {
                if (!debugISPFGateway) {
                    if (xml != null) {
                        xml.delete();
                    }
                    if (rexxScript != null) {
                        ZOS.removeDataset((ProjectComponent)this, rexxScript);
                    }
                    if (out != null) {
                        out.delete();
                    }
                    if (parmFile != null) {
                        parmFile.delete();
                    }
                }
            }
        }
        mnm.leave(new String[0]);
    }

    private static String buildCLIwithExportPath(Project project, String cmdLine) {
        String path = Executable.getISPFBinPath(project);
        String commandString = "export PATH=" + path + "; " + cmdLine;
        project.log("commandString=" + commandString, 4);
        return commandString;
    }

    public static String getISPFBinPath(Project project) {
        String myISPFBinPath = project.getProperty("team.enterprise.build.ant.myISPFBinPath");
        String path = String.valueOf(Verification.isNonEmpty((String)myISPFBinPath) ? String.valueOf(myISPFBinPath) + COLON : EMPTY_STRING) + "${PATH}:" + System.getenv("_CMDSERV_BASE_HOME") + "/bin";
        return path;
    }

    private void execViaSPME(Project project, File out, String cmdLine) throws IOException {
        Mnm mnm = this.dbg.isOn() ? new Mnm(){}.enter(this.dbg, this.cls, new String[]{cmdLine}) : new Mnm();
        StatisticsBlock block = mnm.getTime(DEBUG_LBL_SPME, true);
        String commandString = Executable.buildCLIwithExportPath(project, cmdLine);
        String command = "execute:" + commandString + " >" + out.getCanonicalPath();
        String result = this.getSubProcessMacroExec().sendReceive(command);
        mnm.setTime(block, true);
        mnm.leave(new String[]{cmdLine, result});
    }

    public static void execViaSubprocess(SubProcess subProcess, Project project, File out, String cmdLine) throws IOException {
        Mnm mnm = staticDbg.isOn() ? new Mnm(){}.enter(staticDbg, staticCls, new String[]{cmdLine}) : new Mnm();
        StatisticsBlock block = mnm.getTime(DEBUG_LBL_SUBP, true);
        String commandString = Executable.buildCLIwithExportPath(project, cmdLine);
        String command = "execute:" + commandString + " >" + out.getCanonicalPath();
        String result = subProcess.sendReceive(command);
        if (block != null) {
            Statistics.logTiming((StatisticsBlock)block);
        }
        mnm.setTime(block, true);
        mnm.leave(new String[]{cmdLine, result});
    }

    private int getSpmeRC(String result) {
        int rc = -1;
        try {
            rc = Integer.valueOf(result);
        }
        catch (NumberFormatException ex) {
            rc = -1;
        }
        return 0;
    }

    public static int execViaTask(Project project, File out, String cmdLine, List<Environment.Variable> envVars) {
        Executable executable = new Executable();
        executable.setProject(project);
        executable.init();
        return executable.execViaTask(project, null, null, out, cmdLine, false, envVars);
    }

    private int execViaTask(Project project, Task owner, File dir, File out, String cmdLine, boolean failOnError, List<Environment.Variable> envVars) {
        Mnm mnm = this.dbg.isOn() ? new Mnm(){}.enter(this.dbg, this.cls, new String[]{cmdLine}) : new Mnm();
        StatisticsBlock block = mnm.getTime(DEBUG_LBL_TASK, true);
        int result = -1;
        ExecTask execTask = new ExecTask();
        execTask.setProject(project);
        execTask.setTaskName(TASKNAME_EXEC);
        execTask.setFailIfExecutionFails(failOnError);
        if (envVars != null) {
            for (Environment.Variable envVar : envVars) {
                execTask.addEnv(envVar);
            }
        }
        if (owner != null) {
            execTask.bindToOwner(owner);
        } else {
            execTask.init();
        }
        if (dir != null) {
            execTask.setDir(dir);
        }
        if (out != null) {
            execTask.setOutput(out);
        }
        execTask.setExecutable(BIN_SH);
        Commandline.Argument arg1 = execTask.createArg();
        arg1.setValue(C_OPTION);
        Commandline.Argument arg2 = execTask.createArg();
        arg2.setValue(Executable.buildCLIwithExportPath(project, cmdLine));
        if (!failOnError) {
            execTask.setResultProperty(PROPERTY_RC);
        }
        execTask.perform();
        if (!failOnError) {
            result = Integer.valueOf(project.getProperty(PROPERTY_RC));
        }
        mnm.setTime(block, true);
        mnm.leave(new Object[]{cmdLine, result});
        return result;
    }

    private boolean shouldPublishISPFGatewayLog(boolean failed) {
        switch (this.getIspfLogPublishType()) {
            case 2: {
                return true;
            }
            case 0: {
                return false;
            }
            case 3: {
                return failed;
            }
        }
        return this.isPublishoutputs() && (!this.isPublishoutputsforerrorsonly() || failed);
    }

    private void initializeVariableMap() {
        this.variableMap.put("&F", "@{source.dataset}");
        this.variableMap.put("&N", "@{source.member.name}");
        if (!this.variables.isEmpty()) {
            for (Variable var : this.variables) {
                this.variableMap.put(var.getName(), var.getValue());
            }
        }
        long l = System.currentTimeMillis() / 1000L;
        this.ssi_info = String.format("%08x", l).toUpperCase(Locale.US);
    }

    private String substituteVars(String str) {
        String strAfter = VariableUtil.substituteVars((String)str, this.variableMap, (Task)this);
        if (!strAfter.equals(str)) {
            this.logMsg("\"" + str + "\" was converted into \"" + strAfter + "\" with variable substitutions.", 4);
        }
        return strAfter;
    }

    public static void publishLogZips(Project project) {
        block6: {
            if (Boolean.parseBoolean(project.getProperty("team.enterprise.build.userbuild"))) {
                project.log("This is a userbuild, do not use publishLogZips at the end of the build", 4);
                return;
            }
            try {
                project.log("publishLogZip: entry", 4);
                String dir = AbstractMacroExec.getLoadDir((Project)project);
                File[] files = new File(dir).listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return Pattern.matches("^logs_\\d{3}\\.zip$", name);
                    }
                });
                if (files != null) {
                    project.log("publishLogZip: # of files to be published: " + files.length, 4);
                }
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    Executable.publishZipFile(file, project);
                    ++n2;
                }
                String buildResultUUID = project.getProperty("buildResultUUID");
                IBuildResultHandle buildResultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildResultUUID), null);
                Executable.publishLogContributions(buildResultHandle, project);
                project.log("publishLogZip: looping through log contribution results of size " + futureLogsConribsPublish.size(), 4);
                int i = 0;
                while (i < futureLogsConribsPublish.size()) {
                    futureLogsConribsPublish.get(i).get();
                    ++i;
                }
                project.log("publishLogZip: exit", 4);
            }
            catch (Exception e) {
                project.log(Messages.FAILED_PUBLISHING_RESULTS, (Throwable)e, 0);
                if (e.getMessage() == null) break block6;
                project.log(e.getMessage());
            }
        }
    }

    private static void publishTextFile(File filePath, Project project, String logLabel, BuildStatus status) {
        File temp = new File(String.valueOf(filePath.getAbsolutePath()) + rand.nextLong());
        String name = filePath.getName();
        filePath.renameTo(temp);
        Executable.doPublish(temp, name, logLabel, project, status, PLAIN_TEXT);
    }

    private static Future<IBuildResultContribution> publishZipFile(File filePath, Project project) {
        String label = Executable.getZipFileLabel(filePath.getName(), filePublishingCounter.get());
        return Executable.doPublish(filePath, label, project, BuildStatus.OK, "application/zip");
    }

    private static Future<IBuildResultContribution> doPublish(File filePath, String label, Project project, BuildStatus contributionStatus, String contentType) {
        return Executable.doPublish(filePath, null, label, project, contributionStatus, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Future<IBuildResultContribution> doPublish(final File filePath, final String desiredName, final String label, final Project project, final BuildStatus contributionStatus, final String contentType) {
        Future<IBuildResultContribution> contribution = Executable.getExecutor().submit(new Callable<IBuildResultContribution>(){

            @Override
            public IBuildResultContribution call() throws Exception {
                boolean userbuild = Boolean.parseBoolean(project.getProperty("team.enterprise.build.userbuild"));
                if (userbuild) {
                    project.log("This is a userbuild, do not attach log to build result", 4);
                    String nameOfFile = filePath.getName();
                    int i = 0;
                    while (i < nameOfFile.length()) {
                        if (nameOfFile.substring(i).startsWith(Executable.LOG_EXTENSION)) {
                            nameOfFile = nameOfFile.substring(0, i + 4);
                        }
                        ++i;
                    }
                    String newFilePath = String.valueOf(filePath.getParent()) + "/" + nameOfFile;
                    File logFile = new File(newFilePath);
                    project.log("Copying the log here : " + newFilePath, 4);
                    FileReader fr = new FileReader(filePath);
                    BufferedReader br = new BufferedReader(fr);
                    FileWriter fw = new FileWriter(logFile, true);
                    String str = null;
                    while ((str = br.readLine()) != null) {
                        fw.write(str);
                        fw.write("\n");
                        fw.flush();
                    }
                    fw.close();
                    br.close();
                    filePath.delete();
                    return null;
                }
                project.log("This is not a userbuild, continue with log and build result contribution", 4);
                if (InitTask.getInstance().getTeamRepository() == null) {
                    filePath.delete();
                    return null;
                }
                BasicLogPublisher publisher = new BasicLogPublisher(filePath.getAbsolutePath(), label, contentType, Executable.UTF_8, desiredName);
                try {
                    IBuildResultContribution result;
                    IBuildResultContribution iBuildResultContribution = result = publisher.createContribution(InitTask.getInstance().getTeamRepository(), contributionStatus);
                    return iBuildResultContribution;
                }
                catch (TeamRepositoryException e) {
                    throw new BuildException((Throwable)e);
                }
                finally {
                    filePath.delete();
                }
            }
        });
        Object object = logContributionMutex;
        synchronized (object) {
            logContributions.add(contribution);
        }
        String buildResultUUID = project.getProperty("buildResultUUID");
        if (buildResultUUID == null || buildResultUUID.trim().isEmpty()) {
            return contribution;
        }
        IBuildResultHandle buildResultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildResultUUID), null);
        if (LOG_CONTRIBUTION_BATCH_SIZE == null) {
            try {
                LOG_CONTRIBUTION_BATCH_SIZE = Integer.parseInt(project.getProperty("team.enterprise.build.publishoutputs.batchsize"));
                if (LOG_CONTRIBUTION_BATCH_SIZE < 1) {
                    LOG_CONTRIBUTION_BATCH_SIZE = 1;
                }
            }
            catch (Exception e) {
                project.log("Error parsing publish batch size, defaulting to 10: " + e.getMessage(), 4);
                LOG_CONTRIBUTION_BATCH_SIZE = 10;
            }
        }
        Object object2 = logContributionMutex;
        synchronized (object2) {
            if (logContributions.size() >= LOG_CONTRIBUTION_BATCH_SIZE) {
                Executable.publishLogContributions(buildResultHandle, project);
            }
        }
        return contribution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Future<Object> publishLogContributions(final IBuildResultHandle buildResultHandle, final Project project) {
        ArrayList<Future<IBuildResultContribution>> futures;
        Object object = logContributionMutex;
        synchronized (object) {
            futures = new ArrayList<Future<IBuildResultContribution>>(logContributions);
            logContributions.clear();
        }
        final ArrayList<Future<IBuildResultContribution>> finalFutures = futures;
        Future<Object> future = Executable.getExecutor().submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                project.log("Log Contribution Publishing callable attempting to publish " + finalFutures.size() + " contributions", 4);
                IBuildResultContribution[] buildResultContributions = new IBuildResultContribution[finalFutures.size()];
                int i = 0;
                while (i < finalFutures.size()) {
                    buildResultContributions[i] = (IBuildResultContribution)((Future)finalFutures.get(i)).get();
                    ++i;
                }
                if (buildResultContributions.length > 0) {
                    ClientFactory.getTeamBuildClient((ITeamRepository)InitTask.getInstance().getTeamRepository()).addBuildResultContributions(buildResultHandle, buildResultContributions, null);
                }
                return null;
            }
        });
        futureLogsConribsPublish.add(future);
        return future;
    }

    public static String getZipFileLabel(String label, int counter) {
        String s = label;
        if (Pattern.matches("^logs_\\d{3}\\.zip$", s)) {
            int n = Integer.parseInt(label.substring(5, 8));
            s = NLS.bind((String)Messages.ZIP_FILE_LABEL, (Object)String.format("%05d", n * 100), (Object[])new Object[]{String.format("%05d", counter - 1)});
        }
        return s;
    }

    private static void copyStreams(InputStream in, OutputStream out) throws IOException {
        int length;
        byte[] buffer = new byte[8192];
        while ((length = in.read(buffer)) >= 0) {
            out.write(buffer, 0, length);
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFileToZip(File zipfile, File fileToAdd, Project project) throws IOException {
        String zipfileName = zipfile.getName();
        ConcurrentLinkedQueue<File> fileQueue = zipsToAdd.get(zipfileName);
        if (fileQueue == null) {
            Hashtable<String, ConcurrentLinkedQueue<File>> hashtable = zipsToAdd;
            synchronized (hashtable) {
                if (!zipsToAdd.containsKey(zipfileName)) {
                    zipsToAdd.put(zipfileName, new ConcurrentLinkedQueue());
                }
                fileQueue = zipsToAdd.get(zipfileName);
            }
        }
        fileQueue.add(fileToAdd);
        ReentrantLock lock = zipLocks.get(zipfileName);
        if (lock == null) {
            Hashtable<String, ReentrantLock> hashtable = zipLocks;
            synchronized (hashtable) {
                if (!zipLocks.containsKey(zipfileName)) {
                    zipLocks.put(zipfileName, new ReentrantLock());
                }
                lock = zipLocks.get(zipfileName);
            }
        }
        if (!lock.tryLock()) {
            return;
        }
        try {
            File savedFile = null;
            if (zipfile.exists()) {
                FilterOutputStream out = null;
                BufferedInputStream in = null;
                try {
                    String tmpdir = AbstractMacroExec.getLoadDir((Project)project);
                    savedFile = File.createTempFile(zipfileName, ZIP_EXTENSION, new File(tmpdir));
                    in = new BufferedInputStream(new FileInputStream(zipfile), 8192);
                    out = new BufferedOutputStream(new FileOutputStream(savedFile), 8192);
                    Executable.copyStreams(in, out);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
            }
            ZipOutputStream zipout = null;
            FilterOutputStream out = null;
            BufferedInputStream in = null;
            try {
                zipout = new ZipOutputStream(new FileOutputStream(zipfile));
                out = new BufferedOutputStream(zipout, 8192);
                if (zipout != null) {
                    while (!fileQueue.isEmpty()) {
                        File fileFromQueue = (File)fileQueue.remove();
                        try {
                            in = new BufferedInputStream(new FileInputStream(fileFromQueue), 8192);
                            if (in == null) continue;
                            zipout.putNextEntry(new ZipEntry(fileFromQueue.getName()));
                            Executable.copyStreams(in, out);
                            zipout.closeEntry();
                            in.close();
                            in = null;
                        }
                        finally {
                            if (fileFromQueue != null) {
                                project.log("addFileToZip: delete temp file", 4);
                                fileFromQueue.delete();
                            }
                        }
                    }
                    if (savedFile != null) {
                        ZipFile oldzip = new ZipFile(savedFile);
                        Enumeration<? extends ZipEntry> entries = oldzip.entries();
                        while (entries.hasMoreElements()) {
                            ZipEntry entry = entries.nextElement();
                            zipout.putNextEntry(entry);
                            in = new BufferedInputStream(oldzip.getInputStream(entry), 8192);
                            Executable.copyStreams(in, out);
                            zipout.closeEntry();
                            in.close();
                            in = null;
                        }
                        oldzip.close();
                    }
                }
            }
            finally {
                if (savedFile != null) {
                    savedFile.delete();
                }
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    private String convertSYSPRINT2MemberName(String dd) {
        if (!("SYSPRINT".equals(dd) || "SYSCPRT".equals(dd) || "SYSOUT".equals(dd))) {
            return dd;
        }
        String memberName = this.getMemberNameFromDescription();
        if (memberName == null) {
            return dd;
        }
        if ("SYSPRINT".equals(dd)) {
            return memberName;
        }
        return String.valueOf(memberName) + "_" + dd;
    }

    private String convertISPFGateway2MemberName() {
        String memberName = this.getMemberNameFromDescription();
        if (memberName == null) {
            return ISPF_GATEWAY;
        }
        return String.valueOf(memberName) + '_' + ISPF_GATEWAY;
    }

    private String getMemberNameFromDescription() {
        String dsd = this.getDescription();
        if (dsd == null) {
            return null;
        }
        int index = dsd.lastIndexOf("(");
        if (index == -1) {
            return null;
        }
        int index2 = dsd.indexOf(")", index);
        if (index2 == -1) {
            return null;
        }
        return dsd.substring(index + 1, index2);
    }

    public HashMap<String, String> getVariableMap() {
        return this.variableMap;
    }

    private String getReturnCodeVariableName() {
        Set<String> keys = this.variableMap.keySet();
        Iterator<String> iterator = keys.iterator();
        while (iterator != null && iterator.hasNext()) {
            String currentKey = iterator.next();
            if (!currentKey.equals("&RTCReturnCodeForTranslator")) continue;
            return this.variableMap.get(currentKey);
        }
        return null;
    }

    protected static int getMsgLogLevel(Project project) {
        String propertyValue = project.getProperty("team.enterprise.build.ant.msgLogLevel");
        if (propertyValue != null) {
            return Integer.parseInt(propertyValue);
        }
        return 2;
    }

    public boolean isMultiProcess() {
        return this.macroExec instanceof SubProcessMacroExec;
    }

    public void setIspfLogCompact(boolean compact) {
        this.ispfLogCompact = compact;
    }

    public boolean isIspfLogCompact() {
        return this.ispfLogCompact;
    }

    public void setIspfLogConsolidate(int consolidate) {
        this.ispfLogConsolidate = consolidate;
    }

    public int getIspfLogConsolidate() {
        return this.ispfLogConsolidate;
    }

    public void setIspfLogPublishType(int type) {
        this.ispfLogPublishType = type;
    }

    public int getIspfLogPublishType() {
        return this.ispfLogPublishType;
    }

    private String findMatchInSyslib(String dsname, String member) {
        for (AbstractDD alloc : this.allocs) {
            if (!(alloc instanceof Concat) || !SYSLIB.equals(alloc.getDd())) continue;
            Concat syslib = (Concat)alloc;
            List<Alloc> syslibdds = syslib.getAllocs();
            for (Alloc syslibdd : syslibdds) {
                if (syslibdd.getUsageType() == 3) {
                    this.logMsg("Skip " + syslibdd.getDsn() + " because it is an existing dataset type", 4);
                    continue;
                }
                if (syslibdd.getDsn().equals(dsname)) {
                    this.logMsg("Found " + dsname + " itself in the SYSLIB", 4);
                    return dsname;
                }
                boolean found = false;
                try {
                    this.logMsg("Checking " + this.formatDatasetMember(syslibdd.getDsn(), member) + " for existence in the system", 4);
                    found = ZOS.datasetExists((ProjectComponent)this, this.formatDatasetMember(syslibdd.getDsn(), member), true, true);
                }
                catch (ZosException e) {
                    this.logMsg("An exception occurred while checking existence of " + this.formatDatasetMember(syslibdd.getDsn(), member) + " :" + e.getLocalizedMessage(), 4);
                    found = false;
                }
                if (!found) continue;
                this.logMsg("Found: " + member + " in " + syslibdd.getDsn() + " so use that to replace " + this.formatDatasetMember(dsname, member), 4);
                return syslibdd.getDsn();
            }
        }
        return null;
    }

    private String formatDatasetMember(String dsname, String member) {
        if (member == null) {
            return dsname;
        }
        return String.valueOf(dsname) + '(' + member + ')';
    }

    public static void staticMemoryReset() {
        if (futureLogsConribsPublish != null) {
            futureLogsConribsPublish.clear();
        }
        LOG_CONTRIBUTION_BATCH_SIZE = null;
    }

    private static class BasicLogPublisher
    extends LogPublisher {
        private final String label;
        private final String name;

        public BasicLogPublisher(String fileLocation, String label, String contentType, String characterEncoding, String name) {
            super(fileLocation, label, contentType, characterEncoding);
            this.label = label;
            this.name = name;
        }

        public IBuildResultContribution createContribution(ITeamRepository teamRepository, BuildStatus contributionStatus) throws TeamRepositoryException {
            IBuildResultContribution contribution = BuildItemFactory.createBuildResultContribution();
            contribution.setLabel(this.label);
            contribution.setImpactsPrimaryResult(true);
            contribution.setStatus(contributionStatus);
            contribution.setExtendedContributionTypeId(this.getExtendedContributionTypeId());
            this.initializeContribution(contribution, teamRepository);
            if (this.name != null) {
                contribution.setExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_NAME, this.name);
            }
            return contribution;
        }
    }

    public class CallMVSModuleTask
    extends Task {
        private final String pgm;
        private final String options;
        private final String ddnames;
        private final boolean attachx;
        private int rc;

        CallMVSModuleTask(String pgm, String options, String ddnames, boolean attachx) {
            this.pgm = pgm;
            this.options = options;
            this.ddnames = ddnames;
            this.attachx = attachx;
        }

        public void execute() {
            this.rc = new com.ibm.teamz.build.ant.jni.Executable().compile(this.pgm, this.options, this.ddnames, this.attachx);
        }

        public int getRc() {
            return this.rc;
        }
    }
}

