/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.build.ant.tasks;

import com.ibm.team.enterprise.build.ant.IBuildableResource;
import com.ibm.team.enterprise.build.ant.internal.messages.Messages;
import com.ibm.team.enterprise.build.ant.internal.utils.AbstractMacroExec;
import com.ibm.team.enterprise.build.ant.tasks.AbstractCompileTask;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.GatewaySessionMgr;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.InteractiveISPFGatewayDebug;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.MacroExecZOS;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.SubProcessManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.eclipse.osgi.util.NLS;

public class CompileTask
extends AbstractCompileTask {
    private static final int DEFAULT_NB_THREADS = 1;
    private List<Exception> exceptions;
    private int runningThreads;
    private int processCount = 1;

    public void init() {
        InteractiveISPFGatewayDebug.init(this.getProject());
        super.init();
    }

    protected void initialize() {
        this.exceptions = new ArrayList<Exception>();
        this.runningThreads = 0;
        String snbSubProcess = this.getProject().getProperty("team.enterprise.build.dependency.ProcessCount");
        String timeoutSubProcess = this.getProject().getProperty("team.enterprise.build.dependency.ProcessTimeout");
        if (snbSubProcess != null) {
            try {
                int nbSubProcess = Integer.parseInt(snbSubProcess);
                this.setProcessCount(nbSubProcess);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.getProcessCount() > 1) {
            SubProcessManager.getSubProcessManager(this.getProcessCount(), timeoutSubProcess, this.dbg).initTargetListener(this.getProject(), this.getOwningTarget());
        } else {
            GatewaySessionMgr.initTargetListener(this.getProject(), this.getOwningTarget());
        }
    }

    protected AbstractMacroExec getMacroExec(IBuildableResource res) {
        return new MacroExecZOS((Task)this, res, this.preview);
    }

    protected void doCompile(boolean isDependencyBasedBuild, List<IBuildableResource> buildables) {
        if (this.getProcessCount() <= 1) {
            super.doCompile(isDependencyBasedBuild, buildables);
            return;
        }
        SubProcessManager.getSubProcessManager().initialize();
        boolean isFirst = true;
        String languageDefinition = null;
        for (IBuildableResource res : buildables) {
            String buildableResourceName;
            if (isFirst) {
                AbstractMacroExec job = this.getMacroExec(res);
                languageDefinition = job.getLangDefName();
                this.log(NLS.bind((String)Messages.COMPILE_TASK_STARTED, (Object)languageDefinition), 2);
                isFirst = false;
            }
            if ((buildableResourceName = res.getName()) == null) {
                buildableResourceName = Messages.INSTREAM_SOURCE;
            }
            buildableResourceName = this.util.substituteSystemSymbols(buildableResourceName);
            ((Resource)res).setName(buildableResourceName);
            if (!this.preprocess(res)) {
                this.log("Preprocessor determined that the build is not required.", 4);
                continue;
            }
            try {
                SubProcessManager.getSubProcessManager().scheduleSubProcessMacroExec((Task)this, res, this.preview, this.runningThreads);
                ++this.runningThreads;
            }
            catch (IOException e1) {
                this.log(e1.getMessage(), 3);
            }
        }
        while (this.runningThreads > 0) {
            this.log("Check ended subProcess, runningThreads = " + this.runningThreads, 4);
            try {
                this.log("Before SubProcessManager.getSubProcessManager().getCompleted()", 4);
                Future<AbstractMacroExec> f = SubProcessManager.getSubProcessManager().getCompleted();
                if (f == null) {
                    this.log("Timeout when waiting completed subProcess", 4);
                    SubProcessManager.getSubProcessManager().cancelRemaining();
                    throw new BuildException("Timeout when waiting completed subProcess");
                }
                if (f.isCancelled()) continue;
                try {
                    AbstractMacroExec job = f.get();
                    if (job == null) continue;
                    String langDefName = job.getLangDefName();
                    IBuildableResource res = job.getBuildableResource();
                    String buildableResourceName = res.getName();
                    this.log("SubProcess for langdef " + langDefName + " res: " + buildableResourceName + " Ended", 4);
                    this.finalizeMacro();
                    Exception ex = this.handeException(job, isDependencyBasedBuild, isDependencyBasedBuild && !this.shouldFailOnError() && this.exceptions.isEmpty());
                    if (ex == null) continue;
                    this.exceptions.add(ex);
                    if (!isDependencyBasedBuild || !this.shouldFailOnError()) continue;
                    SubProcessManager.getSubProcessManager().cancelRemaining();
                }
                catch (InterruptedException e2) {
                    this.log("Unexpected Interruption of SubProcess", e2, 0);
                    throw new BuildException((Throwable)e2);
                }
                catch (ExecutionException e) {
                    this.log("Failure during Execution of SubProcess", e, 0);
                    throw new BuildException((Throwable)e);
                }
            }
            finally {
                --this.runningThreads;
            }
        }
        if (this.exceptions.size() > 0) {
            this.the_exception = this.exceptions.get(0);
        }
        if (languageDefinition != null) {
            this.writelogSummary(languageDefinition);
        }
    }

    public int getProcessCount() {
        return this.processCount;
    }

    public void setProcessCount(int processCount) {
        this.processCount = processCount;
    }
}

