/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.build.ant.tasks;

import com.ibm.team.enterprise.zos.build.ant.internal.messages.Messages;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class CheckRCTask
extends Task {
    private int maxRC;
    private String translatorName;
    private String rcName;

    public void execute() throws BuildException {
        if (this.rcName == null || this.rcName.isEmpty()) {
            this.log(Messages.RC_VAR_NOT_FOUND, 1);
        } else {
            String rcValue = this.getProject().getProperty(this.rcName);
            if (rcValue == null || rcValue.trim().isEmpty()) {
                this.log(Messages.RC_NOT_SET, 3);
            } else {
                try {
                    int rc = Integer.parseInt(rcValue);
                    if (rc > this.maxRC) {
                        throw new BuildException(NLS.bind((String)Messages.RC_EXCEEDS_MAXRC, (Object[])new Object[]{this.translatorName == null ? "" : this.translatorName, rc, Integer.toString(rc, 16), this.maxRC, Integer.toString(this.maxRC, 16)}));
                    }
                }
                catch (NumberFormatException e) {
                    throw new BuildException((Throwable)e);
                }
            }
        }
    }

    public void setMaxrc(int maxRC) {
        this.maxRC = maxRC;
    }

    public void setTranslatorName(String translatorName) {
        this.translatorName = translatorName;
    }

    public void setRcName(String rcName) {
        this.rcName = rcName == null ? null : rcName.trim();
    }
}

