/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.build.ant.listener;

import com.ibm.jzos.ZFile;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.common.model.ICompileContribution;
import com.ibm.team.build.common.model.ICompilePackage;
import com.ibm.team.build.common.model.ICompileSource;
import com.ibm.team.build.extensions.common.debug.Statistics;
import com.ibm.team.build.extensions.common.debug.StatisticsBlock;
import com.ibm.team.build.extensions.toolkit.ant.AntInstance;
import com.ibm.team.build.internal.publishing.ContentPublisher;
import com.ibm.team.enterprise.build.ant.CompilationProblem;
import com.ibm.team.enterprise.build.ant.CompileContributionUtility;
import com.ibm.team.enterprise.build.ant.FileInfoRecord;
import com.ibm.team.enterprise.build.ant.internal.messages.Messages;
import com.ibm.team.enterprise.build.ant.tasks.InitTask;
import com.ibm.team.enterprise.build.common.buildreport.ReturnCodeResource;
import com.ibm.team.enterprise.build.common.buildreport.ReturnCodeResourceCollection;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.EBCDICFilterInputStream;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.ErrorMessages;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.SubProcessMacroExec;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.SubProcessManager;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.ZOS;
import com.ibm.team.enterprise.zos.build.ant.tasks.Executable;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.SubBuildListener;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.osgi.util.NLS;

public class ZosErrorMessageFileListener
implements SubBuildListener {
    public static final String PERFORMANCE_STATISTICS_TITLE = "[Performance statistics per task type]";
    private static final String COMPILE_RESULT_MSG_ID = "CRHTC1656I";
    public static final String SOURCE_FILE_LOG_PREFIX = "(source file) component=";
    public static final String SOURCE_FILE_LOG_PROJECT = " project=";
    public static final String SOURCE_FILE_LOG_DATASET = " dataset=";
    public static final String RETURN_CODE_LOG_PREFIX = "(return code) rc=";
    public static final String RETURN_CODE_LOG_COMPONENT = " component=";
    public static final String RETURN_CODE_LOG_PROJECT = " project=";
    public static final String RETURN_CODE_LOG_DATASET = " dataset=";
    private static final String COMPILE = "compile";
    private static final String XML_EXTENSION = ".xml";
    private static final String SYSXMLSD = "SYSXMLSD";
    private static final String DD_PREFIX = "//DD:";
    private static final String UTF_8 = "UTF-8";
    private static final String CRHTC1539I = "CRHTC1539I";
    private IBuildResult fBuildResult = null;
    private int highestSev = 0;
    protected String buildResultUUID = null;
    private final char information = (char)73;
    private final char warning = (char)87;
    private final String SEVERITY_INFO = "0";
    private final String SEVERITY_WARNING = "1";
    private final String SEVERITY_ERROR = "2";
    protected Collection<IBuildResultContribution> contributions = Collections.synchronizedList(new LinkedList());
    protected Map<String, ICompileContribution> projects = new Hashtable<String, ICompileContribution>();
    private static final String UNRESOLVED_PLACE_HOLDER = "unresolvedPlaceHolder";
    private String projectName = "";
    private final ThreadLocal<File> compileXML = new ThreadLocal();
    private final String COMPILE_CONTRIBUTION_XML = "compileContribution.xml";
    private final Map<String, Integer> messagesToLog = new LinkedHashMap<String, Integer>();
    private boolean taskStatsEnabled;
    private final Map<String, Long> startTimeMap = new Hashtable<String, Long>();
    private final Map<String, Integer> numberOfCallsMap = new Hashtable<String, Integer>();
    private final Map<String, Long> totalTimeMap = new Hashtable<String, Long>();
    private final ThreadLocal<PdsFileInfo> currentPdsFile = new ThreadLocal();

    static {
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
        BuildItemFactory.initializeBuildPackage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareXMLFileForParsing(File xmlfile1, String dsXMLFileName, InputStream ins, BuildEvent event) {
        String xmlQuestionMarkBeginTag = "<?";
        String xmlHeaderLine1 = "<?xml";
        String buildTag = "<BUILD>";
        String endbuildTag = "</BUILD>";
        String headerLine1 = "<?xml version=\"1.0\" standalone=\"yes\"?>";
        String alternateHeaderLine2 = "DOCTYPE plicomp SYSTEM \"plicomp.dtd\">";
        String alternateHeaderLine3 = "DOCTYPE plicomp SYSTEM 'plicomp.dtd'>";
        String headerLine2 = "<!-- ************************************************************************************ -->";
        String headerLine0 = "<!-- ************************************************************************************ -->";
        boolean wroteHeader = false;
        try {
            boolean eof = false;
            BufferedWriter obuff = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(xmlfile1), UTF_8));
            BufferedReader ibuff = new BufferedReader(new InputStreamReader(ins, com.ibm.teamz.build.ant.jni.Executable.retrieveEncoding()));
            if (xmlfile1.exists()) {
                while (!eof) {
                    boolean skip = false;
                    String line = ibuff.readLine();
                    if (line == null) {
                        eof = true;
                        continue;
                    }
                    if (!wroteHeader) {
                        obuff.write(headerLine1, 0, headerLine1.length());
                        obuff.newLine();
                        obuff.write(headerLine2, 0, headerLine2.length());
                        obuff.newLine();
                        obuff.write(buildTag, 0, buildTag.length());
                        obuff.newLine();
                        wroteHeader = true;
                    }
                    if ((line = line.trim()).equals(buildTag)) {
                        skip = true;
                    }
                    if (line.equals(endbuildTag)) {
                        skip = true;
                    }
                    if (line.equals(headerLine0)) {
                        skip = true;
                    }
                    if (line.startsWith(xmlQuestionMarkBeginTag)) {
                        skip = true;
                    }
                    if (line.startsWith(xmlHeaderLine1)) {
                        skip = true;
                    }
                    if (line.indexOf(alternateHeaderLine2) > -1) {
                        skip = true;
                    }
                    if (line.indexOf(alternateHeaderLine3) > -1) {
                        skip = true;
                    }
                    if (skip) continue;
                    obuff.write(line, 0, line.length());
                    obuff.newLine();
                }
                ibuff.close();
            }
            eof = false;
            if (wroteHeader) {
                obuff.write(endbuildTag, 0, endbuildTag.length());
            }
            obuff.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (wroteHeader) {
            Map<String, Integer> map = this.messagesToLog;
            synchronized (map) {
                this.messagesToLog.put("Processed " + dsXMLFileName, 4);
            }
            return true;
        }
        Map<String, Integer> map = this.messagesToLog;
        synchronized (map) {
            this.messagesToLog.put("Did not process " + dsXMLFileName + " - contents were empty", 4);
        }
        return false;
    }

    public void subBuildFinished(BuildEvent arg0) {
    }

    public void subBuildStarted(BuildEvent arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildFinished(BuildEvent event) {
        block12: {
            Map<String, Integer> map = this.messagesToLog;
            synchronized (map) {
                for (Map.Entry<String, Integer> msg : this.messagesToLog.entrySet()) {
                    event.getProject().log(msg.getKey(), msg.getValue().intValue());
                }
                this.messagesToLog.clear();
            }
            if (this.taskStatsEnabled) {
                event.getProject().log(PERFORMANCE_STATISTICS_TITLE, 3);
                event.getProject().log("================================================================================", 3);
                event.getProject().log("# of Calls   Total Time (ms)      Average (ms)   Task Name", 3);
                event.getProject().log("================================================================================", 3);
                Set<String> taskNamesSet = this.totalTimeMap.keySet();
                Object[] taskNames = new String[taskNamesSet.size()];
                taskNamesSet.toArray(taskNames);
                Arrays.sort(taskNames);
                Object[] objectArray = taskNames;
                int n = taskNames.length;
                int n2 = 0;
                while (n2 < n) {
                    Object taskName = objectArray[n2];
                    long totalTime = this.totalTimeMap.get(taskName);
                    int numberOfCalls = this.numberOfCallsMap.get(taskName);
                    long averageTime = totalTime / (long)numberOfCalls;
                    event.getProject().log(String.format("%10d   %15d   %15d   %s", numberOfCalls, totalTime, averageTime, taskName), 3);
                    ++n2;
                }
                event.getProject().log("================================================================================", 3);
            }
            try {
                if (this.contributions.size() > 0) {
                    CompileContributionUtility.publishBuildResultContributions((IBuildResult)this.getBuildResult(event), (ITeamRepository)InitTask.getInstance().getTeamRepository(), this.contributions);
                    if (Boolean.valueOf(System.getProperty("team.enterprise.build.toolkit.publishSampleFiles")).booleanValue()) {
                        File compileContFile = new File(new File(event.getProject().getProperty("team.enterprise.scm.fetchDestination")), "compileContribution.xml");
                        if (compileContFile.exists()) {
                            compileContFile.delete();
                        }
                        event.getProject().log("Publishing compile contribution data to file " + compileContFile.getAbsolutePath());
                        CompileContributionUtility.publishCompileContributionsXml((File)compileContFile, (IBuildResult)this.getBuildResult(event), (ITeamRepository)InitTask.getInstance().getTeamRepository(), this.contributions);
                    }
                }
            }
            catch (Exception e) {
                event.getProject().log(com.ibm.team.enterprise.zos.build.ant.internal.messages.Messages.FAILED_PUBLISHING_RESULTS, (Throwable)e, 0);
                if (e.getMessage() == null) break block12;
                event.getProject().log(e.getMessage());
            }
        }
        Executable.publishLogZips(event.getProject());
        Executable.getExecutor().shutdown();
        event.getProject().log("Max thread simul count: " + Executable.getExecutor().getLargestPoolSize() + " total thread utilization: " + Executable.getExecutor().getTaskCount(), 4);
        for (StatisticsBlock block : AntInstance.getInstance().getStatisticsBlocks()) {
            Statistics.logCounter((StatisticsBlock)block);
        }
    }

    public void buildStarted(BuildEvent buildEvent) {
        this.taskStatsEnabled = Boolean.valueOf(System.getProperty("team.enterprise.build.toolkit.enableAntTaskStats"));
        AntInstance.getInstance().setProject(buildEvent.getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageLogged(BuildEvent buildEvent) {
        block21: {
            String message = buildEvent.getMessage();
            if (message != null) {
                if (message.contains(SOURCE_FILE_LOG_PREFIX)) {
                    int i = message.indexOf(SOURCE_FILE_LOG_PREFIX);
                    int j = message.indexOf(" dataset=");
                    if (j > i) {
                        this.projectName = message.substring(i + SOURCE_FILE_LOG_PREFIX.length(), j);
                    }
                } else {
                    if (message.contains(COMPILE_RESULT_MSG_ID)) {
                        try {
                            Task task = buildEvent.getTask();
                            SubProcessMacroExec spme = SubProcessManager.getSubProcessMacroExec(task);
                            if (!(spme instanceof SubProcessMacroExec)) {
                                spme = null;
                            }
                            if (ZOS.ddnameExists((ProjectComponent)task, SYSXMLSD, spme)) {
                                EBCDICFilterInputStream ins;
                                this.compileXML.set(File.createTempFile(COMPILE, XML_EXTENSION));
                                if (spme == null) {
                                    ins = new EBCDICFilterInputStream(new ZFile("//DD:SYSXMLSD", "r").getInputStream());
                                } else {
                                    String s;
                                    SubProcessMacroExec tmpSPME = spme;
                                    tmpSPME.send("getDDContents:SYSXMLSD");
                                    String results = "";
                                    while ((s = tmpSPME.readLine()) != null) {
                                        results = String.valueOf(results) + s + "\n";
                                    }
                                    ins = new EBCDICFilterInputStream(new ByteArrayInputStream(results.getBytes()));
                                }
                                if (!this.prepareXMLFileForParsing(this.compileXML.get(), SYSXMLSD, ins, buildEvent)) {
                                    this.compileXML.get().delete();
                                    this.compileXML.set(null);
                                }
                                break block21;
                            }
                            Map<String, Integer> ins = this.messagesToLog;
                            synchronized (ins) {
                                this.messagesToLog.put("SYSXMLSD does not exist", 4);
                                break block21;
                            }
                        }
                        catch (Exception e) {
                            throw new BuildException((Throwable)e);
                        }
                    }
                    if (message.contains(RETURN_CODE_LOG_PREFIX)) {
                        int i = message.indexOf(RETURN_CODE_LOG_PREFIX);
                        int j = message.indexOf(RETURN_CODE_LOG_COMPONENT);
                        int k = message.indexOf(" project=");
                        int l = message.indexOf(" dataset=");
                        if (j > i && k > j && l > k) {
                            String rc = message.substring(i + RETURN_CODE_LOG_PREFIX.length(), j).trim();
                            String rcComponentName = message.substring(j + RETURN_CODE_LOG_COMPONENT.length(), k).trim();
                            String rcProjectName = message.substring(k + " project=".length(), l).trim();
                            String rcDataset = message.substring(l + " dataset=".length()).trim();
                            int bracketIndex = rcDataset.lastIndexOf("(");
                            if (bracketIndex > 0) {
                                String rcBuildPath = rcDataset.substring(0, bracketIndex);
                                String rcBuildFile = rcDataset.substring(bracketIndex + 1, rcDataset.length() - 1);
                                ReturnCodeResource rcResource = new ReturnCodeResource(rcComponentName, this.projectName, rcBuildPath, rcBuildFile, rc);
                                ReturnCodeResourceCollection.getInstance().addResource(rcComponentName, rcProjectName, (Object)rcResource);
                            }
                        }
                    } else if (message.contains(CRHTC1539I)) {
                        String pds = this.parsePDSMemberFromMessage1539I(message);
                        this.currentPdsFile.set(pds == null ? new PdsFileInfo("") : new PdsFileInfo(pds));
                    }
                }
            }
        }
    }

    public void targetFinished(BuildEvent arg0) {
    }

    public void targetStarted(BuildEvent arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskFinished(BuildEvent buildEvent) {
        Task task = buildEvent.getTask();
        Map<String, Integer> map = this.messagesToLog;
        synchronized (map) {
            for (Map.Entry<String, Integer> msg : this.messagesToLog.entrySet()) {
                task.log(msg.getKey(), msg.getValue().intValue());
            }
            this.messagesToLog.clear();
        }
        if (this.taskStatsEnabled) {
            String taskName = task.getTaskName();
            String key = String.valueOf(task.hashCode());
            Long startTimeLong = this.startTimeMap.get(key);
            if (startTimeLong != null) {
                this.startTimeMap.remove(key);
                Long totalTimeLong = this.totalTimeMap.get(taskName);
                long totalTime = totalTimeLong == null ? 0L : totalTimeLong;
                this.totalTimeMap.put(taskName, new Long(totalTime += System.currentTimeMillis() - startTimeLong));
                Integer numberOfCallsInteger = this.numberOfCallsMap.get(taskName);
                int numberOfCalls = numberOfCallsInteger == null ? 0 : numberOfCallsInteger;
                this.numberOfCallsMap.put(taskName, new Integer(++numberOfCalls));
            }
        }
        if (this.compileXML.get() != null) {
            try {
                task.log("Process an error message file for feedback.", 4);
                Project project = task.getProject();
                String buildResultUUID = project.getProperty("buildResultUUID");
                Assert.isNotNull((Object)buildResultUUID);
                this.setBuildResultUUID(buildResultUUID);
                this.processErrorMessageFile(this.compileXML.get(), SYSXMLSD, buildEvent);
            }
            finally {
                this.compileXML.get().delete();
                this.compileXML.set(null);
            }
        }
    }

    public void taskStarted(BuildEvent buildEvent) {
        if (this.taskStatsEnabled) {
            Task task = buildEvent.getTask();
            String key = String.valueOf(task.hashCode());
            this.startTimeMap.put(key, new Long(System.currentTimeMillis()));
        }
    }

    public void processErrorMessageFile(File xmlFile, String dsXMLFileName, BuildEvent event) {
        block5: {
            try {
                this.highestSev = -1;
                this.parseErrorMessagesFile(xmlFile, dsXMLFileName, event);
                this.checkShouldBuildFail(event);
            }
            catch (OperationCanceledException e) {
                if (e.getMessage() != null) {
                    event.getProject().log(e.getMessage());
                }
                event.getProject().log(com.ibm.team.enterprise.zos.build.ant.internal.messages.Messages.COULD_NOT_CONNECT_TO_REPOSITORY, 0);
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                event.getProject().log(String.valueOf(com.ibm.team.enterprise.zos.build.ant.internal.messages.Messages.ERROR_PARSING_EVENT_FILE) + e.getClass().getName(), (Throwable)e, 0);
                if (e.getMessage() == null) break block5;
                event.getProject().log(e.getMessage());
            }
        }
    }

    public void cleanup() {
    }

    private boolean parseErrorMessagesFile(File xmlFile, String dsXMLFileName, BuildEvent event) throws BuildException, TeamRepositoryException, Exception {
        ErrorMessages parsedOutput = new ErrorMessages();
        if (!xmlFile.exists()) {
            return false;
        }
        parsedOutput.read(xmlFile);
        Vector validityResourceVector = parsedOutput.getCmpMsgResourceVector();
        Vector<String> validityMsgFileVector = parsedOutput.getCmpMsgFileVector();
        Vector<String> validityMsgNumberVector = parsedOutput.getCmpMsgNumberVector();
        if (validityResourceVector.size() < 1 || validityMsgFileVector.size() != validityMsgNumberVector.size()) {
            Object[] inserts;
            String errorMsg;
            IBuildResult buildResult = this.getBuildResult(event);
            try {
                String remoteName = String.valueOf(dsXMLFileName) + XML_EXTENSION;
                errorMsg = com.ibm.team.enterprise.zos.build.ant.internal.messages.Messages.INVALID_ERROR_FEEDBACK_FILE;
                inserts = new Object[]{dsXMLFileName, remoteName};
                this.publishFile(xmlFile, buildResult, InitTask.getInstance().getTeamRepository(), remoteName, com.ibm.team.enterprise.zos.build.ant.internal.messages.Messages.ERROR_FEEDBACK_FILE_DESCRIPTION, BuildStatus.ERROR);
            }
            catch (BuildException e) {
                inserts = new Object[]{dsXMLFileName};
                errorMsg = com.ibm.team.enterprise.zos.build.ant.internal.messages.Messages.INVALID_ERROR_FEEDBACK_FILE_UPLOAD_FAILED;
                event.getProject().log(e.getMessage(), (Throwable)e, 0);
            }
            throw new BuildException(NLS.bind((String)errorMsg, (Object[])inserts));
        }
        Vector msgFileNumberVector = parsedOutput.getFileNumberVector();
        if (msgFileNumberVector.size() > 0 && ((String)msgFileNumberVector.elementAt(0)).equalsIgnoreCase("-1")) {
            msgFileNumberVector.remove(0);
        }
        Vector<String> msgFileVector = parsedOutput.getCmpMsgFileVector();
        int i = 0;
        while (i < msgFileVector.size()) {
            if (msgFileVector.elementAt(i).trim().equalsIgnoreCase("")) {
                msgFileVector.remove(i);
            }
            ++i;
        }
        this.addErrorMessagesToCompileContribution(parsedOutput, event);
        return true;
    }

    private void publishFile(File file, IBuildResult buildResult, ITeamRepository teamRepository, final String displayName, String description, BuildStatus status) throws TeamRepositoryException {
        String contributionStatus = status.name();
        ContentPublisher filePublisher = new ContentPublisher(IBuildResultContribution.ARTIFACT_EXTENDED_CONTRIBUTION_ID, file.getAbsolutePath(), description, "text/xml", UTF_8){

            protected void initializeContribution(IBuildResultContribution contribution, ITeamRepository teamRepository) throws TeamRepositoryException {
                super.initializeContribution(contribution, teamRepository);
                contribution.setExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_NAME, displayName);
            }
        };
        IBuildResultContribution contribution = filePublisher.publish((IBuildResultHandle)buildResult, BuildStatus.valueOf((String)contributionStatus), teamRepository);
        if (contribution == null) {
            throw new BuildException(String.valueOf(this.getClass().getSimpleName()) + ".publishFile() failed (contribution == null)");
        }
    }

    public void setBuildResultUUID(String buildResultUUID) {
        this.buildResultUUID = buildResultUUID;
    }

    private IBuildResultHandle getBuildResultHandle(BuildEvent event) throws TeamRepositoryException {
        return (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.buildResultUUID), null);
    }

    private void checkShouldBuildFail(BuildEvent event) throws BuildException {
        boolean failOnError = Boolean.valueOf(event.getProject().getProperty("com.ibm.teamz.build.ant.failOnError"));
        if (failOnError && this.highestSev >= Integer.parseInt("2")) {
            throw new BuildException(com.ibm.team.enterprise.zos.build.ant.internal.messages.Messages.SEVERITY_THRESHOLD_HIT);
        }
    }

    protected IBuildResult getBuildResult(BuildEvent event) throws BuildException {
        try {
            if (this.fBuildResult == null) {
                IBuildResultHandle resultHandle = this.getBuildResultHandle(event);
                this.fBuildResult = (IBuildResult)InitTask.getInstance().getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)resultHandle, 1, CompileContributionUtility.getProgressMonitor());
            }
            return this.fBuildResult;
        }
        catch (ItemNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        catch (TeamRepositoryException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void addErrorMessagesToCompileContribution(ErrorMessages errorMsgs, BuildEvent event) throws TeamRepositoryException {
        Vector<String> messageNumbers = errorMsgs.getCmpMsgNumberVector();
        if (messageNumbers.size() == 0) {
            event.getTask().log(NLS.bind((String)"There are no error messages found for {0} to add to Compilation Results", (Object)this.currentPdsFile.get().pds), 4);
            return;
        }
        IBuildResultHandle buildResultHandle = this.getBuildResultHandle(event);
        FileInfoRecord record = new FileInfoRecord();
        String currentMessageFile = "";
        Vector<String> messageFiles = errorMsgs.getCmpMsgFileVector();
        Vector<Integer> lineNumbers = errorMsgs.getCmpMsgLineVector();
        Vector<String> messageTexts = errorMsgs.getCmpMsgTextVector();
        event.getTask().log(NLS.bind((String)"Found {0} messages when processing {1}", (Object)messageNumbers.size(), (Object)this.currentPdsFile.get().pds), 4);
        int i = 0;
        while (i < messageNumbers.size()) {
            String messageNumber = messageNumbers.get(i);
            String messageFile = messageFiles.get(i);
            if (messageFile == null || messageFile.isEmpty()) {
                event.getTask().log(NLS.bind((String)"Found a message error {0} that is not responding to any file", (Object)messageNumber), 4);
            } else {
                String messageText;
                if (!currentMessageFile.equals(messageFile)) {
                    if (!(currentMessageFile.isEmpty() || record.getWarningCount() <= 0 && record.getErrorCount() <= 0)) {
                        PdsFileInfo pdsFileInfo = new PdsFileInfo(currentMessageFile);
                        this.addErrorSource(pdsFileInfo, record, buildResultHandle, event);
                    }
                    currentMessageFile = messageFile;
                    record = new FileInfoRecord();
                }
                String severity = this.getSeverityFromMessageNumber(messageNumber);
                String messageId = this.getMessageIdFromMessageNumber(messageNumber);
                Integer lineNumber = i < lineNumbers.size() ? lineNumbers.get(i) : 0;
                String string = messageText = i < messageTexts.size() ? this.trimNewLine(messageTexts.get(i)) : "";
                if ("2".equals(severity)) {
                    record.incrementErrorCount();
                    record.addError(lineNumber, severity, messageId, messageText);
                } else {
                    record.incrementWarningCount();
                    record.addWarning(lineNumber, severity, messageId, messageText);
                }
                int severityNumber = Integer.parseInt(severity);
                if (severityNumber > this.highestSev) {
                    this.highestSev = severityNumber;
                }
            }
            ++i;
        }
        if (!(currentMessageFile.isEmpty() || record.getWarningCount() <= 0 && record.getErrorCount() <= 0)) {
            PdsFileInfo pdsFileInfo = new PdsFileInfo(currentMessageFile);
            this.addErrorSource(pdsFileInfo, record, buildResultHandle, event);
        }
    }

    private void addErrorSource(PdsFileInfo pdsFileInfo, FileInfoRecord fileInfoRecord, IBuildResultHandle buildResultHandle, BuildEvent buildEvent) {
        try {
            if (pdsFileInfo.isSequentialFile || !this.currentPdsFile.get().pds.isEmpty() && !this.currentPdsFile.get().isSamePds(pdsFileInfo)) {
                this.addErrorSourceForImmediateFile(pdsFileInfo, fileInfoRecord, buildResultHandle);
            } else {
                this.addErrorSourceForDirectSourceFile(pdsFileInfo, fileInfoRecord, buildResultHandle);
            }
        }
        catch (Exception e) {
            buildEvent.getTask().log("Cannot add error source for " + pdsFileInfo.member, 4);
        }
    }

    private void addErrorSourceForDirectSourceFile(PdsFileInfo pdsFileInfo, FileInfoRecord fileInfoRecord, IBuildResultHandle buildResultHandle) {
        CompilationProblem problem;
        ICompileSource sourceFile = CompileContributionUtility.createSourceFile((String)pdsFileInfo.member, (String)pdsFileInfo.member, (int)fileInfoRecord.getErrorCount(), (int)fileInfoRecord.getWarningCount());
        int i = 0;
        while (i < fileInfoRecord.getErrorCount()) {
            problem = (CompilationProblem)fileInfoRecord.getErrors().get(i);
            CompileContributionUtility.addErrorToSource((ICompileSource)sourceFile, (int)problem.getLineNumber(), (String)problem.getProblemMessage());
            ++i;
        }
        i = 0;
        while (i < fileInfoRecord.getWarningCount()) {
            problem = (CompilationProblem)fileInfoRecord.getWarnings().get(i);
            CompileContributionUtility.addWarningToSource((ICompileSource)sourceFile, (int)problem.getLineNumber(), (String)problem.getProblemMessage());
            ++i;
        }
        ICompileContribution compileContribution = this.projects.get(this.projectName);
        if (compileContribution == null) {
            compileContribution = CompileContributionUtility.createProject((String)this.projectName, (IBuildResultHandle)buildResultHandle, this.contributions);
            this.projects.put(this.projectName, compileContribution);
        }
        ICompilePackage compileProject = (ICompilePackage)compileContribution.getCompilePackages().get(0);
        List packages = compileProject.getSubCompilePackages();
        ICompilePackage compileZFolder = null;
        int i2 = 0;
        while (i2 < packages.size()) {
            ICompilePackage pck = (ICompilePackage)packages.get(i2);
            if (pck.getPackageName().equals(pdsFileInfo.zFolder)) {
                compileZFolder = pck;
                break;
            }
            ++i2;
        }
        if (compileZFolder == null) {
            compileZFolder = CompileContributionUtility.addCompilePackage((ICompilePackage)compileProject, (String)pdsFileInfo.zFolder, (IBuildResultHandle)buildResultHandle);
        }
        List compileSources = compileZFolder.getCompileSources();
        compileSources.add(sourceFile);
        CompileContributionUtility.updateCompilePackageCounts((ICompilePackage)compileZFolder, (int)fileInfoRecord.getErrorCount(), (int)fileInfoRecord.getWarningCount());
        CompileContributionUtility.updateCompilePackageCounts((ICompilePackage)compileProject, (int)fileInfoRecord.getErrorCount(), (int)fileInfoRecord.getWarningCount());
    }

    private void addErrorSourceForImmediateFile(PdsFileInfo pdsFileInfo, FileInfoRecord fileInfoRecord, IBuildResultHandle buildResultHandle) {
        CompilationProblem problem;
        String fileNameLabel = NLS.bind((String)com.ibm.team.enterprise.zos.build.ant.internal.messages.Messages.COMPILE_RESULT_INTERMEDIATE_FILE_LABEL, (Object)this.currentPdsFile.get().member, (Object)pdsFileInfo.member);
        ICompileSource sourceFile = CompileContributionUtility.createSourceFile((String)fileNameLabel, (String)this.currentPdsFile.get().member, (int)fileInfoRecord.getErrorCount(), (int)fileInfoRecord.getWarningCount());
        int i = 0;
        while (i < fileInfoRecord.getErrorCount()) {
            problem = (CompilationProblem)fileInfoRecord.getErrors().get(i);
            CompileContributionUtility.addErrorToSource((ICompileSource)sourceFile, (int)problem.getLineNumber(), (String)problem.getProblemMessage());
            ++i;
        }
        i = 0;
        while (i < fileInfoRecord.getWarningCount()) {
            problem = (CompilationProblem)fileInfoRecord.getWarnings().get(i);
            CompileContributionUtility.addWarningToSource((ICompileSource)sourceFile, (int)problem.getLineNumber(), (String)problem.getProblemMessage());
            ++i;
        }
        ICompileContribution compileContribution = this.projects.get(UNRESOLVED_PLACE_HOLDER);
        if (compileContribution == null) {
            compileContribution = CompileContributionUtility.createPlaceHolderCompilePackage((String)com.ibm.team.enterprise.zos.build.ant.internal.messages.Messages.COMPILE_RESULT_UNRESOLVED_FOLDER, (IBuildResultHandle)buildResultHandle, this.contributions);
            this.projects.put(UNRESOLVED_PLACE_HOLDER, compileContribution);
        }
        ICompilePackage unresolvedHolder = (ICompilePackage)compileContribution.getCompilePackages().get(0);
        unresolvedHolder.getCompileSources().add(sourceFile);
        CompileContributionUtility.updateCompilePackageCounts((ICompilePackage)unresolvedHolder, (int)fileInfoRecord.getErrorCount(), (int)fileInfoRecord.getWarningCount());
    }

    private String parsePDSMemberFromMessage1539I(String message) {
        String[] specials;
        String logMessageString = Messages.PROCESSING_BUILDABLE_FILE;
        MessageFormat messageFormat = new MessageFormat(logMessageString);
        int numPatterns = messageFormat.getFormats().length;
        Object[] strings = new String[numPatterns];
        int i = 0;
        while (i < numPatterns) {
            strings[i] = "*";
            ++i;
        }
        String regex = MessageFormat.format(messageFormat.toPattern(), strings);
        String[] stringArray = specials = new String[]{"\\", ".", "(", ")", "^", "$", "+", "{", "}", "[", "]"};
        int n = specials.length;
        int n2 = 0;
        while (n2 < n) {
            String special = stringArray[n2];
            if (regex.contains(special)) {
                regex = regex.replace(special, "\\" + special);
            }
            ++n2;
        }
        regex = regex.replace("*", ".+");
        Pattern pattern = Pattern.compile(regex = regex.replace(" ", "\\s"));
        Matcher match = pattern.matcher(message);
        if (match.find()) {
            message = match.group();
        }
        try {
            Object[] uniqueStrings = messageFormat.parse(message);
            return (String)uniqueStrings[0];
        }
        catch (ParseException e) {
            return null;
        }
    }

    private String getSeverityFromMessageNumber(String messageNumber) {
        String message = messageNumber.trim();
        int severityIndicator = 32;
        if (message.length() > 1) {
            severityIndicator = message.charAt(message.length() - 1);
        }
        switch (severityIndicator) {
            case 73: {
                return "0";
            }
            case 87: {
                return "1";
            }
        }
        return "2";
    }

    private String getMessageIdFromMessageNumber(String messageNumber) {
        String messageId = messageNumber;
        if (messageNumber.length() > 1) {
            messageId = messageNumber.substring(0, messageNumber.length() - 1);
        }
        if (messageId.endsWith("-")) {
            messageId = messageId.substring(0, messageId.length() - 1);
        }
        return messageId;
    }

    private String trimNewLine(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        return message.replaceAll("(\r\n|\r|\n|\n\r)", " ");
    }

    class PdsFileInfo {
        protected String pds = "";
        protected String zFolder = "";
        protected String member = "";
        protected boolean isSequentialFile;

        protected PdsFileInfo(String pds) {
            Assert.isNotNull((Object)pds);
            this.pds = pds.trim();
            this.separateFolderAndMember(this.pds);
        }

        protected boolean isSamePds(PdsFileInfo pdsFileInfo) {
            return pdsFileInfo != null && this.pds.equalsIgnoreCase(pdsFileInfo.pds);
        }

        private void separateFolderAndMember(String pdsMember) {
            this.zFolder = "";
            this.member = "";
            int openBracketIndex = pdsMember.indexOf("(");
            int closedBracketIndex = pdsMember.indexOf(")", openBracketIndex);
            boolean bl = this.isSequentialFile = openBracketIndex == -1 || closedBracketIndex == -1;
            if (this.isSequentialFile) {
                this.member = pdsMember;
            } else {
                int lastDotIndex = pdsMember.lastIndexOf(".", openBracketIndex);
                if (lastDotIndex > -1) {
                    this.zFolder = pdsMember.substring(lastDotIndex + 1, openBracketIndex);
                    this.member = pdsMember.substring(openBracketIndex + 1, closedBracketIndex);
                }
            }
        }
    }
}

