/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.build.ant.internal.utils;

import com.ibm.jzos.FileFactory;
import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZUtil;
import com.ibm.team.build.common.IStaticReset;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.enterprise.build.ant.tasks.InitTask;
import com.ibm.team.enterprise.zos.build.ant.internal.messages.Messages;
import com.ibm.team.enterprise.zos.build.ant.internal.tasks.DatasetExistsTask;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.SubProcessMacroExec;
import com.ibm.teamz.build.ant.jni.SystemServices;
import com.ibm.teamz.build.ant.zos.exceptions.ZosException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class ZOS
implements IStaticReset {
    private static final String cls = ZOS.class.getSimpleName();
    private static final int BUFFER_SIZE = 4096;
    private static final byte EBCDIC_SPACE = 64;
    public static final int X_57080000 = 1460142080;
    public static final int X_04380000 = 70778880;
    public static final int X_17080002 = 386400258;
    public static final int X_02100000 = 0x2100000;
    private static final String SPACE = " ";
    private static final String READ_ONLY = "r";
    private static final String TWO_AMPERSANDS = "&&";
    private static final String TWO_SLASHES = "//";
    private static final String APOSTROPHE = "'";
    private static final String COLON_WITH_SPACES = " : ";
    private static final String FREE = "free";
    private static final boolean LOG_ENABLED = true;
    private static final String OS_NAME = "os.name";
    private static final String Z_OS = "z/OS";
    private static final boolean IS_Z_OS = "z/OS".equals(System.getProperty("os.name"));
    private static final String ENCODING_ENVIRONMENT_VARIABLE = "ZLANG";
    private static String _zLang = null;
    protected static Set<String> knownToExist = new HashSet<String>();
    protected static Set<String> knownToNotExist = new HashSet<String>();
    protected static Set<String> knownPDSToBeSequentialorNonExistent = new HashSet<String>();
    protected static Set<String> knownPDSToBeValid = new HashSet<String>();
    protected static ReentrantReadWriteLock knownToExistLock = new ReentrantReadWriteLock();
    protected static ReentrantReadWriteLock knownToBeSequentialLock = new ReentrantReadWriteLock();

    public static void bpxwdyn(ProjectComponent projectComponent, String cmd) throws RcException {
        if (!IS_Z_OS) {
            return;
        }
        String command = cmd;
        String options = projectComponent.getProject().getProperty("team.enterprise.build.ant.bpxwdyn.options");
        if (options != null) {
            command = String.valueOf(command) + SPACE + options;
        }
        ZOS.log(projectComponent, NLS.bind((String)Messages.ZOS_BPXWDYN, (Object)command), 3);
        try {
            ZFile.bpxwdyn((String)command);
        }
        catch (RcException e) {
            int rc = e.getRc();
            int lvl = 0;
            switch (rc) {
                case 0: 
                case 0x2100000: 
                case 386400258: 
                case 1460142080: {
                    break;
                }
                case 70778880: {
                    if (command.toLowerCase(Locale.US).trim().startsWith(FREE)) {
                        lvl = 4;
                    }
                }
                default: {
                    ZOS.log(projectComponent, NLS.bind((String)Messages.ERROR_IN_BPXWDYN, (Object)command, (Object)rc), lvl);
                    ZOS.logException(projectComponent, Messages.ZOS_RCEXCEPTION_THROWN, e);
                }
            }
            switch (rc) {
                case 0: 
                case 56: {
                    break;
                }
                case 70778880: {
                    if (command.toLowerCase(Locale.US).trim().startsWith(FREE)) break;
                }
                default: {
                    throw e;
                }
            }
        }
    }

    public static void bpxwdyn(ProjectComponent projectComponent, String cmd, SubProcessMacroExec spme) throws RcException {
        if (!IS_Z_OS) {
            return;
        }
        if (spme == null) {
            ZOS.bpxwdyn(projectComponent, cmd);
            return;
        }
        String command = cmd;
        String options = projectComponent.getProject().getProperty("team.enterprise.build.ant.bpxwdyn.options");
        if (options != null) {
            command = String.valueOf(command) + SPACE + options;
        }
        ZOS.log(projectComponent, NLS.bind((String)Messages.ZOS_BPXWDYN, (Object)command), 3);
        try {
            String ret = spme.sendReceive(command);
            try {
                int rc = Integer.parseInt(ret);
                int lvl = 0;
                switch (rc) {
                    case 0: 
                    case 0x2100000: 
                    case 386400258: 
                    case 1460142080: {
                        break;
                    }
                    case 70778880: {
                        if (command.toLowerCase(Locale.US).trim().startsWith(FREE)) {
                            lvl = 4;
                        }
                    }
                    default: {
                        ZOS.log(projectComponent, NLS.bind((String)Messages.ERROR_IN_BPXWDYN, (Object)command, (Object)rc), lvl);
                    }
                }
                switch (rc) {
                    case 0: 
                    case 56: {
                        break;
                    }
                    case 70778880: {
                        if (command.toLowerCase(Locale.US).trim().startsWith(FREE)) break;
                    }
                    default: {
                        throw new RcException("", rc);
                    }
                }
            }
            catch (NumberFormatException e) {
                ZOS.log(projectComponent, NLS.bind((String)Messages.ERROR_IN_BPXWDYN, (Object)command, (Object)ret), 0);
            }
        }
        catch (IOException e) {
            ZOS.log(projectComponent, "BPXWDYN IOException " + e.getMessage(), 0);
        }
    }

    public static void free(Task task, String dd, SubProcessMacroExec spme) throws ZFileException, RcException {
        ZOS.bpxwdyn((ProjectComponent)task, String.format("free dd(%s)", dd), spme);
    }

    private static boolean ddExists(ProjectComponent projectComponent, String dd) throws ZFileException {
        if (!IS_Z_OS) {
            return false;
        }
        boolean b = ZFile.ddExists((String)dd);
        ZOS.log(projectComponent, NLS.bind((String)Messages.ZOS_DD_EXISTS, (Object)dd, (Object)b), 4);
        return b;
    }

    private static boolean ddExists(ProjectComponent projectComponent, String dd, SubProcessMacroExec spme) throws ZFileException {
        if (!IS_Z_OS) {
            return false;
        }
        if (spme == null) {
            return ZOS.ddExists(projectComponent, dd);
        }
        boolean b = false;
        try {
            String ret = spme.sendReceive("ddExists:" + dd);
            if (ret == null) {
                ZOS.log(projectComponent, "ERROR on ddExists " + dd, 4);
                b = false;
            } else {
                b = ret.equalsIgnoreCase("true");
            }
        }
        catch (IOException e) {
            b = false;
        }
        ZOS.log(projectComponent, NLS.bind((String)Messages.ZOS_DD_EXISTS, (Object)dd, (Object)b), 4);
        return b;
    }

    static String buildSingleQuotedDsName(String dsname) {
        return dsname == null || dsname.startsWith(TWO_AMPERSANDS) ? dsname : APOSTROPHE + dsname + APOSTROPHE;
    }

    public static boolean datasetExists(ProjectComponent projectComponent, String dsname) throws ZosException {
        return ZOS.datasetExists(projectComponent, dsname, false);
    }

    public static boolean datasetExists(ProjectComponent projectComponent, String dsname, boolean useCache) throws ZosException {
        return ZOS.datasetExists(projectComponent, dsname, false, false);
    }

    public static boolean datasetExists(ProjectComponent projectComponent, String dsname, boolean useCache, boolean useNonExistCache) throws ZosException {
        boolean result;
        if (!IS_Z_OS) {
            return false;
        }
        if (useCache) {
            knownToExistLock.readLock().lock();
            try {
                if (knownToExist.contains(dsname)) {
                    return true;
                }
                if (useNonExistCache && knownToNotExist.contains(dsname)) {
                    return false;
                }
            }
            finally {
                knownToExistLock.readLock().unlock();
            }
        }
        if (InitTask.getInstance() != null && InitTask.getInstance().isPerformanceAnalysisEnabled()) {
            DatasetExistsTask task = new DatasetExistsTask(projectComponent, dsname);
            if (projectComponent instanceof Task) {
                task.bindToOwner((Task)projectComponent);
            }
            task.setTaskName("(internal) datasetexiststask");
            task.perform();
            result = task.exists();
        } else {
            result = ZOS.datasetExists2(projectComponent, dsname);
        }
        if (useCache && (result || useNonExistCache)) {
            knownToExistLock.writeLock().lock();
            if (result) {
                knownToExist.add(dsname);
            } else if (useNonExistCache) {
                knownToNotExist.add(dsname);
            }
            knownToExistLock.writeLock().unlock();
        }
        return result;
    }

    public static boolean datasetExists2(ProjectComponent projectComponent, String dsname) throws ZosException {
        boolean isExist = false;
        String singleQuotedDsName = ZOS.buildSingleQuotedDsName(dsname);
        try {
            ZFile f = null;
            try {
                try {
                    f = new ZFile(TWO_SLASHES + singleQuotedDsName, READ_ONLY);
                    isExist = true;
                }
                catch (ZFileException e1) {
                    ZOS.log(projectComponent, e1.getMessage(), 4);
                    ZOS.log(projectComponent, NLS.bind((String)Messages.ZOS_DS_EXISTS, (Object)singleQuotedDsName, (Object)isExist), 4);
                    if (f != null) {
                        f.close();
                    }
                }
            }
            finally {
                ZOS.log(projectComponent, NLS.bind((String)Messages.ZOS_DS_EXISTS, (Object)singleQuotedDsName, (Object)isExist), 4);
                if (f != null) {
                    f.close();
                }
            }
        }
        catch (ZFileException e) {
            ZOS.logException(projectComponent, Messages.ZOS_ZFILE_EXCEPTION_THROWN, e);
            throw new ZosException((Throwable)e);
        }
        return isExist;
    }

    public static boolean isPDSValid(ProjectComponent projectComponent, String dsname) throws ZosException {
        if (!IS_Z_OS) {
            return false;
        }
        knownToBeSequentialLock.readLock().lock();
        try {
            if (knownPDSToBeValid.contains(dsname)) {
                return true;
            }
            if (knownPDSToBeSequentialorNonExistent.contains(dsname)) {
                return false;
            }
        }
        finally {
            knownToBeSequentialLock.readLock().unlock();
        }
        boolean result = ZOS.isPDSValid2(projectComponent, dsname);
        knownToBeSequentialLock.writeLock().lock();
        if (result) {
            knownPDSToBeValid.add(dsname);
        } else {
            knownPDSToBeSequentialorNonExistent.add(dsname);
        }
        knownToBeSequentialLock.writeLock().unlock();
        return result;
    }

    public static boolean isPDSValid2(ProjectComponent projectComponent, String dsname) throws ZosException {
        boolean isValid = false;
        String singleQuotedDsName = ZOS.buildSingleQuotedDsName(dsname);
        try {
            ZFile f = null;
            try {
                try {
                    f = new ZFile(TWO_SLASHES + singleQuotedDsName, READ_ONLY);
                    isValid = true;
                    if (f.getDsorg() == 8) {
                        ZOS.log(projectComponent, NLS.bind((String)Messages.ZOS_PDS_SEQUENTIAL, (Object)singleQuotedDsName), 4);
                        isValid = false;
                    }
                }
                catch (ZFileException e1) {
                    ZOS.log(projectComponent, e1.getMessage(), 4);
                    ZOS.log(projectComponent, NLS.bind((String)Messages.ZOS_PDS_VALID, (Object)singleQuotedDsName, (Object)isValid), 4);
                    if (f != null) {
                        f.close();
                    }
                }
            }
            finally {
                ZOS.log(projectComponent, NLS.bind((String)Messages.ZOS_PDS_VALID, (Object)singleQuotedDsName, (Object)isValid), 4);
                if (f != null) {
                    f.close();
                }
            }
        }
        catch (ZFileException e) {
            ZOS.logException(projectComponent, Messages.ZOS_ZFILE_EXCEPTION_THROWN, e);
            throw new ZosException((Throwable)e);
        }
        return isValid;
    }

    public static boolean ddnameExists(ProjectComponent projectComponent, String ddname, SubProcessMacroExec spme) throws ZosException {
        try {
            return ZOS.ddExists(projectComponent, ddname, spme);
        }
        catch (ZFileException e) {
            ZOS.logException(projectComponent, Messages.ZOS_ZFILE_EXCEPTION_THROWN, e);
            throw new ZosException((Throwable)e);
        }
    }

    public static boolean ddnameExists(ProjectComponent projectComponent, String ddname) throws ZosException {
        try {
            return ZOS.ddExists(projectComponent, ddname);
        }
        catch (ZFileException e) {
            ZOS.logException(projectComponent, Messages.ZOS_ZFILE_EXCEPTION_THROWN, e);
            throw new ZosException((Throwable)e);
        }
    }

    public static List<String> getDDNames(ProjectComponent projectComponent, SubProcessMacroExec spme) {
        String ddList;
        if (spme == null) {
            SystemServices systemServices = new SystemServices();
            return Arrays.asList(systemServices.getDDNames());
        }
        ZOS.log(projectComponent, "getDDNames:", 4);
        ArrayList<String> strings = new ArrayList<String>();
        try {
            ddList = spme.sendReceive("getDDNames:");
            ZOS.log(projectComponent, "getDDNames:" + ddList, 0);
        }
        catch (IOException e) {
            SystemServices systemServices = new SystemServices();
            return Arrays.asList(systemServices.getDDNames());
        }
        StringTokenizer tokenizer = new StringTokenizer(ddList, "/");
        while (tokenizer.hasMoreTokens()) {
            strings.add(tokenizer.nextToken());
        }
        return strings;
    }

    public static boolean locateDD(ProjectComponent projectComponent, String ddname, SubProcessMacroExec spme) {
        if (spme == null) {
            SystemServices systemServices = new SystemServices();
            return systemServices.locateDD(ddname);
        }
        String cmd = "locateDD:";
        ZOS.log(projectComponent, Debug.enter((String[])new String[]{cls, cmd}), 4);
        boolean result = false;
        try {
            result = Boolean.parseBoolean(spme.sendReceive(String.valueOf(cmd) + ddname));
        }
        catch (IOException e) {
            ZOS.logException(projectComponent, Messages.ZOS_ZFILE_EXCEPTION_THROWN, e);
        }
        ZOS.log(projectComponent, Debug.leave((String[])new String[]{cls, cmd, Boolean.toString(result)}), 4);
        return result;
    }

    public static OutputStream getOutputStream(String dsname) throws IOException {
        return FileFactory.newBufferedOutputStream((String)(TWO_SLASHES + ZOS.buildSingleQuotedDsName(dsname)));
    }

    public static void removeDataset(ProjectComponent projectComponent, String dsname) throws ZosException {
        try {
            ZFile.remove((String)(TWO_SLASHES + ZOS.buildSingleQuotedDsName(dsname)));
        }
        catch (ZFileException e) {
            ZOS.logException(projectComponent, Messages.ZOS_ZFILE_EXCEPTION_THROWN, e);
            throw new ZosException((Throwable)e);
        }
    }

    public static void removeDataset(ProjectComponent projectComponent, String dsname, SubProcessMacroExec spme) throws ZosException {
        try {
            String ret = spme.sendReceive("remove:" + dsname);
            if (!ret.equals("0")) {
                ZOS.log(projectComponent, String.valueOf(Messages.ZOS_ZFILE_EXCEPTION_THROWN) + ret, 3);
                throw new ZosException(ret);
            }
        }
        catch (IOException e) {
            ZOS.logException(projectComponent, Messages.ZOS_ZFILE_EXCEPTION_THROWN, e);
            throw new ZosException((Throwable)e);
        }
    }

    public static ZFile saveLines(Task task, String dsname, List<String> lines) throws Exception {
        String output = TWO_SLASHES + ZOS.buildSingleQuotedDsName(dsname);
        ZFile zFileOut = new ZFile(output, "wb,type=record,recfm=fb,lrecl=80,noseek");
        int lrecl = zFileOut.getLrecl();
        byte[] recBuf = new byte[lrecl];
        for (String line : lines) {
            byte[] b = line.getBytes(ZUtil.getDefaultPlatformEncoding());
            int len = b.length > lrecl ? lrecl : b.length;
            System.arraycopy(b, 0, recBuf, 0, len);
            int i = len;
            while (i < lrecl) {
                recBuf[i] = 64;
                ++i;
            }
            zFileOut.write(recBuf, 0, lrecl);
        }
        zFileOut.flush();
        if (!dsname.startsWith(TWO_AMPERSANDS)) {
            zFileOut.close();
        }
        return zFileOut;
    }

    public static void close(ZFile file) throws ZFileException {
        file.close();
    }

    public static void log(ProjectComponent projectComponent, String s, int msgLevel) {
        if (projectComponent != null) {
            projectComponent.log(s, msgLevel);
        } else {
            System.out.println(s);
        }
    }

    private static void logException(ProjectComponent projectComponent, String s, Throwable t) {
        if (projectComponent != null && projectComponent instanceof Task) {
            ((Task)projectComponent).log(s, t, 0);
        } else {
            System.out.println(String.valueOf(s) + COLON_WITH_SPACES + t);
        }
    }

    public static String fileToString(File file, String fileEncoding) throws IOException, IllegalArgumentException {
        StringBuffer fileContents = new StringBuffer();
        try (FileInputStream inputStream = null;){
            inputStream = new FileInputStream(file);
            byte[] buffer = new byte[4096];
            int bytesRead = inputStream.read(buffer);
            while (bytesRead != -1) {
                fileContents.append(new String(buffer, 0, bytesRead, fileEncoding));
                bytesRead = inputStream.read(buffer);
            }
        }
        return fileContents.toString();
    }

    public static long getRecordCount(ProjectComponent projectComponent, String dsname) throws ZosException {
        long count = 0L;
        ZFile f = null;
        try {
            try {
                f = new ZFile(TWO_SLASHES + ZOS.buildSingleQuotedDsName(dsname), "rb,type=record");
                f.seek(0L, 2);
                count = f.tell();
            }
            finally {
                if (f != null) {
                    f.close();
                }
            }
        }
        catch (ZFileException e) {
            ZOS.logException(projectComponent, Messages.ZOS_ZFILE_EXCEPTION_THROWN, e);
            throw new ZosException((Throwable)e);
        }
        return count;
    }

    public static boolean isZOS() {
        return IS_Z_OS;
    }

    public static void staticMemoryReset() {
        knownToExist = new HashSet<String>();
        knownToNotExist = new HashSet<String>();
        knownPDSToBeSequentialorNonExistent = new HashSet<String>();
        knownPDSToBeValid = new HashSet<String>();
        knownToExistLock = new ReentrantReadWriteLock();
        knownToBeSequentialLock = new ReentrantReadWriteLock();
        _zLang = null;
    }

    public static String convertMemberName(ProjectComponent projectComponent, String memberName) {
        String zLang = ZOS.getZLang();
        ZOS.log(projectComponent, "convertMemberName for " + memberName + " zLang = " + zLang, 4);
        if (zLang != null && zLang.length() > 0 && (zLang.contains("1142") || zLang.contains("277"))) {
            String correctedMemberName = memberName.replace('\u00d8', '@');
            correctedMemberName = correctedMemberName.replace('\u00c6', '#');
            correctedMemberName = correctedMemberName.replace('\u00c5', '$');
            ZOS.log(projectComponent, "converted Member Name is " + correctedMemberName, 4);
            return correctedMemberName;
        }
        return memberName;
    }

    private static String getZLang() {
        if (_zLang == null) {
            _zLang = System.getenv(ENCODING_ENVIRONMENT_VARIABLE);
        }
        return _zLang;
    }
}

