/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.build.ant.internal.utils;

import com.ibm.team.build.common.IStaticReset;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.enterprise.build.ant.IBuildableResource;
import com.ibm.team.enterprise.build.ant.internal.utils.AbstractMacroExec;
import com.ibm.team.enterprise.zos.build.ant.internal.messages.Messages;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.GatewaySessionMgr;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.SubProcess;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.SubProcessBuildListener;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.SubProcessMacroExec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class SubProcessManager
implements IStaticReset {
    private final IDebugger dbg;
    private final String cls;
    private static AtomicInteger globalFailCount = new AtomicInteger(0);
    private static SubProcessManager subProcessManager;
    private static final int NO_TIMEOUT = 0;
    private final ExecutorService executor;
    private final CompletionService<AbstractMacroExec> completionService;
    private final List<Future<AbstractMacroExec>> futures;
    private final List<SubProcessMacroExec> subProcessMacroExecs;
    private final List<SubProcess> subProcessPool;
    private final ReentrantReadWriteLock poolLock = new ReentrantReadWriteLock();
    private final int maxFailureSize;
    private int subProcessTimeout;
    private long count;

    public static SubProcessManager getSubProcessManager(int nb, String timeout, IDebugger dbg) {
        if (subProcessManager == null) {
            subProcessManager = new SubProcessManager(nb, timeout, dbg);
        }
        return subProcessManager;
    }

    public static SubProcessManager getSubProcessManager() {
        return subProcessManager;
    }

    public static SubProcessMacroExec getSubProcessMacroExec(Task task) {
        if (task == null) {
            return null;
        }
        String decription = task.getDescription();
        if (decription == null) {
            return null;
        }
        Object spme = task.getProject().getReference(decription.toUpperCase());
        if (spme instanceof SubProcessMacroExec) {
            return (SubProcessMacroExec)((Object)spme);
        }
        return null;
    }

    public void initTargetListener(Project project, Target target) {
        project.addBuildListener((BuildListener)new SubProcessBuildListener(this, target));
    }

    private SubProcessManager(int nb, String timeout, IDebugger dbg) {
        this.dbg = dbg;
        this.cls = this.getClass().getSimpleName();
        this.executor = Executors.newFixedThreadPool(nb);
        this.completionService = new ExecutorCompletionService<AbstractMacroExec>(this.executor);
        this.futures = new ArrayList<Future<AbstractMacroExec>>();
        this.subProcessMacroExecs = new ArrayList<SubProcessMacroExec>();
        this.subProcessPool = new ArrayList<SubProcess>();
        this.count = 0L;
        this.maxFailureSize = nb;
        if (timeout == null) {
            this.subProcessTimeout = 0;
        } else {
            try {
                int i;
                this.subProcessTimeout = i = Integer.parseInt(timeout);
            }
            catch (NumberFormatException e) {
                this.subProcessTimeout = 0;
            }
        }
    }

    public void stop(Project project) {
        this.poolLock.writeLock().lock();
        GatewaySessionMgr.stop(project, this.subProcessPool);
        for (SubProcess subProcess : this.subProcessPool) {
            if (subProcess == null) continue;
            subProcess.stop();
        }
        this.subProcessPool.clear();
        this.poolLock.writeLock().unlock();
    }

    SubProcess getSubProcess(Task parentTask, int runningThread) throws IOException {
        this.poolLock.readLock().lock();
        try {
            for (SubProcess subProcess : this.subProcessPool) {
                if (subProcess.claim()) {
                    parentTask.log("SUBPROCESS getSubProcess : Reuse (" + subProcess.getName() + ")", 4);
                    SubProcess subProcess2 = subProcess;
                    return subProcess2;
                }
                parentTask.log("SUBPROCESS getSubProcess :(" + subProcess.getName() + ") Status :" + (Object)((Object)subProcess.getStatus()), 4);
            }
        }
        finally {
            this.poolLock.readLock().unlock();
        }
        this.poolLock.writeLock().lock();
        try {
            ++this.count;
            parentTask.log("SUBPROCESS getSubProcess : create a new subProcess" + this.count, 4);
            SubProcess newOne = new SubProcess(parentTask.getProject(), Long.toString(this.count), this.dbg);
            this.subProcessPool.add(newOne);
            SubProcess subProcess = newOne;
            return subProcess;
        }
        finally {
            this.poolLock.writeLock().unlock();
        }
    }

    public void checkSubProcessErrorCount(Task parentTask, String name, Exception e) throws BuildException {
        int failCount = globalFailCount.incrementAndGet();
        if (e != null) {
            parentTask.log("Exception starting subprocess for:" + name + " failCount=" + failCount, 3);
        } else {
            parentTask.log("Failure starting subprocess for:" + name + " failCount=" + failCount, 3);
        }
        if (failCount > this.maxFailureSize) {
            if (e != null) {
                throw new BuildException(NLS.bind((String)Messages.SUBPROCESS_STARTUP_FAILED, (Object)name), (Throwable)e);
            }
            throw new BuildException(NLS.bind((String)Messages.SUBPROCESS_STARTUP_FAILED, (Object)name));
        }
    }

    public AbstractMacroExec scheduleSubProcessMacroExec(Task parentTask, IBuildableResource res, boolean preview, int runningThreads) throws IOException {
        parentTask.log("SUBPROCESS getSubProcessMacroExec for:" + res.getName(), 4);
        SubProcessMacroExec newJob = new SubProcessMacroExec(this, parentTask, res, preview, runningThreads);
        this.subProcessMacroExecs.add(newJob);
        this.futures.add(this.completionService.submit((Callable<AbstractMacroExec>)((Object)newJob)));
        parentTask.log("SUBPROCESS getSubProcessMacroExec for:" + res.getName() + " submitted", 4);
        return newJob;
    }

    public int cancelRemaining() {
        int i = 0;
        for (Future<AbstractMacroExec> f : this.futures) {
            if (!f.cancel(false)) continue;
            ++i;
        }
        return i;
    }

    public Future<AbstractMacroExec> getCompleted() throws InterruptedException {
        if (this.subProcessTimeout == 0) {
            return this.completionService.take();
        }
        return this.completionService.poll(this.subProcessTimeout, TimeUnit.MINUTES);
    }

    public void initialize() {
        for (SubProcessMacroExec subProcessMacroExec : this.subProcessMacroExecs) {
            subProcessMacroExec.setRunningThread(0);
        }
    }

    public static void staticMemoryReset() {
        subProcessManager = null;
    }
}

