/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.build.ant.internal.utils;

import com.ibm.team.enterprise.build.ant.IBuildableResource;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.MacroExecZOS;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.SubProcess;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.SubProcessManager;
import java.io.IOException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.property.LocalProperties;

public class SubProcessMacroExec
extends MacroExecZOS {
    public static final String PREFIX_CMD = "prefix:SPME:";
    private final SubProcessManager subProcessManager;
    private SubProcess subProcess;
    private int runningThread;

    public SubProcessMacroExec(SubProcessManager manager, Task parentTask, IBuildableResource buildableResource, boolean preview, int runningThread) {
        super(parentTask, buildableResource, preview);
        this.runningThread = runningThread;
        this.subProcessManager = manager;
    }

    @Override
    public SubProcessMacroExec call() {
        this.parentTask.log("SubProcessMacroExec call()  for:" + this.buildableResource.getName(), 4);
        LocalProperties.get((Project)this.parentTask.getProject()).copy();
        SubProcess sp = null;
        while (true) {
            try {
                String echo;
                while ((sp = this.subProcessManager.getSubProcess(this.parentTask, this.runningThread)).sendReceive(PREFIX_CMD) == null || !(echo = "resource:" + this.buildableResource.getName()).equals(sp.sendReceive(echo))) {
                    this.subProcessManager.checkSubProcessErrorCount(this.parentTask, this.buildableResource.getName(), null);
                }
            }
            catch (IOException e) {
                this.subProcessManager.checkSubProcessErrorCount(this.parentTask, this.buildableResource.getName(), e);
                continue;
            }
            break;
        }
        this.setSubProcess(sp);
        super.call();
        this.parentTask.log("SubProcessMacroExec end of call()  for:" + this.buildableResource.getName(), 4);
        sp.setReady();
        return this;
    }

    public void destroy() {
        this.getSubProcess().setReady();
    }

    public SubProcess getSubProcess() {
        return this.subProcess;
    }

    public String sendReceive(String s) throws IOException {
        return this.subProcess.sendReceive(s);
    }

    public void send(String s) throws IOException {
        this.subProcess.send(s);
    }

    public String readLine() throws IOException {
        return this.subProcess.readLine();
    }

    public void setSubProcess(SubProcess subProcess) {
        this.subProcess = subProcess;
    }

    public boolean isFirstOne() {
        return this.runningThread == 0;
    }

    public int getRunningThread() {
        return this.runningThread;
    }

    public void setRunningThread(int runningThread) {
        this.runningThread = runningThread;
    }
}

