/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.build.ant.internal.utils;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.DebugGroup;
import com.ibm.team.build.extensions.common.debug.DebugMessage;
import com.ibm.team.build.extensions.common.debug.DebugUtility;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.build.extensions.common.debug.StatisticsBlock;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.zos.build.ant.internal.messages.Messages;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.GatewaySessionMgr;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.InteractiveISPFGateway;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.tools.ant.Project;

@DebugUtility
@DebugGroup(value={"gateway"})
public class SubProcess {
    private static final String BIN_SH = "/bin/sh";
    private static final String BIN_SH_C = "-c";
    private static final String BIN_SH_D = "-d";
    private static final String BLD_TOOLKIT = "BLD_TOOLKIT";
    private static final String BPX_SHAREAS = "_BPX_SHAREAS";
    private static final String SUBPROCESS_CMD = "%s/SubProcess";
    private static final String SUBPROCESS_FLG = "subProcessFlag";
    private static final String SUBPROCESS_LOG = "%s/subProcess.%s.log";
    private static final String SUBPROCESS_PFX = "SPME:";
    private static final String SUBPROCESS_TST = "subProcessTest";
    private static final String Java = "java";
    private static final String JavaCP = "-cp";
    private static final String JavaDebug = "-Xdebug";
    private static final String JavaDebugJdwp = "-Xrunjdwp:server=y,transport=dt_socket,address=54321,suspend=y";
    private static final String JavaSubComp = "%1$s/SubCompiler.jar:%1$s/com.ibm.teamz.build.ant.zos.jar";
    private static final String JavaSubCompClass = "com.ibm.team.enterprise.zos.build.subprocess.SubProcess";
    private final IDebugger dbg;
    private final String cls;
    private final boolean dbgOn;
    private final Project project;
    private final String name;
    private final ReentrantReadWriteLock statusLock = new ReentrantReadWriteLock();
    private Process subProcess;
    private subProcessStatus status;
    private PrintStream subProcessStdIn;
    private InputStreamReader subProcessStdErr;
    private BufferedReader subProcessStdOut;
    public GatewaySessionMgr.Sessions gatewaySessions = new GatewaySessionMgr.Sessions();
    private StatisticsBlock block;

    public SubProcess(Project project, String name, IDebugger dbg) throws IOException {
        String[] cmd;
        String fetchDestinationDirectory;
        this.project = project;
        this.name = name;
        this.dbg = dbg.getDbg(dbg, this.getClass());
        this.cls = this.getClass().getSimpleName();
        this.dbgOn = this.dbg.isOn();
        this.statusLock.writeLock().lock();
        this.status = subProcessStatus.NEW;
        this.statusLock.writeLock().unlock();
        String buildToolkitDirectory = System.getenv(BLD_TOOLKIT);
        if (buildToolkitDirectory == null) {
            buildToolkitDirectory = ".";
        }
        if ((fetchDestinationDirectory = project.getProperty("team.enterprise.scm.fetchDestination")) == null) {
            fetchDestinationDirectory = ".";
        }
        String traceFile = String.format(SUBPROCESS_LOG, fetchDestinationDirectory, name);
        String executable = String.format(SUBPROCESS_CMD, buildToolkitDirectory);
        String subProcessFlag = Verification.toNonNull((String)project.getProperty(SUBPROCESS_FLG));
        String subProcessTest = Verification.toNonNull((String)project.getProperty(SUBPROCESS_TST));
        String[] cmdC = new String[]{BIN_SH, BIN_SH_C, executable};
        String[] cmdCOld = new String[]{executable};
        String[] cmdCDebug = new String[]{BIN_SH, BIN_SH_C, String.valueOf(executable) + BIN_SH_D + traceFile};
        String[] cmdJ = new String[]{Java, JavaCP, String.format(JavaSubComp, subProcessTest), JavaSubCompClass, name};
        String[] cmdJDebug = new String[]{Java, JavaCP, JavaDebug, JavaDebugJdwp, String.format(JavaSubComp, subProcessTest), JavaSubCompClass, name};
        ArrayList<String> env = new ArrayList<String>();
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            env.add(String.valueOf(key) + "=" + value);
        }
        InteractiveISPFGateway.setupEnv(project, env);
        String[] envp = env.toArray(new String[env.size()]);
        switch (subProcessFlag) {
            case "": {
                if ("yes".equalsIgnoreCase(System.getenv(BPX_SHAREAS))) {
                    cmd = cmdC;
                    break;
                }
                cmd = cmdCOld;
                break;
            }
            case "C": {
                cmd = cmdC;
                break;
            }
            case "COld": {
                cmd = cmdCOld;
                break;
            }
            case "CDebug": {
                cmd = cmdCDebug;
                break;
            }
            case "J": {
                cmd = cmdJ;
                break;
            }
            case "JDebug": {
                cmd = cmdJDebug;
                break;
            }
            default: {
                cmd = cmdC;
            }
        }
        this.subProcess = cmd.length == 1 ? Runtime.getRuntime().exec(cmd[0], envp) : Runtime.getRuntime().exec(cmd, envp);
        this.status = subProcessStatus.BUSY;
        if (dbg.isFlow()) {
            DebugMessage dm = new DebugMessage(null, null, false);
            dm.append(cmd);
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{this.cls, this.getName(), dm.get()});
        }
    }

    public void send(String s) throws IOException {
        Mnm mnm = this.dbgOn ? new Mnm(){}.enter(this.dbg, this.cls, new String[]{this.getName(), s}) : new Mnm();
        this.getSubProcessStdIn().println(s);
        this.getSubProcessStdIn().flush();
        mnm.leave(new String[]{this.getName(), s});
    }

    public String sendReceive(String s) throws IOException {
        Mnm mnm = this.dbgOn ? new Mnm(){}.enter(this.dbg, this.cls, new String[]{this.getName(), s}) : new Mnm();
        mnm.getTime(this.getName(), true);
        this.send(s);
        mnm.setInterval(this.block, this.getNameLabel("send"));
        String line = null;
        while (true) {
            DebugMessage dm;
            line = this.innerReadline(this.dbg);
            mnm.setInterval(this.block, this.getNameLabel("line"));
            if (line == null) {
                DebugMessage emsg = new DebugMessage(Messages.SUBPROCESS_READLINE_NULL, new Object[]{this.getName()});
                mnm.error(new String[]{emsg.bind()});
                this.setNew();
                try {
                    int rc = this.subProcess.exitValue();
                    DebugMessage dm2 = new DebugMessage(Messages.SUBPROCESS_READLINE_EXIT, new Object[]{this.getName(), rc});
                    mnm.error(new String[]{dm2.bind()});
                }
                catch (IllegalThreadStateException e) {
                    DebugMessage dm3 = new DebugMessage(Messages.SUBPROCESS_READLINE_TERM, new Object[]{this.getName()});
                    mnm.error(new String[]{dm3.bind()});
                    this.subProcess.destroy();
                }
                break;
            }
            if (line.startsWith(SUBPROCESS_PFX)) {
                if (this.dbg.isTrace()) {
                    dm = new DebugMessage(Messages.SUBPROCESS_READLINE_RECV, new Object[]{this.getName(), line});
                    mnm.trace(new String[]{dm.bind()});
                }
                line = line.substring(SUBPROCESS_PFX.length());
                break;
            }
            if (!this.dbg.isTrace()) continue;
            dm = new DebugMessage(Messages.SUBPROCESS_READLINE_XTRA, new Object[]{this.getName(), line});
            mnm.trace(new String[]{dm.bind()});
        }
        mnm.logTiming(this.block, true);
        mnm.leave(new String[]{this.getName(), LogString.valueOf((String)line)});
        return line;
    }

    private String innerReadline(IDebugger dbg) throws IOException {
        String result;
        Mnm mnm = this.dbgOn ? new Mnm(){}.enter(dbg, this.cls, new String[]{this.getName()}) : new Mnm();
        mnm.getTime(this.getName());
        this.drainStdErr();
        mnm.setInterval(this.block, this.getNameLabel("stderr"));
        try {
            result = this.getSubProcessStdOut().readLine();
            mnm.setInterval(this.block, this.getNameLabel("stdout"));
        }
        catch (IOException e) {
            this.setNew();
            throw e;
        }
        mnm.logTiming(this.block);
        mnm.leave(new String[]{this.getName(), LogString.valueOf((String)result)});
        return result;
    }

    private void drainStdErr() {
        StringBuffer sb;
        Mnm mnm;
        block5: {
            mnm = this.dbgOn ? new Mnm(){}.enter(this.dbg, this.cls, new String[]{this.getName()}) : new Mnm();
            sb = new StringBuffer();
            try {
                if (this.subProcess.getErrorStream().available() > 0) {
                    InputStreamReader sr = this.getSubProcessStdErr();
                    char[] buffer = new char[8192];
                    while (sr.ready()) {
                        int c = sr.read(buffer, 0, buffer.length);
                        if (c == -1) break;
                        sb.append(buffer, 0, c);
                    }
                    if (this.dbg.isTrace() && sb.length() > 0) {
                        DebugMessage dm = new DebugMessage(Messages.SUBPROCESS_READLINE_STDE, new Object[]{this.getName(), sb.toString()});
                        mnm.trace(new String[]{dm.bind()});
                    }
                }
            }
            catch (Exception e) {
                if (!this.dbg.isDebug()) break block5;
                mnm.error(new String[]{e.getMessage()});
            }
        }
        mnm.leave(new Object[]{this.getName(), sb.length()});
    }

    public String readLine() throws IOException {
        return this.readLine(this.dbg);
    }

    public String readLine(IDebugger dbg) throws IOException {
        String ret = this.innerReadline(dbg);
        if (ret.startsWith(SUBPROCESS_PFX)) {
            return null;
        }
        return ret;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLabel(String label) {
        return String.valueOf(this.name) + ":" + label;
    }

    public Project getProject() {
        return this.project;
    }

    private PrintStream getSubProcessStdIn() {
        if (this.subProcessStdIn == null) {
            OutputStream out = this.subProcess.getOutputStream();
            this.subProcessStdIn = new PrintStream(out);
        }
        if (this.dbgOn) {
            new Mnm(){}.inout(this.dbg, this.cls, new String[]{this.getName()});
        }
        return this.subProcessStdIn;
    }

    private InputStreamReader getSubProcessStdErr() {
        if (this.subProcessStdErr == null) {
            this.subProcessStdErr = new InputStreamReader(this.subProcess.getErrorStream());
        }
        if (this.dbgOn) {
            new Mnm(){}.inout(this.dbg, this.cls, new String[]{this.getName()});
        }
        return this.subProcessStdErr;
    }

    public BufferedReader getSubProcessStdOut() {
        if (this.subProcessStdOut == null) {
            InputStream in = this.subProcess.getInputStream();
            this.subProcessStdOut = new BufferedReader(new InputStreamReader(in));
        }
        return this.subProcessStdOut;
    }

    private boolean isReady() {
        boolean result = false;
        this.statusLock.readLock().lock();
        try {
            result = this.status.equals((Object)subProcessStatus.READY);
        }
        finally {
            this.statusLock.readLock().unlock();
        }
        if (this.dbgOn) {
            new Mnm(){}.inout(this.dbg, this.cls, new String[]{this.getName(), LogString.valueOf((boolean)result)});
        }
        return result;
    }

    public void setReady() {
        this.statusLock.writeLock().lock();
        try {
            this.status = subProcessStatus.READY;
        }
        finally {
            this.statusLock.writeLock().unlock();
        }
        if (this.dbgOn) {
            new Mnm(){}.inout(this.dbg, this.cls, new String[]{this.getName(), LogString.valueOf((Enum)this.status)});
        }
    }

    public boolean claim() {
        boolean result = false;
        if (this.isReady()) {
            this.statusLock.writeLock().lock();
            if (this.isReady()) {
                this.status = subProcessStatus.BUSY;
                result = true;
            }
            this.statusLock.writeLock().unlock();
        }
        if (this.dbgOn) {
            new Mnm(){}.inout(this.dbg, this.cls, new String[]{this.getName(), LogString.valueOf((boolean)result)});
        }
        return result;
    }

    public subProcessStatus getStatus() {
        subProcessStatus result;
        this.statusLock.readLock().lock();
        try {
            result = this.status;
        }
        finally {
            this.statusLock.readLock().unlock();
        }
        if (this.dbgOn) {
            new Mnm(){}.inout(this.dbg, this.cls, new String[]{this.getName(), LogString.valueOf((Enum)result)});
        }
        return result;
    }

    private void setNew() {
        Mnm mnm = this.dbgOn ? new Mnm(){}.enter(this.dbg, this.cls, new String[]{this.getName()}) : new Mnm();
        this.statusLock.writeLock().lock();
        this.status = subProcessStatus.NEW;
        this.subProcessStdIn = null;
        this.subProcessStdErr = null;
        this.subProcessStdOut = null;
        this.statusLock.writeLock().unlock();
        mnm.leave(new String[]{this.getName()});
    }

    public void stop() {
        Mnm mnm = this.dbgOn ? new Mnm(){}.enter(this.dbg, this.cls, new String[]{this.getName()}) : new Mnm();
        try {
            this.setNew();
            this.send("Stop");
            this.subProcess.destroy();
        }
        catch (IOException e) {
            mnm.error((Throwable)e, new String[]{e.getMessage()});
        }
        mnm.logCounter(this.block);
        mnm.leave(new String[]{this.getName()});
    }

    protected void finalize() throws Throwable {
        if (this.subProcess != null) {
            this.subProcess.destroy();
        }
        super.finalize();
        if (this.dbgOn) {
            new Mnm(){}.inout(this.dbg, this.cls, new String[]{this.getName()});
        }
    }

    public static enum subProcessStatus {
        NEW,
        READY,
        BUSY;

    }
}

