/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.build.ant.internal.utils;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.team.enterprise.build.ant.IBuildableResource;
import com.ibm.team.enterprise.build.ant.internal.messages.Messages;
import com.ibm.team.enterprise.build.ant.internal.utils.AbstractMacroExec;
import com.ibm.team.enterprise.build.common.buildreport.BuildFileXMLModel;
import com.ibm.team.enterprise.systemdefinition.common.MemberNamePattern;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosPlatformObject;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.SubProcessMacroExec;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.ZOS;
import com.ibm.team.enterprise.zos.build.ant.tasks.Executable;
import com.ibm.team.enterprise.zos.build.ant.types.Alloc;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class MacroExecZOS
extends AbstractMacroExec {
    private static final String TEMP_SOURCE_DATA_SET_NAME = "&&ANTZTEMP";
    private ZFile tempFile;

    public MacroExecZOS(Task parentTask, IBuildableResource buildableResource, boolean preview) {
        super(parentTask, buildableResource, preview);
    }

    public AbstractMacroExec call() {
        AbstractMacroExec result = super.call();
        Alloc.freeAll(this.parentTask, this instanceof SubProcessMacroExec ? (SubProcessMacroExec)this : null);
        return result;
    }

    protected void getPlatformDependentAttributes(Properties p) throws Exception {
        String componentName;
        String projectName;
        String member;
        String memberName;
        String buildPath = this.buildableResource.getBuildPath();
        if (buildPath == null || buildPath.trim().length() == 0) {
            buildPath = this.allocateTemporarySourceDataSet();
        }
        if ((memberName = this.buildableResource.getBuildFile()) != null) {
            memberName = memberName.toUpperCase();
        }
        if ((member = memberName) == null || member.trim().length() == 0) {
            member = "";
            memberName = "";
        } else {
            member = "(" + member + ")";
        }
        String dataSetName = this.tempFile != null ? buildPath : String.valueOf(buildPath) + member;
        p.setProperty("source.dataset", dataSetName);
        p.setProperty("source.member", member);
        p.setProperty("source.member.name", memberName);
        if (this.buildableResource.getVersionId() != null) {
            p.setProperty("source.version", this.buildableResource.getVersionId());
        }
        if ((projectName = this.buildableResource.getProjectName()) != null) {
            p.setProperty("source.project", projectName);
        }
        if ((componentName = this.buildableResource.getComponentName()) != null) {
            p.setProperty("source.component", componentName);
        }
        String scmLocation = this.getMemberScmLocation();
        String fileExtension = this.getFileExtension(scmLocation);
        p.setProperty("source.member.scm.location", scmLocation);
        p.setProperty("source.member.file.extension", fileExtension);
        if (this.buildableResource.getReason() != null) {
            p.setProperty("source.reasontorebuild", this.buildableResource.getReason());
        }
    }

    private String allocateTemporarySourceDataSet() throws Exception {
        String text;
        if (ZOS.datasetExists((ProjectComponent)this.parentTask, TEMP_SOURCE_DATA_SET_NAME)) {
            ZOS.removeDataset((ProjectComponent)this.parentTask, TEMP_SOURCE_DATA_SET_NAME);
        }
        if ((text = this.buildableResource.getNestedText()) != null) {
            this.parentTask.log("Allocate temporary source data set for inline data.", 4);
            this.tempFile = ZOS.saveLines(this.parentTask, TEMP_SOURCE_DATA_SET_NAME, this.getLinesList(text));
            this.buildableResource.setBuildPath(TEMP_SOURCE_DATA_SET_NAME);
        }
        return TEMP_SOURCE_DATA_SET_NAME;
    }

    protected void cleanup() {
        super.cleanup();
        if (this.tempFile != null) {
            try {
                ZOS.close(this.tempFile);
            }
            catch (ZFileException zFileException) {
                // empty catch block
            }
            this.tempFile = null;
        }
        if (this.consolidatedLog != null && this.consolidatedLog.exists()) {
            String logLabel;
            String zipInfoMessageInsert = logLabel = NLS.bind((String)Messages.CONSOLIDATED_LOG_DESCRIPTION, this.fJobProperties.get("source.dataset"));
            Executable.publishOrZip(this.consolidatedLog, this.highestLogSeverity, this.getTask().getProject(), this.getTask(), logLabel, zipInfoMessageInsert);
            this.consolidatedLog = null;
        }
    }

    private List<String> getLinesList(String text) {
        String[] lines = text.split("\n");
        ArrayList<String> linesList = new ArrayList<String>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            line = line.replace("\t", "    ");
            linesList.add(line);
            ++n2;
        }
        if (linesList.size() > 0 && ((String)linesList.get(linesList.size() - 1)).trim().length() == 0) {
            linesList.remove(linesList.size() - 1);
        }
        if (linesList.size() > 0 && ((String)linesList.get(0)).trim().length() == 0) {
            linesList.remove(0);
        }
        return linesList;
    }

    protected MemberNamePattern getMemberNamePattern() {
        return new MemberNamePattern(IZosPlatformObject.class);
    }

    protected String getMemberName(Properties p) {
        return p.getProperty("source.member.name");
    }

    protected String getMemberScmLocation() {
        if (this.buildableResource != null) {
            for (BuildFileXMLModel buildFile : this.buildableResource.getInputFiles()) {
                if (!"SELF".equals(buildFile.getType())) continue;
                return buildFile.getScmLocation();
            }
        }
        return "";
    }

    protected String getFileExtension(String scmLocation) {
        int index = scmLocation.lastIndexOf(".");
        if (index > -1 && index < scmLocation.length()) {
            return scmLocation.substring(index + 1);
        }
        return "";
    }
}

