/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.build.ant.internal.utils;

import com.ibm.team.build.common.IStaticReset;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.DebugGroup;
import com.ibm.team.build.extensions.common.debug.DebuggerDummy;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogField;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.build.extensions.toolkit.ant.DebugTask;
import com.ibm.team.build.extensions.toolkit.ant.DebuggerAnt;
import com.ibm.team.enterprise.build.ant.internal.utils.AbstractMacroExec;
import com.ibm.team.enterprise.build.ant.tasks.InitTask;
import com.ibm.team.enterprise.build.common.GatewayErrorMessages;
import com.ibm.team.enterprise.zos.build.ant.internal.messages.Messages;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.GatewayParmFile;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.GatewayResult;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.GatewaySessionMgr;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.SubProcess;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.SubProcessMacroExec;
import com.ibm.team.enterprise.zos.build.ant.tasks.Executable;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.teamz.build.ant.zos.utils.AllocInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Environment;
import org.eclipse.osgi.util.NLS;

@DebugGroup(value={"gateway"})
public class InteractiveISPFGateway
implements IStaticReset {
    private static final String cls = InteractiveISPFGateway.class.getSimpleName();
    private static DebugTask staticTsk;
    private static IDebugger staticDbg;
    private static String debugGroup;
    public static final int GW_RC_SESSION_TIMEOUT = -93;
    public static final String GW_TRACE_MARKER = "*GATEWAY";
    private static final String GW_ISPZXENV = "ISPZXENV";
    private static final String GW_ISPZINT = "ISPZINT";
    private static final String GW_STEPLIB = "STEPLIB";
    private static final String BLZISPGW = "%%BLZISPGW";
    private static final String GATEWAY_PARM_PREFIX = "team.enterprise.gateway.";
    public static final String GATEWAY_PARM_SESSION = "team.enterprise.gateway.sessionid";
    public static final String GATEWAY_RETRIES = "team.enterprise.gateway.translatorRetries";
    public static final String GATEWAY_SYNC_NEW_ISPF = "team.enterprise.gateway.syncNewISPF";
    public static final String GATEWAY_CGI_PING = "team.enterprise.gateway.cgiPing";
    public static final int GATEWAY_RETRIES_DEFAULT = 5;
    private static final int GATEWAY_RETRY_SLEEP_INTERVAL_MS = 1000;
    private static final String BLZSTOP = "BLZSTOP";
    private static final String SERVICE_TSO = "TSO";
    private static final String SERVICE_ISPF = "TSOISPF";
    public static final int CALL_METHOD_TYPE_ISPF = 1;
    public static final int CALL_METHOD_TYPE_TSO = 2;
    private final Project project;
    private final int callMethod;
    private final String translatorCmd;
    private final SubProcessMacroExec spme;
    private final List<AllocInfo> allocationInfos;
    private final boolean debugISPFGateway;
    private final String memberGatewayLog;
    private final IDebugger dbg;
    private static BuildDefResolver buildDefResolver;

    static {
        debugGroup = "gateway";
        staticTsk = new DebugTask();
        staticTsk.setTaskName(cls);
        staticTsk.init();
        try {
            staticDbg = new DebuggerAnt((Task)staticTsk, InteractiveISPFGateway.class);
        }
        catch (Exception e) {
            staticDbg = new DebuggerDummy();
        }
        buildDefResolver = project -> {
            IBuildDefinition result = null;
            try {
                String buildDefProp = project.getProperty("team.enterprise.buildDefinitionUUID");
                IBuildDefinitionHandle buildDefHandle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildDefProp), null);
                ITeamRepository repo = InitTask.getInstance().getTeamRepository();
                result = (IBuildDefinition)repo.itemManager().fetchCompleteItem((IItemHandle)buildDefHandle, 0, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        };
    }

    public static boolean isInteractiveGatewayEnabled(Project project) {
        boolean result = false;
        if (project != null) {
            String enabled = InteractiveISPFGateway.getPropertyValue(project, "team.enterprise.gateway.enabled", null);
            result = Boolean.valueOf(enabled);
        }
        return result;
    }

    private static String getPropertyValue(Project project, String propertyId, String defaultValue) {
        return InteractiveISPFGateway.getPropertyValue(buildDefResolver.resolve(project), propertyId, defaultValue);
    }

    private static String getPropertyValue(IBuildDefinition buildDef, String propertyId, String defaultValue) {
        return buildDef.getConfigurationPropertyValue("com.ibm.team.enterprise.build.common.IEnterpriseGatewayConfigurationElement", propertyId, defaultValue);
    }

    public static void setupEnv(Project project, List<String> env) {
        if (InteractiveISPFGateway.isInteractiveGatewayEnabled(project)) {
            Mnm mnm = new Mnm(){}.put(staticDbg, cls);
            List<Environment.Variable> envVars = InteractiveISPFGateway.getEnv(project);
            for (Environment.Variable envVar : envVars) {
                env.add(envVar.getContent());
                mnm.trace(new Object[]{staticDbg, "setting env " + envVar.getKey() + "=" + envVar.getValue()});
            }
        }
    }

    static List<Environment.Variable> getEnv(Project project) {
        ArrayList<Environment.Variable> result = new ArrayList<Environment.Variable>();
        if (InteractiveISPFGateway.isInteractiveGatewayEnabled(project)) {
            String steplib;
            InteractiveISPFGateway.createEnv(result, "CGI_CEATSO", "TRUE");
            String cgiPing = project.getProperty(GATEWAY_CGI_PING);
            if (cgiPing == null || Boolean.valueOf(cgiPing).booleanValue()) {
                InteractiveISPFGateway.createEnv(result, "CGI_PING", "TRUE");
            }
            if ((steplib = InteractiveISPFGateway.getPropertyValue(project, "team.enterprise.gateway.steplib", null)) != null && steplib != null && steplib.length() > 0) {
                InteractiveISPFGateway.createEnv(result, GW_STEPLIB, steplib);
            }
        }
        return result;
    }

    private static void createEnv(List<Environment.Variable> env, String key, String value) {
        if (key != null && value != null) {
            Mnm mnm = new Mnm(){}.put(staticDbg, cls);
            mnm.items(new String[]{key, value});
            Environment.Variable result = new Environment.Variable();
            result.setKey(key);
            result.setValue(value);
            env.add(result);
        }
    }

    public InteractiveISPFGateway(Project project, int callMethod, String cmd, SubProcessMacroExec spme, List<AllocInfo> allocationInfos, boolean debugISPFGateway) {
        this(project, callMethod, cmd, spme, allocationInfos, debugISPFGateway, null, (IDebugger)new DebuggerDummy());
    }

    public InteractiveISPFGateway(Project project, int callMethod, String cmd, SubProcessMacroExec spme, List<AllocInfo> allocationInfos, boolean debugISPFGateway, String memberGatewayLog, IDebugger debugger) {
        this.project = project;
        this.callMethod = callMethod;
        this.translatorCmd = cmd;
        this.spme = spme;
        this.allocationInfos = allocationInfos;
        this.debugISPFGateway = debugISPFGateway;
        this.memberGatewayLog = memberGatewayLog;
        this.dbg = debugger.getDbg(debugger, this.getClass());
        String session = project.getProperty(GATEWAY_PARM_SESSION);
        if (session != null) {
            if (this.dbg.isInfo()) {
                this.dbg.logMsg("using session from project properties:  " + session);
            }
            GatewaySessionMgr.setCurrentGatewaySession(callMethod, spme, session);
        }
        GatewaySessionMgr.initSubProcess(project, spme, this.dbg);
    }

    public IDebugger getDbg() {
        return this.dbg;
    }

    public int getCallMethod() {
        return this.callMethod;
    }

    public String getTranslatorCmd() {
        return this.translatorCmd;
    }

    public SubProcessMacroExec getSpme() {
        return this.spme;
    }

    public List<AllocInfo> getAllocationInfos() {
        return this.allocationInfos;
    }

    public String getMemberGatewayLog() {
        return this.memberGatewayLog;
    }

    public static void configure(BuildDefResolver aBuildDefResolver, GatewaySessionMgr.SessionsResolver aSessionsResolver) {
        buildDefResolver = aBuildDefResolver;
        GatewaySessionMgr.setSessionsResolver(aSessionsResolver);
    }

    public CommandLine getGatewayCmdLine() {
        File parmFile;
        Mnm mnm = new Mnm(){}.put(this.dbg, cls);
        String propSyncNewISPF = this.project.getProperty(GATEWAY_SYNC_NEW_ISPF);
        if ((propSyncNewISPF == null || Boolean.valueOf(propSyncNewISPF).booleanValue()) && this.callMethod == 1 && GatewaySessionMgr.getCurrentGatewaySession(this.callMethod, this.spme) == null) {
            this.createNewISPFSession();
        }
        CommandLine result = new CommandLine();
        result.parmFile = parmFile = GatewayParmFile.generateParmFile(this);
        String debugISPFGatewayProp = this.project.getProperty("team.enterprise.gateway.trace");
        boolean debugISPFGateway = Boolean.valueOf(debugISPFGatewayProp);
        String cmdLine = String.format("%%BLZISPGW 'PATH(%s)%s'", parmFile.getAbsolutePath(), debugISPFGateway ? " ( TRACE(I)" : "");
        cmdLine = this.formatGatewayCommand(cmdLine);
        result.cmdLine = InteractiveISPFGateway.formatGatewayCall(this.project, cmdLine);
        String processCount = this.project.getProperty("team.enterprise.build.dependency.ProcessCount");
        if (processCount != null && Integer.valueOf(processCount) == 1) {
            result.envVars = InteractiveISPFGateway.getEnv(this.project);
        }
        result.subProcess = GatewaySessionMgr.getSubProcessForSingleProcessBuilds();
        mnm.leave(new String[]{String.valueOf(Debug.data((String[])new String[]{GW_TRACE_MARKER, this.getGatewayTraceId(), "translatorCmd", LogField.valueOf((String)this.translatorCmd), "memberLog", LogField.valueOf((String)this.memberGatewayLog)})) + Debug.data((String[])new String[]{"cmdLine", LogField.valueOf((String)result.cmdLine)})});
        return result;
    }

    private String getGatewayTraceId() {
        SubProcess subProcess = GatewaySessionMgr.getSubProcess(this.spme);
        return InteractiveISPFGateway.getGatewayTraceId(this.callMethod, subProcess);
    }

    public static String getGatewayTraceId(int callMethod, SubProcess subProcess) {
        return String.valueOf(InteractiveISPFGateway.getCallMethod(callMethod)) + "/" + (subProcess != null ? subProcess.getName() : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewISPFSession() {
        Mnm mnm = new Mnm(){}.enter(this.dbg, cls, new String[0]);
        String gatewayCommand = this.formatGatewayCommand("");
        gatewayCommand = InteractiveISPFGateway.formatGatewayCall(this.project, gatewayCommand);
        File out = InteractiveISPFGateway.getTempFile(this.project, BLZSTOP);
        Class<InteractiveISPFGateway> clazz = InteractiveISPFGateway.class;
        synchronized (InteractiveISPFGateway.class) {
            GatewayResult gatewayResult;
            block8: {
                block7: {
                    try {
                        Executable.execViaSubprocess(GatewaySessionMgr.getSubProcess(this.spme), this.project, out, gatewayCommand);
                    }
                    catch (IOException e) {
                        if (!this.dbg.isError()) break block7;
                        Debug.error((IDebugger)this.dbg, (Throwable)e, (String[])new String[]{"Couldn't issue request to start a new ISPF session"});
                    }
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                gatewayResult = null;
                try {
                    gatewayResult = this.getResult(out);
                }
                catch (Exception e) {
                    if (!this.dbg.isError()) break block8;
                    Debug.error((IDebugger)this.dbg, (Throwable)e, (String[])new String[]{"Couldn't start a new ISPF session"});
                }
            }
            mnm.leave(new String[]{Debug.data((String[])new String[]{GW_TRACE_MARKER, this.getGatewayTraceId(), "result", LogField.valueOf((Object)gatewayResult)})});
            return;
        }
    }

    private String formatGatewayCommand(String cmdLine) {
        Mnm mnm = new Mnm(){}.put(this.dbg, cls);
        String loglevel = this.project.getProperty("team.enterprise.gateway.loglevel");
        String session = GatewaySessionMgr.getCurrentGatewaySession(this.callMethod, this.spme);
        boolean isExistingSession = session != null;
        String gwCmd = String.valueOf(this.callMethod == 2 ? "" : "TSO ") + cmdLine + (loglevel != null ? " &LOGLEVEL=" + loglevel : "");
        if (isExistingSession) {
            gwCmd = String.valueOf(gwCmd) + this.getPingRequest() + " " + session + " &REQUEST=REUSE";
        } else {
            IBuildDefinition buildDef = buildDefResolver.resolve(this.project);
            gwCmd = String.valueOf(gwCmd) + " &REQUEST=" + this.getRequest() + " &PROCNAME=" + InteractiveISPFGateway.getPropertyValue(buildDef, "team.enterprise.gateway.procname", "") + " &ACCTNUM=" + InteractiveISPFGateway.getPropertyValue(buildDef, "team.enterprise.gateway.acctnum", "") + " &GROUPID=" + InteractiveISPFGateway.getPropertyValue(buildDef, "team.enterprise.gateway.groupid", "") + " &REGIONSZ=" + InteractiveISPFGateway.getPropertyValue(buildDef, "team.enterprise.gateway.regionsz", "");
        }
        mnm.trace(new String[]{gwCmd});
        return gwCmd;
    }

    private String getRequest() {
        Mnm mnm = new Mnm(){}.put(this.dbg, cls);
        Boolean reuseIspfSession = InteractiveISPFGateway.isReuseISPFSession(this.project.getProperties());
        String result = String.format("%s%s", reuseIspfSession != false ? "RECONN" : "NEW", this.callMethod == 2 ? SERVICE_TSO : SERVICE_ISPF);
        mnm.items(new String[]{result});
        return result;
    }

    private String getPingRequest() {
        String pingProp = this.project.getProperty("team.enterprise.gateway.ping");
        return Boolean.valueOf(pingProp) != false ? " &REQUEST=PING" : "";
    }

    static String formatGatewayCall(Project project, String gatewayCmd) {
        String gwModuleProp = project.getProperty("team.enterprise.gateway.ispzxenv");
        String gwModule = Boolean.valueOf(gwModuleProp) != false ? GW_ISPZXENV : GW_ISPZINT;
        String result = String.format("echo \"%s\" |%s", gatewayCmd, gwModule);
        return result;
    }

    static Boolean isReuseISPFSession(Hashtable<String, Object> properties) {
        return Boolean.FALSE;
    }

    static File getTempFile(Project project, String prefix) {
        File out;
        Mnm mnm = new Mnm(){}.put(staticDbg, cls);
        String dirName = AbstractMacroExec.getLoadDir((Project)project);
        File dir = new File(dirName);
        try {
            out = File.createTempFile(prefix, ".log", dir);
        }
        catch (IOException e) {
            if (staticDbg.isError()) {
                Debug.error((IDebugger)staticDbg, (Throwable)e, (String[])new String[]{"Error creating tempfile for gateway log"});
            }
            out = null;
        }
        mnm.items(new Object[]{out});
        return out;
    }

    public static GatewayResult getGatewayResultForTest(File gatewayLog, boolean debug) {
        return GatewayResult.getGatewayResult(gatewayLog, debug);
    }

    public GatewayResult getResult(File gatewayLog) throws RetryException {
        GatewayResult result = GatewayResult.getGatewayResult(gatewayLog, this.debugISPFGateway);
        if (result.session != null) {
            GatewaySessionMgr.setCurrentGatewaySession(this.callMethod, this.spme, result.session);
        }
        return result;
    }

    public void checkRc(GatewayResult gwResult) throws RetryException {
        Mnm mnm = new Mnm(){}.put(this.dbg, cls);
        if (this.dbg.isFlow()) {
            mnm.debug(new String[]{Debug.data((String[])new String[]{GW_TRACE_MARKER, this.getGatewayTraceId(), "result", LogField.valueOf((Object)gwResult)})});
        }
        if (gwResult.ispfRC == -93) {
            if (this.dbg.isFlow()) {
                Debug.trace((String[])new String[]{"session timeout detected from ISPF rc;  will retry translator command."});
            }
            GatewaySessionMgr.setCurrentGatewaySession(this.callMethod, this.spme, null);
            throw new RetryException(NLS.bind((String)Messages.TRANSLATOR_SESSION_TIMEDOUT, null));
        }
        if (gwResult.ispfRC == -992) {
            mnm.trace(new String[]{"detected ISPF enqueue;  will stop the session and retry...."});
            if (GatewaySessionMgr.stop(this.project, GatewaySessionMgr.getSubProcess(this.spme), this.callMethod, gwResult.session, true)) {
                GatewaySessionMgr.setCurrentGatewaySession(this.callMethod, this.spme, null);
            } else {
                mnm.warn(new String[]{"couldn't stop the gateway session after detecting enqueue error"});
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new RetryException(GatewayErrorMessages.msg((int)-992));
        }
        if (gwResult.isFailure) {
            mnm.trace(new String[]{"throwing build exception due to result.rc=" + gwResult.rc});
            throw new BuildException(NLS.bind((String)Messages.TRANSLATOR_ERROR_WITH_GATEWAY_CALL, (Object)gwResult.rc, (Object)gwResult.errorMessage));
        }
    }

    static String getCallMethod(int callMethod) {
        return callMethod == 2 ? SERVICE_TSO : SERVICE_ISPF;
    }

    public static interface BuildDefResolver {
        public IBuildDefinition resolve(Project var1);
    }

    public static class CommandLine {
        public String cmdLine = null;
        public File parmFile = null;
        public List<Environment.Variable> envVars = null;
        public SubProcess subProcess;
    }

    public static class RetryException
    extends Exception {
        public RetryException(String msg) {
        }
    }
}

