/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.build.ant.internal.utils;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.DebugGroup;
import com.ibm.team.build.extensions.common.debug.DebuggerDummy;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogField;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.build.extensions.toolkit.ant.DebugTask;
import com.ibm.team.build.extensions.toolkit.ant.DebuggerAnt;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.GatewayResult;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.InteractiveISPFGateway;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.SubProcess;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.SubProcessMacroExec;
import com.ibm.team.enterprise.zos.build.ant.tasks.Executable;
import java.io.File;
import java.util.List;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

@DebugGroup(value={"gateway"})
public class GatewaySessionMgr {
    private static final String cls = GatewaySessionMgr.class.getSimpleName();
    private static DebugTask staticTsk = new DebugTask();
    private static IDebugger staticDbg;
    private static final String BLZSTOP = "BLZSTOP";
    private static SubProcess subProcess;
    private static SessionsResolver sessionsResolver;

    static {
        staticTsk.setTaskName(cls);
        staticTsk.init();
        try {
            staticDbg = new DebuggerAnt((Task)staticTsk, GatewaySessionMgr.class);
        }
        catch (Exception e) {
            staticDbg = new DebuggerDummy();
        }
        subProcess = null;
        sessionsResolver = spme -> GatewaySessionMgr.getSubProcess((SubProcessMacroExec)spme).gatewaySessions;
    }

    static void setSessionsResolver(SessionsResolver aSessionsResolver) {
        sessionsResolver = aSessionsResolver;
    }

    static synchronized void initSubProcess(Project project, SubProcessMacroExec spme, IDebugger dbg) {
        if (spme == null && subProcess == null) {
            try {
                project.log("Gateway setting up subprocess");
                subProcess = new SubProcess(project, "0", dbg);
                String PREFIX_CMD = "prefix:SPME:";
                subProcess.sendReceive(PREFIX_CMD);
            }
            catch (Exception e) {
                dbg.log("Gateway could not instantiate a subprocess to use with single-process builds", (Throwable)e);
            }
        }
    }

    public static SubProcess getSubProcessForSingleProcessBuilds() {
        return subProcess;
    }

    static SubProcess getSubProcess(SubProcessMacroExec spme) {
        return spme == null ? subProcess : spme.getSubProcess();
    }

    private static String getSubProcessId(SubProcessMacroExec spme) {
        SubProcess sp = GatewaySessionMgr.getSubProcess(spme);
        return sp != null ? spme.getSubProcess().getName() : "(null)";
    }

    static String getCurrentGatewaySession(int callMethod, SubProcessMacroExec spme) {
        String result = null;
        if (spme != null) {
            if (staticDbg.isFlow()) {
                Debug.debug((IDebugger)staticDbg, (String[])new String[]{"current session for subprocess " + GatewaySessionMgr.getSubProcessId(spme) + " is " + result});
            }
        } else if (staticDbg.isFlow()) {
            Debug.debug((IDebugger)staticDbg, (String[])new String[]{"current session is " + result});
        }
        result = sessionsResolver.resolve(spme).getSession(callMethod);
        return result;
    }

    static void setCurrentGatewaySession(int callMethod, SubProcessMacroExec spme, String session) {
        if (spme != null) {
            if (staticDbg.isFlow()) {
                Debug.debug((IDebugger)staticDbg, (String[])new String[]{"setCurrentGatewaySession " + session + " to subprocess " + GatewaySessionMgr.getSubProcessId(spme)});
            }
        } else if (staticDbg.isFlow()) {
            Debug.debug((IDebugger)staticDbg, (String[])new String[]{"setCurrentGatewaySession " + session});
        }
        sessionsResolver.resolve(spme).setSession(callMethod, session);
    }

    public static void stop(Project project, List<SubProcess> subProcessPool) {
        if (InteractiveISPFGateway.isInteractiveGatewayEnabled(project)) {
            Mnm mnm = new Mnm(){}.enter(staticDbg, cls, new String[0]);
            SessionStopResult stopResult = new SessionStopResult();
            mnm.inter(new String[]{"stopping sessions on subprocesses"});
            for (SubProcess subprocess : subProcessPool) {
                GatewaySessionMgr.stop(project, stopResult, subprocess);
            }
            if (stopResult.sessionsOpened > 0) {
                GatewaySessionMgr.logStopResult(project, stopResult);
            }
            mnm.leave(new String[0]);
        }
    }

    private static void logStopResult(Project project, SessionStopResult stopResult) {
        if (project != null) {
            project.log(NLS.bind((String)"Closed {0} of {1} interactive gateway sessions.", (Object)stopResult.sessionsClosed, (Object)stopResult.sessionsOpened));
        }
    }

    private static void stop(Project project, SessionStopResult stopResult, SubProcess subprocess) {
        Sessions sessions;
        Mnm mnm = new Mnm(){}.enter(staticDbg, cls, new String[0]);
        if (subprocess != null && (sessions = subprocess.gatewaySessions).hasSessions()) {
            mnm.inter(new String[]{"stopping sessions for subprocess " + subprocess.getName()});
            GatewaySessionMgr.stop(project, subprocess, sessions, stopResult);
        }
        mnm.leave(new String[0]);
    }

    private static void stop(Project project, SubProcess subprocess, Sessions sessions, SessionStopResult stopResult) {
        Mnm mnm = new Mnm(){}.enter(staticDbg, cls, new String[0]);
        if (sessions.sessionTSO != null) {
            ++stopResult.sessionsOpened;
            if (GatewaySessionMgr.stop(project, subprocess, 2, sessions.sessionTSO, true)) {
                ++stopResult.sessionsClosed;
                sessions.sessionTSO = null;
            }
        }
        if (sessions.sessionISPF != null) {
            ++stopResult.sessionsOpened;
            if (GatewaySessionMgr.stop(project, subprocess, 1, sessions.sessionISPF, true)) {
                ++stopResult.sessionsClosed;
                sessions.sessionISPF = null;
            }
        }
        mnm.leave(new String[0]);
    }

    static boolean stop(Project project, SubProcess subprocess, int callMethod, String session, boolean useSubprocess) {
        GatewayResult gatewayResult;
        boolean result;
        Mnm mnm;
        block12: {
            mnm = new Mnm(){}.enter(staticDbg, cls, new String[0]);
            result = false;
            gatewayResult = null;
            if (session != null) {
                File out = null;
                try {
                    try {
                        int loglevel = 2;
                        boolean reuseIspfSession = InteractiveISPFGateway.isReuseISPFSession(project.getProperties());
                        String gatewayCmd = " &LOGLEVEL=" + loglevel + " &REQUEST=" + (reuseIspfSession ? "DORMANT" : "LOGOFF") + session;
                        gatewayCmd = InteractiveISPFGateway.formatGatewayCall(project, gatewayCmd);
                        out = InteractiveISPFGateway.getTempFile(project, BLZSTOP);
                        if (useSubprocess) {
                            Executable.execViaSubprocess(subprocess, project, out, gatewayCmd);
                        } else {
                            Executable.execViaTask(project, out, gatewayCmd, InteractiveISPFGateway.getEnv(project));
                        }
                        gatewayResult = GatewayResult.getGatewayResult(out, false);
                        int rc = gatewayResult.ispfRC;
                        result = true;
                    }
                    catch (Exception e) {
                        if (staticDbg.isWarn()) {
                            Debug.warn((IDebugger)staticDbg, (Throwable)e, (String[])new String[]{"Exception trying to stop session " + session});
                        }
                        if (out != null) {
                            out.delete();
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        out.delete();
                    }
                    throw throwable;
                }
                if (out != null) {
                    out.delete();
                }
            }
        }
        mnm.leave(new String[]{Debug.data((String[])new String[]{"*GATEWAY", InteractiveISPFGateway.getGatewayTraceId(callMethod, subprocess), "result", LogField.valueOf((boolean)result), "session", LogField.valueOf((String)session)}), LogField.valueOf(gatewayResult)});
        return result;
    }

    public static void initTargetListener(Project project, Target owningTarget) {
        Mnm mnm = new Mnm(){}.enter(staticDbg, cls, new String[0]);
        boolean alreadyListening = false;
        for (BuildListener l : project.getBuildListeners()) {
            if (!(l instanceof InteractiveGatewayBuildListener)) continue;
            alreadyListening = true;
            break;
        }
        if (!alreadyListening) {
            mnm.debug(new String[]{"adding build listener"});
            project.addBuildListener((BuildListener)new InteractiveGatewayBuildListener(staticDbg));
        }
        mnm.leave(new String[0]);
    }

    public static void stopSubProcess() {
        Mnm mnm = new Mnm(){}.enter(staticDbg, cls, new String[0]);
        if (subProcess != null) {
            mnm.inter(new Object[]{staticDbg, "stopping gateway's subProcess"});
            subProcess.stop();
            subProcess = null;
        }
        mnm.leave(new String[0]);
    }

    public static void staticMemoryReset() {
        GatewaySessionMgr.stopSubProcess();
    }

    private static final class InteractiveGatewayBuildListener
    implements BuildListener {
        private IDebugger dbg;

        public InteractiveGatewayBuildListener(IDebugger dbg) {
            this.dbg = dbg;
        }

        public void buildStarted(BuildEvent event) {
        }

        public void buildFinished(BuildEvent event) {
            this.endOfBuild(event);
        }

        private void endOfBuild(BuildEvent event) {
            Mnm mnm = new Mnm(){}.enter(this.dbg, cls, new String[0]);
            Project project = event.getProject();
            SessionStopResult stopResult = new SessionStopResult();
            GatewaySessionMgr.stop(project, stopResult, subProcess);
            GatewaySessionMgr.logStopResult(project, stopResult);
            if (project != null) {
                mnm.debug(new String[]{"removing build listener"});
                project.removeBuildListener((BuildListener)this);
            }
            GatewaySessionMgr.stopSubProcess();
            mnm.leave(new String[0]);
        }

        public void targetStarted(BuildEvent event) {
        }

        public void targetFinished(BuildEvent event) {
            Mnm mnm = new Mnm(){}.enter(this.dbg, cls, new String[0]);
            if ("all".equals(event.getTarget().getName())) {
                this.endOfBuild(event);
            }
            mnm.leave(new String[0]);
        }

        public void taskStarted(BuildEvent event) {
        }

        public void taskFinished(BuildEvent event) {
        }

        public void messageLogged(BuildEvent event) {
        }
    }

    private static class SessionStopResult {
        int sessionsOpened = 0;
        int sessionsClosed = 0;

        private SessionStopResult() {
        }
    }

    public static class Sessions {
        private String sessionTSO = null;
        private String sessionISPF = null;

        public boolean hasSessions() {
            return this.sessionTSO != null || this.sessionISPF != null;
        }

        public void setSession(int callMethod, String session) {
            switch (callMethod) {
                case 2: {
                    this.sessionTSO = session;
                    break;
                }
                case 1: {
                    this.sessionISPF = session;
                    break;
                }
            }
        }

        public String getSession(int callMethod) {
            String result = null;
            switch (callMethod) {
                case 2: {
                    result = this.sessionTSO;
                    break;
                }
                case 1: {
                    result = this.sessionISPF;
                    break;
                }
            }
            return result;
        }

        public String toString() {
            return String.valueOf(this.sessionTSO == null ? "" : this.sessionTSO) + (this.sessionTSO != null && this.sessionISPF != null ? "|" : "") + (this.sessionISPF == null ? "" : this.sessionISPF);
        }
    }

    public static interface SessionsResolver {
        public Sessions resolve(SubProcessMacroExec var1);
    }
}

