/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.build.ant.internal.utils;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.DebugGroup;
import com.ibm.team.build.extensions.common.debug.DebuggerDummy;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogField;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.build.extensions.toolkit.ant.DebugTask;
import com.ibm.team.build.extensions.toolkit.ant.DebuggerAnt;
import com.ibm.team.enterprise.build.common.GatewayErrorMessages;
import com.ibm.team.enterprise.zos.build.ant.internal.messages.Messages;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.InteractiveISPFGateway;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

@DebugGroup(value={"gateway"})
public class GatewayResult {
    private static final String cls = GatewayResult.class.getSimpleName();
    private static DebugTask staticTsk = new DebugTask();
    static IDebugger staticDbg;
    private static final String ISPF_RC = "RC=";
    private static final String ISPF_RSN = "RSN=";
    private static final String XML_TAG_START = "<";
    private static final String XML_TAG_END = "</";
    private static final String XML_END = ">";
    private static final String SESS = "SESS";
    public static final int DEFAULT_GATEWAY_RC = -900;
    public static final int GW_RC_ISPF_ENQUEUE = -992;
    public String errorMessage;
    public boolean isFailure = true;
    public String session;
    public int rc = -900;
    public int ispfRC = -900;
    public Integer ispfRSN = null;
    public Integer blzrc = null;
    @DebugGroup(value={"gateway"})
    private static LogParser ParserGatewayRSN;
    private static LogParser ParserSessionId;
    private static final Pattern ispfEnqueue;
    private static LogParser ParserISPFEnqueue;

    static {
        staticTsk.setTaskName(cls);
        staticTsk.init();
        try {
            staticDbg = new DebuggerAnt((Task)staticTsk, InteractiveISPFGateway.class);
        }
        catch (Exception e) {
            staticDbg = new DebuggerDummy();
        }
        ParserGatewayRSN = (result, line, debug, ispf, sessionInfo) -> {
            Mnm mnm = new Mnm(){}.put(staticDbg, cls);
            boolean matched = false;
            if (!ispf && !sessionInfo && line.startsWith(ISPF_RSN)) {
                result.ispfRSN = Integer.valueOf(line.substring(ISPF_RSN.length()).trim());
                matched = true;
                mnm.items(new String[]{"found RSN code in gateway log " + result.ispfRSN});
            }
            return matched;
        };
        ParserSessionId = (result, line, debug, ispf, sessionInfo) -> {
            Mnm mnm = new Mnm(){}.put(staticDbg, cls);
            if (sessionInfo) {
                result.session = GatewayResult.getText(line, SESS);
                if (result.session != null) {
                    mnm.items(new String[]{"found session id in gateway log " + result.session});
                }
            }
            return result.session != null;
        };
        ispfEnqueue = Pattern.compile(".*ISPT036.*ISPSPROF.*");
        ParserISPFEnqueue = (result, line, debug, ispf, sessionInfo) -> {
            Mnm mnm = new Mnm(){}.put(staticDbg, cls);
            boolean matches = false;
            if (!ispf && !sessionInfo && (matches = ispfEnqueue.matcher(line).matches())) {
                result.ispfRC = -992;
                mnm.items(new String[]{"found ispf enqueue message in gateway log: " + line});
            }
            return matches;
        };
    }

    public String toString() {
        return Debug.data((String[])new String[]{"rc", LogField.valueOf((int)this.rc), "ispfRC", LogField.value((Object)this.ispfRC), "blzrc", LogField.value((Object)this.blzrc), "session", LogField.valueOf((String)this.session)});
    }

    public static GatewayResult getGatewayResult(File gatewayLog, boolean debug) {
        GatewayResult result = new GatewayResult();
        LogParser[] finders = new LogParser[]{ParserSessionId, new ParserISPFRC(), new ParserBLZRC(), ParserISPFEnqueue};
        GatewayResult.parseLog(result, gatewayLog, finders, debug);
        GatewayResult.determineRC(result);
        return result;
    }

    private static void determineRC(GatewayResult result) {
        Mnm mnm = new Mnm(){}.enter(staticDbg, cls, new Object[]{result});
        result.isFailure = true;
        if (result.blzrc != null) {
            result.rc = result.blzrc;
            boolean bl = result.isFailure = result.rc < 0;
            if (result.isFailure) {
                result.errorMessage = GatewayErrorMessages.msg((int)result.rc);
            }
        } else if (result.ispfRC < 0) {
            result.rc = result.ispfRC;
            result.errorMessage = GatewayErrorMessages.msg((int)result.rc);
        } else {
            result.rc = -900;
            result.errorMessage = GatewayErrorMessages.msg((int)result.rc);
            result.errorMessage = NLS.bind((String)Messages.TRANSLATOR_ERROR_WITH_GATEWAY_CALL_WITH_ISPFRC, (Object)result.ispfRC);
        }
        mnm.leave(new String[0]);
    }

    public static void parseLog(GatewayResult result, File f, LogParser[] parsers, boolean debug) {
        Mnm mnm;
        block22: {
            mnm = new Mnm(){}.enter(staticDbg, cls, new String[0]);
            Boolean[] parserResults = new Boolean[parsers.length];
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new FileReader(f), 1024);
                    boolean ispf = false;
                    boolean sessionInfo = false;
                    int matches = 0;
                    block10: while ((line = reader.readLine()) != null && matches < parsers.length) {
                        if (!(ispf || line.indexOf("<ISPF>") < 0 && line.indexOf("<TSO>") < 0)) {
                            ispf = true;
                            continue;
                        }
                        if (ispf && (line.indexOf("</ISPF>") >= 0 || line.indexOf("</TSO>") >= 0)) {
                            ispf = false;
                            continue;
                        }
                        if (!sessionInfo && line.indexOf("<SESSION-INFO>") >= 0) {
                            sessionInfo = true;
                            continue;
                        }
                        if (sessionInfo && line.indexOf("</SESSION-INFO>") >= 0) {
                            sessionInfo = false;
                            continue;
                        }
                        int i = 0;
                        while (i < parsers.length) {
                            if (parserResults[i] == null && parsers[i].parse(result, line, debug, ispf, sessionInfo)) {
                                parserResults[i] = Boolean.TRUE;
                                ++matches;
                                continue block10;
                            }
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    if (staticDbg.isFlow()) {
                        Debug.error((IDebugger)staticDbg, (Throwable)e, (String[])new String[0]);
                    }
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block22;
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        mnm.leave(new String[0]);
    }

    private static String getText(String xml, String searchTag) {
        String endSearchTag;
        int j;
        String result = null;
        String startSearchTag = XML_TAG_START + searchTag + XML_END;
        int i = xml.indexOf(startSearchTag);
        if (i >= 0 && (j = xml.indexOf(endSearchTag = XML_TAG_END + searchTag + XML_END)) >= 0) {
            result = xml.substring(i + startSearchTag.length(), j);
        }
        return result;
    }

    public static interface LogParser {
        public boolean parse(GatewayResult var1, String var2, boolean var3, boolean var4, boolean var5);
    }

    @DebugGroup(value={"gateway"})
    private static class ParserBLZRC
    implements LogParser {
        boolean isBLZISPGW = false;
        boolean matched = false;

        private ParserBLZRC() {
        }

        @Override
        public boolean parse(GatewayResult result, String line, boolean debug, boolean isISPF, boolean sessionInfo) {
            Mnm mnm = new Mnm(){}.put(staticDbg, cls);
            if (!this.matched && isISPF) {
                if (!this.isBLZISPGW && line.indexOf("<BLZISPGW>") >= 0) {
                    mnm.items(new String[]{"found <BLZISPGW> in gateway log "});
                    this.isBLZISPGW = true;
                } else if (this.isBLZISPGW) {
                    if (line.indexOf("</BLZISPGW>") >= 0) {
                        mnm.items(new String[]{"found </BLZISPGW> in gateway log "});
                        this.isBLZISPGW = false;
                    } else {
                        String strValue = GatewayResult.getText(line, "BLZRC");
                        mnm.items(new String[]{"found <BLZRC> in gateway log: " + strValue});
                        if (strValue != null) {
                            this.matched = true;
                            try {
                                int rc = Integer.valueOf(strValue);
                                result.blzrc = rc;
                            }
                            catch (Exception e) {
                                result.blzrc = null;
                            }
                        }
                    }
                }
            }
            return this.matched;
        }
    }

    @DebugGroup(value={"gateway"})
    private static class ParserISPFRC
    implements LogParser {
        String ispfRC = null;
        boolean matched = false;

        private ParserISPFRC() {
        }

        @Override
        public boolean parse(GatewayResult result, String line, boolean debug, boolean isISPF, boolean sessionInfo) {
            Mnm mnm = new Mnm(){}.put(staticDbg, cls);
            if (!sessionInfo) {
                if (this.ispfRC == null) {
                    if (line.startsWith(GatewayResult.ISPF_RC)) {
                        this.ispfRC = line.substring(GatewayResult.ISPF_RC.length()).trim();
                    }
                } else if (line.startsWith("</ISPINFO>")) {
                    result.ispfRC = Integer.valueOf(this.ispfRC);
                    this.matched = true;
                    mnm.items(new String[]{"found RC in gateway log " + result.ispfRC});
                } else {
                    this.ispfRC = null;
                }
            }
            return this.matched;
        }
    }
}

