/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.build.ant.internal.utils;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.DebugGroup;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.InteractiveISPFGateway;
import com.ibm.teamz.build.ant.zos.utils.AllocInfo;
import com.ibm.teamz.build.ant.zos.utils.ISPFGatewayUtil;
import java.io.File;
import java.io.FileOutputStream;

@DebugGroup(value={"gateway"})
public class GatewayParmFile {
    private static final String cls = GatewayParmFile.class.getSimpleName();
    private static final String PREFIX_ISPFGATEWAYINPUT = "ISPGW";
    private static final String EXTENSION_ISPFGATEWAYINPUT = ".blz";

    public static File generateParmFile(InteractiveISPFGateway gw) {
        File result;
        Mnm mnm;
        block5: {
            IDebugger dbg = gw.getDbg();
            mnm = new Mnm(){}.enter(dbg, cls, new String[0]);
            result = null;
            try {
                StringBuffer buffer = new StringBuffer();
                int i = 0;
                String NEWLINE = "\n";
                buffer.append("cmd=" + (gw.getTranslatorCmd() == null ? "" : gw.getTranslatorCmd()) + NEWLINE);
                for (AllocInfo allocInfo : gw.getAllocationInfos()) {
                    String ddn = allocInfo.getDdName();
                    String dsn = allocInfo.getDataSetName();
                    String shr = allocInfo.getShrCommand();
                    String noo = allocInfo.getNewCommand();
                    buffer.append("ddn." + ++i + "=" + (ddn == null ? "" : ddn) + NEWLINE);
                    buffer.append("dsn." + i + "=" + (dsn == null ? "" : dsn) + NEWLINE);
                    buffer.append("shr." + i + "=" + (shr == null ? "" : shr) + NEWLINE);
                    buffer.append("new." + i + "=" + (noo == null ? "" : noo) + NEWLINE);
                    String[] instreamData = allocInfo.getInstreamData();
                    if (instreamData == null) continue;
                    String dd = ddn;
                    int j = 0;
                    String[] stringArray = instreamData;
                    int n = instreamData.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String instream = stringArray[n2];
                        ++j;
                        if (instream.length() > ISPFGatewayUtil.INSTREAM_CHAR_LIMIT) {
                            throw new IllegalArgumentException("Instream data line longer than 80 characters");
                        }
                        String instreamLine = instream.replace("'", "''");
                        buffer.append(String.valueOf(dd) + "." + j + "=" + instreamLine + NEWLINE);
                        ++n2;
                    }
                    buffer.append(String.valueOf(dd) + "." + 0 + "=" + j + NEWLINE);
                }
                buffer.append("ddn.0=" + i + NEWLINE);
                String allocStatements = buffer.toString();
                mnm.inter(new String[]{allocStatements});
                result = File.createTempFile(PREFIX_ISPFGATEWAYINPUT, EXTENSION_ISPFGATEWAYINPUT, null);
                FileOutputStream fos = new FileOutputStream(result);
                fos.write(allocStatements.getBytes());
                fos.flush();
                fos.close();
            }
            catch (Exception e) {
                if (!dbg.isError()) break block5;
                Debug.error((IDebugger)dbg, (Throwable)e, (String[])new String[]{"error trying to write parm file"});
            }
        }
        mnm.leave(new String[0]);
        return result;
    }
}

