/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.build.ant.internal.utils;

import com.ibm.jzos.ZUtil;
import com.ibm.team.build.common.IStaticReset;
import com.ibm.team.enterprise.build.ant.AbstractFileSystemUtil;
import com.ibm.team.enterprise.build.ant.IFileSystemUtil;
import com.ibm.team.enterprise.build.ant.internal.utils.SimulationUtil;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildFile;
import com.ibm.team.enterprise.build.buildmap.common.model.IOutputBuildFile;
import com.ibm.team.enterprise.build.common.IDeletedOutputFile;
import com.ibm.team.enterprise.build.common.simulationregistry.ISimulationRegistryFile;
import com.ibm.team.enterprise.scmee.zos.DataSetLocationFactory;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.SubProcessMacroExec;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.SubProcessManager;
import com.ibm.team.enterprise.zos.build.ant.internal.utils.ZOS;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.teamz.build.ant.jni.ISPFStatistics;
import com.ibm.teamz.build.ant.zos.exceptions.UndefinedRecordFormatException;
import com.ibm.teamz.build.ant.zos.exceptions.ZosException;
import com.ibm.teamz.build.ant.zos.utils.SSISupport;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;

public class FileSystemUtil
extends AbstractFileSystemUtil
implements IStaticReset {
    public static final boolean SIMULATION_ENABLED = System.getProperty("scmee.simulate") != null;
    private static final String RIGHT_PARENTHESIS = ")";
    private static final String LEFT_PARENTHESIS = "(";
    private static final long ONE_THOUSAND = 1000L;
    private static IFileSystemUtil singleton = null;

    private FileSystemUtil() {
    }

    public static IFileSystemUtil getInstance() {
        if (singleton == null) {
            singleton = new FileSystemUtil();
        }
        return singleton;
    }

    public FileSystemUtil(String prefix, String workspaceUuid) {
        super(prefix, workspaceUuid);
    }

    public boolean isNativePlatform() {
        return ZOS.isZOS();
    }

    public void delete(Task task, IBuildFile buildFile) {
        if (SimulationUtil.isSimulationMode()) {
            SimulationUtil.delete((IBuildFile)buildFile);
        } else {
            try {
                SubProcessMacroExec spme = SubProcessManager.getSubProcessMacroExec(task);
                if (spme != null) {
                    ZOS.removeDataset((ProjectComponent)task, this.getDataSetNameWithMember((ProjectComponent)task, buildFile), spme);
                } else {
                    ZOS.removeDataset((ProjectComponent)task, this.getDataSetNameWithMember((ProjectComponent)task, buildFile));
                }
            }
            catch (ZosException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    public void delete(Task task, String buildFile, String buildPath, String sequential) {
        if (!SimulationUtil.isSimulationMode()) {
            try {
                SubProcessMacroExec spme = SubProcessManager.getSubProcessMacroExec(task);
                if (spme != null) {
                    ZOS.removeDataset((ProjectComponent)task, this.getDataSetNameWithMember(buildFile, buildPath, sequential), spme);
                } else {
                    ZOS.removeDataset((ProjectComponent)task, this.getDataSetNameWithMember(buildFile, buildPath, sequential));
                }
            }
            catch (ZosException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    public boolean exists(Task task, String buildFile, String buildPath, String sequential) {
        if (SimulationUtil.isSimulationMode()) {
            if (SimulationUtil.exists((String)buildFile, (String)buildPath, (String)this.getDataSetNameWithMember(buildFile, buildPath, sequential), (boolean)false)) {
                return true;
            }
            if (!this.isNativePlatform()) {
                return false;
            }
        }
        try {
            return ZOS.datasetExists((ProjectComponent)task, this.getDataSetNameWithMember(buildFile, buildPath, sequential));
        }
        catch (ZosException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public boolean exists(Task task, IBuildFile buildFile) {
        if (SimulationUtil.isSimulationMode()) {
            if (SimulationUtil.exists((IBuildFile)buildFile, (String)(buildFile.isHFS() ? this.getHFSPath(buildFile) : this.getDataSetNameWithMember((ProjectComponent)task, buildFile)))) {
                return true;
            }
            if (!this.isNativePlatform()) {
                return false;
            }
        }
        if (buildFile.isHFS()) {
            return this.fileExistsHFS(task, this.getHFSPath(buildFile), task.getProject().getProperty("team.enterprise.build.hfs.outputdir"));
        }
        try {
            return ZOS.datasetExists((ProjectComponent)task, this.getDataSetNameWithMember((ProjectComponent)task, buildFile));
        }
        catch (ZosException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public boolean isPDSValid(Task task, String pdsName) {
        if (SimulationUtil.isSimulationMode() && !this.isNativePlatform()) {
            return true;
        }
        try {
            return ZOS.isPDSValid((ProjectComponent)task, pdsName);
        }
        catch (ZosException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public boolean fileExists(Task task, ISimulationRegistryFile registryFile) {
        if (registryFile.isHFS()) {
            return this.fileExistsHFS(task, registryFile.getNativePath(), task.getProject().getProperty("team.enterprise.build.hfs.outputdir"));
        }
        try {
            return ZOS.datasetExists((ProjectComponent)task, registryFile.getNativePath());
        }
        catch (ZosException e) {
            return false;
        }
    }

    public void normalize(Task task, IBuildFile buildFile) {
    }

    public long lastModified(Task task, IBuildFile buildFile) {
        return this.lastModified(task, buildFile, false);
    }

    public boolean doesFileExist(Task task, IOutputBuildFile file) {
        block5: {
            boolean isHFS = file.isHFS();
            if (isHFS) break block5;
            if (ZOS.datasetExists((ProjectComponent)task, this.getDataSetNameWithMember((ProjectComponent)task, (IBuildFile)file))) {
                return true;
            }
        }
        try {
            String hfsPath = this.getHFSPath((IBuildFile)file);
            if (this.fileExistsHFS(task, hfsPath, task.getProject().getProperty("team.enterprise.build.hfs.outputdir"))) {
                return true;
            }
        }
        catch (ZosException zosException) {
            // empty catch block
        }
        return false;
    }

    public long lastModified(Task task, IBuildFile buildFile, boolean save) {
        boolean isHFS = buildFile.isHFS();
        if (!SimulationUtil.isSimulationMode() || this.isNativePlatform()) {
            long value;
            if (buildFile instanceof IOutputBuildFile && ((IOutputBuildFile)buildFile).isSequential()) {
                return 0L;
            }
            boolean isSkipSSICheck = Boolean.valueOf(task.getProject().getProperty("team.enterprise.build.ant.skipSSICheck"));
            ISPFStatistics stats = null;
            if (isHFS) {
                value = this.lastModifiedHFS(task, buildFile, task.getProject().getProperty("team.enterprise.build.hfs.outputdir"));
            } else {
                try {
                    try {
                        String memberName = ZOS.convertMemberName((ProjectComponent)task, this.getMemberName(buildFile));
                        stats = new ISPFStatistics(this.getDataSetName(buildFile), memberName);
                        if (save && stats != null && stats.getCreationDate().getTime() == 0L && stats.getModificationDate().getTime() == 0L && !SimulationUtil.isSimulationMode()) {
                            Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
                            stats.setCreationDate(now);
                            stats.setModificationDate(now);
                            long count = ZOS.getRecordCount((ProjectComponent)task, this.getDataSetNameWithMember((ProjectComponent)task, buildFile));
                            if (count != -1L) {
                                stats.setInitialLines((int)count);
                                stats.setCurrentLines((int)count);
                            }
                            stats.save();
                        }
                    }
                    catch (UndefinedRecordFormatException e) {
                        if (!isSkipSSICheck) {
                            stats = new ISPFStatistics(this.getDataSetName(buildFile), this.getMemberName(buildFile), true);
                        }
                    }
                }
                catch (Exception e) {
                    task.log((Throwable)e, 4);
                }
                long l = value = stats == null ? 0L : stats.getModificationDate().getTime();
            }
            if (value > 0L || !SimulationUtil.isSimulationMode()) {
                if (save && SimulationUtil.isSimulationMode()) {
                    SimulationUtil.addToRegistry((IBuildFile)buildFile, (long)value, (String)(isHFS ? this.getHFSPath(buildFile) : this.getDataSetNameWithMember((ProjectComponent)task, buildFile)));
                }
                return value;
            }
            if (stats != null) {
                try {
                    if (!isHFS) {
                        if (ZOS.datasetExists((ProjectComponent)task, this.getDataSetNameWithMember((ProjectComponent)task, buildFile))) {
                            if (save) {
                                SimulationUtil.addToRegistry((IBuildFile)buildFile, (long)value, (String)this.getDataSetNameWithMember((ProjectComponent)task, buildFile));
                            }
                            return value;
                        }
                    } else {
                        String hfsPath = this.getHFSPath(buildFile);
                        if (this.fileExistsHFS(task, hfsPath, task.getProject().getProperty("team.enterprise.build.hfs.outputdir")) && save) {
                            SimulationUtil.addToRegistry((IBuildFile)buildFile, (long)value, (String)hfsPath);
                        }
                    }
                }
                catch (ZosException zosException) {
                    // empty catch block
                }
            }
        }
        return SimulationUtil.lastModified((IBuildFile)buildFile, (boolean)save, (String)(isHFS ? this.getHFSPath(buildFile) : this.getDataSetNameWithMember((ProjectComponent)task, buildFile)));
    }

    public ILocation createLocation(String prefix) {
        ILocation location = null;
        if (prefix != null) {
            location = DataSetLocationFactory.createDataSetLocation((String)prefix);
        }
        return location;
    }

    private String getDataSetNameWithMember(ProjectComponent projectComponent, IBuildFile buildFile) {
        if (buildFile instanceof IOutputBuildFile && ((IOutputBuildFile)buildFile).isSequential()) {
            if (buildFile.getBuildFile() == null || buildFile.getBuildFile().isEmpty()) {
                return buildFile.getBuildPath();
            }
            return String.valueOf(buildFile.getBuildPath()) + "." + buildFile.getBuildFile();
        }
        String memberName = ZOS.convertMemberName(projectComponent, buildFile.getBuildFile());
        return String.valueOf(buildFile.getBuildPath()) + LEFT_PARENTHESIS + memberName + RIGHT_PARENTHESIS;
    }

    private String getDataSetNameWithMember(String buildFile, String buildPath, String sequential) {
        if (Boolean.parseBoolean(sequential)) {
            if (buildFile == null || buildFile.isEmpty()) {
                return buildPath;
            }
            return String.valueOf(buildPath) + "." + buildFile;
        }
        return String.valueOf(buildPath) + LEFT_PARENTHESIS + buildFile + RIGHT_PARENTHESIS;
    }

    private String getDataSetName(IBuildFile buildFile) {
        return buildFile.getBuildPath();
    }

    private String getMemberName(IBuildFile buildFile) {
        return buildFile.getBuildFile();
    }

    public String substituteSystemSymbols(String s) {
        String ss;
        if (!(SIMULATION_ENABLED || s == null || s.isEmpty() || s.indexOf(38) == -1 || (ss = ZUtil.substituteSystemSymbols((String)s)) == null || ss.isEmpty())) {
            return ss;
        }
        return s;
    }

    public long lastModified(Task task, IDeletedOutputFile outputFile) {
        String dataset = outputFile.getBuildPath();
        String member = outputFile.getBuildFile();
        if (dataset == null) {
            task.log("Cannot find the last modified time because dataset is NULL", 4);
            return 0L;
        }
        if (member == null) {
            task.log("Cannot find last modified time for the member of dataset(" + dataset + ") because the member is NULL", 4);
            return 0L;
        }
        if (Boolean.parseBoolean(outputFile.getSequential())) {
            task.log("Cannot find the last modified time because the member(" + member + ") in the dataset(" + dataset + ") is sequential", 4);
            return 0L;
        }
        try {
            ISPFStatistics stats = new ISPFStatistics(dataset, member);
            return stats.getModificationDate().getTime();
        }
        catch (UndefinedRecordFormatException urfe) {
            try {
                SSISupport ssi = new SSISupport(dataset, member);
                return ssi.getTimestamp();
            }
            catch (Exception e) {
                task.log((Throwable)e, 4);
            }
        }
        catch (Exception e) {
            task.log((Throwable)e, 4);
        }
        task.log("Cannot find the last modified timestamp for the member(" + member + ") in the dataset(" + dataset + ") in both ISPF and SSI");
        return 0L;
    }

    public static void staticMemoryReset() {
        singleton = null;
    }
}

