/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.build.ant.internal.utils;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class EBCDICFilterInputStream
extends FilterInputStream {
    private static final int X_FF = 255;
    private static final int LINE_FEED = 37;
    private static final int CARRIAGE_RETURN = 13;
    private static final int NEW_LINE = 21;
    private static final int HORIZONTAL_TAB = 5;
    private static final int GRAPHIC_ESCAPE = 8;
    private static final int SHIFT_IN = 15;
    private static final int SHIFT_OUT = 14;
    private static final int EBCDIC_SPACE = 64;
    private static final int PRINT_AND_SKIP_TO_CHANNEL_1 = 137;
    private static final int SKIP_TO_CHANNEL_1 = 139;
    private boolean lineBoundary = true;

    public EBCDICFilterInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        return this.convert(this.in.read());
    }

    @Override
    public int read(byte[] b) throws IOException {
        return b == null ? 0 : this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.in.read(b, off, len);
        if (n > 0) {
            int i = off;
            while (i < off + n) {
                b[i] = (byte)this.convert(b[i] & 0xFF);
                ++i;
            }
        }
        return n;
    }

    private int convert(int c) {
        if (this.lineBoundary && (c == 137 || c == 139)) {
            this.lineBoundary = false;
            return 64;
        }
        this.lineBoundary = c == 21 || c == 37;
        return c >= 64 || c == 14 || c == 15 || c == 8 || c == 5 || c == 21 || c == 13 || c == 37 ? c : 64;
    }
}

