/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.wizards;

import com.ibm.team.enterprise.systemdefinition.ui.wizards.ProjectAreaSelectionPart;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ProjectAreaSelectionPage
extends WizardPage {
    private ProjectAreaSelectionPart fPart;
    private Object fViewerInput = ConnectedProjectAreaRegistry.getDefault();
    private final List<ViewerFilter> fFilters = new ArrayList<ViewerFilter>();
    private IProcessAreaSelectionValidator fValidator;
    private final boolean fAllowArchived;

    public ProjectAreaSelectionPage(String title, String description, boolean allowArchived) {
        super(title);
        this.setTitle(title);
        this.setDescription(description);
        this.fAllowArchived = allowArchived;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getContextHelpId());
        this.fPart = new ProjectAreaSelectionPart(composite, this.fAllowArchived);
        this.fPart.setInput(this.fViewerInput);
        TreeViewer TreeViewer2 = this.fPart.getTreeViewer();
        if (!this.fFilters.isEmpty()) {
            TreeViewer2.setFilters(this.fFilters.toArray(new ViewerFilter[this.fFilters.size()]));
        }
        TreeViewer2.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IWizardContainer container = ProjectAreaSelectionPage.this.getContainer();
                if (container instanceof WizardDialog) {
                    WizardDialog dialog = (WizardDialog)container;
                    if (ProjectAreaSelectionPage.this.getWizard().canFinish()) {
                        try {
                            ProjectAreaSelectionPage.this.getWizard().performFinish();
                        }
                        finally {
                            dialog.close();
                        }
                    }
                }
            }
        });
        TreeViewer2.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean areaSelected;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object firstElement = selection.getFirstElement();
                boolean bl = areaSelected = !selection.isEmpty() && firstElement instanceof IProcessArea;
                if (ProjectAreaSelectionPage.this.fValidator != null && areaSelected) {
                    String errorMessage = ProjectAreaSelectionPage.this.fValidator.validate((IProcessArea)firstElement);
                    ProjectAreaSelectionPage.this.setErrorMessage(errorMessage);
                    ProjectAreaSelectionPage.this.setPageComplete(errorMessage == null);
                } else {
                    ProjectAreaSelectionPage.this.setPageComplete(areaSelected);
                }
            }
        });
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        this.setPageComplete(false);
    }

    public void dispose() {
        this.fPart.dispose();
        super.dispose();
    }

    public IProjectAreaHandle getSelectedProjectArea() {
        if (this.fPart.getSelectedProcessArea() != null) {
            return this.fPart.getSelectedProcessArea().getProjectArea();
        }
        return null;
    }

    public TreeViewer getViewer() {
        return this.fPart.getTreeViewer();
    }

    public void setViewerInput(Object viewerInput) {
        this.fViewerInput = viewerInput;
    }

    public void addViewerFilter(ViewerFilter filter) {
        this.fFilters.add(filter);
    }

    public void setAreaSelectionValidator(IProcessAreaSelectionValidator validator) {
        this.fValidator = validator;
    }

    public ProjectAreaSelectionPart getProjectAreaSelectionPart() {
        return this.fPart;
    }

    private String getContextHelpId() {
        return "com.ibm.team.enterprise.systemdefinition.ui.dialog_project_selection";
    }

    public static interface IProcessAreaSelectionValidator {
        public String validate(IProcessArea var1);
    }
}

