/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.wizards;

import com.ibm.team.enterprise.systemdefinition.ui.Activator;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class ProjectAreaContentProvider
implements ITreePathContentProvider,
ITreeContentProvider,
IDeferredWorkbenchAdapter {
    private TreeViewer fTreeViewer;
    private DeferredTreeContentManager fContentManager;
    private StandardLabelProvider fLabelProvider = new StandardLabelProvider(null, (IElementRemovedNotifier)new ElementRemovedNotifierImpl());
    private boolean fIncludeArchived = false;
    private final List<?> fAllChildrenFilteredItems = new ArrayList();
    private static final Object[] EMPTY = new Object[0];

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        monitor.beginTask("", 1000);
        try {
            collector.add(this.computeChildren(object, (IProgressMonitor)new SubProgressMonitor(monitor, 500)), (IProgressMonitor)new SubProgressMonitor(monitor, 500));
        }
        finally {
            monitor.done();
        }
    }

    private Object[] computeChildren(Object element, IProgressMonitor monitor) {
        Object[] children = EMPTY;
        try {
            children = this.computeConnectedProjectAreas(monitor);
        }
        catch (TeamRepositoryException e) {
            Activator.getDefault().log("Exception fetching elements from the team repository", e);
            return new Object[0];
        }
        return children;
    }

    private Object[] computeConnectedProjectAreas(IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        ArrayList<IProjectAreaHandle> repoChildren = new ArrayList<IProjectAreaHandle>();
        int i = 0;
        while (i < repos.length) {
            ITeamRepository teamRepository = repos[i];
            repoChildren.addAll(Arrays.asList(ConnectedProjectAreaRegistry.getDefault().fetchConnectedProjectAreas(teamRepository, true, this.fIncludeArchived, monitor)));
            ++i;
        }
        return repoChildren.toArray();
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        Image image = this.fLabelProvider.getImage(element);
        if (image != null) {
            return ImageDescriptor.createFromImage((Image)image);
        }
        return null;
    }

    public String getLabel(Object element) {
        String label = this.fLabelProvider.getText(element);
        if (label == null) {
            label = "parent item";
        }
        return label;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement != null) {
            return this.getChildren(inputElement);
        }
        return EMPTY;
    }

    public void dispose() {
        this.fTreeViewer = null;
        this.fContentManager = null;
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
            this.fLabelProvider = null;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fTreeViewer = (TreeViewer)viewer;
    }

    public Object[] getChildren(Object parentElement) {
        DeferredTreeContentManager contentManager = this.getContentManager();
        if (contentManager != null) {
            Object[] children = contentManager.getChildren(parentElement);
            if (children == null) {
                return EMPTY;
            }
            return children;
        }
        return new Object[]{""};
    }

    private DeferredTreeContentManager getContentManager() {
        if (this.fContentManager == null && this.fTreeViewer != null) {
            this.fContentManager = new DeferredTreeContentManager(this, (AbstractTreeViewer)this.fTreeViewer){

                protected IDeferredWorkbenchAdapter getAdapter(Object element) {
                    if (ProjectAreaContentProvider.this.hasChildren(element)) {
                        return ProjectAreaContentProvider.this;
                    }
                    return super.getAdapter(element);
                }
            };
        }
        return this.fContentManager;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof PendingUpdateAdapter) {
            return false;
        }
        return element instanceof ConnectedProjectAreaRegistry;
    }

    public Object[] getChildren(TreePath parentPath) {
        return this.getChildren(parentPath.getLastSegment());
    }

    public TreePath[] getParents(Object element) {
        return new TreePath[0];
    }

    public boolean hasChildren(TreePath path) {
        return this.hasChildren(path.getLastSegment());
    }

    public void setIncludeArchived(boolean includeArchived) {
        this.fIncludeArchived = includeArchived;
        this.fAllChildrenFilteredItems.clear();
        if (this.fTreeViewer != null) {
            this.fTreeViewer.refresh();
        }
    }
}

