/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.wizards;

import com.ibm.team.build.extensions.common.debug.DebugGroup;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.common.ui.IDialogItem;
import com.ibm.team.enterprise.common.ui.elements.DialogTextItem;
import com.ibm.team.enterprise.common.ui.util.GridTools;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.ui.wizards.AbstractImporterWizardPage;
import com.ibm.team.foundation.common.text.XMLString;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

@DebugGroup(value={"zPackaging"})
public class NewPackagingProjectWizardPage00
extends AbstractImporterWizardPage {
    private final String cls = ((Object)((Object)this)).getClass().getSimpleName();
    private final IDebugger dbg = new Debugger(((Object)((Object)this)).getClass());
    private static final String NonEmpty_Id = Messages.NewBuilderProjectWizardPage00_Error_NonEmpty_Id;
    private static final String NonEmpty_Password = Messages.NewBuilderProjectWizardPage00_Error_NonEmpty_Password;
    private static final String NonEmpty_ProjectArea = Messages.NewBuilderProjectWizardPage00_Error_NonEmpty_ProjectArea;
    private static final String NonEmpty_ProjectName = Messages.NewBuilderProjectWizardPage00_Error_NonEmpty_ProjectName;
    private static final String NonEmpty_Repository = Messages.NewBuilderProjectWizardPage00_Error_NonEmpty_Repository;
    private static final String NonEmpty_UserId = Messages.NewBuilderProjectWizardPage00_Error_NonEmpty_UserId;
    private static final int PROJECT_GROUP_LABEL_WIDTH = 120;
    private static final int PROJECT_GROUP_VALUE_WIDTH = 350;
    private static final int PRODUCT_GROUP_LABEL_WIDTH = 120;
    private static final int PRODUCT_GROUP_VALUE_WIDTH = 350;
    private static final int PROPERTY_GROUP_LABEL_WIDTH = 120;
    private static final int PROPERTY_GROUP_VALUE_WIDTH = 350;
    protected final DialogTextItem projectName = new DialogTextItem();
    protected final DialogTextItem id = new DialogTextItem();
    protected final DialogTextItem name = new DialogTextItem();
    protected final DialogTextItem description = new DialogTextItem();
    protected final DialogTextItem repository = new DialogTextItem();
    protected final DialogTextItem userId = new DialogTextItem();
    protected final DialogTextItem password = new DialogTextItem();
    protected final DialogTextItem passwordFile = new DialogTextItem();
    protected final DialogTextItem projectArea = new DialogTextItem();

    public NewPackagingProjectWizardPage00(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    public final void createControl(Composite parent) {
        Mnm mnm = new Mnm(){}.enter(this.dbg, this.cls, new String[0]);
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.team.enterprise.systemdefinition.ui.wizard_zpackaging_project");
        this.createControlProjectGroup(composite);
        this.createControlProductGroup(composite);
        this.createControlPropertyGroup(composite);
        this.setPageComplete(false);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        mnm.leave(new String[0]);
    }

    private final void createControlProjectGroup(Composite parent) {
        Mnm mnm = new Mnm(){}.enter(this.dbg, this.cls, new String[0]);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 10;
        Composite projectGroup = new Composite(parent, 0);
        projectGroup.setLayout((Layout)gridLayout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.projectName.create(projectGroup, Messages.NewPackagingProjectWizardPage00_Label_ProjectName, (Object)"", Messages.NewPackagingProjectWizardPage00_HelpLbl_ProjectName, Messages.NewPackagingProjectWizardPage00_HelpTxt_ProjectName, 120, 350);
        this.projectName.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPackagingProjectWizardPage00.this.setPageComplete(NewPackagingProjectWizardPage00.this.validate());
            }
        });
        mnm.leave(new String[0]);
    }

    private final void createControlProductGroup(Composite parent) {
        Mnm mnm = new Mnm(){}.enter(this.dbg, this.cls, new String[0]);
        GridTools.createSeparator((Composite)parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 10;
        Composite productGroup = new Composite(parent, 0);
        productGroup.setLayout((Layout)gridLayout);
        productGroup.setLayoutData((Object)new GridData(768));
        this.id.create(productGroup, Messages.NewPackagingProjectWizardPage00_Label_ProductId, (Object)"", 120, 350);
        this.id.addHelp(Messages.NewPackagingProjectWizardPage00_HelpLbl_ProductId, Messages.NewPackagingProjectWizardPage00_HelpTxt_ProductId);
        this.id.item.setTextLimit(8);
        this.id.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPackagingProjectWizardPage00.this.setPageComplete(NewPackagingProjectWizardPage00.this.validate());
            }
        });
        this.name.create(productGroup, Messages.NewPackagingProjectWizardPage00_Label_ProductName, (Object)"", 120, 350);
        this.name.addHelp(Messages.NewPackagingProjectWizardPage00_HelpLbl_ProductName, Messages.NewPackagingProjectWizardPage00_HelpTxt_ProductName);
        this.name.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPackagingProjectWizardPage00.this.setPageComplete(NewPackagingProjectWizardPage00.this.validate());
            }
        });
        this.description.create(productGroup, Messages.NewPackagingProjectWizardPage00_Label_ProductDescription, (Object)"", 120, 350, 80);
        this.description.addHelp(Messages.NewPackagingProjectWizardPage00_HelpLbl_ProductDescription, Messages.NewPackagingProjectWizardPage00_HelpTxt_ProductDescription);
        this.description.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPackagingProjectWizardPage00.this.setPageComplete(NewPackagingProjectWizardPage00.this.validate());
            }
        });
        mnm.leave(new String[0]);
    }

    private final void createControlPropertyGroup(Composite parent) {
        Mnm mnm = new Mnm(){}.enter(this.dbg, this.cls, new String[0]);
        GridTools.createSeparator((Composite)parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 10;
        Composite propertyGroup = new Composite(parent, 0);
        propertyGroup.setLayout((Layout)gridLayout);
        propertyGroup.setLayoutData((Object)new GridData(768));
        this.repository.create(propertyGroup, Messages.NewPackagingProjectWizardPage00_Label_Repository, (Object)"", 120, 350);
        this.repository.addHelp(Messages.NewPackagingProjectWizardPage00_HelpLbl_Repository, Messages.NewPackagingProjectWizardPage00_HelpTxt_Repository);
        this.repository.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPackagingProjectWizardPage00.this.setPageComplete(NewPackagingProjectWizardPage00.this.validate());
            }
        });
        this.userId.create(propertyGroup, Messages.NewPackagingProjectWizardPage00_Label_UserId, (Object)"", 120, 350);
        this.userId.addHelp(Messages.NewPackagingProjectWizardPage00_HelpLbl_UserId, Messages.NewPackagingProjectWizardPage00_HelpTxt_UserId);
        this.userId.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPackagingProjectWizardPage00.this.setPageComplete(NewPackagingProjectWizardPage00.this.validate());
            }
        });
        this.password.create(propertyGroup, Messages.NewPackagingProjectWizardPage00_Label_Password, (Object)"", 120, 350, IDialogItem.Style.PASSWORD);
        this.password.addHelp(Messages.NewPackagingProjectWizardPage00_HelpLbl_Password, Messages.NewPackagingProjectWizardPage00_HelpTxt_Password);
        this.password.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPackagingProjectWizardPage00.this.setPageComplete(NewPackagingProjectWizardPage00.this.validate());
            }
        });
        this.passwordFile.create(propertyGroup, Messages.NewPackagingProjectWizardPage00_Label_PasswordFile, (Object)"", 120, 350);
        this.passwordFile.addHelp(Messages.NewPackagingProjectWizardPage00_HelpLbl_PasswordFile, Messages.NewPackagingProjectWizardPage00_HelpTxt_PasswordFile);
        this.passwordFile.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPackagingProjectWizardPage00.this.setPageComplete(NewPackagingProjectWizardPage00.this.validate());
            }
        });
        this.projectArea.create(propertyGroup, Messages.NewPackagingProjectWizardPage00_Label_ProjectArea, (Object)"", 120, 350);
        this.projectArea.addHelp(Messages.NewPackagingProjectWizardPage00_HelpLbl_ProjectArea, Messages.NewPackagingProjectWizardPage00_HelpTxt_ProjectArea);
        this.projectArea.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPackagingProjectWizardPage00.this.setPageComplete(NewPackagingProjectWizardPage00.this.validate());
            }
        });
        mnm.leave(new String[0]);
    }

    public String getDescription() {
        return this.description == null ? "" : XMLString.createFromPlainText((String)this.description.item.getText().trim()).toString();
    }

    public String getId() {
        return this.id == null ? "" : this.id.item.getText().trim();
    }

    public String getName() {
        return this.name == null ? "" : this.name.item.getText().trim();
    }

    public String getPassword() {
        return this.password == null ? "" : this.password.item.getText().trim();
    }

    public String getPasswordFile() {
        return this.passwordFile == null ? "" : this.passwordFile.item.getText().trim();
    }

    public String getProjectArea() {
        return this.projectArea == null ? "" : this.projectArea.item.getText().trim();
    }

    public final IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public final String getProjectName() {
        return this.projectName.item == null ? "" : this.projectName.item.getText().trim();
    }

    public String getRepository() {
        return this.repository == null ? "" : this.repository.item.getText().trim();
    }

    public String getUserId() {
        return this.userId == null ? "" : this.userId.item.getText().trim();
    }

    public final boolean isPageComplete() {
        return this.validate();
    }

    public final void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.projectName.item.setFocus();
        }
    }

    public final boolean validate() {
        if (!this.validateProjectName()) {
            return false;
        }
        if (!this.validateId()) {
            return false;
        }
        if (!this.validateName()) {
            return false;
        }
        if (!this.validateDescription()) {
            return false;
        }
        if (!this.validateRepository()) {
            return false;
        }
        if (!this.validateUserId()) {
            return false;
        }
        if (!this.validatePassword()) {
            return false;
        }
        return this.validateProjectArea();
    }

    private boolean validateDescription() {
        return this.validateClear((IDialogItem)this.description);
    }

    private boolean validateId() {
        if (!this.validateNonBlank(this.id, this.getId(), NonEmpty_Id)) {
            return false;
        }
        if (!Verification.isAlphaAlphaNumeric((String)this.getId())) {
            this.setItemMessage(this.id.deco, Messages.NewPackagingProjectWizardPage00_Error_Alphanum_ProductId);
            this.setErrorMessage(Messages.NewPackagingProjectWizardPage00_Error_Alphanum_ProductId);
            this.setMessage(null);
            return false;
        }
        return this.validateClear((IDialogItem)this.id);
    }

    private boolean validateName() {
        return this.validateClear((IDialogItem)this.name);
    }

    private boolean validatePassword() {
        return this.validateNonBlank(this.password, this.getPassword(), NonEmpty_Password);
    }

    private boolean validateProjectArea() {
        return this.validateNonBlank(this.projectArea, this.getProjectArea(), NonEmpty_ProjectArea);
    }

    private boolean validateProjectName() {
        if (!this.validateNonBlank(this.projectName, this.getProjectName(), NonEmpty_ProjectName)) {
            return false;
        }
        if (this.getProjectName().indexOf(32) > -1) {
            this.setItemMessage(this.projectName.deco, Messages.NewPackagingProjectWizardPage00_Error_HasSpace_ProjectName);
            this.setErrorMessage(Messages.NewPackagingProjectWizardPage00_Error_HasSpace_ProjectName);
            this.setMessage(null);
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus nameStatus = workspace.validateName(this.getProjectName(), 4);
        if (!nameStatus.isOK()) {
            this.setItemMessage(this.projectName.deco, nameStatus.getMessage());
            this.setErrorMessage(nameStatus.getMessage());
            this.setMessage(null);
            return false;
        }
        IProject project = this.getProjectHandle();
        if (project.exists()) {
            this.setItemMessage(this.projectName.deco, Messages.NewPackagingProjectWizardPage00_Error_Original_ProjectName);
            this.setErrorMessage(Messages.NewPackagingProjectWizardPage00_Error_Original_ProjectName);
            this.setMessage(null);
            return false;
        }
        return this.validateClear((IDialogItem)this.projectName);
    }

    private boolean validateRepository() {
        return this.validateNonBlank(this.repository, this.getRepository(), NonEmpty_Repository);
    }

    private boolean validateUserId() {
        return this.validateNonBlank(this.userId, this.getUserId(), NonEmpty_UserId);
    }
}

