/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.wizards;

import com.ibm.team.build.extensions.common.debug.DebugGroup;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.enterprise.systemdefinition.client.packaging.PackagingFactory;
import com.ibm.team.enterprise.systemdefinition.client.packaging.PackagingUtilities;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLanguage;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterProperties;
import com.ibm.team.enterprise.systemdefinition.common.model.Itemtype;
import com.ibm.team.enterprise.systemdefinition.ui.ILanguageWizard;
import com.ibm.team.enterprise.systemdefinition.ui.LanguageWizardItems;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.ui.wizards.NewPackagingLanguageWizardPage00;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.plugin.AbstractUIPlugin;

@DebugGroup(value={"zPackaging"})
public class NewPackagingLanguageWizard
extends Wizard
implements IWorkbenchWizard {
    private final String cls = ((Object)((Object)this)).getClass().getSimpleName();
    private final IDebugger dbg = new Debugger(((Object)((Object)this)).getClass());
    private NewPackagingLanguageWizardPage00 page00;
    private IProject project;
    private String projectName = "";
    private Itemtype type;
    private IImporterProperties properties;
    private ILanguageWizard languageWizard;
    private Map<Object, ILanguageWizard> languageWizards;
    private List<IWizardPage> pages = new ArrayList<IWizardPage>();

    public final void init(IWorkbench workbench, IStructuredSelection selection) {
        Mnm mnm = new Mnm(){}.enter(this.dbg, this.cls, new String[0]);
        if (!selection.isEmpty() && selection.getFirstElement() instanceof IProject) {
            IProject selectedProject = (IProject)selection.getFirstElement();
            if (PackagingUtilities.isProjectValid((IProject)selectedProject)) {
                this.project = selectedProject;
                this.projectName = this.project.getName();
                this.properties = PackagingUtilities.getProjectProperties((IProject)this.project);
            } else {
                this.openErrorDialog((IStatus)new Status(1, "com.ibm.team.enterprise.systemdefinition.ui", NLS.bind((String)Messages.NewPackagingLanguageWizard_Error_Project, (Object)selectedProject.getName())));
            }
        }
        LanguageWizardItems itemInstance = LanguageWizardItems.getInstance(this.dbg);
        this.languageWizards = itemInstance.getItemMap();
        this.setWindowTitle(Messages.NewPackagingLanguageWizard_Title);
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.team.enterprise.systemdefinition.ui", (String)"icons/wizban/language_wizban.gif");
        this.setDefaultPageImageDescriptor(imageDescriptor);
        this.setHelpAvailable(true);
        mnm.leave(new String[0]);
    }

    public void addLanguagePages() {
        for (IWizardPage page : this.pages) {
            super.addPage(page);
        }
    }

    public void clearLanguagePages() {
        for (IWizardPage page : this.pages) {
            page.dispose();
        }
        this.pages = new ArrayList<IWizardPage>();
    }

    public void addPage(IWizardPage page) {
        this.pages.add(page);
    }

    public final void addPages() {
        Mnm mnm = new Mnm(){}.enter(this.dbg, this.cls, new String[0]);
        this.page00 = new NewPackagingLanguageWizardPage00(Messages.NewPackagingLanguageWizardPage00_Title);
        this.page00.setTitle(Messages.NewPackagingLanguageWizardPage00_Title);
        this.page00.setDescription(Messages.NewPackagingLanguageWizardPage00_Description);
        this.page00.setProject(this.project);
        this.page00.setProperties(this.properties);
        super.addPage((IWizardPage)this.page00);
        mnm.leave(new String[0]);
    }

    public final boolean canFinish() {
        if (this.languageWizard == null) {
            return false;
        }
        return super.canFinish();
    }

    public final ILanguageWizard getLanguageWizard() {
        return this.languageWizard;
    }

    public final Map<Object, ILanguageWizard> getLanguageWizards() {
        return this.languageWizards;
    }

    public final Itemtype getType() {
        return this.type;
    }

    public final IProject getProject() {
        return this.project;
    }

    public final String getProjectName() {
        return this.projectName;
    }

    public final IImporterProperties getProperties() {
        return this.properties;
    }

    public final void openErrorDialog(IStatus status) {
        this.openErrorDialog(null, status);
    }

    public final void openErrorDialog(Shell parent, IStatus status) {
        final ErrorDialog dialog = new ErrorDialog(parent, Messages.NewPackagingLanguageWizard_Error_Dialog_Title, Messages.NewPackagingLanguageWizard_Error_Dialog_Message, status, 7);
        dialog.setBlockOnOpen(true);
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    dialog.open();
                }
            });
        } else {
            dialog.open();
        }
    }

    public final boolean performFinish() {
        Mnm mnm = new Mnm(){}.enter(this.dbg, this.cls, new String[0]);
        final IImporterLanguage language = this.languageWizard.getLangugage();
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    PackagingFactory.createLanguageFiles((IProject)NewPackagingLanguageWizard.this.getProject(), (IImporterLanguage)language, (IProgressMonitor)monitor);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(false, false, operation);
        }
        catch (InvocationTargetException ite) {
            this.openErrorDialog((IStatus)new Status(4, "com.ibm.team.enterprise.systemdefinition.ui", ite.getTargetException().getMessage()));
            ite.printStackTrace();
        }
        catch (Exception e) {
            this.openErrorDialog((IStatus)new Status(4, "com.ibm.team.enterprise.systemdefinition.ui", e.getMessage()));
            e.printStackTrace();
        }
        mnm.leave(new String[0]);
        return true;
    }

    public final void setLanguageWizard(ILanguageWizard languageWizard) {
        this.languageWizard = languageWizard;
    }

    public final void setType(Itemtype type) {
        this.type = type;
    }

    public final void setProject(IProject project) {
        this.project = project;
    }

    public final void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public final void setProperties(IImporterProperties properties) {
        this.properties = properties;
    }
}

