/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.wizards;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.extensions.common.debug.DebugGroup;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.build.extensions.common.util.StringParser;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.internal.systemdefinition.client.ProjectArea;
import com.ibm.team.enterprise.internal.systemdefinition.client.Workspace;
import com.ibm.team.enterprise.systemdefinition.client.packaging.PackagingUtilities;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterProperties;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackgingSysoutClass;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.ItemTypeSelectionDialog;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.FetchBuildDefinitionsJob;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.JclinGenerationJob;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.SystemDefinitionJob;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.ui.util.MessagingTools;
import com.ibm.team.enterprise.systemdefinition.ui.util.RepositoryTools;
import com.ibm.team.enterprise.systemdefinition.ui.wizards.NewPackagingJclinGenWizardPage00;
import com.ibm.team.filesystem.rcp.core.internal.changes.ActiveWorkspaceManager;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.plugin.AbstractUIPlugin;

@DebugGroup(value={"zPackaging"})
public class NewPackagingJclinGenWizard
extends Wizard
implements IWorkbenchWizard {
    private final String cls = ((Object)((Object)this)).getClass().getSimpleName();
    private final IDebugger dbg = new Debugger(((Object)((Object)this)).getClass());
    private NewPackagingJclinGenWizardPage00 page00;
    private IProjectArea projectArea;
    private ITeamRepository repository;
    private IProject project;
    private String projectName = "";
    private IImporterProperties properties;
    private final List<IBuildDefinition> buildDefinitions = new LinkedList<IBuildDefinition>();
    private final List<IWorkspace> workspaces = new ArrayList<IWorkspace>();
    private IBuildDefinition buildDefinition;
    private IVersionDefinition version;
    private IWorkspace workspace;
    private IPackgingSysoutClass.SysoutClass sysoutClass;
    private boolean sortContent;
    private String jclinFolder;
    private List<String> ignoreFiles;
    private List<String> exclude;
    private List<String> include;
    private Map<String, List<String>> excludeProject;
    private Map<String, List<String>> includeProject;

    public final void init(IWorkbench workbench, IStructuredSelection selection) {
        Mnm mnm = new Mnm(){}.enter(this.dbg, this.cls, new String[0]);
        if (!selection.isEmpty() && selection.getFirstElement() instanceof IProject) {
            IProject selectedProject = (IProject)selection.getFirstElement();
            if (PackagingUtilities.isProjectValid((IProject)selectedProject)) {
                this.setProject(selectedProject);
                this.setProjectName(this.project.getName());
                this.setProperties(PackagingUtilities.getProjectProperties((IProject)this.project));
                this.setRepository();
                this.setProjectArea();
                this.setWorkspaces();
            } else {
                this.openErrorDialog((IStatus)new Status(1, "com.ibm.team.enterprise.systemdefinition.ui", NLS.bind((String)Messages.NewPackagingJclinGenWizard_Error_Project, (Object)selectedProject.getName())));
            }
        }
        this.setWindowTitle(Messages.NewPackagingJclinGenWizard_Title);
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.team.enterprise.systemdefinition.ui", (String)"icons/wizban/jclin_wizban.gif");
        this.setDefaultPageImageDescriptor(imageDescriptor);
        this.setHelpAvailable(true);
        mnm.leave(new String[0]);
    }

    public final void addPages() {
        Mnm mnm = new Mnm(){}.enter(this.dbg, this.cls, new String[0]);
        this.page00 = new NewPackagingJclinGenWizardPage00(Messages.NewPackagingJclinGenWizardPage00_Title);
        this.page00.setTitle(Messages.NewPackagingJclinGenWizardPage00_Title);
        this.page00.setDescription(Messages.NewPackagingJclinGenWizardPage00_Description);
        this.page00.setProject(this.project);
        this.page00.setProperties(this.properties);
        this.addPage((IWizardPage)this.page00);
        mnm.leave(new String[0]);
    }

    public final boolean canFinish() {
        return super.canFinish();
    }

    public final String getBuildDefinitionName() {
        return Verification.isNonNull((Object)this.buildDefinition) ? this.buildDefinition.getId() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<IBuildDefinition> getBuildDefinitions() {
        List<IBuildDefinition> list = this.buildDefinitions;
        synchronized (list) {
            return this.buildDefinitions;
        }
    }

    private final SystemDefinitionJob getFetchProjectAreaJob(final ITeamRepository repository, final String projectAreaName, final IDebugger dbg) {
        return new SystemDefinitionJob(Messages.NewPackagingJclinGenWizard_Fetch_ProjectArea, true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                IProjectArea projectArea = ProjectArea.getProjectArea((ITeamRepository)repository, (String)projectAreaName, (IDebugger)dbg);
                NewPackagingJclinGenWizard.this.setProjectArea(projectArea);
                return Status.OK_STATUS;
            }
        };
    }

    public final IProject getProject() {
        return this.project;
    }

    public final IProjectArea getProjectArea() {
        return this.projectArea;
    }

    public final String getProjectName() {
        return this.projectName;
    }

    public final IImporterProperties getProperties() {
        return this.properties;
    }

    public final ITeamRepository getRepository() {
        return this.repository;
    }

    public final String getVersionName() {
        return Verification.isNonNull((Object)this.version) ? this.version.getName() : "";
    }

    public final String getWorkspaceName() {
        return Verification.isNonNull((Object)this.workspace) ? this.workspace.getName() : "";
    }

    public final List<IWorkspace> getWorkspaces() {
        return this.workspaces;
    }

    public final void openErrorDialog(IStatus status) {
        this.openErrorDialog(null, status);
    }

    public final void openErrorDialog(Shell parent, IStatus status) {
        final ErrorDialog dialog = new ErrorDialog(parent, Messages.NewPackagingJclinGenWizard_Error_Dialog_Title, Messages.NewPackagingJclinGenWizard_Error_Dialog_Message, status, 7);
        dialog.setBlockOnOpen(true);
        if (Display.getCurrent() == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    dialog.open();
                }
            });
        } else {
            dialog.open();
        }
    }

    public final boolean performFinish() {
        Mnm mnm = new Mnm(){}.enter(this.dbg, this.cls, new String[0]);
        JclinGenerationJob job = new JclinGenerationJob(Messages.JclinGenerationJob_Title, this.repository, this.projectArea, this.getVersion(), this.getWorkspace(), this.getBuildDefinition(), this.isSortContent(), this.getJclinFolder(), this.getSysoutClass(), this.getIgnoreFiles(), this.getExclude(), this.getInclude(), this.getExcludeProject(), this.getIncludeProject(), this.dbg);
        job.setPriority(30);
        job.schedule();
        mnm.leave(new String[0]);
        return true;
    }

    public final void setBuildDefinitions(ItemTypeSelectionDialog dialog) {
        FetchBuildDefinitionsJob job = new FetchBuildDefinitionsJob(this.repository, this.projectArea, dialog, this.buildDefinitions, this.dbg);
        job.schedule();
    }

    public final void setProject(IProject project) {
        this.project = project;
    }

    public final void setProjectArea(IProjectArea projectArea) {
        this.projectArea = projectArea;
    }

    public final void setProjectArea() {
        SystemDefinitionJob job = this.getFetchProjectAreaJob(this.repository, this.getProperties().getProjectArea(), this.dbg);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.projectArea == null) {
            MessagingTools.openErrorDialog(this.getShell(), Messages.NewPackagingJclinGenWizard_Error_Title, NLS.bind((String)Messages.NewPackagingJclinGenWizard_Error_NotFound_ProjectArea, (Object)this.getProperties().getProjectArea()));
            this.performCancel();
        }
    }

    public final void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public final void setProperties(IImporterProperties properties) {
        this.properties = properties;
    }

    public final void setRepository(ITeamRepository repository) {
        this.repository = repository;
    }

    public final void setRepository() {
        ITeamRepository repository = RepositoryTools.getTeamRepository(this.getProperties().getRepositoryAddress());
        if (repository == null) {
            MessagingTools.openErrorDialog(this.getShell(), Messages.NewPackagingJclinGenWizard_Error_Title, NLS.bind((String)Messages.NewPackagingJclinGenWizard_Error_NotFound_Repository, (Object)this.getProperties().getRepositoryAddress()));
            this.performCancel();
        }
        this.repository = repository;
    }

    public final void setWorkspaces() {
        ActiveWorkspaceManager workspaceManager = ActiveWorkspaceManager.getInstance();
        Object[] workspaceHandles = workspaceManager.getActiveWorkspaces();
        if (!Verification.isNonEmpty((Object[])workspaceHandles)) {
            MessagingTools.openErrorDialog(this.getShell(), Messages.NewPackagingJclinGenWizard_Error_Title, Messages.NewPackagingJclinGenWizard_Error_NotFound_Workspace);
            return;
        }
        List workspaces = Workspace.getWorkspaces((ITeamRepository)this.repository, Arrays.asList(workspaceHandles));
        if (!Verification.isNonEmpty((List)workspaces)) {
            MessagingTools.openErrorDialog(this.getShell(), Messages.NewPackagingJclinGenWizard_Error_Title, Messages.NewPackagingJclinGenWizard_Error_NotFound_Workspace);
            return;
        }
        this.workspaces.clear();
        this.workspaces.addAll(workspaces);
    }

    public final IBuildDefinition getBuildDefinition() {
        return this.buildDefinition;
    }

    public final void setBuildDefinition(IBuildDefinition buildDefinition) {
        this.buildDefinition = buildDefinition;
    }

    public final List<String> getExclude() {
        return this.exclude;
    }

    public final Map<String, List<String>> getExcludeProject() {
        return this.excludeProject;
    }

    public final void setExclude(String exclude) {
        if (Verification.isNonBlank((String)exclude)) {
            this.excludeProject = StringParser.parseArgumentsAndOptions((String)exclude);
            this.exclude = new ArrayList<String>(this.excludeProject.keySet());
        }
    }

    public final List<String> getIgnoreFiles() {
        return this.ignoreFiles;
    }

    public final void setIgnoreFiles(String ignoreFiles) {
        if (Verification.isNonBlank((String)ignoreFiles)) {
            this.ignoreFiles = new ArrayList<String>(Arrays.asList(ignoreFiles.split(",")));
        }
    }

    public final List<String> getInclude() {
        return this.include;
    }

    public final Map<String, List<String>> getIncludeProject() {
        return this.includeProject;
    }

    public final void setInclude(String include) {
        if (Verification.isNonBlank((String)include)) {
            this.includeProject = StringParser.parseArgumentsAndOptions((String)include);
            this.include = new ArrayList<String>(this.includeProject.keySet());
        }
    }

    public final String getJclinFolder() {
        return this.jclinFolder;
    }

    public final void setJclinFolder(String jclinFolder) {
        this.jclinFolder = jclinFolder;
    }

    public final boolean getSortContent() {
        return this.sortContent;
    }

    public final boolean isSortContent() {
        return this.sortContent;
    }

    public final void setSortContent(boolean sortContent) {
        this.sortContent = sortContent;
    }

    public final IPackgingSysoutClass.SysoutClass getSysoutClass() {
        return this.sysoutClass;
    }

    public final void setSysoutClass(IPackgingSysoutClass.SysoutClass sysoutClass) {
        this.sysoutClass = sysoutClass;
    }

    public final IVersionDefinition getVersion() {
        return this.version;
    }

    public final void setVersion(IVersionDefinition version) {
        this.version = version;
    }

    public final IWorkspace getWorkspace() {
        return this.workspace;
    }

    public final void setWorkspace(IWorkspace workspace) {
        this.workspace = workspace;
    }
}

