/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.wizards;

import com.ibm.team.build.extensions.common.debug.DebugGroup;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.enterprise.common.common.ZPackagingNature;
import com.ibm.team.enterprise.common.ui.IDialogItem;
import com.ibm.team.enterprise.common.ui.elements.DialogComboItem;
import com.ibm.team.enterprise.common.ui.elements.DialogTextItem;
import com.ibm.team.enterprise.common.ui.elements.DialogTextItemBrowse;
import com.ibm.team.enterprise.common.ui.util.GridTools;
import com.ibm.team.enterprise.systemdefinition.client.packaging.PackagingUtilities;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterProperties;
import com.ibm.team.enterprise.systemdefinition.ui.Activator;
import com.ibm.team.enterprise.systemdefinition.ui.elements.ZComponentIResourceLabelProvider;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.ui.wizards.AbstractImporterWizardPage;
import com.ibm.team.enterprise.systemdefinition.ui.wizards.NewPackagingEngineWizard;
import com.ibm.team.foundation.common.text.XMLString;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

@DebugGroup(value={"zPackaging"})
public class NewPackagingEngineWizardPage00
extends AbstractImporterWizardPage {
    private final String cls = ((Object)((Object)this)).getClass().getSimpleName();
    private final IDebugger dbg = new Debugger(((Object)((Object)this)).getClass());
    private static final String NonEmpty_EngineId = Messages.NewPackagingEngineWizardPage00_Error_NonEmpty_EngineId;
    private static final String NonEmpty_ProjectName = Messages.NewPackagingEngineWizardPage00_Error_NonEmpty_ProjectName;
    private static final int PROJECT_GROUP_LABEL_WIDTH = 120;
    private static final int PROJECT_GROUP_VALUE_WIDTH = 350;
    private static final int DETAILS_GROUP_LABEL_WIDTH = 120;
    private static final int DETAILS_GROUP_VALUE_WIDTH = 350;
    protected final DialogTextItemBrowse projectName = new DialogTextItemBrowse();
    protected final DialogTextItem engineId = new DialogTextItem();
    protected final DialogTextItem engineDesc = new DialogTextItem();
    protected final DialogComboItem engineType = new DialogComboItem();
    private IProject project;
    private IImporterProperties properties;

    public NewPackagingEngineWizardPage00(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    public final void createControl(Composite parent) {
        Mnm mnm = new Mnm(){}.enter(this.dbg, this.cls, new String[0]);
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.team.enterprise.systemdefinition.ui.wizard_zpackaging_engine");
        this.createControlProjectGroup(composite);
        this.createControlDetailsGroup(composite);
        this.setProjectName();
        this.setPageComplete(false);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        mnm.leave(new String[0]);
    }

    private final void createControlProjectGroup(Composite parent) {
        Mnm mnm = new Mnm(){}.enter(this.dbg, this.cls, new String[0]);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 2;
        Composite projectGroup = new Composite(parent, 0);
        projectGroup.setLayout((Layout)gridLayout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.projectName.create(projectGroup, Messages.NewPackagingEngineWizardPage00_Label_ProjectName, (Object)this.getOurWizard().getProjectName(), Messages.NewPackagingEngineWizardPage00_HelpLbl_ProjectName, Messages.NewPackagingEngineWizardPage00_HelpTxt_ProjectName, 120, 350);
        this.projectName.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NewPackagingEngineWizardPage00.this.validateProjectName()) {
                    NewPackagingEngineWizardPage00.this.properties = PackagingUtilities.getProjectProperties((IProject)NewPackagingEngineWizardPage00.this.getProjectHandle());
                    NewPackagingEngineWizardPage00.this.getOurWizard().setProject(NewPackagingEngineWizardPage00.this.getProjectHandle());
                    NewPackagingEngineWizardPage00.this.getOurWizard().setProjectName(NewPackagingEngineWizardPage00.this.getProjectName());
                    NewPackagingEngineWizardPage00.this.getOurWizard().setProperties(NewPackagingEngineWizardPage00.this.properties);
                } else if (NewPackagingEngineWizardPage00.this.properties != null) {
                    NewPackagingEngineWizardPage00.this.properties = null;
                    NewPackagingEngineWizardPage00.this.getOurWizard().setProject(null);
                    NewPackagingEngineWizardPage00.this.getOurWizard().setProjectName(null);
                    NewPackagingEngineWizardPage00.this.getOurWizard().setProperties(null);
                }
                NewPackagingEngineWizardPage00.this.setPageComplete(NewPackagingEngineWizardPage00.this.validate());
            }
        });
        this.projectName.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(NewPackagingEngineWizardPage00.this.getShell(), (ILabelProvider)new ZComponentIResourceLabelProvider());
                dialog.setIgnoreCase(false);
                dialog.setTitle(Messages.NewPackagingEngineWizardPage00_Select_Project_Label);
                dialog.setMessage(Messages.NewPackagingEngineWizardPage00_Select_Project_Descritpion);
                dialog.setEmptyListMessage(Messages.NewPackagingEngineWizardPage00_Select_Project_Empty);
                dialog.setMultipleSelection(false);
                dialog.setElements((Object[])PackagingUtilities.getProjects());
                dialog.open();
                Object result = dialog.getFirstResult();
                if (result != null) {
                    NewPackagingEngineWizardPage00.this.projectName.item.setText(((IProject)result).getName());
                }
            }
        });
        mnm.leave(new String[0]);
    }

    private final void createControlDetailsGroup(Composite parent) {
        Mnm mnm = new Mnm(){}.enter(this.dbg, this.cls, new String[0]);
        GridTools.createSeparator((Composite)parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 2;
        Composite detailsGroup = new Composite(parent, 0);
        detailsGroup.setLayout((Layout)gridLayout);
        detailsGroup.setLayoutData((Object)new GridData(768));
        this.engineId.create(detailsGroup, Messages.NewPackagingEngineWizardPage00_Label_EngineId, (Object)"", 120, 350);
        this.engineId.addHelp(Messages.NewPackagingEngineWizardPage00_HelpLbl_EngineId, Messages.NewPackagingEngineWizardPage00_HelpTxt_EngineId);
        this.engineId.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPackagingEngineWizardPage00.this.setPageComplete(NewPackagingEngineWizardPage00.this.validate());
            }
        });
        this.engineDesc.create(detailsGroup, Messages.NewPackagingEngineWizardPage00_Label_EngineDesc, (Object)"", 120, 350);
        this.engineDesc.addHelp(Messages.NewPackagingEngineWizardPage00_HelpLbl_EngineDesc, Messages.NewPackagingEngineWizardPage00_HelpTxt_EngineDesc);
        this.engineDesc.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPackagingEngineWizardPage00.this.setPageComplete(NewPackagingEngineWizardPage00.this.validate());
            }
        });
        mnm.leave(new String[0]);
    }

    public final String getEngineDesc() {
        return this.engineDesc == null ? "" : XMLString.createFromPlainText((String)this.engineDesc.item.getText().trim()).toString();
    }

    public final String getEngineId() {
        return this.engineId == null ? "" : this.engineId.item.getText().trim();
    }

    public final NewPackagingEngineWizard getOurWizard() {
        return (NewPackagingEngineWizard)this.getWizard();
    }

    public final IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public final String getProjectName() {
        return this.projectName.item == null ? "" : this.projectName.item.getText().trim();
    }

    public final boolean isPageComplete() {
        return this.validate();
    }

    public final void setProject(IProject project) {
        this.project = project;
    }

    public final void setProjectName() {
        if (this.project != null && this.projectName.item != null) {
            this.projectName.item.setText(this.project.getName());
            this.projectName.item.setEnabled(false);
            this.projectName.browse.setEnabled(false);
        }
    }

    public final void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.projectName.item.setFocus();
        }
    }

    public final boolean validate() {
        if (!this.validateProjectName()) {
            return false;
        }
        return this.validateEngineId();
    }

    private final boolean validateEngineId() {
        if (!this.validateNonBlank(this.engineId, this.getEngineId(), NonEmpty_EngineId)) {
            return false;
        }
        if (this.getEngineId().indexOf(32) > -1) {
            this.setItemMessage(this.engineId.deco, Messages.NewPackagingEngineWizardPage00_Error_HasSpace_EngineId);
            this.setErrorMessage(Messages.NewPackagingEngineWizardPage00_Error_HasSpace_EngineId);
            this.setMessage(null);
            return false;
        }
        return this.validateClear((IDialogItem)this.engineId);
    }

    private final boolean validateProjectName() {
        if (!this.validateNonBlank(this.projectName, this.getProjectName(), NonEmpty_ProjectName)) {
            return false;
        }
        if (this.getProjectName().indexOf(32) > -1) {
            this.setItemMessage(this.projectName.deco, Messages.NewPackagingEngineWizardPage00_Error_HasSpace_ProjectName);
            this.setErrorMessage(Messages.NewPackagingEngineWizardPage00_Error_HasSpace_ProjectName);
            this.setMessage(null);
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus nameStatus = workspace.validateName(this.getProjectName(), 4);
        if (!nameStatus.isOK()) {
            this.setItemMessage(this.projectName.deco, nameStatus.getMessage());
            this.setErrorMessage(nameStatus.getMessage());
            this.setMessage(null);
            return false;
        }
        IProject project = this.getProjectHandle();
        if (!project.exists()) {
            this.setItemMessage(this.projectName.deco, Messages.NewPackagingEngineWizardPage00_Error_NotExist_ProjectName);
            this.setErrorMessage(Messages.NewPackagingEngineWizardPage00_Error_NotExist_ProjectName);
            this.setMessage(null);
            return false;
        }
        try {
            if (project.hasNature(ZPackagingNature.ID)) {
                this.setItemMessage(this.projectName.deco, Messages.NewPackagingEngineWizardPage00_Error_NotValid_ProjectName);
                this.setErrorMessage(Messages.NewPackagingEngineWizardPage00_Error_NotValid_ProjectName);
                this.setMessage(null);
                return false;
            }
        }
        catch (CoreException ce) {
            Activator.log(ce);
            this.setItemMessage(this.projectName.deco, Messages.NewPackagingEngineWizardPage00_Error_External_ProjectName);
            this.setErrorMessage(Messages.NewPackagingEngineWizardPage00_Error_External_ProjectName);
            this.setMessage(null);
            return false;
        }
        return this.validateClear((IDialogItem)this.projectName);
    }
}

