/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.wizards;

import com.ibm.team.build.extensions.common.debug.DebugGroup;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.common.ui.IDialogItem;
import com.ibm.team.enterprise.common.ui.elements.DialogTextItem;
import com.ibm.team.enterprise.common.ui.util.GridTools;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.ui.wizards.AbstractImporterWizardPage;
import com.ibm.team.foundation.common.text.XMLString;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

@DebugGroup(value={"zBuilder"})
public class NewBuilderProjectWizardPage00
extends AbstractImporterWizardPage {
    private final String cls = ((Object)((Object)this)).getClass().getSimpleName();
    private final IDebugger dbg = new Debugger(((Object)((Object)this)).getClass());
    private static final String NonEmpty_Id = Messages.NewBuilderProjectWizardPage00_Error_NonEmpty_Id;
    private static final String NonEmpty_Password = Messages.NewBuilderProjectWizardPage00_Error_NonEmpty_Password;
    private static final String NonEmpty_ProjectArea = Messages.NewBuilderProjectWizardPage00_Error_NonEmpty_ProjectArea;
    private static final String NonEmpty_ProjectName = Messages.NewBuilderProjectWizardPage00_Error_NonEmpty_ProjectName;
    private static final String NonEmpty_Repository = Messages.NewBuilderProjectWizardPage00_Error_NonEmpty_Repository;
    private static final String NonEmpty_UserId = Messages.NewBuilderProjectWizardPage00_Error_NonEmpty_UserId;
    private static final int PROJECT_GROUP_LABEL_WIDTH = 120;
    private static final int PROJECT_GROUP_VALUE_WIDTH = 350;
    private static final int SPECIFY_GROUP_LABEL_WIDTH = 120;
    private static final int SPECIFY_GROUP_VALUE_WIDTH = 350;
    private static final int PROPERTY_GROUP_LABEL_WIDTH = 120;
    private static final int PROPERTY_GROUP_VALUE_WIDTH = 350;
    private final DialogTextItem projectName = new DialogTextItem();
    private final DialogTextItem id = new DialogTextItem();
    private final DialogTextItem name = new DialogTextItem();
    private final DialogTextItem description = new DialogTextItem();
    private final DialogTextItem repository = new DialogTextItem();
    private final DialogTextItem userId = new DialogTextItem();
    private final DialogTextItem password = new DialogTextItem();
    private final DialogTextItem passwordFile = new DialogTextItem();
    private final DialogTextItem projectArea = new DialogTextItem();
    private boolean started;
    private FormToolkit toolkit;

    public NewBuilderProjectWizardPage00(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    public final void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.team.enterprise.systemdefinition.ui.wizard_zbuilder_project");
    }

    public final void createControl(Composite parent) {
        Mnm mnm = new Mnm(){}.enter(this.dbg, this.cls, new String[0]);
        Listener[] listeners = this.getShell().getListeners(28);
        if (listeners.length > 1) {
            this.getShell().removeListener(28, listeners[1]);
        }
        this.toolkit = new FormToolkit(Display.getDefault());
        this.toolkit.setBackground(null);
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.team.enterprise.systemdefinition.ui.wizard_zbuilder_project");
        this.createControlProjectGroup(composite);
        this.createControlSpecifyGroup(composite);
        this.createControlPropertyGroup(composite);
        this.setPageComplete(false);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        mnm.leave(new String[0]);
    }

    private void createControlProjectGroup(Composite parent) {
        Mnm mnm = new Mnm(){}.enter(this.dbg, this.cls, new String[0]);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 10;
        Composite projectGroup = new Composite(parent, 0);
        projectGroup.setLayout((Layout)gridLayout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.projectName.create(projectGroup, Messages.NewBuilderProjectWizardPage00_Label_ProjectName, (Object)"", 120, 350);
        this.projectName.addHelp(Messages.NewBuilderProjectWizardPage00_HelpLbl_ProjectName, Messages.NewBuilderProjectWizardPage00_HelpTxt_ProjectName, (DialogPage)this);
        this.projectName.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewBuilderProjectWizardPage00.this.setPageComplete(NewBuilderProjectWizardPage00.this.validate());
            }
        });
        mnm.leave(new String[0]);
    }

    private void createControlSpecifyGroup(Composite parent) {
        Mnm mnm = new Mnm(){}.enter(this.dbg, this.cls, new String[0]);
        GridTools.createSeparator((Composite)parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 10;
        Composite specifyGroup = new Composite(parent, 0);
        specifyGroup.setLayout((Layout)gridLayout);
        specifyGroup.setLayoutData((Object)new GridData(768));
        this.id.create(specifyGroup, Messages.NewBuilderProjectWizardPage00_Label_Id, (Object)"", 120, 350);
        this.id.addHelp(Messages.NewBuilderProjectWizardPage00_HelpLbl_Id, Messages.NewBuilderProjectWizardPage00_HelpTxt_Id);
        this.id.item.setTextLimit(8);
        this.id.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewBuilderProjectWizardPage00.this.setPageComplete(NewBuilderProjectWizardPage00.this.validate());
            }
        });
        this.name.create(specifyGroup, Messages.NewBuilderProjectWizardPage00_Label_Name, (Object)"", 120, 350);
        this.name.addHelp(Messages.NewBuilderProjectWizardPage00_HelpLbl_Name, Messages.NewBuilderProjectWizardPage00_HelpTxt_Name);
        this.name.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewBuilderProjectWizardPage00.this.setPageComplete(NewBuilderProjectWizardPage00.this.validate());
            }
        });
        this.description.create(specifyGroup, Messages.NewBuilderProjectWizardPage00_Label_Description, (Object)"", 120, 350, 80);
        this.description.addHelp(Messages.NewBuilderProjectWizardPage00_HelpLbl_Description, Messages.NewBuilderProjectWizardPage00_HelpTxt_Description);
        this.description.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewBuilderProjectWizardPage00.this.setPageComplete(NewBuilderProjectWizardPage00.this.validate());
            }
        });
        mnm.leave(new String[0]);
    }

    private void createControlPropertyGroup(Composite parent) {
        Mnm mnm = new Mnm(){}.enter(this.dbg, this.cls, new String[0]);
        GridTools.createSeparator((Composite)parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 10;
        Composite propertyGroup = new Composite(parent, 0);
        propertyGroup.setLayout((Layout)gridLayout);
        propertyGroup.setLayoutData((Object)new GridData(768));
        this.repository.create(propertyGroup, Messages.NewBuilderProjectWizardPage00_Label_Repository, (Object)"", 120, 350);
        this.repository.addHelp(Messages.NewBuilderProjectWizardPage00_HelpLbl_Repository, Messages.NewBuilderProjectWizardPage00_HelpTxt_Repository);
        this.repository.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewBuilderProjectWizardPage00.this.setPageComplete(NewBuilderProjectWizardPage00.this.validate());
            }
        });
        this.userId.create(propertyGroup, Messages.NewBuilderProjectWizardPage00_Label_UserId, (Object)"", 120, 350);
        this.userId.addHelp(Messages.NewBuilderProjectWizardPage00_HelpLbl_UserId, Messages.NewBuilderProjectWizardPage00_HelpTxt_UserId);
        this.userId.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewBuilderProjectWizardPage00.this.setPageComplete(NewBuilderProjectWizardPage00.this.validate());
            }
        });
        this.password.create(propertyGroup, Messages.NewBuilderProjectWizardPage00_Label_Password, (Object)"", 120, 350, IDialogItem.Style.PASSWORD);
        this.password.addHelp(Messages.NewBuilderProjectWizardPage00_HelpLbl_Password, Messages.NewBuilderProjectWizardPage00_HelpTxt_Password);
        this.password.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewBuilderProjectWizardPage00.this.setPageComplete(NewBuilderProjectWizardPage00.this.validate());
            }
        });
        this.passwordFile.create(propertyGroup, Messages.NewBuilderProjectWizardPage00_Label_PasswordFile, (Object)"", 120, 350);
        this.passwordFile.addHelp(Messages.NewBuilderProjectWizardPage00_HelpLbl_PasswordFile, Messages.NewBuilderProjectWizardPage00_HelpTxt_PasswordFile);
        this.passwordFile.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewBuilderProjectWizardPage00.this.setPageComplete(NewBuilderProjectWizardPage00.this.validate());
            }
        });
        this.projectArea.create(propertyGroup, Messages.NewBuilderProjectWizardPage00_Label_ProjectArea, (Object)"", 120, 350);
        this.projectArea.addHelp(Messages.NewBuilderProjectWizardPage00_HelpLbl_ProjectArea, Messages.NewBuilderProjectWizardPage00_HelpTxt_ProjectArea);
        this.projectArea.item.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewBuilderProjectWizardPage00.this.setPageComplete(NewBuilderProjectWizardPage00.this.validate());
            }
        });
        mnm.leave(new String[0]);
    }

    public final boolean canFlipToNextPage() {
        if (!this.isStarted()) {
            this.setStarted();
            return false;
        }
        return this.isPageComplete();
    }

    public final String GetDescription() {
        return this.description.item == null ? "" : XMLString.createFromPlainText((String)this.description.item.getText().trim()).toString();
    }

    public final String getId() {
        return this.id.item == null ? "" : this.id.item.getText().trim();
    }

    public final String GetName() {
        return this.name.item == null ? "" : this.name.item.getText().trim();
    }

    public final String getPassword() {
        return this.password.item == null ? "" : this.password.item.getText().trim();
    }

    public final String getPasswordFile() {
        return this.passwordFile.item == null ? "" : this.passwordFile.item.getText().trim();
    }

    public final String getProjectArea() {
        return this.projectArea.item == null ? "" : this.projectArea.item.getText().trim();
    }

    public final IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public final String getProjectName() {
        return this.projectName.item == null ? "" : this.projectName.item.getText().trim();
    }

    public final String getRepository() {
        return this.repository.item == null ? "" : this.repository.item.getText().trim();
    }

    public final String getUserId() {
        return this.userId.item == null ? "" : this.userId.item.getText().trim();
    }

    public final boolean isPageComplete() {
        if (!this.isStarted()) {
            return false;
        }
        return this.validate();
    }

    public final boolean isStarted() {
        return this.started;
    }

    public final boolean setStarted() {
        this.started = true;
        return true;
    }

    public final void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.projectName.item.setFocus();
        }
    }

    public final boolean validate() {
        if (!this.validateProjectName()) {
            return false;
        }
        if (!this.validateId()) {
            return false;
        }
        if (!this.validateName()) {
            return false;
        }
        if (!this.validateDescription()) {
            return false;
        }
        if (!this.validateRepository()) {
            return false;
        }
        if (!this.validateUserId()) {
            return false;
        }
        if (!this.validatePassword()) {
            return false;
        }
        return this.validateProjectArea();
    }

    private boolean validateDescription() {
        return this.validateClear((IDialogItem)this.description);
    }

    private boolean validateId() {
        if (!this.validateNonBlank(this.id, this.getId(), NonEmpty_Id)) {
            return false;
        }
        if (!Verification.isAlphaAlphaNumeric((String)this.getId())) {
            this.setItemMessage(this.id.deco, Messages.NewBuilderProjectWizardPage00_Error_Alphanum_Id);
            this.setErrorMessage(Messages.NewBuilderProjectWizardPage00_Error_Alphanum_Id);
            this.setMessage(null);
            return false;
        }
        return this.validateClear((IDialogItem)this.id);
    }

    private boolean validateName() {
        return this.validateClear((IDialogItem)this.name);
    }

    private boolean validatePassword() {
        return this.validateNonBlank(this.password, this.getPassword(), NonEmpty_Password);
    }

    private boolean validateProjectArea() {
        return this.validateNonBlank(this.projectArea, this.getProjectArea(), NonEmpty_ProjectArea);
    }

    private boolean validateProjectName() {
        if (!this.validateNonBlank(this.projectName, this.getProjectName(), NonEmpty_ProjectName)) {
            return false;
        }
        if (this.getProjectName().indexOf(32) > -1) {
            this.setItemMessage(this.projectName.deco, Messages.NewBuilderProjectWizardPage00_Error_HasSpace_ProjectName);
            this.setErrorMessage(Messages.NewBuilderProjectWizardPage00_Error_HasSpace_ProjectName);
            this.setMessage(null);
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus nameStatus = workspace.validateName(this.getProjectName(), 4);
        if (!nameStatus.isOK()) {
            this.setItemMessage(this.projectName.deco, nameStatus.getMessage());
            this.setErrorMessage(nameStatus.getMessage());
            this.setMessage(null);
            return false;
        }
        IProject project = this.getProjectHandle();
        if (project.exists()) {
            this.setItemMessage(this.projectName.deco, Messages.NewBuilderProjectWizardPage00_Error_Original_ProjectName);
            this.setErrorMessage(Messages.NewBuilderProjectWizardPage00_Error_Original_ProjectName);
            this.setMessage(null);
            return false;
        }
        return this.validateClear((IDialogItem)this.projectName);
    }

    private boolean validateRepository() {
        return this.validateNonBlank(this.repository, this.getRepository(), NonEmpty_Repository);
    }

    private boolean validateUserId() {
        return this.validateNonBlank(this.userId, this.getUserId(), NonEmpty_UserId);
    }
}

