/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.wizards;

import com.ibm.team.enterprise.systemdefinition.client.mapping.ISystemDefinitionMappingClient;
import com.ibm.team.enterprise.systemdefinition.common.mapping.ISystemDefinitionMapping;
import com.ibm.team.enterprise.systemdefinition.common.mapping.ISystemDefinitionMappingPair;
import com.ibm.team.enterprise.systemdefinition.common.mapping.SystemDefinitionMappingParser;
import com.ibm.team.enterprise.systemdefinition.ui.Activator;
import com.ibm.team.enterprise.systemdefinition.ui.editors.SystemDefinitionMappingEditorInput;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.ui.wizards.ImportSystemDefinitionMappingPage;
import com.ibm.team.repository.client.ITeamRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ImportSystemDefinitionMappingWizard
extends Wizard
implements IExportWizard {
    private ImportSystemDefinitionMappingPage page1;
    private IWorkbench workbench;

    public ImportSystemDefinitionMappingWizard() {
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(Activator.imageDescriptorFromPlugin((String)"com.ibm.team.enterprise.systemdefinition.ui", (String)"icons/wizban/sysdef_import_wiz.png"));
    }

    public boolean performFinish() {
        boolean error = false;
        final ITeamRepository repository = this.page1.getTeamRepository();
        try {
            final boolean isOverwrite = this.page1.isOverwrite();
            final List<String> types = this.page1.getAvailableTypes();
            final String filename = this.page1.getFile();
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask("", 100);
                    ISystemDefinitionMappingClient client = (ISystemDefinitionMappingClient)repository.getClientLibrary(ISystemDefinitionMappingClient.class);
                    if (!client.hasPermission()) {
                        throw new InvocationTargetException(null, Messages.ImportSystemDefinitionMappingPage_NO_PERMISSION);
                    }
                    int numWork = 100 / types.size();
                    try {
                        String xmlContent = ImportSystemDefinitionMappingWizard.this.readFromFile(new File(filename));
                        List mappings = new SystemDefinitionMappingParser().parse(xmlContent, types);
                        if (mappings == null || mappings.isEmpty()) {
                            throw new Exception(NLS.bind((String)Messages.ImportSystemDefinitionMappingPage_ERROR_NO_MAPPING, (Object)filename));
                        }
                        for (ISystemDefinitionMapping mapping : mappings) {
                            ISystemDefinitionMapping existingMapping = client.getSystemDefinitionMapping(mapping.getType(), (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)numWork));
                            if (existingMapping != null && existingMapping.getPairs().size() > 0) {
                                List pairs = existingMapping.getPairs();
                                for (ISystemDefinitionMappingPair newPair : mapping.getPairs()) {
                                    boolean skip = false;
                                    int index = existingMapping.indexOf(newPair.getSrcUUID(), newPair.getSrcName());
                                    if (index > -1) {
                                        boolean bl = skip = !isOverwrite;
                                        if (!skip) {
                                            pairs.remove(index);
                                        }
                                    }
                                    if (skip) continue;
                                    pairs.add(newPair);
                                }
                                client.save(existingMapping, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)numWork));
                                continue;
                            }
                            client.save(mapping, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)numWork));
                        }
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            error = true;
            if (e.getTargetException() != null) {
                MessageDialog.openError((Shell)this.workbench.getActiveWorkbenchWindow().getShell(), (String)Messages.SystemDefinitionMappingDialogSelection_ERROR_TITLE, (String)e.getTargetException().getLocalizedMessage());
            } else {
                MessageDialog.openError((Shell)this.workbench.getActiveWorkbenchWindow().getShell(), (String)Messages.SystemDefinitionMappingDialogSelection_ERROR_TITLE, (String)e.getLocalizedMessage());
            }
        }
        catch (Exception e) {
            error = true;
            MessageDialog.openError((Shell)this.workbench.getActiveWorkbenchWindow().getShell(), (String)Messages.SystemDefinitionMappingDialogSelection_ERROR_TITLE, (String)e.getLocalizedMessage());
        }
        if (!error) {
            try {
                SystemDefinitionMappingEditorInput input = new SystemDefinitionMappingEditorInput(repository);
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, input.getEditorId());
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
    }

    public void addPages() {
        this.page1 = new ImportSystemDefinitionMappingPage();
        this.addPage((IWizardPage)this.page1);
    }

    private String readFromFile(File file) throws IOException {
        StringBuffer fileContent = new StringBuffer();
        FileInputStream is = new FileInputStream(file);
        InputStreamReader isr = new InputStreamReader((InputStream)is, "UTF-8");
        char[] buffer = new char[256];
        int bytesRead = isr.read(buffer);
        while (bytesRead != -1) {
            fileContent.append(new String(buffer, 0, bytesRead));
            bytesRead = isr.read(buffer);
        }
        isr.close();
        return fileContent.toString();
    }
}

