/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.wizards;

import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ImportSystemDefinitionMappingPage
extends WizardPage {
    private TableViewer repositoryViewer;
    private Text fileField;
    private Button overwriteButton;
    private final List<String> availableTypes;

    protected ImportSystemDefinitionMappingPage() {
        super("ExportSystemDefinitionMappingPage");
        this.setTitle(Messages.ImportSystemDefinitionMappingPage_TITLE);
        this.setDescription(Messages.ImportSystemDefinitionMappingPage_DESC);
        this.availableTypes = new ArrayList<String>();
        this.availableTypes.add(IResourceDefinition.ITEM_TYPE.getName());
        this.availableTypes.add(ILanguageDefinition.ITEM_TYPE.getName());
        this.availableTypes.add(ITranslator.ITEM_TYPE.getName());
        this.availableTypes.add(ISearchPath.ITEM_TYPE.getName());
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
        Label label = new Label(composite, 16384);
        label.setText(Messages.ImportSystemDefinitionMappingPage_REPOSITORY_LABEL);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)label);
        Table table = new Table(composite, 68356);
        this.repositoryViewer = new TableViewer(table);
        this.repositoryViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.repositoryViewer.setLabelProvider((IBaseLabelProvider)new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
        this.repositoryViewer.setInput((Object)TeamPlatform.getTeamRepositoryService().getTeamRepositories());
        GridDataFactory.fillDefaults().grab(true, true).span(3, 1).applyTo((Control)this.repositoryViewer.getTable());
        this.repositoryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ImportSystemDefinitionMappingPage.this.validate();
            }
        });
        if (this.repositoryViewer.getTable().getItemCount() > 0) {
            this.repositoryViewer.getTable().select(0);
        }
        label = new Label(composite, 16384);
        label.setText(Messages.ImportSystemDefinitionMappingPage_FILE_LABEL);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)label);
        label = new Label(composite, 16384);
        label.setText(Messages.ExportSystemDefinitionMappingPage_XML_FILE_LABEL);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.fileField = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fileField);
        this.fileField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportSystemDefinitionMappingPage.this.validate();
            }
        });
        final Button browseBtn = new Button(composite, 8);
        browseBtn.setText(Messages.ExportSystemDefinitionMappingPage_BROWSE_LABEL);
        browseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(browseBtn.getShell(), 4096);
                fileDialog.setText(Messages.ImportSystemDefinitionMappingPage_BROWSE_FILE_DESC);
                String exportFile = ImportSystemDefinitionMappingPage.this.fileField.getText();
                if (exportFile != null) {
                    fileDialog.setFilterPath(new Path(exportFile).removeLastSegments(1).toOSString());
                    fileDialog.setFileName(exportFile);
                }
                fileDialog.setFilterExtensions(new String[]{"*.xml", "*"});
                String result = fileDialog.open();
                if (result != null) {
                    ImportSystemDefinitionMappingPage.this.fileField.setText(result);
                }
            }
        });
        this.overwriteButton = new Button(composite, 32);
        this.overwriteButton.setText(Messages.ImportSystemDefinitionMappingPage_OVERWRITE);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, false).applyTo((Control)this.overwriteButton);
        this.setControl((Control)composite);
        this.validate();
    }

    private void validate() {
        if (this.repositoryViewer != null && this.getTeamRepository() == null) {
            this.setErrorMessage(Messages.ImportSystemDefinitionMappingPage_ERROR_NO_REPO_SELECTED);
            this.setPageComplete(false);
            return;
        }
        if (this.fileField != null && (this.fileField.getText() == null || this.fileField.getText().equals("") || !new File(this.fileField.getText()).exists())) {
            this.setErrorMessage(Messages.ImportSystemDefinitionMappingPage_ERROR_FILE_INVALID);
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public ITeamRepository getTeamRepository() {
        if (this.repositoryViewer.getSelection().isEmpty()) {
            return null;
        }
        return (ITeamRepository)((IStructuredSelection)this.repositoryViewer.getSelection()).getFirstElement();
    }

    public String getFile() {
        return this.fileField.getText();
    }

    public boolean isOverwrite() {
        return this.overwriteButton.getSelection();
    }

    public List<String> getAvailableTypes() {
        return this.availableTypes;
    }
}

