/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.wizards;

import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.mapping.ISystemDefinitionMappingPair;
import com.ibm.team.enterprise.systemdefinition.common.mapping.SystemDefinitionMappingParser;
import com.ibm.team.enterprise.systemdefinition.common.mapping.impl.SystemDefinitionMapping;
import com.ibm.team.enterprise.systemdefinition.common.mapping.impl.SystemDefinitionMappingPair;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.enterprise.systemdefinition.ui.Activator;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.ui.wizards.ExportSystemDefinitionMappingPage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportSystemDefinitionMappingWizard
extends Wizard
implements IExportWizard {
    private ExportSystemDefinitionMappingPage page1;
    private IWorkbench workbench;

    public ExportSystemDefinitionMappingWizard() {
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(Activator.imageDescriptorFromPlugin((String)"com.ibm.team.enterprise.systemdefinition.ui", (String)"icons/wizban/sysdef_export_wiz.png"));
    }

    public boolean performFinish() {
        boolean error = false;
        try {
            final ITeamRepository repository = this.page1.getTeamRepository();
            final List<String> types = this.page1.getSelectedTypes();
            final String destinationFile = this.page1.getDestination();
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask("", 100);
                    ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)repository.getClientLibrary(ISystemDefinitionModelClient.class);
                    int numWork = 100 / types.size();
                    ArrayList<SystemDefinitionMapping> mappings = new ArrayList<SystemDefinitionMapping>();
                    try {
                        for (String type : types) {
                            IItemType newType = SystemDefinitionUtil.getTypeFromName((String)type);
                            if (newType != null) {
                                SystemDefinitionMapping mapping = new SystemDefinitionMapping(type);
                                List handles = client.findSystemDefinitions(newType, null, -1, false, Arrays.asList(ISystemDefinition.NAME_PROPERTY), null);
                                for (ISystemDefinition handle : handles) {
                                    SystemDefinitionMappingPair pair = new SystemDefinitionMappingPair(handle.getItemId(), handle.getName(), null, null);
                                    mapping.addPair((ISystemDefinitionMappingPair)pair);
                                }
                                if (mapping.getPairs().size() > 0) {
                                    mappings.add(mapping);
                                }
                            } else {
                                Activator.log(NLS.bind((String)"Unable to find item type to map {0}", (Object)type));
                            }
                            monitor.worked(numWork);
                        }
                        ExportSystemDefinitionMappingWizard.this.writeToFile(new SystemDefinitionMappingParser().toXML(mappings), new File(destinationFile));
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            error = true;
            if (e.getTargetException() != null) {
                MessageDialog.openError((Shell)this.workbench.getActiveWorkbenchWindow().getShell(), (String)Messages.SystemDefinitionMappingDialogSelection_ERROR_TITLE, (String)e.getTargetException().getLocalizedMessage());
            } else {
                MessageDialog.openError((Shell)this.workbench.getActiveWorkbenchWindow().getShell(), (String)Messages.SystemDefinitionMappingDialogSelection_ERROR_TITLE, (String)e.getLocalizedMessage());
            }
        }
        catch (Exception e) {
            error = true;
            MessageDialog.openError((Shell)this.workbench.getActiveWorkbenchWindow().getShell(), (String)Messages.SystemDefinitionMappingDialogSelection_ERROR_TITLE, (String)e.getLocalizedMessage());
        }
        return !error;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
    }

    public void addPages() {
        this.page1 = new ExportSystemDefinitionMappingPage();
        this.addPage((IWizardPage)this.page1);
    }

    private void writeToFile(String content, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        osw.write(content);
        osw.flush();
        osw.close();
    }
}

