/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.wizards;

import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.ui.util.TypeLabelProvider;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ExportSystemDefinitionMappingPage
extends WizardPage {
    private CheckboxTableViewer typeViewer;
    private final List<String> exportTypes;
    private TableViewer repositoryViewer;
    private Text destinationField;

    protected ExportSystemDefinitionMappingPage() {
        super("ExportSystemDefinitionMappingPage");
        this.setTitle(Messages.ExportSystemDefinitionMappingPage_TITLE);
        this.setDescription(Messages.ExportSystemDefinitionMappingPage_DESC);
        this.exportTypes = new ArrayList<String>();
        this.exportTypes.add(IResourceDefinition.ITEM_TYPE.getName());
        this.exportTypes.add(ILanguageDefinition.ITEM_TYPE.getName());
        this.exportTypes.add(ITranslator.ITEM_TYPE.getName());
        this.exportTypes.add(ISearchPath.ITEM_TYPE.getName());
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
        Label label = new Label(composite, 16384);
        label.setText(Messages.ExportSystemDefinitionMappingPage_REPOSITORY_LABEL);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)label);
        Table table = new Table(composite, 68356);
        this.repositoryViewer = new TableViewer(table);
        this.repositoryViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.repositoryViewer.setLabelProvider((IBaseLabelProvider)new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
        this.repositoryViewer.setInput((Object)TeamPlatform.getTeamRepositoryService().getTeamRepositories());
        GridDataFactory.fillDefaults().grab(true, true).span(3, 1).applyTo((Control)this.repositoryViewer.getTable());
        this.repositoryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExportSystemDefinitionMappingPage.this.validate();
            }
        });
        if (this.repositoryViewer.getTable().getItemCount() == 1) {
            this.repositoryViewer.getTable().select(0);
        }
        label = new Label(composite, 16384);
        label.setText(Messages.ExportSystemDefinitionMappingPage_TYPE_LABEL);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)label);
        this.typeViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridDataFactory.fillDefaults().grab(true, true).span(3, 1).applyTo((Control)this.typeViewer.getTable());
        this.typeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.typeViewer.setLabelProvider((IBaseLabelProvider)new TypeLabelProvider());
        this.typeViewer.setInput(this.exportTypes);
        this.typeViewer.setAllChecked(true);
        this.typeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExportSystemDefinitionMappingPage.this.validate();
            }
        });
        label = new Label(composite, 16384);
        label.setText(Messages.ExportSystemDefinitionMappingPage_DESTINATION_LABEL);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)label);
        label = new Label(composite, 16384);
        label.setText(Messages.ExportSystemDefinitionMappingPage_XML_FILE_LABEL);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.destinationField = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.destinationField);
        this.destinationField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportSystemDefinitionMappingPage.this.validate();
            }
        });
        final Button browseBtn = new Button(composite, 8);
        browseBtn.setText(Messages.ExportSystemDefinitionMappingPage_BROWSE_LABEL);
        browseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(browseBtn.getShell(), 8192);
                fileDialog.setText(Messages.ExportSystemDefinitionMappingPage_BROWSE_FILE_DESC);
                String exportFile = ExportSystemDefinitionMappingPage.this.destinationField.getText();
                if (exportFile != null) {
                    fileDialog.setFilterPath(new Path(exportFile).removeLastSegments(1).toOSString());
                    fileDialog.setFileName(exportFile);
                }
                fileDialog.setFilterExtensions(new String[]{"*.xml", "*"});
                String result = fileDialog.open();
                if (result != null) {
                    ExportSystemDefinitionMappingPage.this.destinationField.setText(ExportSystemDefinitionMappingPage.this.appendExtension(result));
                }
            }
        });
        this.setControl((Control)composite);
        this.validate();
    }

    private void validate() {
        if (this.typeViewer != null && this.typeViewer.getCheckedElements().length == 0) {
            this.setErrorMessage(Messages.ExportSystemDefinitionMappingPage_ERROR_NO_TYPE_SELECTED);
            this.setPageComplete(false);
            return;
        }
        if (this.repositoryViewer != null && this.getTeamRepository() == null) {
            this.setErrorMessage(Messages.ExportSystemDefinitionMappingPage_ERROR_NO_REPO_SELECTED);
            this.setPageComplete(false);
            return;
        }
        if (this.destinationField != null && (this.destinationField.getText() == null || this.destinationField.getText().equals(""))) {
            this.setErrorMessage(Messages.ExportSystemDefinitionMappingPage_ERROR_DESTINATION_INVALID);
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public List<String> getSelectedTypes() {
        ArrayList<String> checkedTypes = new ArrayList<String>();
        Object[] objectArray = this.typeViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            checkedTypes.add((String)object);
            ++n2;
        }
        return checkedTypes;
    }

    public ITeamRepository getTeamRepository() {
        if (this.repositoryViewer.getSelection().isEmpty()) {
            return null;
        }
        return (ITeamRepository)((IStructuredSelection)this.repositoryViewer.getSelection()).getFirstElement();
    }

    private String appendExtension(String file) {
        if (file.lastIndexOf(".") == -1) {
            return String.valueOf(file) + ".xml";
        }
        return file;
    }

    public String getDestination() {
        return this.appendExtension(this.destinationField.getText());
    }
}

