/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.wizards;

import com.ibm.team.enterprise.common.common.utils.StringMatcher;
import com.ibm.team.enterprise.common.ui.util.Utils;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.enterprise.systemdefinition.ui.Activator;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.LanguageDefinitionSelectionDialog;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IMetadataProperties;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IChangePropertiesOperation;
import com.ibm.team.internal.filesystem.ui.adapters.AbstractAdaptableRemoteResource;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class AssignLanguageDefinitionWizard
extends Wizard {
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private LanguageDefinitionSelectionAndFilterPage fLanguageDefinitionPage;
    private SummaryPage fSummaryPage;
    private BrowsePage fBrowsePage;
    private IStructuredSelection fSelection;
    private List<IShareable> fFiles;
    private static final String PATTERN_DELIMITER = ",";
    private static final String DEFAULT_EXCLUDE_FILTERS = "*/.*,*.properties,*.xml";
    private List<StringMatcher> fIncludeFilters;
    private List<StringMatcher> fExcludeFilters;
    private IItemType type;
    private Map<UUID, ISystemDefinition> _cache;

    public AssignLanguageDefinitionWizard(IWorkbench workbench) {
        this.setWindowTitle(Messages.AssignLanguageDefinitionWizard_TITLE);
        this.setNeedsProgressMonitor(true);
    }

    public void setSelection(IStructuredSelection selection) {
        this.fSelection = selection;
        try {
            this.type = !selection.isEmpty() && (selection.getFirstElement() instanceof IResource && com.ibm.team.enterprise.systemdefinition.ui.helper.Utils.isInZComponentProject(selection.getFirstElement()) || com.ibm.team.enterprise.systemdefinition.ui.helper.Utils.isZFile(selection.getFirstElement())) ? IZosLanguageDefinition.ITEM_TYPE : IIBMiLanguageDefinition.ITEM_TYPE;
        }
        catch (CoreException e) {
            this.type = IIBMiLanguageDefinition.ITEM_TYPE;
        }
    }

    public void addPages() {
        this.fLanguageDefinitionPage = new LanguageDefinitionSelectionAndFilterPage();
        this.addPage((IWizardPage)this.fLanguageDefinitionPage);
        this.fBrowsePage = new BrowsePage();
        this.addPage((IWizardPage)this.fBrowsePage);
        this.fSummaryPage = new SummaryPage();
        this.addPage((IWizardPage)this.fSummaryPage);
    }

    public boolean performFinish() {
        block6: {
            if (!this.fLanguageDefinitionPage.fBrowseFilesButton.getSelection()) break block6;
            this.fFiles = this.fBrowsePage.gatherCheckedShareableFiles();
            this.updateLanguageDefinitionProperty();
            return true;
        }
        try {
            this.fFiles = this.extractSelectedShareableFiles((IProgressMonitor)new NullProgressMonitor());
            this.updateLanguageDefinitionProperty();
            return true;
        }
        catch (FileSystemException e) {
            Activator.log(e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredTitle, (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredDescription);
        }
        catch (CoreException e) {
            Activator.log(e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredTitle, (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredDescription);
        }
        catch (InvocationTargetException e) {
            Activator.log(e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredTitle, (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredDescription);
        }
        catch (InterruptedException e) {
            Activator.log(e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredTitle, (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredDescription);
        }
        return false;
    }

    private void updateLanguageDefinitionProperty() throws InvocationTargetException, InterruptedException {
        this.getContainer().run(true, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor progress) throws InvocationTargetException, InterruptedException {
                progress.beginTask(Messages.AssignLanguageDefinitionWizard_PROGRESS_MESSAGE, AssignLanguageDefinitionWizard.this.fFiles.size());
                for (IShareable shareable : AssignLanguageDefinitionWizard.this.fFiles) {
                    try {
                        IChangePropertiesOperation operation = IOperationFactory.instance.getChangePropertiesOperation(new ChangePropertiesDilemmaHandler());
                        IMetadataProperties metadataProperties = shareable.getMetadataProperties(null);
                        Map currentProperties = metadataProperties.getCurrentProperties();
                        HashMap<String, String> newProperties = new HashMap<String, String>();
                        newProperties.putAll(currentProperties);
                        newProperties.put("team.enterprise.language.definition", ((AssignLanguageDefinitionWizard)AssignLanguageDefinitionWizard.this).fLanguageDefinitionPage.fLanguageDefinitionUUID);
                        operation.setProperties(shareable, newProperties);
                        operation.run(null);
                        progress.worked(1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                progress.done();
            }
        });
    }

    private List<StringMatcher> createFilters(String patternString) {
        ArrayList<StringMatcher> filters = new ArrayList<StringMatcher>();
        if (patternString != null) {
            StringTokenizer t = new StringTokenizer(patternString, PATTERN_DELIMITER);
            while (t.hasMoreElements()) {
                filters.add(new StringMatcher(this.stripBackSlashAtBeginning(t.nextToken()), true, false));
            }
        }
        return filters;
    }

    private List<IShareable> extractSelectedShareableFiles(IProgressMonitor monitor) throws FileSystemException, CoreException {
        if (this.fLanguageDefinitionPage.fIncludeExcludeFilterButton.getSelection()) {
            this.fIncludeFilters = this.createFilters(this.fLanguageDefinitionPage.fIncludeFilterField.getText());
            this.fExcludeFilters = this.createFilters(this.fLanguageDefinitionPage.fExcludeFilterField.getText());
        }
        ArrayList<IShareable> shared = new ArrayList<IShareable>(this.fSelection.size());
        List selList = this.fSelection.toList();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)selList.size());
        for (Object obj : selList) {
            if (!(obj instanceof IAdaptable)) continue;
            this.extractShareableFilesFromResource((IAdaptable)obj, shared, progress);
        }
        return shared;
    }

    private List<IProject> extractSelectedShareableProjects(IProgressMonitor monitor) throws FileSystemException, CoreException {
        ArrayList<IProject> selectedSharedProjects = new ArrayList<IProject>(this.fSelection.size());
        List selList = this.fSelection.toList();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)selList.size());
        for (Object obj : selList) {
            this.extractShareableProjectsFromResource((IResource)obj, selectedSharedProjects, progress);
        }
        return selectedSharedProjects;
    }

    private void extractShareableFilesFromResource(IAdaptable resource, List<IShareable> shared, SubMonitor progress) throws FileSystemException, CoreException {
        IMetadataProperties metadataProperties;
        String langDefUUID;
        if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                this.extractShareableFilesFromResource((IAdaptable)child, shared, progress);
                ++n2;
            }
            return;
        }
        IShareable shareable = this.getShareable(resource);
        if (shareable == null || shareable.getShare((IProgressMonitor)progress.newChild(1)) == null) {
            return;
        }
        String shareablePath = this.stripBackSlashAtBeginning(shareable.getLocalPath().toString());
        if (this.fLanguageDefinitionPage.fIncludeExcludeFilterButton.getSelection()) {
            boolean isMatch;
            boolean bl = isMatch = this.isFiltered(shareablePath, this.fIncludeFilters) && !this.isFiltered(shareablePath, this.fExcludeFilters);
            if (!isMatch) {
                return;
            }
        }
        if (resource instanceof IResource && com.ibm.team.enterprise.systemdefinition.ui.helper.Utils.isZComponentProject(((IResource)resource).getProject()) && !com.ibm.team.enterprise.systemdefinition.ui.helper.Utils.isZFile(resource)) {
            return;
        }
        if (this.fLanguageDefinitionPage.fExcludeAssignedButton.getSelection() && (langDefUUID = (String)(metadataProperties = shareable.getMetadataProperties(null)).getCurrentProperties().get("team.enterprise.language.definition")) != null && !langDefUUID.trim().equals("")) {
            return;
        }
        if (!shared.contains(shareable)) {
            shared.add(shareable);
        }
    }

    private void extractShareableProjectsFromResource(IResource resource, List<IProject> sharedProjects, SubMonitor progress) throws FileSystemException, CoreException {
        IShareable shareable = null;
        IProject project = resource.getProject();
        shareable = (IShareable)project.getAdapter(IShareable.class);
        if (shareable == null || shareable.getShare((IProgressMonitor)progress.newChild(1)) == null) {
            return;
        }
        if (!sharedProjects.contains(project)) {
            sharedProjects.add(project);
        }
    }

    private IShareable getShareable(IAdaptable adaptable) {
        if (adaptable == null) {
            return null;
        }
        IShareable shareable = (IShareable)adaptable.getAdapter(IShareable.class);
        if (shareable != null) {
            return shareable;
        }
        AbstractAdaptableRemoteResource aarr = (AbstractAdaptableRemoteResource)adaptable.getAdapter(AbstractAdaptableRemoteResource.class);
        if (aarr != null && (shareable = (IShareable)aarr.getAdapter(IShareable.class)) != null) {
            return shareable;
        }
        shareable = (IShareable)aarr.getAdapter(IShareable.class);
        if (shareable != null) {
            return shareable;
        }
        return null;
    }

    private boolean isFiltered(String fileName, List<StringMatcher> filters) {
        for (StringMatcher filter : filters) {
            if (!filter.match(fileName)) continue;
            return true;
        }
        return false;
    }

    private boolean isHiddenResource(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getName().trim().startsWith(".");
        }
        return false;
    }

    private String stripBackSlashAtBeginning(String path) {
        if (path != null && path.startsWith("/") && path.length() > 1) {
            return path.substring(1);
        }
        return path;
    }

    private class BrowsePage
    extends WizardPage
    implements ICheckStateListener {
        private CheckboxTreeViewer fBrowseTreeViewer;
        private BrowseTreeContentProvider fContentProvider;
        private String fLanguageDefinitionName;

        protected BrowsePage() {
            super(Messages.AssignLanguageDefinitionWizard_BrowsePage_PAGETITLE);
            this.setTitle(Messages.AssignLanguageDefinitionWizard_BrowsePage_TITLE);
            this.setDescription(NLS.bind((String)Messages.AssignLanguageDefinitionWizard_BrowsePage_DESCRIPTION, (Object)""));
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setFont(parent.getFont());
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(768));
            ((GridData)label.getLayoutData()).horizontalSpan = 2;
            label.setText(Messages.AssignLanguageDefinitionWizard_BrowsePage_Table_Description);
            this.fBrowseTreeViewer = new CheckboxTreeViewer(composite, 2048);
            this.fBrowseTreeViewer.setLabelProvider((IBaseLabelProvider)new CurrentAssignedLangdefLabelProvider());
            this.fContentProvider = new BrowseTreeContentProvider();
            this.fBrowseTreeViewer.setContentProvider((IContentProvider)this.fContentProvider);
            this.fBrowseTreeViewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    block4: {
                        if (!AssignLanguageDefinitionWizard.this.isHiddenResource(element)) break block4;
                        return false;
                    }
                    try {
                        if (SystemDefinitionUtil.isTypeOf((IItemType)AssignLanguageDefinitionWizard.this.type, (IItemType)IZosLanguageDefinition.ITEM_TYPE)) {
                            return com.ibm.team.enterprise.systemdefinition.ui.helper.Utils.isZFileOrZFileContainer(element);
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    return true;
                }
            }});
            this.fBrowseTreeViewer.addCheckStateListener((ICheckStateListener)this);
            int NUM_COLUMNS = 2;
            GridDataFactory.fillDefaults().grab(true, true).hint(150, 150).applyTo((Control)this.fBrowseTreeViewer.getTree());
            Composite buttons = this.createButtonComposite(composite);
            GridLayoutFactory.fillDefaults().generateLayout(buttons);
            GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(composite);
            this.setControl((Control)composite);
        }

        private Composite createButtonComposite(Composite composite) {
            Composite buttons = new Composite(composite, 0);
            Button selectAllButton = new Button(buttons, 8);
            selectAllButton.setText(Messages.AssignLanguageDefinitionWizard_BrowsePage_SelectAllLabel);
            selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object[] elements;
                    BrowsePage.this.fBrowseTreeViewer.setGrayedElements(new Object[0]);
                    Object[] objectArray = elements = BrowsePage.this.fContentProvider.getElements("root");
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        BrowsePage.this.fBrowseTreeViewer.setSubtreeChecked(element, true);
                        ++n2;
                    }
                    BrowsePage.this.setPageComplete(true);
                }
            });
            Button deselectAllButton = new Button(buttons, 8);
            deselectAllButton.setText(Messages.AssignLanguageDefinitionWizard_BrowsePage_DeselectAllLabel);
            deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BrowsePage.this.fBrowseTreeViewer.setGrayedElements(new Object[0]);
                    BrowsePage.this.fBrowseTreeViewer.setCheckedElements(new Object[0]);
                    BrowsePage.this.setPageComplete(false);
                }
            });
            new Label(buttons, 0);
            Button selectAllUnassignedButton = new Button(buttons, 8);
            selectAllUnassignedButton.setText(Messages.AssignLanguageDefinitionWizard_BrowsePage_SelectAllUnassigned);
            selectAllUnassignedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        BrowsePage.this.checkAllUnassignedElements();
                    }
                    catch (Exception e1) {
                        Activator.log(e1);
                        MessageDialog.openError((Shell)BrowsePage.this.getShell(), (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredTitle, (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredDescription);
                    }
                }
            });
            return buttons;
        }

        protected void checkAllUnassignedElements() throws Exception {
            Object[] elements;
            Object[] objectArray = elements = this.fContentProvider.getElements("root");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.checkUnassigned(element);
                ++n2;
            }
        }

        private void checkUnassigned(Object element) throws Exception {
            if (element instanceof IFile) {
                IShareable shareable = (IShareable)((IFile)element).getAdapter(IShareable.class);
                IMetadataProperties metadataProperties = shareable.getMetadataProperties(null);
                String langDefUUID = (String)metadataProperties.getCurrentProperties().get("team.enterprise.language.definition");
                if (langDefUUID == null || langDefUUID.trim().equals("")) {
                    this.fBrowseTreeViewer.setChecked(element, true);
                    this.updateCheckedState(element, true);
                }
            } else {
                IResource[] iResourceArray = ((IContainer)element).members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    this.checkUnassigned(member);
                    ++n2;
                }
            }
        }

        public void updateProjectSelection(final List<IProject> projects, final String langDefLabel) {
            this.fLanguageDefinitionName = langDefLabel;
            if (this.fBrowseTreeViewer.getInput() == null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BrowsePage.this.setDescription(NLS.bind((String)Messages.AssignLanguageDefinitionWizard_BrowsePage_DESCRIPTION, (Object)langDefLabel));
                        BrowsePage.this.fContentProvider.setRootProjects(projects);
                        BrowsePage.this.fBrowseTreeViewer.setInput((Object)"root");
                    }
                });
            }
            this.setPageComplete(this.fBrowseTreeViewer.getCheckedElements().length > 0);
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            boolean isChecked = event.getChecked();
            Object element = event.getElement();
            this.updateCheckedState(element, isChecked);
        }

        private void updateCheckedState(Object element, boolean isChecked) {
            this.updateElementAndChildren(element, isChecked);
            this.updateAncestors(((IResource)element).getParent(), isChecked, false);
            int count = this.fBrowseTreeViewer.getCheckedElements().length;
            this.setPageComplete(count > 0);
        }

        private void updateElementAndChildren(Object element, boolean check) {
            this.fBrowseTreeViewer.setGrayed(element, false);
            this.fBrowseTreeViewer.setChecked(element, check);
            Object[] objectArray = ((BrowseTreeContentProvider)this.fBrowseTreeViewer.getContentProvider()).getChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.updateElementAndChildren(child, check);
                ++n2;
            }
        }

        private void updateAncestors(Object element, boolean check, boolean gray) {
            if (element == null) {
                return;
            }
            if (gray) {
                check = true;
            } else {
                Object[] objectArray = ((BrowseTreeContentProvider)this.fBrowseTreeViewer.getContentProvider()).getChildren(element);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (this.fBrowseTreeViewer.getGrayed(child) || check != this.fBrowseTreeViewer.getChecked(child)) {
                        check = true;
                        gray = true;
                        break;
                    }
                    ++n2;
                }
            }
            this.fBrowseTreeViewer.setChecked(element, check);
            this.fBrowseTreeViewer.setGrayed(element, gray);
            this.updateAncestors(((IResource)element).getParent(), check, gray);
        }

        public IWizardPage getNextPage() {
            AssignLanguageDefinitionWizard.this.fSummaryPage.updateSummary(this.gatherCheckedShareableFiles(), this.fLanguageDefinitionName);
            return AssignLanguageDefinitionWizard.this.fSummaryPage;
        }

        private List<IShareable> gatherCheckedShareableFiles() {
            Object[] checkedElements;
            ArrayList<IShareable> files = new ArrayList<IShareable>();
            Object[] objectArray = checkedElements = this.fBrowseTreeViewer.getCheckedElements();
            int n = checkedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IFile) {
                    files.add((IShareable)((IFile)element).getAdapter(IShareable.class));
                }
                ++n2;
            }
            return files;
        }

        class BrowseTreeContentProvider
        implements ITreeContentProvider {
            private List<IProject> fRootProjects;

            BrowseTreeContentProvider() {
            }

            public void setRootProjects(List<IProject> rootProjects) {
                this.fRootProjects = rootProjects;
            }

            public Object[] getChildren(Object element) {
                if (element instanceof IFile) {
                    return new Object[0];
                }
                if (element instanceof IContainer) {
                    try {
                        return ((IContainer)element).members();
                    }
                    catch (CoreException e) {
                        Activator.log(e);
                        MessageDialog.openError((Shell)BrowsePage.this.getShell(), (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredTitle, (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredDescription);
                    }
                }
                return null;
            }

            public Object getParent(Object element) {
                return ((IResource)element).getParent();
            }

            public boolean hasChildren(Object element) {
                return !(element instanceof IFile);
            }

            public Object[] getElements(Object element) {
                if (this.fRootProjects != null) {
                    return this.fRootProjects.toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            }
        }
    }

    class CurrentAssignedLangdefLabelProvider
    extends LabelProvider {
        private Image fProjectImage;
        private Image fFolderImage;
        private Image fFileImage;

        CurrentAssignedLangdefLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IShareable || element instanceof IFile) {
                IShareable shareable = element instanceof IFile ? (IShareable)((IFile)element).getAdapter(IShareable.class) : (IShareable)element;
                String path = shareable.getLocalPath().toString();
                try {
                    IMetadataProperties metadataProperties = shareable.getMetadataProperties(null);
                    String langDefUUID = (String)metadataProperties.getCurrentProperties().get("team.enterprise.language.definition");
                    if (langDefUUID != null && !langDefUUID.trim().equals("")) {
                        IShare share = shareable.getShare(null);
                        ISharingDescriptor desc = share.getSharingDescriptor();
                        ITeamRepository repository = Utils.getTeamRepository((ISharingDescriptor)desc);
                        ISystemDefinition langdef = this.getLanguageDefinition(UUID.valueOf((String)langDefUUID), repository);
                        path = langdef != null ? String.valueOf(path) + " (" + langdef.getName() + ")" : String.valueOf(path) + " (" + Messages.AbstractSystemDefinitionEditor_MISSING + ")";
                    }
                    return path;
                }
                catch (Exception e) {
                    return path;
                }
            }
            if (element instanceof IResource) {
                return ((IResource)element).getName();
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            if (element instanceof IFile) {
                if (this.fFileImage == null) {
                    this.fFileImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
                }
                return this.fFileImage;
            }
            if (element instanceof IFolder) {
                if (this.fFolderImage == null) {
                    this.fFolderImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
                return this.fFolderImage;
            }
            if (element instanceof IProject) {
                if (this.fProjectImage == null) {
                    this.fProjectImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
                }
                return this.fProjectImage;
            }
            return null;
        }

        private ISystemDefinition getLanguageDefinition(UUID uuid, final ITeamRepository repository) throws Exception {
            if (AssignLanguageDefinitionWizard.this._cache == null) {
                Future<Map<UUID, ISystemDefinition>> future = Executors.newSingleThreadExecutor().submit(new Callable<Map<UUID, ISystemDefinition>>(){

                    @Override
                    public Map<UUID, ISystemDefinition> call() throws Exception {
                        ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)repository.getClientLibrary(ISystemDefinitionModelClient.class);
                        List sysDefs = client.findSystemDefinitions(AssignLanguageDefinitionWizard.this.type, null, -1, true, null, null);
                        HashMap<UUID, ISystemDefinition> cache = new HashMap<UUID, ISystemDefinition>();
                        for (ISystemDefinition systemDefinition : sysDefs) {
                            cache.put(systemDefinition.getItemId(), systemDefinition);
                        }
                        return cache;
                    }
                });
                AssignLanguageDefinitionWizard.this._cache = future.get();
            }
            return (ISystemDefinition)AssignLanguageDefinitionWizard.this._cache.get(uuid);
        }
    }

    private class LanguageDefinitionSelectionAndFilterPage
    extends WizardPage {
        Text fLanguageDefinitionField;
        String fLanguageDefinitionUUID;
        Button fApplyAllButton;
        Button fIncludeExcludeFilterButton;
        Button fBrowseFilesButton;
        Text fIncludeFilterField;
        Text fExcludeFilterField;
        Button fExcludeAssignedButton;

        protected LanguageDefinitionSelectionAndFilterPage() {
            super(Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_PAGETITLE);
            this.setTitle(Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_TITLE);
            this.setDescription(Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_DESCRIPTION);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setFont(parent.getFont());
            this.initializeDialogUnits((Control)parent);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(1808));
            Composite subGroup = new Composite(composite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            subGroup.setLayout((Layout)layout);
            subGroup.setLayoutData((Object)new GridData(768));
            this.createLanguageDefinitionGroup(subGroup);
            this.createFilterGroup(subGroup);
            this.createExcludeAlreadyAssignedGroup(subGroup);
            this.setPageComplete(this.validate());
            this.setControl((Control)composite);
        }

        private ITeamRepository getTeamRepository() {
            for (IAdaptable resource : AssignLanguageDefinitionWizard.this.fSelection) {
                ITeamRepository repository = this.getTeamRepository(resource);
                if (repository == null) continue;
                return repository;
            }
            return null;
        }

        private ITeamRepository getTeamRepository(IAdaptable adaptable) {
            IShare share;
            block8: {
                IShareable shareable;
                block7: {
                    try {
                        IResource resource;
                        if (adaptable.getAdapter(IResource.class) != null && ((resource = (IResource)adaptable.getAdapter(IResource.class)).getType() == 4 || resource.getType() == 2)) {
                            IResource[] children;
                            IResource[] iResourceArray = children = ((IContainer)resource).members();
                            int n = children.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IResource child = iResourceArray[n2];
                                ITeamRepository repository = this.getTeamRepository((IAdaptable)child);
                                if (repository != null) {
                                    return repository;
                                }
                                ++n2;
                            }
                        }
                        if ((shareable = AssignLanguageDefinitionWizard.this.getShareable(adaptable)) != null) break block7;
                        return null;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                share = shareable.getShare(null);
                if (share != null) break block8;
                return null;
            }
            ISharingDescriptor desc = share.getSharingDescriptor();
            return Utils.getTeamRepository((ISharingDescriptor)desc);
        }

        private final void createLanguageDefinitionGroup(Composite subGroup) {
            Label label = new Label(subGroup, 0);
            label.setText(Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_LANGUAGE_DEFINITION_LABEL);
            this.fLanguageDefinitionField = new Text(subGroup, 2048);
            GridData data = new GridData(768);
            data.widthHint = 250;
            this.fLanguageDefinitionField.setLayoutData((Object)data);
            this.fLanguageDefinitionField.setFont(subGroup.getFont());
            this.fLanguageDefinitionField.setEditable(false);
            Button button = new Button(subGroup, 0);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        ISystemDefinition langDef;
                        ITeamRepository repository = LanguageDefinitionSelectionAndFilterPage.this.getTeamRepository();
                        LanguageDefinitionSelectionDialog dialog = new LanguageDefinitionSelectionDialog(LanguageDefinitionSelectionAndFilterPage.this.getShell(), repository, null, false, AssignLanguageDefinitionWizard.this.type);
                        if (dialog.open() == 0 && (langDef = (ISystemDefinition)dialog.getFirstResult()) != null) {
                            LanguageDefinitionSelectionAndFilterPage.this.fLanguageDefinitionUUID = langDef.getItemId().getUuidValue();
                            LanguageDefinitionSelectionAndFilterPage.this.fLanguageDefinitionField.setText(langDef.getName());
                            AssignLanguageDefinitionWizard.this.fLanguageDefinitionPage.setPageComplete(LanguageDefinitionSelectionAndFilterPage.this.validate());
                            LanguageDefinitionSelectionAndFilterPage.this.getWizard().getContainer().updateButtons();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
            button.setText(Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_BROWSE_LABEL);
        }

        private final void createExcludeAlreadyAssignedGroup(Composite subGroup) {
            this.fExcludeAssignedButton = new Button(subGroup, 32);
            this.fExcludeAssignedButton.setSelection(true);
            this.fExcludeAssignedButton.setText(Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_EXCLUDE_ASSIGNED_LABEL);
            GridData data = new GridData(768);
            data.horizontalSpan = 3;
            this.fExcludeAssignedButton.setLayoutData((Object)data);
        }

        private final void createFilterGroup(Composite subGroup) {
            Label label = new Label(subGroup, 64);
            label.setText("");
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            label.setLayoutData((Object)gridData);
            Group applyGroup = new Group(subGroup, 0);
            GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)applyGroup);
            applyGroup.setText(Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_FILTER_GROUP_LABEL);
            GridLayoutFactory.fillDefaults().numColumns(1).applyTo((Composite)applyGroup);
            this.fApplyAllButton = this.createRadioButton((Composite)applyGroup, Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_APPLY_ALL_LABEL, 16400);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fApplyAllButton);
            this.fIncludeExcludeFilterButton = this.createRadioButton((Composite)applyGroup, Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_INCLUDE_FILTER_LABEL, 16400);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fIncludeExcludeFilterButton);
            Composite includeExcludeComposite = new Composite((Composite)applyGroup, 0);
            GridDataFactory.fillDefaults().indent(15, -1).grab(true, true).applyTo((Control)includeExcludeComposite);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(includeExcludeComposite);
            label = new Label(includeExcludeComposite, 16384);
            label.setText(Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_INCLUDE_PATTERN_LABEL);
            GridDataFactory.fillDefaults().applyTo((Control)label);
            this.fIncludeFilterField = new Text(includeExcludeComposite, 2052);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fIncludeFilterField);
            this.fIncludeFilterField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AssignLanguageDefinitionWizard.this.fLanguageDefinitionPage.setPageComplete(LanguageDefinitionSelectionAndFilterPage.this.validate());
                    LanguageDefinitionSelectionAndFilterPage.this.getWizard().getContainer().updateButtons();
                }
            });
            this.fIncludeFilterField.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_INCLUDE_FILTER_LABEL;
                }
            });
            label = new Label(includeExcludeComposite, 16384);
            label.setText(Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_EXCLUDE_PATTERN_LABEL);
            GridDataFactory.fillDefaults().applyTo((Control)label);
            this.fExcludeFilterField = new Text(includeExcludeComposite, 2052);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fExcludeFilterField);
            this.fExcludeFilterField.setText(AssignLanguageDefinitionWizard.DEFAULT_EXCLUDE_FILTERS);
            this.fExcludeFilterField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AssignLanguageDefinitionWizard.this.fLanguageDefinitionPage.setPageComplete(LanguageDefinitionSelectionAndFilterPage.this.validate());
                    LanguageDefinitionSelectionAndFilterPage.this.getWizard().getContainer().updateButtons();
                }
            });
            this.fExcludeFilterField.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_EXCLUDE_FILTER_LABEL;
                }
            });
            label = new Label(includeExcludeComposite, 16384);
            label = new Label(includeExcludeComposite, 16384);
            label.setText(Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_PATTERN_LABEL);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
            this.fBrowseFilesButton = this.createRadioButton((Composite)applyGroup, Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_BROWSE_FILES_LABEL, 16400);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fBrowseFilesButton);
            this.fApplyAllButton.setSelection(true);
            this.handleRadioUpdate(false);
        }

        private Button createRadioButton(Composite parent, String label, int style) {
            Button radioButton = new Button(parent, style);
            radioButton.setText(label);
            radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LanguageDefinitionSelectionAndFilterPage.this.handleRadioUpdate(true);
                }
            });
            return radioButton;
        }

        private void handleRadioUpdate(boolean wizardInitialized) {
            this.fIncludeFilterField.setEnabled(this.fIncludeExcludeFilterButton.getSelection());
            this.fExcludeFilterField.setEnabled(this.fIncludeExcludeFilterButton.getSelection());
            AssignLanguageDefinitionWizard.this.fLanguageDefinitionPage.setPageComplete(this.validate());
            if (wizardInitialized) {
                this.getWizard().getContainer().updateButtons();
                if (this.fBrowseFilesButton.getSelection()) {
                    this.fExcludeAssignedButton.setSelection(false);
                    this.fExcludeAssignedButton.setEnabled(false);
                } else {
                    this.fExcludeAssignedButton.setEnabled(true);
                }
            }
        }

        private boolean validate() {
            if (AssignLanguageDefinitionWizard.this.fLanguageDefinitionPage != null) {
                if (((AssignLanguageDefinitionWizard)AssignLanguageDefinitionWizard.this).fLanguageDefinitionPage.fLanguageDefinitionField.getText().equals("")) {
                    return false;
                }
                if (((AssignLanguageDefinitionWizard)AssignLanguageDefinitionWizard.this).fLanguageDefinitionPage.fIncludeExcludeFilterButton.getSelection() && ((AssignLanguageDefinitionWizard)AssignLanguageDefinitionWizard.this).fLanguageDefinitionPage.fIncludeFilterField.getText().equals("") && ((AssignLanguageDefinitionWizard)AssignLanguageDefinitionWizard.this).fLanguageDefinitionPage.fExcludeFilterField.getText().equals("")) {
                    return false;
                }
            }
            return true;
        }

        public IWizardPage getNextPage() {
            if (this.fBrowseFilesButton.getSelection()) {
                try {
                    AssignLanguageDefinitionWizard.this.fBrowsePage.updateProjectSelection(AssignLanguageDefinitionWizard.this.extractSelectedShareableProjects((IProgressMonitor)new NullProgressMonitor()), this.fLanguageDefinitionField.getText());
                }
                catch (Exception e) {
                    Activator.log(e);
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredTitle, (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredDescription);
                }
                return AssignLanguageDefinitionWizard.this.fBrowsePage;
            }
            try {
                AssignLanguageDefinitionWizard.this.fSummaryPage.updateSummary(AssignLanguageDefinitionWizard.this.extractSelectedShareableFiles((IProgressMonitor)new NullProgressMonitor()), this.fLanguageDefinitionField.getText());
                AssignLanguageDefinitionWizard.this.fBrowsePage.setPageComplete(true);
            }
            catch (Exception e) {
                Activator.log(e);
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredTitle, (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredDescription);
            }
            return AssignLanguageDefinitionWizard.this.fSummaryPage;
        }
    }

    private class SummaryPage
    extends WizardPage {
        private Table matchBox;
        private TableViewer fSummaryTableViewer;

        protected SummaryPage() {
            super(Messages.AssignLanguageDefinitionWizard_SummaryPage_PAGETITLE);
            this.setTitle(Messages.AssignLanguageDefinitionWizard_SummaryPage_TITLE);
            this.setDescription(NLS.bind((String)Messages.AssignLanguageDefinitionWizard_SummaryPage_DESCRIPTION, (Object)""));
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setFont(parent.getFont());
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(768));
            label.setText(Messages.AssignLanguageDefinitionWizard_SummaryPage_Table_Description);
            this.matchBox = new Table(composite, 2048);
            GridData data = new GridData(1808);
            data.heightHint = 50;
            data.horizontalSpan = 1;
            this.matchBox.setLayoutData((Object)data);
            this.fSummaryTableViewer = new TableViewer(this.matchBox);
            this.fSummaryTableViewer.setContentProvider((IContentProvider)new ListContentProvider());
            this.fSummaryTableViewer.setLabelProvider((IBaseLabelProvider)new CurrentAssignedLangdefLabelProvider());
            this.setPageComplete(true);
            this.setControl((Control)composite);
        }

        public void updateSummary(final List<IShareable> files, final String langDefLabel) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SummaryPage.this.setDescription(NLS.bind((String)Messages.AssignLanguageDefinitionWizard_SummaryPage_DESCRIPTION, (Object)langDefLabel));
                    SummaryPage.this.matchBox.removeAll();
                    if (files.size() == 0) {
                        TableItem tableItem = new TableItem(SummaryPage.this.matchBox, 0);
                        tableItem.setText(Messages.AssignLanguageDefinitionWizard_SummaryPage_NO_MATCHES);
                    } else {
                        SummaryPage.this.fSummaryTableViewer.setInput((Object)files);
                    }
                }
            });
        }

        class ListContentProvider
        implements IStructuredContentProvider {
            ListContentProvider() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }
    }
}

