/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.wizards;

import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionWizard;
import com.ibm.team.enterprise.systemdefinition.ui.wizards.ProjectAreaSelectionPage;
import com.ibm.team.process.common.IProjectAreaHandle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class AbstractSystemDefinitionWizard
extends Wizard
implements ISystemDefinitionWizard {
    private IWizardPage[] fCustomWizardPages = null;
    private ProjectAreaSelectionPage fProjectAreaSelectionPage;
    private IWorkbenchPage fPage;

    protected abstract String getDefinitionPluginID();

    protected abstract String getDefinitionWizardTitle();

    protected abstract String getDefinitionWizardImagePath();

    protected abstract IWizardPage[] getDefinitionWizardPages();

    protected abstract Action getDefinitionWizardAction(IProjectAreaHandle var1);

    public AbstractSystemDefinitionWizard() {
        this.setWindowTitle(this.getDefinitionWizardTitle());
        this.setDefaultPageImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)this.getDefinitionPluginID(), (String)this.getDefinitionWizardImagePath()));
    }

    public void addPages() {
        IWizardPage[] customPages = this.getDefinitionWizardPages();
        if (customPages != null) {
            IWizardPage[] iWizardPageArray = customPages;
            int n = customPages.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage p = iWizardPageArray[n2];
                this.addPage(p);
                ++n2;
            }
            this.fCustomWizardPages = customPages;
        } else {
            this.fProjectAreaSelectionPage = this.getProjectAreaSelectionPage();
            this.addPage((IWizardPage)this.fProjectAreaSelectionPage);
        }
    }

    protected ProjectAreaSelectionPage getProjectAreaSelectionPage() {
        if (this.fProjectAreaSelectionPage == null) {
            this.fProjectAreaSelectionPage = new ProjectAreaSelectionPage("Jazz Project Area", "Select a project area for the new translator.", false);
        }
        return this.fProjectAreaSelectionPage;
    }

    public boolean canFinish() {
        boolean wizardComplete = true;
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.fProjectAreaSelectionPage && !this.fProjectAreaSelectionPage.isPageComplete()) {
            wizardComplete = false;
        }
        if (this.fCustomWizardPages != null) {
            IWizardPage[] iWizardPageArray = this.fCustomWizardPages;
            int n = this.fCustomWizardPages.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage p = iWizardPageArray[n2];
                if (currentPage == p) {
                    wizardComplete = wizardComplete && p.isPageComplete();
                }
                ++n2;
            }
        }
        return wizardComplete;
    }

    public boolean performFinish() {
        Action action = this.getDefinitionWizardAction(this.fProjectAreaSelectionPage.getSelectedProjectArea());
        action.run();
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null) {
            this.fPage = window.getActivePage();
        }
    }

    public IWorkbenchPage getWorkbenchPage() {
        return this.fPage;
    }
}

