/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.viewers;

import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.ui.Activator;
import com.ibm.team.enterprise.systemdefinition.ui.IAntSnippetClientModel;
import com.ibm.team.enterprise.systemdefinition.ui.viewers.AntSnippetAnnotationModel;
import com.ibm.team.enterprise.systemdefinition.ui.viewers.AntSnippetDocumentProvider;
import com.ibm.team.enterprise.systemdefinition.ui.viewers.AntSnippetTranslatorListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class AntSnippetViewer
extends SourceViewer
implements IAnnotationModelListener {
    private final LocalResourceManager fResources;
    private final SourceViewerDecorationSupport fDecorationSupport;
    private volatile boolean fIsValid;
    private List<AntSnippetTranslatorListener> fListeners;
    private ITranslator fTranslator;
    private AntSnippetDocumentProvider fDocProvider;
    private final ISharedTextColors fSharedColors = new ISharedTextColors(){

        public Color getColor(RGB rgb) {
            return AntSnippetViewer.this.fResources.createColor(rgb);
        }

        public void dispose() {
        }
    };

    public AntSnippetViewer(Composite parent, int styles, AntSnippetDocumentProvider docProvider) {
        super(parent, null, styles);
        this.fDocProvider = docProvider;
        this.fResources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.fDecorationSupport = new SourceViewerDecorationSupport((ISourceViewer)this, null, (IAnnotationAccess)new DefaultMarkerAnnotationAccess(), this.fSharedColors);
        this.fDecorationSupport.install(null);
    }

    protected String getDocumentPartitioning() {
        return "com.ibm.team.enterprise.systemdefinition.antSnippetPartitioning";
    }

    public IAntSnippetClientModel getModel() {
        if (this.fTranslator != null) {
            return this.fDocProvider.getModel(this.fTranslator);
        }
        return null;
    }

    public void setInput(Object input) {
        IDocument inputDocument = null;
        try {
            if (input != null && input instanceof ITranslator) {
                this.fTranslator = (ITranslator)input;
                IDocument currDocument = this.getDocument();
                inputDocument = this.fDocProvider.createDocument(this.fTranslator);
                if (currDocument == null || inputDocument != null && !inputDocument.equals(currDocument)) {
                    IAnnotationModel annonModel;
                    IAnnotationAccess annotationAccess = new IAnnotationAccess(){

                        public Object getType(Annotation annotation) {
                            return "error.type";
                        }

                        public boolean isMultiLine(Annotation annotation) {
                            return true;
                        }

                        public boolean isTemporary(Annotation annotation) {
                            return true;
                        }
                    };
                    AnnotationPainter painter = new AnnotationPainter((ISourceViewer)this, annotationAccess);
                    painter.addAnnotationType((Object)"error.type");
                    painter.setAnnotationTypeColor((Object)"error.type", new Color((Device)Display.getDefault(), new RGB(255, 0, 0)));
                    painter.addTextStyleStrategy((Object)"error.type", (AnnotationPainter.ITextStyleStrategy)new AnnotationPainter.UnderlineStrategy(3));
                    this.addPainter((IPainter)painter);
                    this.fDocProvider.disconnect(this.fTranslator);
                    this.fDocProvider.connect(this.fTranslator);
                    AbstractDocumentProvider.ElementInfo elemInfo = this.fDocProvider.getElementInfo(this.fTranslator);
                    if (elemInfo instanceof AntSnippetDocumentProvider.AntSnippetInfo) {
                        inputDocument = ((AntSnippetDocumentProvider.AntSnippetInfo)elemInfo).fDocument;
                    }
                    if ((annonModel = this.fDocProvider.getAnnotationModel(this.fTranslator)) != null) {
                        annonModel.addAnnotationModelListener((IAnnotationModelListener)this);
                    }
                    super.setInput((Object)inputDocument);
                }
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    public void modelChanged(IAnnotationModel model) {
        this.fIsValid = true;
        if (model instanceof AntSnippetAnnotationModel) {
            AntSnippetAnnotationModel antModel = (AntSnippetAnnotationModel)model;
            if (!antModel.getSnippetAnnotations().isEmpty()) {
                this.fIsValid = false;
            }
            if (this.fListeners != null) {
                for (AntSnippetTranslatorListener listener : this.fListeners) {
                    listener.antSnippetChanged();
                }
            }
        }
    }

    public IAnnotationModel getAnnotationModel() {
        return this.fDocProvider.getAnnotationModel(this.fTranslator);
    }

    public boolean isScriptValid() {
        return this.fIsValid;
    }

    public void addScriptChangeListener(AntSnippetTranslatorListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.fListeners == null) {
            this.fListeners = new ArrayList<AntSnippetTranslatorListener>();
        }
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public void removeScriptChangeListener(AntSnippetTranslatorListener listener) {
        if (this.fListeners != null && listener != null) {
            this.fListeners.remove(listener);
        }
    }

    public void dispose() {
        this.fDocProvider.disconnect(this.fTranslator);
        this.fResources.dispose();
        this.fDecorationSupport.dispose();
        this.fTranslator = null;
        this.fDocProvider = null;
        if (this.fListeners != null) {
            this.fListeners.clear();
            this.fListeners = null;
        }
    }
}

