/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.viewers;

import com.ibm.team.enterprise.systemdefinition.common.model.ISnippetProblemCollector;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.ui.IAntSnippetClientModel;
import com.ibm.team.enterprise.systemdefinition.ui.viewers.AntSnippetAnnotationModel;
import com.ibm.team.enterprise.systemdefinition.ui.viewers.AntSnippetClientModel;
import org.eclipse.ant.internal.ui.editor.text.AntEditorPartitionScanner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;

public class AntSnippetDocumentProvider
extends AbstractDocumentProvider {
    public static final String ANT_SNIPPET_PARTITIONING = "com.ibm.team.enterprise.systemdefinition.antSnippetPartitioning";
    public static final String[] CONTENT_TYPES = new String[]{"__xml_tag", "__xml_comment", "__xml_cdata", "__xml_dtd", "__dftl_partition_content_type"};

    public IDocument createDocument(Object element) throws CoreException {
        Document doc = new Document();
        if (element instanceof ITranslator) {
            ITranslator tl = (ITranslator)element;
            doc.set(tl.getAntSnippet());
        }
        IDocumentPartitioner partitioner = this.createDocumentPartitioner();
        if (doc instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)doc;
            extension3.setDocumentPartitioner(ANT_SNIPPET_PARTITIONING, partitioner);
        } else {
            doc.setDocumentPartitioner(partitioner);
        }
        partitioner.connect((IDocument)doc);
        return doc;
    }

    private IDocumentPartitioner createDocumentPartitioner() {
        return new FastPartitioner((IPartitionTokenScanner)new AntEditorPartitionScanner(), new String[]{"__xml_tag", "__xml_comment", "__xml_cdata", "__xml_dtd"});
    }

    protected IAnnotationModel createAnnotationModel(Object element) {
        return new AntSnippetAnnotationModel();
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    public IAntSnippetClientModel getModel(Object input) {
        AbstractDocumentProvider.ElementInfo info = this.getElementInfo(input);
        if (info instanceof AntSnippetInfo) {
            AntSnippetInfo xmlInfo = (AntSnippetInfo)info;
            return xmlInfo.fAntModel;
        }
        return null;
    }

    public IAnnotationModel getAnnotationModel(Object input) {
        AbstractDocumentProvider.ElementInfo info = this.getElementInfo(input);
        if (info instanceof AntSnippetInfo) {
            AntSnippetInfo xmlInfo = (AntSnippetInfo)info;
            return xmlInfo.fModel;
        }
        return null;
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        return this.createElementInfo(element, null);
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element, IDocument document) throws CoreException {
        AntSnippetInfo snippetInfo = null;
        snippetInfo = document != null ? new AntSnippetInfo(document, this.createAnnotationModel(element)) : new AntSnippetInfo(this.createDocument(element), this.createAnnotationModel(element));
        if (snippetInfo == null || !(snippetInfo instanceof AntSnippetInfo)) {
            return null;
        }
        if (element instanceof ITranslator) {
            Object annotationModel = snippetInfo.fModel;
            if (annotationModel == null) {
                snippetInfo.fModel = annotationModel = new AntSnippetAnnotationModel();
            }
            ISnippetProblemCollector collector = annotationModel instanceof ISnippetProblemCollector ? (ISnippetProblemCollector)annotationModel : null;
            AntSnippetClientModel antModel = new AntSnippetClientModel(snippetInfo.fDocument, collector);
            antModel.install();
            snippetInfo.fAntModel = antModel;
            snippetInfo.fTranslator = (ITranslator)element;
        }
        return snippetInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        if (info instanceof AntSnippetInfo) {
            AntSnippetInfo snippetInfo = (AntSnippetInfo)info;
            if (snippetInfo.fAntModel != null) {
                IDocument doc = snippetInfo.fDocument;
                Object lock = null;
                lock = doc instanceof ISynchronizable ? ((ISynchronizable)doc).getLockObject() : snippetInfo.fAntModel;
                if (lock == null) {
                    snippetInfo.fAntModel.dispose();
                    snippetInfo.fAntModel = null;
                } else {
                    Object object = lock;
                    synchronized (object) {
                        snippetInfo.fAntModel.dispose();
                        snippetInfo.fAntModel = null;
                    }
                }
            }
        }
        super.disposeElementInfo(element, info);
    }

    public AbstractDocumentProvider.ElementInfo getElementInfo(Object element) {
        return super.getElementInfo(element);
    }

    protected class AntSnippetInfo
    extends AbstractDocumentProvider.ElementInfo {
        IAntSnippetClientModel fAntModel;
        ITranslator fTranslator;

        public AntSnippetInfo(IDocument document, IAnnotationModel model) {
            super((AbstractDocumentProvider)AntSnippetDocumentProvider.this, document, model);
        }

        public boolean equals(Object o) {
            if (this.fTranslator != null) {
                return this.fTranslator.equals(o);
            }
            return super.equals(o);
        }

        public int hashCode() {
            if (this.fTranslator != null) {
                return this.fTranslator.hashCode();
            }
            return super.hashCode();
        }
    }
}

