/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.viewers;

import com.ibm.team.enterprise.systemdefinition.common.internal.model.AbstractAntSnippetModel;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.AntSnippetProblem;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.AntSnippetTarget;
import com.ibm.team.enterprise.systemdefinition.common.model.ISnippetProblem;
import com.ibm.team.enterprise.systemdefinition.common.model.ISnippetProblemCollector;
import com.ibm.team.enterprise.systemdefinition.ui.IAntSnippetClientModel;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ISynchronizable;
import org.xml.sax.Locator;

public class AntSnippetClientModel
extends AbstractAntSnippetModel
implements IAntSnippetClientModel {
    private IDocument fClientDocument;
    private volatile boolean fDirty = true;
    private final Object fDirtyLock = new Object();
    private IDocumentListener fListener;
    private boolean fShouldReconcile = true;

    public AntSnippetClientModel(IDocument document, ISnippetProblemCollector snippetProblemCollector) {
        this.fClientDocument = document;
        this.fClientDocument.addDocumentListener((IDocumentListener)new InternalDocumentListener());
        this.fCollector = snippetProblemCollector;
    }

    @Override
    public void install() {
        this.fListener = new IDocumentListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void documentAboutToBeChanged(DocumentEvent event) {
                Object object = AntSnippetClientModel.this.fDirtyLock;
                synchronized (object) {
                    AntSnippetClientModel.this.fDirty = true;
                }
            }

            public void documentChanged(DocumentEvent event) {
            }
        };
        this.fClientDocument.addDocumentListener(this.fListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.fClientDocument = null;
        }
    }

    private Object getLockObject() {
        Object lock;
        if (this.fClientDocument instanceof ISynchronizable && (lock = ((ISynchronizable)this.fClientDocument).getLockObject()) != null) {
            return lock;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcile() {
        Object object = this.fDirtyLock;
        synchronized (object) {
            if (!this.fShouldReconcile || !this.fDirty) {
                return;
            }
            this.fDirty = false;
        }
        object = this.getLockObject();
        synchronized (object) {
            if (this.fClientDocument == null) {
                this.fTarget = null;
            } else {
                this.parseRawSnippet(this.fClientDocument.get());
            }
        }
    }

    public String getText(int offset, int length) {
        try {
            return this.fClientDocument.get(offset, length);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public void setShouldReconcile(boolean shouldReconcile) {
        this.fShouldReconcile = shouldReconcile;
        if (this.fShouldReconcile) {
            this.reconcile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AntSnippetTarget getTargetNode(boolean doReconcile) {
        if (doReconcile) {
            Object object = this.getLockObject();
            synchronized (object) {
                this.reconcile();
            }
        }
        return this.fTarget;
    }

    @Override
    public void markClean() {
        this.fDirty = false;
    }

    @Override
    public boolean isDirty() {
        return this.fDirty;
    }

    protected void handleError(String message, Locator locator) {
        if (this.fCollector != null) {
            AntSnippetProblem problem = new AntSnippetProblem(message, 0, 0, 1);
            this.fCollector.report((ISnippetProblem)problem);
        }
    }

    public Object getSnippetDocument() {
        return this.fClientDocument;
    }

    private class InternalDocumentListener
    implements IDocumentListener {
        private InternalDocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void documentChanged(DocumentEvent event) {
            Object object = AntSnippetClientModel.this.fDirtyLock;
            synchronized (object) {
                AntSnippetClientModel.this.fDirty = true;
            }
        }
    }
}

