/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.viewers;

import com.ibm.team.enterprise.systemdefinition.common.model.ISnippetProblem;
import com.ibm.team.enterprise.systemdefinition.common.model.ISnippetProblemCollector;
import com.ibm.team.enterprise.systemdefinition.ui.Activator;
import com.ibm.team.enterprise.systemdefinition.ui.viewers.AntSnippetProblemAnnotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationMap;
import org.eclipse.jface.text.source.IAnnotationModel;

public class AntSnippetAnnotationModel
extends AnnotationModel
implements ISnippetProblemCollector {
    private final List<AntSnippetProblemAnnotation> fGeneratedAnnotations = new ArrayList<AntSnippetProblemAnnotation>();
    private final Set<ISnippetProblem> fCollectedProblems = new HashSet<ISnippetProblem>();

    public void report(ISnippetProblem problem) {
        this.fCollectedProblems.add(problem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect() {
        boolean temporaryProblemsChanged = false;
        IAnnotationMap iAnnotationMap = this.getAnnotationMap();
        synchronized (iAnnotationMap) {
            if (this.fGeneratedAnnotations.size() > 0) {
                temporaryProblemsChanged = true;
                this.removeAnnotations(this.fGeneratedAnnotations, false, true);
                this.fGeneratedAnnotations.clear();
            }
            if (this.fCollectedProblems != null && this.fCollectedProblems.size() > 0) {
                for (ISnippetProblem problem : this.fCollectedProblems) {
                    Position position = this.createPositionFromProblem(problem);
                    if (position == null) continue;
                    AntSnippetProblemAnnotation annotation = new AntSnippetProblemAnnotation(problem);
                    annotation.setType("error.type");
                    this.fGeneratedAnnotations.add(annotation);
                    try {
                        this.addAnnotation(annotation, position, false);
                    }
                    catch (BadLocationException ex) {
                        Activator.log(ex);
                    }
                    temporaryProblemsChanged = true;
                }
                this.fCollectedProblems.clear();
            }
        }
        if (temporaryProblemsChanged) {
            this.fireModelChanged(new AnnotationModelEvent((IAnnotationModel)this));
        }
    }

    protected Position createPositionFromProblem(ISnippetProblem problem) {
        int length;
        int start = problem.getOffset();
        if (start >= 0 && (length = problem.getLength()) >= 0) {
            return new Position(start, length);
        }
        return new Position(0, 0);
    }

    public void prepare() {
        this.fCollectedProblems.clear();
    }

    public List<AntSnippetProblemAnnotation> getSnippetAnnotations() {
        return this.fGeneratedAnnotations;
    }
}

