/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.util;

import com.ibm.team.enterprise.systemdefinition.common.ITranslatorEntry;
import com.ibm.team.enterprise.systemdefinition.ui.IModeledTranslatorEntryContext;
import com.ibm.team.enterprise.systemdefinition.ui.ITranslatorEntryConsumer;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;

public class TranslatorEntryLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    protected TableViewer fTableViewer;
    private final ITeamRepository fTeamRepository;
    private final IProjectAreaHandle fProjectArea;
    private final ITranslatorEntryConsumer fTranslatorConsumer;
    protected Map<String, String> fValueToLabelMap = new HashMap<String, String>();

    public TranslatorEntryLabelProvider(TableViewer tableViewer, ITeamRepository repo, IProjectAreaHandle projArea, ITranslatorEntryConsumer consumer) {
        this.fTableViewer = tableViewer;
        this.fTeamRepository = repo;
        this.fProjectArea = projArea;
        this.fTranslatorConsumer = consumer;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry) {
            com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry entry = (com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry)element;
            switch (columnIndex) {
                case 0: {
                    if (entry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable")) {
                        return entry.getValue();
                    }
                    if (this.fTranslatorConsumer != null) {
                        Map<String, String> translatorCache = this.fTranslatorConsumer.getTranslatorCache();
                        if (translatorCache.containsKey(entry.getValue())) {
                            return translatorCache.get(entry.getValue());
                        }
                        return Messages.TranslatorEntryLabelProvider_FETCH_PENDING_LABEL;
                    }
                }
                case 1: {
                    if (entry.getCondition() == null) {
                        return "";
                    }
                    return entry.getCondition();
                }
                case 2: {
                    if (entry.getStepName() == null) {
                        return "";
                    }
                    return entry.getStepName();
                }
            }
        }
        return null;
    }

    protected IModeledTranslatorEntryContext getTranslatorEntryContext(final com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry translatorEntry) {
        return new IModeledTranslatorEntryContext(){

            @Override
            public com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry getModeledTranslatorEntry() {
                return translatorEntry;
            }

            @Override
            public ITeamRepository getTeamRepository() {
                return TranslatorEntryLabelProvider.this.fTeamRepository;
            }

            @Override
            public IProjectAreaHandle getProjectArea() {
                return TranslatorEntryLabelProvider.this.fProjectArea;
            }

            @Override
            public ITranslatorEntry getTranslatorEntry() {
                return null;
            }
        };
    }
}

