/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.util;

import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.util.ItemHandleAwareHashMap;
import com.ibm.team.enterprise.systemdefinition.common.util.SysDefArrayList;
import com.ibm.team.enterprise.systemdefinition.ui.Activator;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class SystemDefinitionDeferredContentProvider
implements ITreeContentProvider,
IDeferredWorkbenchAdapter {
    protected IItemType type;
    protected ITeamRepository repository;
    protected String[] propertiesToFetch;
    private final ConcurrentMap<Object, AtomicBoolean> fObjectFetchMap = new ConcurrentHashMap<Object, AtomicBoolean>();
    private final ItemHandleAwareHashMap<ITeamRepository, List<IProjectArea>> fFetchedProjectAreasPerRepository = new ItemHandleAwareHashMap();
    private final ItemHandleAwareHashMap<IProjectArea, SysDefArrayList<ISystemDefinition>> fFetchedDefinitionsPerProject = new ItemHandleAwareHashMap();
    private final AtomicInteger fFetchTotal = new AtomicInteger(0);
    private final AtomicInteger fAddTotal = new AtomicInteger(0);
    protected DeferredTreeContentManager deferredTreeManager;
    protected TreeViewer treeViewer;
    public static final String[] MINIMUM_PROPERTIES = new String[]{ISystemDefinition.NAME_PROPERTY, ISystemDefinition.DESCRIPTION_PROPERTY, ISystemDefinition.PROJECT_AREA_PROPERTY};

    public SystemDefinitionDeferredContentProvider(ITeamRepository repository, IItemType type) {
        this(repository, type, false);
    }

    public SystemDefinitionDeferredContentProvider(ITeamRepository repository, IItemType type, boolean doFullResolution) {
        this(repository, type, doFullResolution ? null : MINIMUM_PROPERTIES);
    }

    public SystemDefinitionDeferredContentProvider(ITeamRepository repository, IItemType type, String[] propertiesToFetch) {
        this.repository = repository;
        this.type = type;
        this.propertiesToFetch = propertiesToFetch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        AtomicBoolean fetchInProgress = this.getObjectFetched(object);
        SystemDefinitionDeferredContentProvider systemDefinitionDeferredContentProvider = this;
        synchronized (systemDefinitionDeferredContentProvider) {
            block12: {
                if (fetchInProgress.compareAndSet(false, true)) {
                    try {
                        try {
                            if (object instanceof ITeamRepository) {
                                this.fetchRepositoryChildren((ITeamRepository)object, collector, monitor);
                            } else if (object instanceof IProjectAreaHandle) {
                                this.fetchProjectAreaChildren((IProjectAreaHandle)object, collector, monitor);
                            }
                        }
                        catch (TeamRepositoryException e) {
                            Activator.log(e);
                            fetchInProgress.set(false);
                            collector.done();
                            monitor.done();
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        fetchInProgress.set(false);
                        collector.done();
                        monitor.done();
                        throw throwable;
                    }
                    fetchInProgress.set(false);
                    collector.done();
                    monitor.done();
                }
            }
        }
    }

    protected void fetchRepositoryChildren(ITeamRepository repository, IElementCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fFetchedProjectAreasPerRepository.containsKey((Object)repository)) {
            this.addCollectorByArray(collector, ((List)this.fFetchedProjectAreasPerRepository.get((Object)repository)).toArray(), monitor);
        } else {
            List rawProjectAreas = repository.itemManager().fetchCompleteItems(repository.itemManager().getKnownSharedItems(IProjectArea.ITEM_TYPE), 2, null);
            ArrayList<IProjectArea> projectAreas = new ArrayList<IProjectArea>(rawProjectAreas.size());
            ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)repository);
            for (IProjectArea p : rawProjectAreas) {
                if (p == null || p.isArchived() || !client.hasSystemDefinitions((IProjectAreaHandle)p, this.type, -1, false, monitor)) continue;
                projectAreas.add(p);
            }
            Collections.sort(projectAreas, new Comparator<IProjectArea>(){

                @Override
                public int compare(IProjectArea o1, IProjectArea o2) {
                    String label1 = o1.getName();
                    String label2 = o2.getName();
                    return label1.compareTo(label2);
                }
            });
            this.addCollectorByArray(collector, projectAreas.toArray(), monitor);
            this.fFetchedProjectAreasPerRepository.put((Object)repository, projectAreas);
        }
    }

    protected void fetchProjectAreaChildren(IProjectAreaHandle projectArea, IElementCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fFetchedDefinitionsPerProject.containsKey((Object)projectArea)) {
            this.addCollectorByArray(collector, ((SysDefArrayList)this.fFetchedDefinitionsPerProject.get((Object)projectArea)).toArray(), monitor);
        } else {
            SubMonitor smonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.repository);
            if (client != null) {
                IProjectArea fullProjectArea = (IProjectArea)this.repository.itemManager().fetchCompleteItem((IItemHandle)projectArea, 0, (IProgressMonitor)smonitor);
                SysDefArrayList sysDefs = new SysDefArrayList((Collection)client.findSystemDefinitions(this.type, projectArea, -1, false, this.propertiesToFetch == null ? null : Arrays.asList(this.propertiesToFetch), (IProgressMonitor)smonitor.newChild(80)));
                Collections.sort(sysDefs, new Comparator<ISystemDefinition>(){

                    @Override
                    public int compare(ISystemDefinition o1, ISystemDefinition o2) {
                        String label1 = o1.getName();
                        String label2 = o2.getName();
                        return label1.compareTo(label2);
                    }
                });
                this.fFetchedDefinitionsPerProject.put((Object)fullProjectArea, (Object)sysDefs);
                this.addCollectorByArray(collector, sysDefs.toArray(), (IProgressMonitor)smonitor);
            }
        }
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        if (o instanceof ITeamRepository) {
            return ((ITeamRepository)o).getName();
        }
        if (o instanceof IProjectArea) {
            return ((IProjectArea)o).getName();
        }
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof PendingUpdateAdapter) {
            return new Object[0];
        }
        if (parentElement instanceof ITeamRepository && this.fFetchedProjectAreasPerRepository.containsKey(parentElement)) {
            return ((List)this.fFetchedProjectAreasPerRepository.get(parentElement)).toArray();
        }
        if (parentElement instanceof IProjectArea && this.fFetchedDefinitionsPerProject.containsKey(parentElement)) {
            return ((SysDefArrayList)this.fFetchedDefinitionsPerProject.get(parentElement)).toArray();
        }
        if (this.deferredTreeManager != null) {
            return this.deferredTreeManager.getChildren(parentElement);
        }
        return new String[]{Messages.SystemDefinitionDeferredContentProvider_Pending};
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof ITeamRepository || element instanceof IProjectAreaHandle;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof ITeamRepository || inputElement instanceof IProjectAreaHandle) {
            return this.getChildren(inputElement);
        }
        return new Object[0];
    }

    public void dispose() {
        this.deferredTreeManager = null;
        this.fObjectFetchMap.clear();
        this.fFetchedDefinitionsPerProject.clear();
        this.fFetchedProjectAreasPerRepository.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof TreeViewer) {
            this.treeViewer = (TreeViewer)viewer;
        }
        if (this.deferredTreeManager == null) {
            this.deferredTreeManager = new DeferredTreeContentManager((AbstractTreeViewer)viewer){

                protected IDeferredWorkbenchAdapter getAdapter(Object element) {
                    if (SystemDefinitionDeferredContentProvider.this.hasChildren(element)) {
                        return SystemDefinitionDeferredContentProvider.this;
                    }
                    return super.getAdapter(element);
                }
            };
        }
    }

    private AtomicBoolean getObjectFetched(Object obj) {
        AtomicBoolean result = new AtomicBoolean(false);
        AtomicBoolean tempResult = this.fObjectFetchMap.putIfAbsent(obj, result);
        if (tempResult != null) {
            result = tempResult;
        }
        return result;
    }

    private void addCollectorByArray(IElementCollector collector, Object[] objArray, IProgressMonitor monitor) {
        if (objArray != null) {
            collector.add(objArray, monitor);
            this.fFetchTotal.addAndGet(objArray.length);
        }
    }

    public AtomicInteger getFetchTotal() {
        return this.fFetchTotal;
    }

    public AtomicInteger getAddTotal() {
        return this.fAddTotal;
    }
}

