/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.util;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.UUID;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class RepositoryTools {
    private RepositoryTools() {
    }

    public static ITeamRepository getTeamRepository(String uri) {
        ITeamRepository[] repositories;
        ITeamRepository[] iTeamRepositoryArray = repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            if (repository.getRepositoryURI().equals(uri)) {
                return repository;
            }
            ++n2;
        }
        return null;
    }

    public static ITeamRepository getTeamRepository(UUID uuid) {
        ITeamRepository[] repositories;
        ITeamRepository[] iTeamRepositoryArray = repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            if (repository.getId().equals((Object)uuid)) {
                return repository;
            }
            ++n2;
        }
        return null;
    }

    public static ITeamRepository getTeamRepository(IShareable shareable) {
        if (shareable == null) {
            return null;
        }
        IShare share = null;
        try {
            share = shareable.getShare((IProgressMonitor)new NullProgressMonitor());
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        if (share == null) {
            return null;
        }
        ISharingDescriptor descriptor = share.getSharingDescriptor();
        return RepositoryTools.getTeamRepository(descriptor.getRepositoryId());
    }

    public static boolean isShared(IAdaptable element) {
        if (element != null) {
            IShareable share = (IShareable)element.getAdapter(IShareable.class);
            return RepositoryTools.getTeamRepository(share) != null;
        }
        return false;
    }
}

