/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.util;

import com.ibm.team.enterprise.metadata.client.scanner.IMetadataScannerClientLibrary;
import com.ibm.team.enterprise.metadata.common.scanner.IFileMetadataScanner;
import com.ibm.team.enterprise.systemdefinition.common.model.IStringHelper;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public abstract class MetadataScannerLabelProvider
extends LabelProvider {
    private final ITeamRepository repository;
    private Map<String, String> labelCache;

    public MetadataScannerLabelProvider(ITeamRepository repository) {
        this.repository = repository;
        if (repository != null) {
            this.labelCache = new HashMap<String, String>();
        }
    }

    protected abstract ScannerLabelHelper getLabelHelper(Object var1);

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IFileMetadataScanner) {
            String label = ((IFileMetadataScanner)element).getLabel();
            return label;
        }
        if (element instanceof String) {
            String scannerName = (String)element;
            String label = this.labelCache.get(scannerName);
            if (label != null) {
                return label;
            }
            ScannerLabelHelper labelHelper = this.getLabelHelper(element);
            labelHelper.getScannerLabelInBackground(scannerName);
            return Messages.TranslatorEntryLabelProvider_FETCH_PENDING_LABEL;
        }
        if (element instanceof IStringHelper) {
            IStringHelper helper = (IStringHelper)element;
            String scannerName = helper.getValue();
            String label = this.labelCache.get(scannerName);
            if (label != null) {
                return label;
            }
            ScannerLabelHelper labelHelper = this.getLabelHelper(element);
            labelHelper.getScannerLabelInBackground(scannerName);
            return Messages.TranslatorEntryLabelProvider_FETCH_PENDING_LABEL;
        }
        return super.getText(element);
    }

    public class ScannerLabelHelper {
        public void labelAvailable(String label, String scannerUUID) {
        }

        public void getScannerLabelInBackground(final String scannerName) {
            FoundationJob job = new FoundationJob(Messages.ScannerLabelHelper_JOB_LABEL){

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    String label = Messages.ScannerLabelHelper_ITEM_NOT_FOUND;
                    IFileMetadataScanner scanner = this.fetchScanner(scannerName);
                    if (scanner != null) {
                        label = scanner.getLabel();
                    }
                    MetadataScannerLabelProvider.this.labelCache.put(scannerName, label);
                    ScannerLabelHelper.this.asyncLabelAvailable(label, scannerName);
                    return Status.OK_STATUS;
                }

                private IFileMetadataScanner fetchScanner(String scannerName2) throws TeamRepositoryException {
                    IMetadataScannerClientLibrary scannerClient = (IMetadataScannerClientLibrary)MetadataScannerLabelProvider.this.repository.getClientLibrary(IMetadataScannerClientLibrary.class);
                    return scannerClient.getMetadataScanner(scannerName2);
                }
            };
            job.schedule();
        }

        protected void asyncLabelAvailable(final String label, final String scannerName) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ScannerLabelHelper.this.labelAvailable(label, scannerName);
                }
            });
        }
    }
}

