/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.util;

import com.ibm.team.enterprise.systemdefinition.common.ITranslatorEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.IDependencyType;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.IModeledTranslatorEntryContext;
import com.ibm.team.enterprise.systemdefinition.ui.ITranslatorEntryConsumer;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;

public class DependencyTypeLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    protected TableViewer fTableViewer;
    private final ITeamRepository fTeamRepository;
    private final IProjectAreaHandle fProjectArea;
    private ILanguageDefinition fLanguageDefinition;
    private final ITranslatorEntryConsumer fTranslatorConsumer;
    protected Map<String, String> fValueToLabelMap = new HashMap<String, String>();

    public DependencyTypeLabelProvider(TableViewer tableViewer, ITeamRepository repo, IProjectAreaHandle projArea, ILanguageDefinition languageDefinition, ITranslatorEntryConsumer consumer) {
        this.fTableViewer = tableViewer;
        this.fTeamRepository = repo;
        this.fProjectArea = projArea;
        this.fLanguageDefinition = languageDefinition;
        this.fTranslatorConsumer = consumer;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof IDependencyType) {
            IDependencyType entry = (IDependencyType)element;
            switch (columnIndex) {
                case 0: {
                    return entry.getName();
                }
                case 1: {
                    if (entry.getLevel() == 0) {
                        StringBuffer str = new StringBuffer();
                        str.append(Messages.DependencyTypeLabelProvider_ALL);
                        return str.toString();
                    }
                    if (entry.getLevel() == 1) {
                        return Messages.DependencyTypeLabelProvider_NONE;
                    }
                    StringBuffer str = new StringBuffer();
                    for (Object translator : entry.getTranslators()) {
                        if (str.length() > 0) {
                            str.append(",");
                        }
                        str.append(this.getTranslatorEntryLabel((com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry)translator, entry));
                    }
                    return str.toString();
                }
            }
        }
        return null;
    }

    private String getTranslatorEntryLabel(com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry translator, IDependencyType dependencyType) {
        if (translator.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable")) {
            return translator.getValue();
        }
        if (this.fTranslatorConsumer != null) {
            Map<String, String> translatorCache = this.fTranslatorConsumer.getTranslatorCache();
            if (translatorCache.containsKey(translator.getValue())) {
                return translatorCache.get(translator.getValue());
            }
            return Messages.TranslatorEntryLabelProvider_FETCH_PENDING_LABEL;
        }
        return null;
    }

    protected IModeledTranslatorEntryContext getTranslatorEntryContext(final com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry translatorEntry) {
        return new IModeledTranslatorEntryContext(){

            @Override
            public com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry getModeledTranslatorEntry() {
                return translatorEntry;
            }

            @Override
            public ITeamRepository getTeamRepository() {
                return DependencyTypeLabelProvider.this.fTeamRepository;
            }

            @Override
            public IProjectAreaHandle getProjectArea() {
                return DependencyTypeLabelProvider.this.fProjectArea;
            }

            @Override
            public ITranslatorEntry getTranslatorEntry() {
                return null;
            }
        };
    }

    public void setLanguageDefinitionWorkingCopy(ILanguageDefinition languageDefinition) {
        this.fLanguageDefinition = languageDefinition;
    }
}

