/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.services;

import com.ibm.team.enterprise.common.common.parser.ParserException;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterJclParser;
import com.ibm.team.enterprise.internal.systemdefinition.client.importer.ImporterParser;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterBuildOptions;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterLanguage;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterParserResult;
import com.ibm.team.enterprise.systemdefinition.common.importer.IImporterParserStep;
import com.ibm.team.enterprise.systemdefinition.common.util.DatasetCache;
import com.ibm.team.enterprise.systemdefinition.ui.IImporterBuildOptionsTreeNode;
import com.ibm.team.enterprise.systemdefinition.ui.IImporterLanguageWizardPage00;
import com.ibm.team.enterprise.systemdefinition.ui.ILanguageWizard;
import com.ibm.team.enterprise.systemdefinition.ui.ILanguageWizardPage;
import com.ibm.team.enterprise.systemdefinition.ui.elements.BuilderBuildOptionsTreeNode;
import com.ibm.team.enterprise.systemdefinition.ui.elements.BuilderPageFactory;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;

public abstract class AbstractLanguageWizard
implements ILanguageWizard {
    protected IImporterLanguageWizardPage00 page00;
    protected IImporterParserResult parserResult;
    protected List<ILanguageWizardPage> pages = new ArrayList<ILanguageWizardPage>();
    protected DatasetCache datasetCache;

    @Override
    public abstract void addDefaultPages(boolean var1) throws Exception;

    public abstract IImporterLanguage createLanguage();

    @Override
    public final void addPages(Wizard wizard, WizardPage page00, boolean defaultsBuiltin, String defaultsFileName, String defaultsPrefix) throws Exception {
        this.page00 = (IImporterLanguageWizardPage00)page00;
        if (defaultsFileName != null && defaultsFileName.length() > 0) {
            this.readDefaults(defaultsFileName, defaultsPrefix);
            for (IImporterParserStep step : this.parserResult.getSteps()) {
                this.pages.add(BuilderPageFactory.createPage(this.getId(), step, this.datasetCache));
            }
        } else {
            this.addDefaultPages(defaultsBuiltin);
        }
        for (ILanguageWizardPage page : this.pages) {
            if (page != null) {
                wizard.addPage((IWizardPage)page);
            }
            page.resetOptions(true);
        }
    }

    @Override
    public final IImporterBuildOptionsTreeNode getBuildOptionsTreeNode(IImporterBuildOptions pbo) {
        ArrayList<IImporterBuildOptions> pbos = new ArrayList<IImporterBuildOptions>(Arrays.asList(pbo));
        return new BuilderBuildOptionsTreeNode("translator", Messages.NewBuilderLanguageWizard_Options_Translator, pbos);
    }

    @Override
    public final BuilderBuildOptionsTreeNode getBuildOptionsTreeNode() {
        return this.getBuildOptionsTreeNode(false);
    }

    @Override
    public final BuilderBuildOptionsTreeNode getBuildOptionsTreeNode(boolean reset) {
        ArrayList<IImporterBuildOptions> pbos = new ArrayList<IImporterBuildOptions>();
        for (ILanguageWizardPage page : this.pages) {
            if (reset) {
                page.resetOptions(true);
            }
            pbos.add(page.getDefaults().getBuildOptions());
        }
        return new BuilderBuildOptionsTreeNode("translator", Messages.NewBuilderLanguageWizard_Options_Translator, pbos);
    }

    @Override
    public final IImporterLanguage getLangugage() {
        IImporterLanguage language = this.createLanguage();
        language.setDescription(this.page00.GetDescription());
        language.setFolderAdditional(this.page00.getFolderAdditional());
        language.setFolderPrimary(this.page00.getFolderPrimary());
        language.setId(this.page00.getId());
        language.setName(this.page00.GetName());
        language.setPatternAdditional(this.page00.getPatternAdditional());
        language.setPatternPrimary(this.page00.getPatternPrimary());
        language.setPrefix(this.page00.getDefaultsPrefix());
        language.setProjectName(this.page00.getProjectName());
        language.setProperties(this.page00.getProperties());
        language.setSize(this.page00.getSize());
        language.setType(this.page00.getType());
        language.setZFolderName(String.format(this.getZFolderPattern(), this.page00.getId()));
        List steps = language.getSteps();
        for (ILanguageWizardPage page : this.pages) {
            if (page == null) continue;
            steps.add(page.getDefaults());
        }
        return language;
    }

    @Override
    public final void readDefaults(String file, String prefix) throws Exception {
        if (Boolean.getBoolean("com.ibm.team.enterprise.systemdefinition.importer.UseOldParser")) {
            ImporterParser parser = new ImporterParser();
            try {
                this.parserResult = parser.parse(file, prefix);
            }
            catch (ParserException e) {
                throw new Exception(e);
            }
        }
        ImporterJclParser parser = new ImporterJclParser();
        try {
            this.parserResult = parser.parse(file, prefix);
        }
        catch (ParserException e) {
            throw new Exception(e);
        }
    }

    @Override
    public void setCache(DatasetCache cache) {
        this.datasetCache = cache;
    }

    @Override
    public DatasetCache getCache() {
        return this.datasetCache;
    }
}

