/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.properties;

import com.ibm.team.enterprise.common.common.ZComponentNature;
import com.ibm.team.enterprise.common.ui.util.Utils;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.LanguageDefinitionSelectionDialog;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.rcp.ui.IPropertyEntry;
import com.ibm.team.filesystem.rcp.ui.PropertyNamespaceProvider;
import com.ibm.team.filesystem.rcp.ui.internal.properties.SCMPropertyEntry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;

public class LanguageDefinitionPropertyNamespaceProvider
extends PropertyNamespaceProvider
implements PropertyNamespaceProvider.DisplayValueProvider {
    public static Log logger = LogFactory.getLog(LanguageDefinitionPropertyNamespaceProvider.class);

    public String getName() {
        return Messages.LanguageDefinitionPropertyNamespaceProvider_Namespace;
    }

    public String getDisplayLabel(String propertyName) {
        return Messages.LanguageDefinitionPropertyNamespaceProvider_LanguageDefinitionPropertyLabel;
    }

    public IPropertyEntry editProperty(Shell parentShell, IShareable shareable, IPropertyEntry entry) {
        IResource resource;
        ITeamRepository repo = Utils.getTeamRepository((IShareable)shareable);
        LanguageDefinitionSelectionDialog dialog = new LanguageDefinitionSelectionDialog(parentShell, repo, null, this.getPlatformType(resource = (IResource)shareable.getAdapter(IResource.class)));
        int result = dialog.open();
        if (result == 0) {
            String langDefUUID = dialog.getSelectedSystemDefinition().getItemId().getUuidValue();
            return new SCMPropertyEntry(entry.getName(), langDefUUID, dialog.getSelectedSystemDefinition().getName());
        }
        return null;
    }

    private IItemType getPlatformType(IResource resource) {
        try {
            if (resource.getProject().hasNature(ZComponentNature.ID)) {
                return IZosLanguageDefinition.ITEM_TYPE;
            }
            if (resource.getProject().hasNature("com.ibm.etools.iseries.perspective.nature")) {
                return IIBMiLanguageDefinition.ITEM_TYPE;
            }
            return ILanguageDefinition.ITEM_TYPE;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getDisplayValue(String propertyName, String propertyValue, ITeamRepository repo, IProgressMonitor monitor) {
        String result = null;
        try {
            long devSleepDelay = 0L;
            if (devSleepDelay > 0L) {
                Thread.sleep(devSleepDelay);
            }
            ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)repo.getClientLibrary(ISystemDefinitionModelClient.class);
            ISystemDefinition sysDef = client.findSystemDefinitionComplete(propertyValue, null, ILanguageDefinition.ITEM_TYPE, monitor);
            result = sysDef.getName();
        }
        catch (Exception e) {
            logger.error((Object)"Error trying to resolve language definition UUID to name", (Throwable)e);
        }
        return result;
    }
}

