/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.jobs;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.extensions.client.util.SCMWorkspace;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.Statistics;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.internal.systemdefinition.client.packaging.PackagingArtifacts;
import com.ibm.team.enterprise.internal.systemdefinition.client.packaging.PackagingComponent;
import com.ibm.team.enterprise.internal.systemdefinition.client.packaging.PackagingConfiguration;
import com.ibm.team.enterprise.internal.systemdefinition.client.packaging.PackagingContent;
import com.ibm.team.enterprise.systemdefinition.client.IPackagingQueryClient;
import com.ibm.team.enterprise.systemdefinition.client.cache.ItemCacheFactory;
import com.ibm.team.enterprise.systemdefinition.client.cache.ItemCacheLoad;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.importer.ImporterException;
import com.ibm.team.enterprise.systemdefinition.common.model.IVersionDefinition;
import com.ibm.team.enterprise.systemdefinition.common.packaging.IPackgingSysoutClass;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.SystemDefinitionJob;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class JclinGenerationJob
extends SystemDefinitionJob {
    private final IDebugger dbg;
    private final String simpleName;
    private long timingEnter;
    private long timingLeave;
    private final IBuildDefinition buildDefinition;
    private final ITeamRepository repository;
    private final IProjectArea projectArea;
    private final IVersionDefinition version;
    private final IWorkspace workspace;
    private final IPackgingSysoutClass.SysoutClass sysoutClass;
    private final boolean sortContent;
    private final String jclinFolder;
    private final List<String> ignoreFiles;
    private final List<String> exclude;
    private final List<String> include;
    private final Map<String, List<String>> excludeProject;
    private final Map<String, List<String>> includeProject;

    public JclinGenerationJob(String title, ITeamRepository repository, IProjectArea projectArea, IVersionDefinition version, IWorkspace workspace, IBuildDefinition buildDefinition, boolean sortContent, String jclinFolder, IPackgingSysoutClass.SysoutClass sysoutClass, List<String> ignoreFiles, List<String> exclude, List<String> include, Map<String, List<String>> excludeProject, Map<String, List<String>> includeProject, IDebugger dbg) {
        super(title, true);
        this.repository = repository;
        this.projectArea = projectArea;
        this.version = version;
        this.workspace = workspace;
        this.buildDefinition = buildDefinition;
        this.sortContent = sortContent;
        this.jclinFolder = jclinFolder;
        this.sysoutClass = sysoutClass;
        this.ignoreFiles = ignoreFiles;
        this.exclude = exclude;
        this.include = include;
        this.excludeProject = excludeProject;
        this.includeProject = includeProject;
        this.dbg = dbg;
        this.simpleName = ((Object)((Object)this)).getClass().getSimpleName();
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
        try {
            IWorkspaceConnection wsConnection;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            subMonitor.beginTask(NLS.bind((String)Messages.JclinGenerationJob_Begin, (Object)this.version.getName(), (Object[])new Object[0]), 100);
            Statistics.logTiming((String)NLS.bind((String)Messages.JclinGenerationJob_Begin, (Object)this.version.getName(), (Object[])new Object[0]), (IDebugger)this.dbg);
            this.timingEnter = System.nanoTime();
            ItemCacheFactory.clearDataset((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea);
            ItemCacheFactory.clearFunction((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea);
            ItemCacheFactory.createDataset((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea, (IDebugger)this.dbg);
            ItemCacheFactory.loadDataset((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea, (ISystemDefinition.Platform)ISystemDefinition.Platform.zos, (Integer)0, (IDebugger)this.dbg);
            ItemCacheFactory.loadDataset((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea, (ISystemDefinition.Platform)ISystemDefinition.Platform.zos, (Integer)1, (IDebugger)this.dbg);
            ItemCacheFactory.loadFunction((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea, (ISystemDefinition.Platform)ISystemDefinition.Platform.zos, (IDebugger)this.dbg);
            subMonitor.subTask(Messages.JclinGenerationJob_Begin_CSLanguage);
            Statistics.logTiming((String)Messages.JclinGenerationJob_Begin_CSLanguage, (IDebugger)this.dbg);
            IPackagingQueryClient client = (IPackagingQueryClient)this.repository.getClientLibrary(IPackagingQueryClient.class);
            List languages = null;
            try {
                languages = client.fetchLanguageJclincs((IProjectAreaHandle)this.projectArea, (IProgressMonitor)subMonitor.newChild(1));
                if (subMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
            }
            catch (TeamRepositoryException e) {
                e.printStackTrace();
            }
            if (!Verification.isNonEmpty(languages)) {
                throw new ImporterException(Messages.JclinGenerationJob_Error_NotFound_Languages);
            }
            subMonitor.subTask(Messages.JclinGenerationJob_Begin_Connection);
            Statistics.logTiming((String)Messages.JclinGenerationJob_Begin_Connection, (IDebugger)this.dbg);
            try {
                wsConnection = SCMWorkspace.getWorkspaceConnection((ITeamRepository)this.repository, (IWorkspaceHandle)this.workspace, (IProgressMonitor)subMonitor.newChild(1), (IDebugger)this.dbg);
                if (subMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
            }
            catch (TeamRepositoryException e) {
                e.printStackTrace();
                throw new ImporterException(Messages.JclinGenerationJob_Error_External_Workspace, (Throwable)e);
            }
            subMonitor.subTask(Messages.JclinGenerationJob_Begin_CacheSynch);
            Statistics.logTiming((String)Messages.JclinGenerationJob_Begin_CacheSynch, (IDebugger)this.dbg);
            ItemCacheLoad itemCacheLoad = ItemCacheLoad.getInstance();
            if (itemCacheLoad.isLoading()) {
                itemCacheLoad.loaded();
            }
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            subMonitor.worked(1);
            subMonitor.subTask(Messages.JclinGenerationJob_Begin_Initialize);
            Statistics.logTiming((String)Messages.JclinGenerationJob_Begin_Initialize, (IDebugger)this.dbg);
            PackagingConfiguration packagingConfiguration = new PackagingConfiguration(this.repository, this.projectArea, this.version, languages, subMonitor, this.dbg);
            packagingConfiguration.createPackagingDatasetMap();
            packagingConfiguration.createPackagingFmidItemMap();
            packagingConfiguration.createPackagingLanguageMap();
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            subMonitor.worked(1);
            subMonitor.subTask(Messages.JclinGenerationJob_Begin_Components);
            Statistics.logTiming((String)Messages.JclinGenerationJob_Begin_Components, (IDebugger)this.dbg);
            PackagingComponent packagingComponent = new PackagingComponent(this.repository, wsConnection, this.exclude, this.include, this.excludeProject, this.includeProject, subMonitor, this.dbg);
            packagingComponent.createComponentList();
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            packagingComponent.createVersionableList(Messages.JclinGenerationJob_Begin_GetContent, 80);
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            subMonitor.setWorkRemaining(15);
            subMonitor.subTask(Messages.JclinGenerationJob_Begin_BuildItems);
            Statistics.logTiming((String)Messages.JclinGenerationJob_Begin_BuildItems, (IDebugger)this.dbg);
            PackagingContent packagingContent = new PackagingContent(this.repository, wsConnection, this.ignoreFiles, packagingComponent.getFileList(), packagingComponent.getComponentMap(), packagingComponent.getFolderMap(), packagingComponent.getComponentFolderMap(), packagingConfiguration.getPackagingDatasetMap(), packagingConfiguration.getPackagingLanguageMap(), packagingConfiguration.getPackagingFmidItemMap(), packagingConfiguration.getPackagingRelfileMap(), packagingConfiguration.getPackagingRelfileTypeMap(), (IProgressMonitor)subMonitor, this.dbg);
            packagingContent.createPackagingFolderMap();
            packagingContent.createPackagingFileList();
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            subMonitor.worked(1);
            subMonitor.subTask(Messages.JclinGenerationJob_Begin_BuildJclin);
            Statistics.logTiming((String)Messages.JclinGenerationJob_Begin_BuildJclin, (IDebugger)this.dbg);
            PackagingArtifacts packagingArtifacts = new PackagingArtifacts(this.repository, packagingConfiguration.getPackagingVersion(), this.buildDefinition, this.jclinFolder, this.sysoutClass, this.sortContent, this.sortContent ? packagingContent.getPackagingItemListSorted() : packagingContent.getPackagingItemList(), this.sortContent ? packagingConfiguration.getPackagingFmidItemSortedKeys() : packagingConfiguration.getPackagingFmidItemKeys(), packagingComponent.getFileList(), packagingComponent.getFolderMap(), packagingConfiguration.getPackagingDatasetMap(), packagingConfiguration.getPackagingFmidItemMap(), subMonitor, this.dbg);
            packagingArtifacts.createJclin(14);
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ItemCacheFactory.clearDataset((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea);
            ItemCacheFactory.clearFunction((ITeamRepository)this.repository, (IProjectAreaHandle)this.projectArea);
            this.timingLeave = System.nanoTime();
            Statistics.logTiming((String)Messages.JclinGenerationJob_Finis, (long)this.timingEnter, (long)this.timingLeave, (IDebugger)this.dbg);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TeamRepositoryException((Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

