/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.jobs;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.query.IBaseBuildDefinitionQueryModel;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.internal.client.iterator.ItemQueryIterator;
import com.ibm.team.build.internal.common.model.query.BaseBuildDefinitionQueryModel;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.ItemTypeSelectionDialog;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.SystemDefinitionJob;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;

public class FetchBuildDefinitionsJob
extends SystemDefinitionJob {
    private final IDebugger dbg;
    private final String simpleName;
    private final ITeamRepository repository;
    private final IProjectArea projectArea;
    private final ItemTypeSelectionDialog dialog;
    private final List<IBuildDefinition> buildDefinitions;

    public FetchBuildDefinitionsJob(ITeamRepository repository, IProjectArea projectArea, ItemTypeSelectionDialog dialog, List<IBuildDefinition> buildDefinitions, IDebugger dbg) {
        super(Messages.FetchBuildDefinitionsJob_Title, true);
        this.repository = repository;
        this.projectArea = projectArea;
        this.dialog = dialog;
        this.buildDefinitions = buildDefinitions;
        this.dbg = dbg;
        this.simpleName = ((Object)((Object)this)).getClass().getSimpleName();
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName()});
        }
        client = ClientFactory.getTeamBuildClient((ITeamRepository)this.repository);
        itemManager = this.repository.itemManager();
        query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)IBaseBuildDefinitionQueryModel.IBuildDefinitionQueryModel.ROOT);
        queryModel = IBaseBuildDefinitionQueryModel.IBuildDefinitionQueryModel.ROOT;
        model = (BaseBuildDefinitionQueryModel.BuildDefinitionQueryModel)queryModel;
        itemHandle = model.processArea()._eq((IItemHandle)this.projectArea);
        itemFilter = model.configurationElements().elementId()._eq("com.ibm.team.enterprise.zos.build.common.IZosDependencyBuildConfigurationElement");
        query.filter(itemHandle._and(itemFilter));
        query.orderByDscUsingLocale(model.id());
        iterator = new ItemQueryIterator(client, query, IQueryService.EMPTY_PARAMETERS);
        var10_10 = this.buildDefinitions;
        synchronized (var10_10) {
            this.buildDefinitions.clear();
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl19 : MonitorExitStatement: MONITOREXIT : var10_10
            if (true) ** GOTO lbl34
        }
        do {
            definitionHandles = iterator.next(512, monitor);
            items = itemManager.fetchCompleteItems(definitionHandles, 0, monitor);
            var12_12 = this.buildDefinitions;
            synchronized (var12_12) {
                this.buildDefinitions.addAll(items);
            }
lbl34:
            // 2 sources

        } while (iterator.hasNext(monitor));
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                FetchBuildDefinitionsJob.this.dialog.getTreeViewer().refresh();
            }
        });
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf(this.buildDefinitions)});
        }
        return Status.OK_STATUS;
    }
}

