/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.systemdefinition.ui.helper;

import com.ibm.team.enterprise.metadata.client.scanner.IMetadataScannerClientLibrary;
import com.ibm.team.enterprise.metadata.common.scanner.IFileMetadataScanner;
import com.ibm.team.enterprise.systemdefinition.common.dto.ChangeLogDelta;
import com.ibm.team.enterprise.systemdefinition.common.dto.DeltaType;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorHandle;
import com.ibm.team.enterprise.systemdefinition.common.util.ChangeLogUtil;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.enterprise.systemdefinition.common.util.zos.IZosSystemDefinitionUtil;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionCache;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class SystemDefHistoryHelper {
    protected static Map<String, String> tagsToLabels = new HashMap<String, String>();
    protected Map<String, String> scannerMap = null;
    private ITeamRepository repository = null;
    protected ISystemDefinitionCache sysDefCache = null;

    static {
        if (!tagsToLabels.containsKey(SystemDefinitionUtil.SYSTEM_DEF_NAME_TAG.getWholeTagName())) {
            tagsToLabels.put(SystemDefinitionUtil.SYSTEM_DEF_NAME_TAG.getWholeTagName(), Messages.SystemDefinition_Name);
        }
        if (!tagsToLabels.containsKey(SystemDefinitionUtil.SYSTEM_DEF_DESCRIPTION_TAG.getWholeTagName())) {
            tagsToLabels.put(SystemDefinitionUtil.SYSTEM_DEF_DESCRIPTION_TAG.getWholeTagName(), Messages.SystemDefinition_Description);
        }
        if (!tagsToLabels.containsKey(SystemDefinitionUtil.SYSTEM_DEF_PLATFORM_TAG.getWholeTagName())) {
            tagsToLabels.put(SystemDefinitionUtil.SYSTEM_DEF_PLATFORM_TAG.getWholeTagName(), Messages.SystemDefinition_Platform);
        }
        if (!tagsToLabels.containsKey(SystemDefinitionUtil.SYSTEM_DEF_NON_IMPACTING_TAG.getWholeTagName())) {
            tagsToLabels.put(SystemDefinitionUtil.SYSTEM_DEF_NON_IMPACTING_TAG.getWholeTagName(), Messages.SystemDefinition_NonImpacting);
        }
        if (!tagsToLabels.containsKey(SystemDefinitionUtil.TRANSLATOR_VARIABLES_TAG.getWholeTagName())) {
            tagsToLabels.put(SystemDefinitionUtil.TRANSLATOR_VARIABLES_TAG.getWholeTagName(), Messages.SystemDefinition_TRANSLATOR_VARIABLES);
        }
        if (!tagsToLabels.containsKey(SystemDefinitionUtil.TRANSLATOR_OUTPUTS_TAG.getWholeTagName())) {
            tagsToLabels.put(SystemDefinitionUtil.TRANSLATOR_OUTPUTS_TAG.getWholeTagName(), Messages.SystemDefinition_TRANSLATOR_OUTPUTS);
        }
        if (!tagsToLabels.containsKey(SystemDefinitionUtil.TRANSLATOR_OUTPUT_PATH_TAG.getWholeTagName())) {
            tagsToLabels.put(SystemDefinitionUtil.TRANSLATOR_OUTPUT_PATH_TAG.getWholeTagName(), Messages.SystemDefinition_TRANSLATOR_OUTPUT_PATH);
        }
        if (!tagsToLabels.containsKey(SystemDefinitionUtil.TRANSLATOR_OUTPUT_CONDITION_TAG.getWholeTagName())) {
            tagsToLabels.put(SystemDefinitionUtil.TRANSLATOR_OUTPUT_CONDITION_TAG.getWholeTagName(), Messages.SystemDefinition_TRANSLATOR_OUTPUT_CONDITION);
        }
        if (!tagsToLabels.containsKey(SystemDefinitionUtil.TRANSLATOR_OUTPUT_DEPLOYTYPE_TAG.getWholeTagName())) {
            tagsToLabels.put(SystemDefinitionUtil.TRANSLATOR_OUTPUT_DEPLOYTYPE_TAG.getWholeTagName(), Messages.SystemDefinition_TRANSLATOR_OUTPUT_DEPLOY_TYPE);
        }
        if (!tagsToLabels.containsKey(SystemDefinitionUtil.LANGUAGE_DEF_CALCULATE_IMPACTS_TAG.getWholeTagName())) {
            tagsToLabels.put(SystemDefinitionUtil.LANGUAGE_DEF_CALCULATE_IMPACTS_TAG.getWholeTagName(), Messages.SystemDefinition_LANGDEF_CALCULATE_IMPACTS);
        }
        if (!tagsToLabels.containsKey(SystemDefinitionUtil.LANGUAGE_DEF_CONSOLIDATE_LOGS_TAG.getWholeTagName())) {
            tagsToLabels.put(SystemDefinitionUtil.LANGUAGE_DEF_CONSOLIDATE_LOGS_TAG.getWholeTagName(), Messages.SystemDefinition_LANGDEF_CONSOLIDATE_LOGS);
        }
        if (!tagsToLabels.containsKey(SystemDefinitionUtil.LANGUAGE_DEF_LANGUAGE_CODE_TAG.getWholeTagName())) {
            tagsToLabels.put(SystemDefinitionUtil.LANGUAGE_DEF_LANGUAGE_CODE_TAG.getWholeTagName(), Messages.SystemDefinition_LANGDEF_LANGUAGE);
        }
        if (!tagsToLabels.containsKey(SystemDefinitionUtil.LANGUAGE_DEF_DEFAULT_PATTERNS_TAG.getWholeTagName())) {
            tagsToLabels.put(SystemDefinitionUtil.LANGUAGE_DEF_DEFAULT_PATTERNS_TAG.getWholeTagName(), Messages.SystemDefinition_LANGDEF_FILE_EXTENSION);
        }
        if (!tagsToLabels.containsKey(SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATORS_TAG.getWholeTagName())) {
            tagsToLabels.put(SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATORS_TAG.getWholeTagName(), Messages.DependencyTypesControl_TRANSLATOR_NAME);
        }
        if (!tagsToLabels.containsKey(SystemDefinitionUtil.LANGUAGE_DEF_SCANNERS_TAG.getWholeTagName())) {
            tagsToLabels.put(SystemDefinitionUtil.LANGUAGE_DEF_SCANNERS_TAG.getWholeTagName(), Messages.SystemDefinition_LANGDEF_SCANNERS);
        }
        if (!tagsToLabels.containsKey(SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPES_TAG.getWholeTagName())) {
            tagsToLabels.put(SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPES_TAG.getWholeTagName(), Messages.SystemDefinition_LANGDEF_DEPENDENCYTYPES);
        }
        if (!tagsToLabels.containsKey(SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPE_LEVEL_TAG.getWholeTagName())) {
            tagsToLabels.put(SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPE_LEVEL_TAG.getWholeTagName(), Messages.SystemDefinition_LANGDEF_DEPENDTYPE_LEVEL);
        }
        if (!tagsToLabels.containsKey(SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_CONDITION_TAG.getWholeTagName())) {
            tagsToLabels.put(SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_CONDITION_TAG.getWholeTagName(), Messages.SystemDefinitionHistory_LANGDEF_CONDITION);
        }
        if (!tagsToLabels.containsKey(SystemDefinitionUtil.LANGUAGE_DEF_SCOPED_PROPERTIES_TAG.getWholeTagName())) {
            tagsToLabels.put(SystemDefinitionUtil.LANGUAGE_DEF_SCOPED_PROPERTIES_TAG.getWholeTagName(), Messages.SystemDefinition_LANGDEF_PROPERTIES);
        }
        if (!tagsToLabels.containsKey(SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_VALUE_TAG.getWholeTagName())) {
            tagsToLabels.put(SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_VALUE_TAG.getWholeTagName(), Messages.SystemDefinition_LANGDEF_TRANSLATOR_VALUE);
        }
        if (!tagsToLabels.containsKey(SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_STEPNAME_TAG.getWholeTagName())) {
            tagsToLabels.put(SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_STEPNAME_TAG.getWholeTagName(), Messages.SystemDefinitionHistory_LANGDEF_STEP_NAME);
        }
        if (!tagsToLabels.containsKey(SystemDefinitionUtil.SYSTEM_DEF_PRELIST_TAG.getWholeTagName())) {
            tagsToLabels.put(SystemDefinitionUtil.SYSTEM_DEF_PRELIST_TAG.getWholeTagName(), Messages.SystemDefinitionHistory_SEQUENCE_PREVIOUS);
        }
        if (!tagsToLabels.containsKey(SystemDefinitionUtil.SYSTEM_DEF_CURLIST_TAG.getWholeTagName())) {
            tagsToLabels.put(SystemDefinitionUtil.SYSTEM_DEF_CURLIST_TAG.getWholeTagName(), Messages.SystemDefinitionHistory_SEQUENCE_CURRENT);
        }
    }

    public SystemDefHistoryHelper(ISystemDefinitionCache systemDefinitionCache, ITeamRepository repository) {
        this.sysDefCache = systemDefinitionCache;
        this.repository = repository;
    }

    public String generateHTMLContent(List<ChangeLogDelta> changeLogDeltas, boolean isNew, Timestamp modifiedSince, Timestamp changeDate) throws TeamRepositoryException {
        String result = null;
        if (changeLogDeltas == null || changeLogDeltas.size() == 0) {
            return result;
        }
        StringBuilder htmlBuilder = new StringBuilder();
        htmlBuilder.append("<table class=\"changes\"");
        if (modifiedSince != null && changeDate.after(modifiedSince)) {
            htmlBuilder.append(" style=\"{color: gray;}\"");
        }
        htmlBuilder.append(">");
        for (ChangeLogDelta changeLogDelta : changeLogDeltas) {
            String label = tagsToLabels.get(changeLogDelta.getId());
            if (label == null) continue;
            htmlBuilder.append("<tr>");
            htmlBuilder.append("<td align=\"left\">").append(label).append("</td>");
            htmlBuilder.append("<td align=\"left\">");
            this.generateChangeLogDetlaHTMLContent(changeLogDelta, htmlBuilder, isNew, null, 0, false);
            htmlBuilder.append("</td>");
            htmlBuilder.append("</tr>");
        }
        htmlBuilder.append("</table>");
        return htmlBuilder.toString();
    }

    protected void generateOrderedListHTMLContent(ChangeLogDelta changeLogDelta, StringBuilder htmlBuilder, boolean isNew, String id) {
    }

    private void generateChangeLogDetlaHTMLContent(ChangeLogDelta changeLogDelta, StringBuilder htmlBuilder, boolean isNew, String id, int blankSize, boolean needBlank) throws TeamRepositoryException {
        if (changeLogDelta == null || htmlBuilder == null) {
            return;
        }
        String htmlContent = changeLogDelta.getHtmlContent();
        EList subChanges = changeLogDelta.getSubChanges();
        String oldValue = changeLogDelta.getOldValue();
        String newValue = changeLogDelta.getNewValue();
        if (subChanges != null && subChanges.size() > 0) {
            if (IZosSystemDefinitionUtil.ZTRANSLATOR_DATA_DEFINITION_TAG.getWholeTagName().equals(id)) {
                this.generateDDHTMLContent(htmlBuilder, changeLogDelta, blankSize + 4);
            } else {
                this.generateSubHTMLContent(htmlBuilder, (List<ChangeLogDelta>)subChanges, isNew, changeLogDelta.getType(), blankSize + 4, needBlank);
            }
        } else if (DeltaType.UUID == changeLogDelta.getType()) {
            if (needBlank) {
                this.generateHTMLBlank(htmlBuilder, blankSize);
            }
            this.generateUUIDHTMLContent(htmlBuilder, changeLogDelta.getId(), oldValue, newValue, changeLogDelta.isNeedDiff());
        } else if (htmlContent != null) {
            if (needBlank) {
                this.generateHTMLBlank(htmlBuilder, blankSize);
            }
            String label = null;
            if (id != null) {
                label = tagsToLabels.get(id);
            }
            if (label != null) {
                htmlBuilder.append("<b>").append(label).append("</b>").append("&nbsp;").append(":").append("&nbsp;");
            }
            htmlBuilder.append(htmlContent);
        } else if (htmlContent == null && (oldValue != null || newValue != null)) {
            this.generateClientHTMLContent(htmlBuilder, changeLogDelta.getType(), changeLogDelta.getId(), oldValue, newValue);
        }
    }

    protected void generateDDHTMLContent(StringBuilder htmlBuilder, ChangeLogDelta changeLogDelta, int blankSize) throws TeamRepositoryException {
    }

    protected void generateClientHTMLContent(StringBuilder htmlBuilder, DeltaType type, String id, String oldValue, String newValue) throws TeamRepositoryException {
        if (SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPE_LEVEL_TAG.getWholeTagName().equals(id)) {
            this.generateValuesContent(htmlBuilder, this.getDependLevelLable(oldValue), this.getDependLevelLable(newValue), type, SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPE_LEVEL_TAG.getWholeTagName(), null);
        } else if (SystemDefinitionUtil.LANGUAGE_DEF_LANGUAGE_CODE_TAG.getWholeTagName().equals(id)) {
            this.generateValuesContent(htmlBuilder, this.getLanguageCodesLabel(oldValue), this.getLanguageCodesLabel(newValue), type, null, null);
        }
    }

    protected String getLanguageCodesLabel(String oldValue) {
        return null;
    }

    private String getDependLevelLable(String value) {
        String result = null;
        if (value == null) {
            return result;
        }
        int valueInt = 0;
        try {
            valueInt = Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return result;
        }
        switch (valueInt) {
            case 0: {
                result = Messages.DependencyTypeLabelProvider_ALL;
                break;
            }
            case 1: {
                result = Messages.DependencyTypeLabelProvider_NONE;
                break;
            }
            case 2: {
                result = Messages.SystemDefinition_LANGDEF_DEPENDTYPE_PARTIAL;
                break;
            }
            default: {
                result = Messages.DependencyTypeLabelProvider_ALL;
            }
        }
        return result;
    }

    protected void generateValuesContent(StringBuilder htmlBuilder, String oldValue, String newValue, DeltaType type, String id, String defaultValue) {
        if (htmlBuilder == null) {
            return;
        }
        String label = null;
        if (id != null) {
            label = tagsToLabels.get(id);
        }
        if (label != null) {
            htmlBuilder.append("<b>").append(label).append("</b>").append("&nbsp;").append(":").append("&nbsp;");
        }
        String oldContent = null;
        String newContent = null;
        if (DeltaType.ADD == type) {
            newContent = newValue == null || newValue.length() == 0 ? defaultValue : newValue;
        } else {
            oldContent = oldValue == null || oldValue.length() == 0 ? defaultValue : oldValue;
            newContent = newValue == null || newValue.length() == 0 ? defaultValue : newValue;
        }
        htmlBuilder.append(ChangeLogUtil.getHTMLContent((Object)oldContent, (Object)newContent, (boolean)false, (boolean)false));
    }

    protected void generateUUIDHTMLContent(StringBuilder htmlBuilder, String id, String oldValue, String newValue, boolean needDiff) throws TeamRepositoryException {
        if (id == null) {
            return;
        }
        String oldName = null;
        String newName = null;
        if (newValue != null) {
            newName = this.getReferenceObjectName(id, newValue);
        } else if (needDiff) {
            newName = "";
        }
        if (oldValue != null) {
            oldName = this.getReferenceObjectName(id, oldValue);
        } else if (needDiff) {
            oldName = "";
        }
        String result = ChangeLogUtil.getHTMLContent((Object)oldName, (Object)newName, (boolean)needDiff, (boolean)false);
        if (result != null && result.length() > 0) {
            htmlBuilder.append(result);
        }
    }

    protected String getReferenceObjectName(String id, String uuid) throws TeamRepositoryException {
        ITranslatorHandle handle;
        ISystemDefinition sysDef;
        String result = null;
        if (SystemDefinitionUtil.LANGUAGE_DEF_SCANNER_TAG.getWholeTagName().equals(id)) {
            result = this.getScannerLabel(uuid);
        } else if (this.sysDefCache != null && SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATOR_VALUE_TAG.getWholeTagName().equals(id) && (sysDef = this.sysDefCache.getSystemDefinition((ISystemDefinitionHandle)(handle = (ITranslatorHandle)ITranslator.ITEM_TYPE.createItemHandle(UUID.valueOf((String)uuid), null)), null)) != null) {
            result = sysDef.getName();
        }
        return result;
    }

    private String getScannerLabel(String name) throws TeamRepositoryException {
        IFileMetadataScanner scanner;
        IMetadataScannerClientLibrary scannerClient;
        String result = null;
        if (this.repository == null || name == null || name.length() == 0) {
            return result;
        }
        if (this.scannerMap == null) {
            this.scannerMap = new HashMap<String, String>();
        }
        if ((result = this.scannerMap.get(name)) == null && (scannerClient = (IMetadataScannerClientLibrary)this.repository.getClientLibrary(IMetadataScannerClientLibrary.class)) != null && (scanner = scannerClient.getMetadataScanner(name)) != null && (result = scanner.getLabel()) != null) {
            this.scannerMap.put(name, result);
        }
        return result;
    }

    protected void generateSubHTMLContent(StringBuilder htmlBuilder, List<ChangeLogDelta> changeLogDeltas, boolean isNew, DeltaType type, int blankSize, boolean needBlank) throws TeamRepositoryException {
        if (changeLogDeltas == null || changeLogDeltas.size() == 0) {
            return;
        }
        if (DeltaType.LIST == type) {
            ArrayList<ChangeLogDelta> addDeltas = new ArrayList<ChangeLogDelta>();
            ArrayList<ChangeLogDelta> changeDeltas = new ArrayList<ChangeLogDelta>();
            ArrayList<ChangeLogDelta> orderChangeDeltas = new ArrayList<ChangeLogDelta>();
            ArrayList<ChangeLogDelta> deleteDeltas = new ArrayList<ChangeLogDelta>();
            this.generateChangesDeltas(changeLogDeltas, addDeltas, changeDeltas, orderChangeDeltas, deleteDeltas);
            boolean isFirstline = true;
            if (addDeltas.size() > 0) {
                isFirstline = false;
                htmlBuilder.append(Messages.SystemDefinitionHistory_ADDED).append("\n<br />");
                for (ChangeLogDelta addDelta : addDeltas) {
                    this.generateChangeLogDetlaHTMLContent(addDelta, htmlBuilder, isNew, addDelta.getId(), blankSize - 4, needBlank);
                    htmlBuilder.append("<br />");
                }
            }
            if (changeDeltas.size() > 0) {
                if (isFirstline) {
                    isFirstline = false;
                } else if (needBlank) {
                    this.generateHTMLBlank(htmlBuilder, blankSize);
                }
                htmlBuilder.append(Messages.SystemDefinitionHistory_CHANGED).append("\n<br />");
                for (ChangeLogDelta changeDelta : changeDeltas) {
                    htmlBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                    this.generateChangeLogDetlaHTMLContent(changeDelta, htmlBuilder, isNew, changeDelta.getId(), blankSize, needBlank);
                    htmlBuilder.append("<br />");
                }
            }
            if (deleteDeltas.size() > 0) {
                if (isFirstline) {
                    isFirstline = false;
                } else if (needBlank) {
                    this.generateHTMLBlank(htmlBuilder, blankSize);
                }
                htmlBuilder.append(Messages.SystemDefinitionHistory_REMOVED).append("\n<br />");
                for (ChangeLogDelta deleteDelta : deleteDeltas) {
                    htmlBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                    this.generateChangeLogDetlaHTMLContent(deleteDelta, htmlBuilder, isNew, deleteDelta.getId(), blankSize, needBlank);
                    htmlBuilder.append("<br />");
                }
            }
            if (orderChangeDeltas.size() == 1) {
                if (isFirstline) {
                    isFirstline = false;
                } else if (needBlank) {
                    this.generateHTMLBlank(htmlBuilder, blankSize);
                }
                this.generateOrderListHTMLContent((ChangeLogDelta)orderChangeDeltas.get(0), htmlBuilder, isNew, blankSize, needBlank);
            }
        } else {
            int size = changeLogDeltas.size();
            int firstLength = 0;
            int firstBegin = -1;
            boolean containList = false;
            boolean subNeedBlank = needBlank;
            boolean dependLevel = false;
            int i = 0;
            while (i < changeLogDeltas.size()) {
                ChangeLogDelta changeLogDelta = changeLogDeltas.get(i);
                String id = changeLogDelta.getId();
                DeltaType changeType = changeLogDelta.getType();
                if (i == 0 && size > 1) {
                    firstBegin = htmlBuilder.length();
                }
                if (!containList && DeltaType.LIST == changeType) {
                    containList = true;
                }
                if (SystemDefinitionUtil.LANGUAGE_DEF_TRANSLATORS_TAG.getWholeTagName().equals(id)) {
                    subNeedBlank = true;
                    String label = tagsToLabels.get(id);
                    if (label != null && label.length() > 0) {
                        if (dependLevel) {
                            htmlBuilder.append("\n<br />");
                            this.generateHTMLBlank(htmlBuilder, blankSize + firstLength);
                        }
                        htmlBuilder.append("<b>").append(Messages.DependencyTypesControl_TRANSLATOR_NAME).append("</b>").append("\n<br />");
                        this.generateHTMLBlank(htmlBuilder, blankSize + firstLength + 4);
                    }
                }
                if (containList && i > 0 && IZosSystemDefinitionUtil.ZTRANSLATOR_CONCAT_CONDITION_TAG.getWholeTagName().equals(changeLogDeltas.get(i - 1).getId())) {
                    htmlBuilder.append("<br />");
                }
                this.generateChangeLogDetlaHTMLContent(changeLogDelta, htmlBuilder, isNew, changeLogDelta.getId(), blankSize + firstLength, subNeedBlank);
                subNeedBlank = false;
                if (SystemDefinitionUtil.LANGUAGE_DEF_DEPENDENCY_TYPE_LEVEL_TAG.getWholeTagName().equals(id)) {
                    dependLevel = true;
                }
                if (i == 0 && size > 1) {
                    String beginString = htmlBuilder.substring(firstBegin);
                    firstLength = beginString.replaceAll("&nbsp;", " ").length();
                    htmlBuilder.append("&nbsp;").append("[").append("&nbsp;");
                    firstLength += 4;
                } else if (i == size - 1 && size > 1) {
                    if (containList) {
                        this.generateHTMLBlank(htmlBuilder, blankSize + firstLength);
                    }
                    htmlBuilder.append("]");
                } else {
                    htmlBuilder.append("&nbsp;");
                }
                ++i;
            }
        }
    }

    private void generateOrderListHTMLContent(ChangeLogDelta orderChangeDelta, StringBuilder htmlBuilder, boolean isNew, int blankSize, boolean needBlank) throws TeamRepositoryException {
        if (orderChangeDelta == null || htmlBuilder == null) {
            return;
        }
        EList subChanges = orderChangeDelta.getSubChanges();
        if (subChanges.size() == 2) {
            ChangeLogDelta oldChange = (ChangeLogDelta)subChanges.get(0);
            ChangeLogDelta curChange = (ChangeLogDelta)subChanges.get(1);
            if (oldChange == null || curChange == null) {
                return;
            }
            htmlBuilder.append(Messages.SystemDefinitionHistory_SEQUENCECHANGED).append("\n");
            htmlBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            htmlBuilder.append("<table ");
            if (blankSize > 0) {
                htmlBuilder.append("style=\"margin-left:").append(blankSize * 2).append("px;\" ");
            }
            htmlBuilder.append("cellpadding='0' cellspacing='1' border='0' >");
            htmlBuilder.append("<tr>").append("<th>").append(tagsToLabels.get(oldChange.getId())).append("</th>").append("<th>").append(tagsToLabels.get(curChange.getId())).append("</th>").append("</tr>").append("<tr>");
            this.generateVerticalList(oldChange, htmlBuilder, isNew, blankSize, needBlank);
            this.generateVerticalList(curChange, htmlBuilder, isNew, blankSize, needBlank);
            htmlBuilder.append("</tr>").append("</table>");
        }
    }

    private void generateVerticalList(ChangeLogDelta change, StringBuilder htmlBuilder, boolean isNew, int blankSize, boolean needBlank) throws TeamRepositoryException {
        if (change == null || htmlBuilder == null) {
            return;
        }
        htmlBuilder.append("<td align=\"left\">");
        EList subChanges = change.getSubChanges();
        for (ChangeLogDelta subChange : subChanges) {
            this.generateChangeLogDetlaHTMLContent(subChange, htmlBuilder, isNew, null, blankSize, needBlank);
            htmlBuilder.append("<br />");
        }
        htmlBuilder.append("</td>");
    }

    protected void generateHTMLBlank(StringBuilder htmlBuilder, int count) {
        if (htmlBuilder == null || count < 1) {
            return;
        }
        int i = 0;
        while (i < count) {
            htmlBuilder.append("&nbsp;");
            ++i;
        }
    }

    protected void generateChangesDeltas(Collection<ChangeLogDelta> changeLogDeltas, List<ChangeLogDelta> addDeltas, List<ChangeLogDelta> changeDeltas, List<ChangeLogDelta> orderChangeDeltas, List<ChangeLogDelta> deleteDeltas) {
        if (changeLogDeltas == null || changeLogDeltas.size() == 0) {
            return;
        }
        for (ChangeLogDelta changeLogDelta : changeLogDeltas) {
            DeltaType type = changeLogDelta.getType();
            if (DeltaType.ADD == type) {
                addDeltas.add(changeLogDelta);
                continue;
            }
            if (DeltaType.CHANGE == type) {
                changeDeltas.add(changeLogDelta);
                continue;
            }
            if (DeltaType.ORDER_CHANGE == type) {
                orderChangeDeltas.add(changeLogDelta);
                continue;
            }
            if (DeltaType.DELETE != type) continue;
            deleteDeltas.add(changeLogDelta);
        }
    }
}

